/*************************************************************
 Description:
 $file_description$
 Author:
 LiuBin
 Date:
 2020/10/28 11:49:08
 *************************************************************/
#include "mbtk_ftp.h"
#include "mbtk_list.h"
#include "mbtk_sock.h"
#include "mbtk_str.h"
#include "mbtk_sock2.h"
#include <sys/msg.h>

/*************************************************************
 typedef struct:local at
 *************************************************************/
typedef struct
{
    char host[64];
    uint16 port;
    mbtk_ftp_auth_type_enum auth_type;
    bool ftp_type;
    bool use_cert;
    char name[FTP_SERVER_USER_NAME_MAX+1];
    char pass[FTP_SERVER_USER_PASS_MAX+1];
    mbtk_ftp_handle at_ftp_handle;
    char remote_path[MBTK_FTP_FILE_NAME_MAX+1];
    char local_path[MBTK_FTP_FILE_NAME_MAX+1];
    int rest_size;
    int read_size;
    int put_len;
} mbtk_at_init_parameter;

mbtk_at_init_parameter mbtk_at_ftp_par_at={0};

/*************************************************************
 Variables:local
 *************************************************************/
// static list_node_t *ftp_client_list = NULL;

/*************************************************************
 Variables:public
 *************************************************************/

/*************************************************************
 Local Function Declaration
 *************************************************************/

/*************************************************************
 Local Function Definitions
 *************************************************************/

//at
struct my_msg   //消息队列结构体
{
	long int my_msg_type;
    char *ptr;
}mbtk_at_msg;

int msgid;

int mbtk_at_msgid(int *at_msgid)
{
    msgid = *at_msgid;
    return 0;
}

void mbtk_at_printf(void *data)
{
    char *ptr = malloc(strlen(data)+1);
    memset(ptr,0,strlen(data)+1);
    memcpy(ptr, data, strlen(data)+1);
    mbtk_at_msg.ptr = ptr;
	mbtk_at_msg.my_msg_type=3;
	msgsnd(msgid,&mbtk_at_msg,sizeof(&mbtk_at_msg),0);   //发送数据到缓冲区
}

int mbtk_at_ftp(int parameter,int port,char *addr, char *pass, char *name,int at_auth_type ,bool ftp_type, bool use_cert)
{
    int at_ftp_ret = 0;

    LOGI("%s %d", __FUNCTION__, __LINE__);
    switch (parameter) {
    case 0: {
        mbtk_at_ftp_par_at.port = port;
        break;
        }
    case 1: {
        memset(mbtk_at_ftp_par_at.host, 0, strlen(mbtk_at_ftp_par_at.host)+1);
        memcpy(mbtk_at_ftp_par_at.host, addr, strlen(addr)+1);
        break;
        }
    case 2: {
        memset(mbtk_at_ftp_par_at.pass, 0, strlen(mbtk_at_ftp_par_at.pass)+1);
        memcpy(mbtk_at_ftp_par_at.pass, pass, strlen(pass)+1);
        break;
        }
    case 3: {
        memset(mbtk_at_ftp_par_at.name, 0, strlen(mbtk_at_ftp_par_at.name)+1);
        memcpy(mbtk_at_ftp_par_at.name, name, strlen(name)+1);
        break;
        }
    case 4: {
        mbtk_at_ftp_par_at.auth_type = at_auth_type;
        mbtk_at_ftp_par_at.use_cert = use_cert;
        break;
        }
    case 5: {
        mbtk_at_ftp_par_at.ftp_type = ftp_type;
        break;
        }
    default :
        at_ftp_ret = -1;
        return at_ftp_ret;
    }
    return at_ftp_ret;
}

int mbtk_at_get_ftp_info(int parameter,int *port,char *addr, char *pass, char *name, int *at_auth_type ,int *ftp_type, int *use_cert)
{
    int at_ftp_ret = 0;

    LOGI("%s %d", __FUNCTION__, __LINE__);
    switch (parameter) {
    case 0: {
        *port = mbtk_at_ftp_par_at.port;
        break;
        }
    case 1: {
        memset(addr, 0, strlen(addr)+1);
        memcpy(addr, mbtk_at_ftp_par_at.host, strlen(mbtk_at_ftp_par_at.host)+1);
        break;
        }
    case 2: {
        memset(pass, 0, strlen(pass)+1);
        memcpy(pass, mbtk_at_ftp_par_at.pass, strlen(mbtk_at_ftp_par_at.pass)+1);
        break;
        }
    case 3: {
        memset(name, 0, strlen(name)+1);
        memcpy(name, mbtk_at_ftp_par_at.name, strlen(mbtk_at_ftp_par_at.name)+1);
        break;
        }
    case 4: {
        *at_auth_type = mbtk_at_ftp_par_at.auth_type;
        *use_cert = mbtk_at_ftp_par_at.use_cert;
        break;
        }
    case 5: {
        *ftp_type = mbtk_at_ftp_par_at.ftp_type;
        break;
        }
    default :
        at_ftp_ret = -1;
    }
    return at_ftp_ret;
}

int mbtk_at_ftp_mkrmdel(int cmd,char *dir)
{
    int at_ftp_ret = 0;

    LOGI("%s %d", __FUNCTION__, __LINE__);

    char send_buf[1024];

    mbtk_at_ftp_par_at.at_ftp_handle = mbtk_ftp_init(mbtk_at_ftp_par_at.host, mbtk_at_ftp_par_at.port, mbtk_at_ftp_par_at.auth_type,
                                    0, mbtk_at_ftp_par_at.use_cert);
    mbtk_ftp_data_type_set(mbtk_at_ftp_par_at.at_ftp_handle,mbtk_at_ftp_par_at.ftp_type);//FTP_DATA_TYPE_I = 2 FTP_DATA_TYPE_A = 0
    if(mbtk_at_ftp_par_at.at_ftp_handle < 0)
            at_ftp_ret = -1;

    at_ftp_ret = mbtk_ftp_login(mbtk_at_ftp_par_at.at_ftp_handle,mbtk_at_ftp_par_at.name,mbtk_at_ftp_par_at.pass);
    if(at_ftp_ret != 0)
    {
        printf("ftp_login err:%d\n",at_ftp_ret);
    }
    memset(mbtk_at_ftp_par_at.remote_path, 0, strlen(mbtk_at_ftp_par_at.remote_path)+1);
    memcpy(mbtk_at_ftp_par_at.remote_path,dir,strlen(dir)+1);
    switch (cmd)
    {
        case 0:
        {
            at_ftp_ret = mbtk_ftp_dir_mkdir(mbtk_at_ftp_par_at.at_ftp_handle,dir);
            if(at_ftp_ret != 0)
            {
                printf("+CFTPMKD: FAIL,<%d>\n",at_ftp_ret);
                sprintf(send_buf,"+CFTPMKD: FAIL,<%d>\n",at_ftp_ret);
            }
            else
            {
                printf("+CFTPMKD: SUCCESS\n");
                sprintf(send_buf,"+CFTPMKD: SUCCESS\n");
            }
            break;
        }
        case 1:
        {
            at_ftp_ret = mbtk_ftp_dir_rmdir(mbtk_at_ftp_par_at.at_ftp_handle,dir);
            if(at_ftp_ret != 0)
            {
                printf("+CFTPRMD: FAIL,<%d>\n",at_ftp_ret);
                sprintf(send_buf,"+CFTPRMD: FAIL,<%d>\n",at_ftp_ret);
            }
            else
            {
                printf("+CFTPRMD: SUCCESS\n");
                sprintf(send_buf,"+CFTPRMD: SUCCESS\n");
            }
            break;
        }
        case 2:
        {
            at_ftp_ret = mbtk_ftp_file_del(mbtk_at_ftp_par_at.at_ftp_handle,dir);
            if(at_ftp_ret != 0)
            {
                printf("+CFTPDELE: FAIL,<%d>\n",at_ftp_ret);
                sprintf(send_buf,"+CFTPDELE: FAIL,<%d>\n",at_ftp_ret);
            }
            else
            {
                printf("+CFTPDELE: SUCCESS\n");
                sprintf(send_buf,"+CFTPDELE: SUCCESS\n");
            }
            break;
        }
        default:
            break;
    }

    mbtk_at_printf(send_buf);
    mbtk_at_printf("end");
    mbtk_ftp_quit(mbtk_at_ftp_par_at.at_ftp_handle);
    mbtk_ftp_deinit(mbtk_at_ftp_par_at.at_ftp_handle);
    return at_ftp_ret;
}

int mbtk_at_ftp_upload(char *remote_path,char *local_path, int size_byte, int rest_size)
{
    int at_ftp_ret=-1;
    int len_size = 0;
    char send_buf[1024];

    mbtk_at_ftp_par_at.at_ftp_handle = mbtk_ftp_init(mbtk_at_ftp_par_at.host, mbtk_at_ftp_par_at.port, mbtk_at_ftp_par_at.auth_type,
                                    0, mbtk_at_ftp_par_at.use_cert);
    mbtk_ftp_data_type_set(mbtk_at_ftp_par_at.at_ftp_handle,mbtk_at_ftp_par_at.ftp_type);//FTP_DATA_TYPE_I = 2 FTP_DATA_TYPE_A = 0
    if(mbtk_at_ftp_par_at.at_ftp_handle < 0)
        at_ftp_ret = -1;

    at_ftp_ret = mbtk_ftp_login(mbtk_at_ftp_par_at.at_ftp_handle,mbtk_at_ftp_par_at.name,mbtk_at_ftp_par_at.pass);
    if(at_ftp_ret != 0)
    {
        printf("ftp_login err:%d\n",at_ftp_ret);
    }

    memset(mbtk_at_ftp_par_at.remote_path, 0, strlen(mbtk_at_ftp_par_at.remote_path)+1);
    memcpy(mbtk_at_ftp_par_at.remote_path, remote_path, strlen(remote_path)+1);
    if(local_path!=NULL)
    {
        memset(mbtk_at_ftp_par_at.local_path, 0, strlen(mbtk_at_ftp_par_at.local_path)+1);
        memcpy(mbtk_at_ftp_par_at.local_path, local_path, strlen(local_path)+1);
    }
    mbtk_at_ftp_par_at.put_len = size_byte;
    mbtk_at_ftp_par_at.rest_size = rest_size;

    {
        FILE *fp;
        fp=fopen(local_path,"r");
        if(NULL==fp)
            printf("Read file error\n");
        else
        {
            printf("Open file success\n");
            fseek(fp,0,SEEK_END); //将文件读写指针移动到文件尾
            len_size=ftell(fp); //ftell函数获取从文件尾移动到文件开头的偏移量
            fclose(fp);
        }
    }
    if(local_path == NULL)
    {
        at_ftp_ret = mbtk_ftp_upload_start(mbtk_at_ftp_par_at.at_ftp_handle, remote_path,
                          NULL, size_byte);
        if(at_ftp_ret != 0)
        {
            printf("+CFTPPUT: FAIL,<%d>\n",at_ftp_ret);
            sprintf(send_buf,"+CFTPPUT: FAIL,<%d>\n",at_ftp_ret);
        }
        else
        {
            at_ftp_ret = mbtk_ftp_upload_send(mbtk_at_ftp_par_at.at_ftp_handle,"" ,size_byte);
            if(at_ftp_ret != 0)
            {
                printf("+CFTPPUT: FAIL,<%d>\n",at_ftp_ret);
                sprintf(send_buf,"+CFTPPUT: FAIL,<%d>\n",at_ftp_ret);
            }
            else
            {
                printf("+CFTPPUT: SUCCESS,<%d>\n",len_size);
                sprintf(send_buf,"+CFTPPUT: SUCCESS,<%d>\n",len_size);
            }
        }
        mbtk_ftp_upload_end(mbtk_at_ftp_par_at.at_ftp_handle);
    }
    else
    {
        at_ftp_ret = mbtk_ftp_upload_start(mbtk_at_ftp_par_at.at_ftp_handle, remote_path,
                          local_path, size_byte);
        if(at_ftp_ret != 0)
        {
            printf("+CFTPPUT: FAIL,<%d>\n",at_ftp_ret);
            sprintf(send_buf,"+CFTPPUT: FAIL,<%d>\n",at_ftp_ret);
        }
        else
        {
            printf("+CFTPPUT: SUCCESS,<%d>\n",len_size);
            sprintf(send_buf,"+CFTPPUT: SUCCESS,<%d>\n",len_size);
        }
    }
    mbtk_at_printf(send_buf);
    mbtk_at_printf("end");
    mbtk_ftp_quit(mbtk_at_ftp_par_at.at_ftp_handle);
    mbtk_ftp_deinit(mbtk_at_ftp_par_at.at_ftp_handle);
    return at_ftp_ret;
}

void mbtk_at_ftp_data_cb(void *data, uint32 data_len)
{
    char resp_buf[2150];
    printf("\n=====data_cb data[%s]=====\n=====data_cb data_len[%d]=====\n",(char*)data, data_len);

    memset(resp_buf,0,2150);
    sprintf(resp_buf, "+CFTPGET:");
    mbtk_at_printf(resp_buf);

    if(data_len > 1021)
    {
        memset(resp_buf,0,2150);
        memcpy(resp_buf,data,1021);
        mbtk_at_printf(resp_buf);
        memset(resp_buf,0,2150);
        sprintf(resp_buf, "<%d>", 1021);
        mbtk_at_printf(resp_buf);

        memset(resp_buf,0,2150);
        sprintf(resp_buf, "+CFTPGET:");
        mbtk_at_printf(resp_buf);
        memset(resp_buf,0,2150);
        memcpy(resp_buf,data+1021,data_len-1021);
        mbtk_at_printf(resp_buf);
        memset(resp_buf,0,2150);
        sprintf(resp_buf, "<%d>", data_len-1021);
        mbtk_at_printf(resp_buf);
    }
    else
    {
        memset(resp_buf,0,2150);
        memcpy(resp_buf,data,data_len);
        mbtk_at_printf(resp_buf);

        memset(resp_buf,0,2150);
        sprintf(resp_buf, "<%d>", data_len);
        mbtk_at_printf(resp_buf);
    }

}

int mbtk_at_ftp_download(void *remote_path, void *local_path, int data_cbc, int rest_size, int read_size)
{

    int at_ftp_ret=-1;
//    int len_size;

    mbtk_at_ftp_par_at.at_ftp_handle = mbtk_ftp_init(mbtk_at_ftp_par_at.host, mbtk_at_ftp_par_at.port, mbtk_at_ftp_par_at.auth_type,
                                    0, mbtk_at_ftp_par_at.use_cert);
    mbtk_ftp_data_type_set(mbtk_at_ftp_par_at.at_ftp_handle,mbtk_at_ftp_par_at.ftp_type);//FTP_DATA_TYPE_I = 2 FTP_DATA_TYPE_A = 0
    if(mbtk_at_ftp_par_at.at_ftp_handle < 0)
        at_ftp_ret = -1;

    at_ftp_ret = mbtk_ftp_login(mbtk_at_ftp_par_at.at_ftp_handle,mbtk_at_ftp_par_at.name,mbtk_at_ftp_par_at.pass);
    if(at_ftp_ret != 0)
    {
        printf("ftp_login err:%d\n",at_ftp_ret);
    }

    memset(mbtk_at_ftp_par_at.remote_path, 0, strlen(mbtk_at_ftp_par_at.remote_path)+1);
    memcpy(mbtk_at_ftp_par_at.remote_path, remote_path, strlen(remote_path)+1);
    if(local_path!=NULL)
    {
        memset(mbtk_at_ftp_par_at.local_path, 0, strlen(mbtk_at_ftp_par_at.local_path)+1);
        memcpy(mbtk_at_ftp_par_at.local_path, local_path, strlen(local_path)+1);
    }
    mbtk_at_ftp_par_at.rest_size = rest_size;
    mbtk_at_ftp_par_at.read_size = read_size;

    // Download file: /data
    uint32 len_count = 0;
    uint32 len;
    int download_time = 0;
    char resp_buf[1024];
//    int ret;

    uint32 file_size = mbtk_ftp_file_size(mbtk_at_ftp_par_at.at_ftp_handle, remote_path);
    if(file_size > 0)
    {
        if(rest_size > file_size)
        {
            printf("+CTPGETFILE: FAIL,<err>");
            memset(resp_buf,0,1024);
            sprintf(resp_buf, "+CTPGETFILE: FAIL,<%d>\r\n",901);
            mbtk_at_printf(resp_buf);
            //ret = ATRESP(30163, 0, 0, resp_buf);
            goto exit;
        }
        printf("Will download file:/data[%d]\n", file_size);
        /*
        memset(resp_buf,0,1024);
        sprintf(resp_buf, "Will download file:/data[%d]",file_size);
        mbtk_at_printf(resp_buf);
        */
        // Start download
        if(data_cbc == 0)//to file
        {
            len = mbtk_ftp_download_start(mbtk_at_ftp_par_at.at_ftp_handle, remote_path, local_path, NULL);
            /*
            memset(resp_buf,0,1024);
            sprintf(resp_buf, "download size:/len[%d]",len);
            mbtk_at_printf(resp_buf);
            */
        }
        else if(data_cbc == 1)
        {
            len = mbtk_ftp_download_start(mbtk_at_ftp_par_at.at_ftp_handle, remote_path, NULL, mbtk_at_ftp_data_cb);
            /*
            memset(resp_buf,0,1024);
            sprintf(resp_buf, "download size:/len[%d]",len);
            mbtk_at_printf(resp_buf);
            */
        }
        else
        {
            printf("+CTPGETFILE: FAIL,<err>");
            memset(resp_buf,0,1024);
            sprintf(resp_buf, "+CTPGETFILE: FAIL,<%d>\r\n",902);
            mbtk_at_printf(resp_buf);
            //ret = ATRESP(30163, 0, 0, resp_buf);
            goto exit;
        }
        if(len > 0)
        {
            len_count += len;
            download_time++;
            printf("Download[time-%d] size:[%d / %d]\n", download_time, len_count, file_size);
            /*
            memset(resp_buf,0,1024);
            sprintf(resp_buf,"Download[time-%d] size:[%d / %d]\n", download_time, len_count, file_size);
            mbtk_at_printf(resp_buf);
            */
            while (len_count < file_size
                   && download_time <= 10 // Try 10 times.
                   && (len = mbtk_ftp_download_continue(mbtk_at_ftp_par_at.at_ftp_handle)) > 0)
            {
                len_count += len;
                download_time++;
                printf("Download[time-%d] size:[%d / %d]\n", download_time, len_count, file_size);
                /*
                memset(resp_buf,0,1024);
                sprintf(resp_buf,"Download[time-%d] size:[%d / %d]\n", download_time, len_count, file_size);
                mbtk_at_printf(resp_buf);
                */
            }

            printf("Download complete - [%d / %d].\n",len_count, file_size);
            memset(resp_buf,0,1024);
            sprintf(resp_buf, "+CFTPGETFILE: SUCCESS,<%d>\r\n",len_count);
            mbtk_at_printf(resp_buf);
            //ret = ATRESP(30163, 0, 0, resp_buf);
        }
        else
        {
            printf("FTP download fail[%d / %d].\n",len_count, file_size);
            memset(resp_buf,0,1024);
            sprintf(resp_buf, "+CTPGETFILE: FAIL,<%d / %d> len=%d",len_count, file_size,len);
            mbtk_at_printf(resp_buf);
            //ret = ATRESP(30163, 0, 0, resp_buf);
            goto exit;
        }
    }else {
        printf("File error.\n");
        memset(resp_buf,0,1024);
        sprintf(resp_buf, "+CTPGETFILE: FAIL,<%d>\r\n",904);
        mbtk_at_printf(resp_buf);
        //ret = ATRESP(30163, 0, 0, resp_buf);
        goto exit;
    }


exit:
    if(file_size != len_count)
        mbtk_at_ftp_par_at.rest_size = len_count;

    //mbtk_at_printf(resp_buf);
    mbtk_at_printf("end");
    mbtk_ftp_quit(mbtk_at_ftp_par_at.at_ftp_handle);
    mbtk_ftp_deinit(mbtk_at_ftp_par_at.at_ftp_handle);
    return at_ftp_ret;

}

void ftp_ls_at_cb_func(void *file_list_cb)
{
//    int ret;
    char resp_buf[1024 + 1];
    printf("+CFTPLIST:\r\n%s\n", ((mbtk_ftp_file_info_s *)file_list_cb)->name);
    sprintf(resp_buf, "%s",((mbtk_ftp_file_info_s *)file_list_cb)->name);
    mbtk_at_printf(resp_buf);
    //ret = ATRESP(30163, 0, 0, resp_buf);
}


int mbtk_at_ftp_list(char *ftp_path)
{
    int at_ftp_ret=-1;
//    int len_size;
    char resp_buf[1024];

    mbtk_at_ftp_par_at.at_ftp_handle = mbtk_ftp_init(mbtk_at_ftp_par_at.host, mbtk_at_ftp_par_at.port, mbtk_at_ftp_par_at.auth_type,
                                    0, mbtk_at_ftp_par_at.use_cert);
    mbtk_ftp_data_type_set(mbtk_at_ftp_par_at.at_ftp_handle,mbtk_at_ftp_par_at.ftp_type);//FTP_DATA_TYPE_I = 2 FTP_DATA_TYPE_A = 0
    if(mbtk_at_ftp_par_at.at_ftp_handle < 0)
        at_ftp_ret = -1;

    at_ftp_ret = mbtk_ftp_login(mbtk_at_ftp_par_at.at_ftp_handle,mbtk_at_ftp_par_at.name,mbtk_at_ftp_par_at.pass);
    if(at_ftp_ret != 0)
    {
        printf("ftp_login err:%d\n",at_ftp_ret);
    }

    memset(mbtk_at_ftp_par_at.remote_path, 0, strlen(mbtk_at_ftp_par_at.remote_path)+1);
    memcpy(mbtk_at_ftp_par_at.remote_path, ftp_path, strlen(ftp_path)+1);

    at_ftp_ret = mbtk_ftp_cd(mbtk_at_ftp_par_at.at_ftp_handle, ftp_path);
    if(FTP_ERR_SUCCESS != at_ftp_ret) {
        printf("mbtk_ftp_cd() fail:%d\n", at_ftp_ret);
        sprintf(resp_buf,"+CFTPLIST: FAIL:%d\n", at_ftp_ret);
        goto exit;
    }
    mbtk_at_printf("+CFTPLIST:");
    mbtk_ftp_file_info_s list_head;
    list_head.ftp_ls_cb_typedef = ftp_ls_at_cb_func;
    at_ftp_ret = mbtk_ftp_dir_ls(mbtk_at_ftp_par_at.at_ftp_handle, &list_head);
    if(FTP_ERR_SUCCESS != at_ftp_ret) {
        printf("mbtk_ftp_dir_ls() fail:%d\n", at_ftp_ret);
        sprintf(resp_buf,"+CFTPLIST: FAIL:%d\n", at_ftp_ret);
        goto exit;
    }
    else
    {
        printf("+CFTPLIST: SUCCESS\r\n");
        sprintf(resp_buf,"+CFTPLIST: SUCCESS\r\n");
    }
exit:
    mbtk_at_printf(resp_buf);
    mbtk_at_printf("end");
    mbtk_ftp_quit(mbtk_at_ftp_par_at.at_ftp_handle);
    mbtk_ftp_deinit(mbtk_at_ftp_par_at.at_ftp_handle);
    return at_ftp_ret;
}

int mbtk_at_get_ftp_data_info(char *remote_path, char *local_path, int *rest_size, int *read_size, int *put_len)
{
    if(remote_path != NULL)
    {
        memset(remote_path, 0, strlen(remote_path)+1);
        memcpy(remote_path, mbtk_at_ftp_par_at.remote_path, strlen(mbtk_at_ftp_par_at.remote_path)+1);
    }
    if(local_path != NULL)
    {
        memset(local_path, 0, strlen(local_path)+1);
        memcpy(local_path, mbtk_at_ftp_par_at.local_path, strlen(mbtk_at_ftp_par_at.local_path)+1);
    }
    if(rest_size != NULL)
        *rest_size = mbtk_at_ftp_par_at.rest_size;
    if(read_size != NULL)
        *read_size = mbtk_at_ftp_par_at.read_size;
    if(put_len != NULL)
        *put_len = mbtk_at_ftp_par_at.put_len;
    return 0;
}



