#ifndef __TIM_H__
#define __TIM_H__

enum {
	IMAGE_ID_DTIM_A = 0x54494D31, /* dtim primary */
	IMAGE_ID_DTIM_B = 0x54494d32, /* dtim recovery */
	IMAGE_ID_UBOOT  = 0x4F534C4F,
	IMAGE_ID_KERNEL = 0x5A494D47,
	IMAGE_ID_ROOTFS = 0x5359534A,
	IMAGE_ID_ARBEL  = 0x41524249,
	IMAGE_ID_MSA	= 0x47524249,
	IMAGE_ID_RF		= 0x52464249,
	IMAGE_ID_OEMD	= 0x4F454D44,
	IMAGE_ID_OBM	= 0x4f424d49,
	IMAGE_ID_TIMH	= 0x54494d48,

    // Add by liubin
    IMAGE_ID_DEVICE	= 0x4F454D55,
};

#define TIMIDENTIFIER		0x54494D48		// "TIMH"
// TIM Versions
#define TIM_3_2_00			0x30200			// Support for Partitioning
#define TIM_3_3_00			0x30300			// Support for ECDSA-256
#define TIM_3_4_00			0x30400			// Support for ECDSA-521

// Defined for DTIM support
typedef enum
{
	TIMH_NOTINC				= 0,
	TIMH_INC				= 1,
	DTIM_PRIMARY_INC		= 2,
	DTIM_RECOVERY_INC		= 3,
	DTIM_CP_INC				= 4,
	TIMH_RECOVERY_INC		= 5,
	DTIM_PPSETTING_INC		= 6,
	// 7-9 reserved
	DTIM_CUSTMOZIEDTYPE1	= 10,
	DTIM_CUSTMOZIEDTYPE2	= 11,
	DTIM_CUSTMOZIEDTYPE3	= 12,
	DTIM_CUSTMOZIEDTYPE4	= 13,
	DTIM_CUSTMOZIEDTYPE5	= 14,
	DTIM_CUSTMOZIEDTYPE6	= 15,
	DTIM_CUSTMOZIEDTYPE7	= 16,
	DTIM_CUSTMOZIEDTYPE8	= 17,
	DTIM_CUSTMOZIEDTYPE9	= 18,
	DTIM_CUSTMOZIEDTYPE10	= 19,
	DTIM_CUSTMOZIEDTYPE11	= 20,
	DTIM_CUSTMOZIEDTYPE12	= 21,
	DTIM_CUSTMOZIEDTYPE13	= 22,
	DTIM_CUSTMOZIEDTYPE14	= 23,
	DTIM_CUSTMOZIEDTYPE15	= 24,
	DTIM_CUSTMOZIEDTYPE16	= 25,
	DTIM_CUSTMOZIEDTYPE17	= 26,
	DTIM_CUSTMOZIEDTYPE18	= 27,
	DTIM_CUSTMOZIEDTYPE19	= 28,
	DTIM_CUSTMOZIEDTYPE20	= 29,

	DTIM_CUSTMOZIED_MAX		= 50
} TIMIncluded_Type;

typedef unsigned int UINT_T, *PUINT;
typedef unsigned char UINT8_T;

typedef enum
{
	SHA160 = 0x00000014,   //20
	SHA256 = 0x00000020,   //32
	SHA512 = 0x00000040,   //64
	DUMMY_HASH = 0x7FFFFFFF
}
HASHALGORITHMID_T;

typedef struct
{
 UINT_T Version;
 UINT_T	Identifier;					// "TIMH"
 UINT_T Trusted;					// 1- Trusted, 0 Non
 UINT_T IssueDate;
 UINT_T OEMUniqueID;
} VERSION_I, *pVERSION_I;			// 0x10 bytes

typedef struct
{
 UINT_T WTMFlashSign;
 UINT_T WTMEntryAddr;
 UINT_T WTMEntryAddrBack;
 UINT_T WTMPatchSign;
 UINT_T WTMPatchAddr;
 UINT_T BootFlashSign;
} FLASH_I, *pFLASH_I;				// 0x10 bytes

typedef struct
{
	UINT_T PartitionNumber	: 4;
	UINT_T ImageType		: 8;
	UINT_T Reserved			: 20;
}TIM_INT;

typedef union{
	TIM_INT bits;
	UINT_T value;
}PN, *pPN;

typedef struct
{
 UINT_T ImageID;					// Indicate which Image
 UINT_T NextImageID;				// Indicate next image in the chain
 UINT_T FlashEntryAddr;			 	// Block numbers for NAND
 UINT_T LoadAddr;
 UINT_T ImageSize;
 UINT_T ImageSizeToHash;
 HASHALGORITHMID_T HashAlgorithmID;            // See HASHALGORITHMID_T
 UINT_T Hash[16];					// Reserve 512 bits for the hash
 PN PartitionNumber;
} IMAGE_INFO_3_4_0, *pIMAGE_INFO_3_4_0;			// 0x60 bytes

typedef struct
{
 UINT_T ImageID;					// Indicate which Image
 UINT_T NextImageID;				// Indicate next image in the chain
 UINT_T FlashEntryAddr;			 	// Block numbers for NAND
 UINT_T LoadAddr;
 UINT_T ImageSize;
 UINT_T ImageSizeToHash;
 HASHALGORITHMID_T HashAlgorithmID;			// See HASHALGORITHMID_T
 UINT_T Hash[8];					// Reserve 256 bits for the hash
 UINT_T PartitionNumber;			// This is new for V3.2.0
} IMAGE_INFO_3_2_0, *pIMAGE_INFO_3_2_0;			// 0x40 bytes

// Constant part of the TIMs
typedef struct
{
 VERSION_I      VersionBind;         			// 0
 FLASH_I        FlashInfo;           			// 0x10
 UINT_T         NumImages;           			// 0x20
 UINT_T         NumKeys;						// 0x24
 UINT_T         SizeOfReserved;					// 0x28
} CTIM, *pCTIM;									// 0x2C

// TIM structure for use by DKB/OBM/BootROM
typedef struct
{
 pCTIM 				pConsTIM;			// Constant part
 pIMAGE_INFO_3_4_0	pImg;				// Pointer to Images
 void				*pKey;				// Pointer to Keys
 PUINT				pReserved;			// Pointer to Reserved Area
 void       		*pTBTIM_DS;			// Pointer to Digital Signature
} TIM, *pTIM;

/**
 * General error code definitions			0x0 - 0x1F
 **/
#define NoError								0x0
#define NotFoundError						0x1
#define TIMNotFound							0x6D

// WTP Format Recognized Reserved Area Indicator
#define WTPRESERVEDAREAID	0x4F505448	  // "OPTH"

// Reserved Area Package Headers
#define TERMINATORID		0x5465726D		// "Term"

/********** WTP Recognized Reserved Area Layout ********************************
*
*	WTPTP_Defined_Reserved_Format_ID	\	  This clues BR, OBM and DKB that the reserved area is in a known format
*	Number of Reserved Area Packages	/	  For each package there is a header, payload size and payload
*
*	Header	 	 		\	  Indicates what type of a Reserved Area Package
*	Size		  		 \	  Size Comprises a single Reserved Area Package
*	Payload		  		 /	  There may be any number of Packages so long as TIM/NTIM < 4KB
*			 			/
*
*	Header		 		\	  The Last one should be a Package with a Terminator Header
*	Size		 		/	  The size should be 8 bytes (the size of this package)
*
**********************************************************************************/
typedef struct
{
 UINT_T WTPTP_Reserved_Area_ID;	  	// This clues BR, OBM and DKB that the reserved area is in a known format
 UINT_T	NumReservedPackages;	  	// For each package there is a header, payload size and payload
}WTP_RESERVED_AREA, *pWTP_RESERVED_AREA;

typedef struct
{
 UINT_T Identifier;					// Identification of this reserved area entry
 UINT_T Size;						// Size  = Payload Size + 2 words (8 bytes).
}WTP_RESERVED_AREA_HEADER, *pWTP_RESERVED_AREA_HEADER;

#define DDR_FLASH_MCP_PACKAGE_ID  0X44464D50 // "DFMP"
typedef struct
{
			unsigned int	 VendorDdrPid;
			unsigned int	 FlashInfo; //for eMMC, FlashInfo is flash size, MB; for nand, FlashInfo is NandID
} VendorDdrFlashSpec, *pVendorDdrFlashSpec;


typedef struct
{
			WTP_RESERVED_AREA_HEADER WRAH;
			unsigned int NumberVendorDdrFlashSpec;
			VendorDdrFlashSpec  ddrFlashSpec[2];
} DDR_FLASH_MCP_PACKAGE, *pDDR_FLASH_MCP_PACKAGE;

#define MAXRSAKEYSIZEWORDS	 	64				// 2048 bits
#define MAXECCKEYSIZEWORDS 		17				// 521 bits+

typedef enum
{
	Marvell_DS =		0x00000000,
	PKCS1_v1_5_Caddo =	0x00000001,
	PKCS1_v2_1_Caddo =	0x00000002,
	PKCS1_v1_5_Ippcp =	0x00000003,
	PKCS1_v2_1_Ippcp =	0x00000004,
	ECDSA_256 =			0x00000005,
	ECDSA_521 =			0x00000006,
	PKCS1_v2_2_Ippcp =	0x00000007,
	DUMMY_ENALG = 0x7FFFFFFF   // See _Cryptographic_Scheme for additional id's
}
ENCRYPTALGORITHMID_T;

typedef struct
{
 UINT_T	KeyID;						// Associate an ID with this key
 HASHALGORITHMID_T HashAlgorithmID;	// See HASHALGORITHMID_T
 UINT_T KeySize;					// Specified in bits
 UINT_T PublicKeySize;				// Specified in bits
 UINT_T RSAPublicExponent[MAXRSAKEYSIZEWORDS]; // Contents depend on PublicKeySize
 UINT_T RSAModulus[MAXRSAKEYSIZEWORDS]; // Up to 2K bits
 UINT_T KeyHash[8]; 				// Reserve 256 bits for the hash
} KEY_MOD_3_2_0, *pKEY_MOD_3_2_0;				// 0x22C bytes

typedef struct
{
 UINT_T KeyID;				// Associate an ID with this key
 HASHALGORITHMID_T HashAlgorithmID;	 // See HASHALGORITHMID_T
 UINT_T KeySize;			// Specified in bits
 UINT_T PublicKeySize;		// Specified in bits
 ENCRYPTALGORITHMID_T EncryptAlgorithmID;	// See ENCRYPTALGORITHMID_T;
 union
 {
	struct
	{
 		UINT_T RSAPublicExponent[MAXRSAKEYSIZEWORDS];	// Contents depend on PublicKeySize
		UINT_T RSAModulus[MAXRSAKEYSIZEWORDS];			// Up to 2K bits
	}Rsa;

	struct
	{
		UINT_T PublicKeyCompX[MAXECCKEYSIZEWORDS]; // Contents depend on PublicKeySize
		UINT_T PublicKeyCompY[MAXECCKEYSIZEWORDS]; // Up to 521 bits
		// Pad this struct so it remains consistent with RSA struct
		UINT_T Reserved[(2*MAXRSAKEYSIZEWORDS)-(2*MAXECCKEYSIZEWORDS)];
	}Ecdsa;
 };

 UINT_T KeyHash[8]; 				// Reserve 256 bits for the hash
} KEY_MOD_3_3_0, *pKEY_MOD_3_3_0;		//

typedef struct
{
 UINT_T KeyID;				// Associate an ID with this key
 HASHALGORITHMID_T HashAlgorithmID;	// See HASHALGORITHMID_T
 UINT_T KeySize;			// Specified in bits
 UINT_T PublicKeySize;		// Specified in bits
 ENCRYPTALGORITHMID_T EncryptAlgorithmID; // See ENCRYPTALGORITHMID_T;
 union
 {
	struct
	{
 		UINT_T RSAPublicExponent[MAXRSAKEYSIZEWORDS];	// Contents depend on PublicKeySize
		UINT_T RSAModulus[MAXRSAKEYSIZEWORDS];			// Up to 2K bits
	}Rsa;

	struct
	{
		UINT_T PublicKeyCompX[MAXECCKEYSIZEWORDS]; // Contents depend on PublicKeySize
		UINT_T PublicKeyCompY[MAXECCKEYSIZEWORDS]; // Up to 521 bits
		// Pad this struct so it remains consistent with RSA struct
		UINT_T Reserved[(2*MAXRSAKEYSIZEWORDS)-(2*MAXECCKEYSIZEWORDS)];
	}Ecdsa;

	struct
	{
		UINT_T EncryptedHashRSAPublicExponent[MAXRSAKEYSIZEWORDS];  // Contents depend on PublicKeySize
		UINT_T EncryptedHashRSAModulus[MAXRSAKEYSIZEWORDS];		 // Up to 2K bits
	}EncryptedRsa;

	struct
	{
		UINT_T EncryptedHashPublicKeyCompX_R[MAXECCKEYSIZEWORDS]; // Contents depend on PublicKeySize
		UINT_T EncryptedHashPublicKeyCompX_S[MAXECCKEYSIZEWORDS]; // Contents depend on PublicKeySize

		UINT_T EncryptedHashPublicKeyCompY_R[MAXECCKEYSIZEWORDS]; // Up to 521 bits
		UINT_T EncryptedHashPublicKeyCompY_S[MAXECCKEYSIZEWORDS]; // Up to 521 bits

		// Pad this struct so it remains consistent with encrypted RSA struct
		UINT_T Reserved[(2 * MAXRSAKEYSIZEWORDS)-(4 * MAXECCKEYSIZEWORDS)];
	}EncryptedEcdsa;
 };

 UINT_T KeyHash[16]; 				// Reserve 512 bits for the hash
} KEY_MOD_3_4_0, *pKEY_MOD_3_4_0;		//


typedef struct
{
 ENCRYPTALGORITHMID_T DSAlgorithmID;   // See ENCRYPTALGORITHMID_T
 HASHALGORITHMID_T HashAlgorithmID; // See HASHALGORITHMID_T
 UINT_T KeySize;			  // Specified in bits
 UINT_T Hash[8];			  // Reserve 256 bits for optional key hash
 union 	// Note that this union should not be included as part of the hash for TIM in the Digital Signature
 {
	struct
	{
		UINT_T RSAPublicExponent[MAXRSAKEYSIZEWORDS];
		UINT_T RSAModulus[MAXRSAKEYSIZEWORDS];		   	// Up to 2K bits
		UINT_T RSADigS[MAXRSAKEYSIZEWORDS];				// Contains TIM Hash
	}Rsa;

	struct
	{
		UINT_T ECDSAPublicKeyCompX[MAXECCKEYSIZEWORDS]; // Allow for 544 bits (17 words, 68 bytes for use with EC-521)
		UINT_T ECDSAPublicKeyCompY[MAXECCKEYSIZEWORDS];
		UINT_T ECDSADigS_R[MAXECCKEYSIZEWORDS];
		UINT_T ECDSADigS_S[MAXECCKEYSIZEWORDS];
		// Pad this struct so it remains consistent with RSA struct
		UINT_T Reserved[(MAXRSAKEYSIZEWORDS*3)-(MAXECCKEYSIZEWORDS*4)];
	} Ecdsa;
 };
} PLAT_DS, *pPLAT_DS;

#endif

