/**
 *   \file mbtk_adc.c
 *   \brief A Documented file.
 *
 *  Detailed description
 *   \Author:  js.wang <js.wang@mobiletek.cn>
 *   \Version: 1.0.0
 *   \Date: 2022-04-22
 */
#include <fcntl.h>
#include <stdint.h>
#include <limits.h>
#include <termios.h>
#include <stdarg.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>

#include "mbtk_log.h"
#include "mbtk_type.h"
#include "mbtk_adc.h"

int mbtk_adc_close(const char* adc_dev)
{
    int ret = 0;
    int fd = 0;
    char adc = '3';
    //system("echo 3 > /sys/kernel/debug/adc");
    if(adc_dev != NULL && !access(adc_dev, R_OK))
    {
        //LOGI("DEV:%s", ADC_DEVICE_803);
        fd = open(adc_dev, O_RDWR|O_CREAT|O_TRUNC, 0644);
    }
    else
    {
        LOGE("No found ADC devices.");
        return -1;
    }

    if(fd < 0) {
        LOGE("[%s]  file open error\n", __FUNCTION__);
        return -2;
    }
    ret = write(fd, &adc, 1);
    if (ret < 0) {
        LOGE("%s: error writing to file!\n", __FUNCTION__);
        close(fd);
        return -2;
    }
    close(fd);
    return 0;
}

int mbtk_adc_get(const char* adc_dev, mbtk_adc_enum channle)
{
    int ret = 0;
    int fd = 0;
    char adc_buf[24] = {0};
    char *adc_value = NULL;
    char adc =(channle == MBTK_ADC0 ? '0' : (channle == MBTK_ADC1 ? '1' : '2'));


    if(adc_dev != NULL && !access(adc_dev, R_OK))
    {
        LOGI("[adc] DEV:%s", adc_dev);
        fd = open(adc_dev, O_RDWR|O_CREAT|O_TRUNC, 0644);
    }
    else
    {
        LOGE("No found ADC devices : %s", adc_dev ? adc_dev : "NULL");
        return -1;
    }

    if(fd < 0) {
        LOGE("[%s]  file open error\n", __FUNCTION__);
        return -2;
    }
    ret = write(fd, &adc, 1);
    if (ret < 0) {
        LOGE("%s: error writing to file!\n", __FUNCTION__);
        close(fd);
        return -2;
    }
    ret = read(fd, adc_buf, 24);
    if (ret < 0) {
        LOGE("%s: error writing to file!\n", __FUNCTION__);
        close(fd);
        return -2;
    }else{
        //LOGI("%s %d adc:%s\n", __FUNCTION__, __LINE__, adc_buf);
        adc_value = strstr(adc_buf, "channel");
    }
    close(fd);
    if(adc_value)
    {
        //LOGI("%s adc: %s\n", __FUNCTION__, adc_value);
    }
    else
        return -2;

    return atoi(&adc_value[9]);
}
