#include <stdio.h>
#include <pthread.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/un.h>
#include <poll.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "sta_cli.h"
#include "sta_ctrl.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"
#include "mbtk_str.h"

//#include "sta_log.h"
//#include "mbtk_string.h"

#define STA_CLI_TIMEOUT 15000   // 15s
#define UNIXSTR_PATH "/data/sta_cli_sock"
#define	SA	struct sockaddr
#define	LISTENQ		1024	/* 2nd argument to listen() */
#define STA_CMD_SEPARATED "#$#"
#define STA_MAC_LEN 17	  // xx:xx:xx:xx:xx:xx
#define STA_SSID_MAX_LEN (32 * 5)

bool sta_ctrl_system(const char   *command);

#ifndef INFTIM
#define INFTIM          (-1)    /* infinite poll timeout */
#endif

#define STA_TAG_IND "IND"
#define STA_TAG_CMD "CMD"
#define STA_TAG_CMD_SUCCESS "SUCCESS"
#define STA_TAG_CMD_FAIL "FAIL"
#define STA_TAG_CMD_FAIL_BUSY "FAIL-BUSY"
#define STA_CMD_OPEN "OPEN"
//#define STA_CMD_EXIT "EXIT"
#define STA_CMD_CLOSE "CLOSE"
#define STA_CMD_SCAN "SCAN"
#define STA_CMD_STATUS "STATUS"
#define STA_CMD_MIB "MIB"
#define STA_CMD_RECONFIGURE "RECONFIGURE"
#define STA_CMD_DISCONNECT "DISCONNECT"
#define STA_CMD_RECONNECT "RECONNECT"
#define STA_CMD_SAVE_CONFIG "SAVE_CONFIG"
#define STA_CMD_SET_NETWORK "SET_NETWORK"
#define STA_CMD_GET_NETWORK "GET_NETWORK"
#define STA_CMD_REMOVE_NETWORK "REMOVE_NETWORK"
#define STA_CMD_ADD_NETWORK "ADD_NETWORK"
#define STA_CMD_DISABLE_NETWORK "DISABLE_NETWORK"
#define STA_CMD_ENABLE_NETWORK "ENABLE_NETWORK"
#define STA_CMD_SELECT_NETWORK "SELECT_NETWORK"
#define STA_CMD_LIST_NETWORKS "LIST_NETWORKS"
#define STA_CMD_REASSOCIATE "REASSOCIATE"
#define STA_CMD_REATTACH "REATTACH"

// /var/run/wpa_supplicant
static sta_cli_cmd_id_enum sta_cli_cmd_id = CMD_ID_NON;
static char sta_cli_cmd_reply[STA_BUF_SIZE];
static pthread_cond_t cond;
static pthread_mutex_t mutex;
static int sta_cli_conn_fd = -1;
//static char sta_cli_buf[STA_BUF_SIZE];
static bool sta_should_send_connected_msg = TRUE;
//static bool sta_connected = FALSE;
static bool sta_disconnectting = FALSE;
//static pthread_mutex_t sta_mutex;



int sta_cli_ssid_get(char *ssid)
{
    FILE *fd_tmp = NULL;

    fd_tmp = popen("cat /etc/wifi/sta_network.conf | grep -w 'SSID'   | cut -d '=' -f 2","r");

    if(fd_tmp){
//        char buf[200] = {0};
        if(fgets(ssid,200,fd_tmp) == NULL)
            return -1;
        pclose(fd_tmp);
        if(strlen(ssid) > 0){
           LOGE("test 100:%s, len:%d\n", ssid, strlen(ssid));

        }else{// Open wpa_supplicant
            LOGE("test 101:%s\n", ssid);
        }
    }else{

            LOGE("test 102:%s\n");
    }

    return 0;
}

int sta_cli_psk_get(char *psk)
{
    FILE *fd_tmp = NULL;

    fd_tmp = popen("cat /etc/wifi/sta_network.conf | grep -w 'PASSWORD'   | cut -d '=' -f 2","r");

    if(fd_tmp){
//        char buf[200] = {0};
        if(fgets(psk,200,fd_tmp) == NULL)
            return -1;
        pclose(fd_tmp);
        if(strlen(psk) > 0){
           LOGE("test 100:%s\n", psk);

        }else{// Open wpa_supplicant
            LOGE("test 101:%s\n", psk);
        }
    }else{

            LOGE("test 102:%s\n");
    }

    return 0;
}


int sta_cli_ssid_set(char *ssid)
{

    char buf[100] = {0};
    snprintf(buf, 100, "sed -i 's/SSID=.*$/SSID=%s/g' /etc/wifi/sta_network.conf", ssid);
    LOGE("set ssid:%s", buf);
    mbtk_system(buf);


    return 0;
}

int sta_cli_psk_set(char *psk)
{

    char buf[100] = {0};
    snprintf(buf, 100, "sed -i 's/PASSWORD=.*$/PASSWORD=%s/g' /etc/wifi/sta_network.conf", psk);
    LOGE("set ssid:%s", buf);
    mbtk_system(buf);


    return 0;
}




#if 0
static char*
sta_cli_ssid_process
(
	const char *ssid,
	char *result,
	int len
)
{
    bzero(result,len);
    int ascii = 1;
    int i;
    for (i = 0; i < strlen(ssid); i++){
        if (!isascii(ssid[i])){
            //LOGE("0x%02x\n",(unsigned char)ssid[i]);
            //return 0;
            ascii = 0;
            break;
        }
    }

    if(ascii)
    {
        snprintf(result,len,
                "\"%s\"",ssid);
    }else{
		int pos = 0;
        for (i = 0; i < strlen(ssid); i++){
            LOGE("0x%02x\n",(unsigned char)ssid[i]);
        	snprintf(result + pos,len - pos,
                "%02x",(unsigned char)ssid[i]);
			pos += 2;
        }
    }
    return result;
}
#endif

static char*
sta_cli_mac_get
(
	char *ifname,
	char *mac,
	size_t mac_len
)
{
    struct   ifreq   ifreq;
    int   sock;
	bzero(mac,mac_len);

    if((sock=socket(AF_INET,SOCK_STREAM,0))<0)
    {
        LOGE("socket:errno(%d)\n",errno);
        return NULL;
    }
    strcpy(ifreq.ifr_name,ifname);
    if(ioctl(sock,SIOCGIFHWADDR,&ifreq) <0)
    {
		LOGE("ioctl:errno(%d)\n",errno);
        return NULL;
    }
    snprintf(mac,mac_len,
    	"%02x%02x%02x%02x%02x%02x",
        (unsigned char)ifreq.ifr_hwaddr.sa_data[0],
        (unsigned char)ifreq.ifr_hwaddr.sa_data[1],
        (unsigned char)ifreq.ifr_hwaddr.sa_data[2],
        (unsigned char)ifreq.ifr_hwaddr.sa_data[3],
        (unsigned char)ifreq.ifr_hwaddr.sa_data[4],
        (unsigned char)ifreq.ifr_hwaddr.sa_data[5]);
	return mac;
}


static char*
sta_cli_sta_name_get
(
	char *name,
	size_t name_len
)
{
	bzero(name,name_len);

	// Get host name.
    FILE *stream = NULL;
	char host[100];
	bzero(host,100);
    stream = popen("hostname","r");
    if(stream != NULL)
    {
		if(fgets(host, 100, stream) == NULL) {
            return NULL;
		}
		pclose(stream);
		int index = str_indexof(host,"\n");
		if(strlen(host) > 0
			&& index != 0)
		{
			if(index > 0)
			{
				host[index] = '\0';
			}

			// index < 0
			// No "\n"
		}
		else // No data or empty line.
		{
			// Can not get host,set default to "MBTK".
			memcpy(host,"MBTK",4);
		}
    }
	else
	{
		// Can not get host,set default to "MBTK".
		memcpy(host,"MBTK",4);
	}

	// Get mac address.
	char mac[20];
	if(NULL == sta_cli_mac_get("wlan0", mac, 20))
	{
		// Can not get mac,set default to current time.
		time_t t;
		t = time(NULL);
		snprintf(mac,20,
			"%lld",t);
	}

	snprintf(name,name_len,"%s-%s",host,mac);

	return name;
}

static void
sta_cli_wpa_open_success
(
	void
)
{
    char buf[100];
    int len = snprintf(buf,100,
        "%s-%s-%s"STA_CMD_SEPARATED,
        STA_TAG_CMD,
        STA_CMD_OPEN,
        STA_TAG_CMD_SUCCESS);
    buf[len] = '\0';
    if(sta_cli_conn_fd != -1){
        if(write(sta_cli_conn_fd,buf,len) != len){
            LOGE("Send open msg to client fail.\n");
        }else{
            LOGE("Send open msg to client success.\n");
        }
    }else{
        LOGE("No client connected.\n");
    }
	sta_should_send_connected_msg = FALSE;
}


static void
sta_cli_wpa_msg_cb
(
    char *msg
)
{
    LOGE("cmd_id = %d,[%s]\n",sta_cli_cmd_id,msg);

//    if(sta_cli_conn_fd != -1){
//        if(write(sta_cli_conn_fd,msg,strlen(msg)) != strlen(msg)){
//            LOGE("Send msg to client fail.\n");
//        }else{
//            LOGE("Send msg to client success.\n");
//        }
//    }else{
//        LOGE("No client connected.\n");
//    }

	// Send msg(CMD_OPEN_SUCCESS) to wifi_server.
    if(sta_should_send_connected_msg) {
		sta_cli_wpa_open_success();
    }

    // Connected to AP
    if(str_contains(msg, "CTRL-EVENT-CONNECTED")){
		//sta_connected = TRUE;
		char sta_name[200];
		sta_cli_sta_name_get(sta_name,200);
		char cmd[200];
		int size = snprintf(cmd,200,
			"dhcpcd -h %s -o domain_name_servers --noipv4ll wlan0",sta_name);
        //dhcpcd wlan0 -t 0 -o domain_name_servers --noipv4ll -b -G
		cmd[size] = '\0';
        if(sta_ctrl_system(cmd)){
            char buf[100];
            int len = snprintf(buf,100,
                "%s-CONNECTED"STA_CMD_SEPARATED,
                STA_TAG_IND);
            buf[len] = '\0';
            if(sta_cli_conn_fd != -1){
				usleep(500);
                if(write(sta_cli_conn_fd,buf,len) != len){
                    LOGE("Send msg to client fail.\n");
                }else{
                    LOGE("Send msg to client success.\n");
                }
            }else{
                LOGE("No client connected.\n");
            }
        }
        return;
    }
#if 1
	else if(str_contains(msg, "CTRL-EVENT-DISCONNECTED")
		&& !str_contains(msg, "bssid=00:00:00:00:00:00")
		&& !sta_disconnectting)
	{
		//pthread_mutex_lock(&sta_mutex);
		//if(sta_connected){
	        // Disconnected from AP
	        char buf[100];
	        int len = snprintf(buf,100,
	            "%s-DISCONNECTED"STA_CMD_SEPARATED,
	            STA_TAG_IND);
	        buf[len] = '\0';
	        if(sta_cli_conn_fd != -1){
	            if(write(sta_cli_conn_fd,buf,len) != len){
	                LOGE("Send msg to client fail.\n");
	            }else{
	                LOGE("Send msg to client success.\n");
	            }
	        }else{
	            LOGE("No client connected.\n");
	        }
			//sta_connected = FALSE;
			//pthread_mutex_unlock(&sta_mutex);
	        return;
		//}
		//pthread_mutex_unlock(&sta_mutex);
    }
#endif

    switch(sta_cli_cmd_id)
    {
        case CMD_ID_NON:
        {

            break;
        }
        case CMD_ID_SCAN:
        {
            if(str_contains(msg, "CTRL-EVENT-SCAN-RESULTS")){
                LOGE("Start resume thread.\n");
                pthread_mutex_lock(&mutex);
                pthread_cond_signal(&cond);
                //pthread_cond_broadcast(&cond);
                pthread_mutex_unlock(&mutex);
            }
            break;
        }
        default:
            LOGE("cmd_id[%d] unknown.\n",sta_cli_cmd_id);
            break;
    }
}

static void
sta_cli_thread_pause
(
    long time /* ms */
)
{
    struct timeval now_1;
    struct timespec outtime;
    pthread_t thread_id = pthread_self();
    LOGE("Thread(%ld) pause.\n",thread_id);
    pthread_mutex_lock(&mutex);
    gettimeofday(&now_1, NULL);
    outtime.tv_sec = now_1.tv_sec + time / 1000;
    outtime.tv_nsec = now_1.tv_usec * 1000;
    pthread_cond_timedwait(&cond, &mutex, &outtime);
    pthread_mutex_unlock(&mutex);
    LOGE("Thread(%ld) resume.\n",thread_id);
}

static bool
sta_cli_is_empty_char(char ch)
{
    if(/*ch == ' ' || */ch == '\r' || ch == '\n'
        || ch == '\t')
        return TRUE;
    else
        return FALSE;
}

static char*
sta_cli_value_get
(
	const char *data,
	const char *key, // "key="
	char *value,
	int len
)
{
	bzero(value,len);
	char *ptr = strstr(data,key);
	if(ptr)
	{
		ptr += strlen(key);
		int i = 0;
		while(*ptr != '\r' && *ptr != '\n')
		{
			if(i == len - 1)
				return NULL;
			value[i++] = *ptr++;
		}
		return value;
	}else{
		return NULL;
	}
}


static sta_err_enum
sta_cli_cmd_scan_parse
(
    const char *reply,
    char *data,
    size_t len
)
{
	char *data_base = data;
    LOGE("SCAN:\n%s\n",reply);
    bzero(data,len);
    const char *ptr = reply;
    bool start = FALSE;
    int count = 0; // count for ',' by every line.
    while(*ptr){
        if(!start && *ptr == '\n'){
            start = TRUE;
            ptr++;
        }

        if(start){
            if(sta_cli_is_empty_char(*ptr)){
                if(*ptr == '\r' || *ptr == '\n'){
                    *data++ = '\r';
                    *data++ = '\n';
                    while(*++ptr == '\r' || *ptr == '\n')
                        ;
                    count = 0; // reset for next line.
                }else{
                    if(count < 4) {
                        *data++ = ',';
                        count++;
                        while(*++ptr == ' ' || *ptr == '\t')
                            ;
                    } else {
                        *data++ = *ptr++;
                    }
                }
            }else{
                *data++ = *ptr++;
            }
        }else{
            ptr++;
        }
    }

    LOGE("SCAN 0:\n%s\n",data_base);

	// Delete empty ssid line.
	char *tmp = (char*)calloc(len,1);
	memcpy(tmp,data_base,strlen(data_base));
	bzero(data_base,len);

	const char *ptr_pre = tmp;
	ptr = strstr(ptr_pre,"\r\n");
	LOGE("line:%s\n",ptr == NULL?"NULL":ptr);
	char ssid[STA_BUF_SIZE] = {0};
	const char *p;
	while(ptr)
	{
		LOGE("Get line.\n");
		// Get ssid.
		if(*(ptr - 1) == ',') // No ssid
		{
			LOGE("Delete one line.\n");
		}else{
			char s[STA_BUF_SIZE] = {0};
			p = ptr - 1;
			int len = 0;
			while(*p-- != ','){
				len++;
			}
			p += 2;
			memcpy(s,p,len);
			LOGE("ssid = %s;s = %s\n",ssid,s);
			if(str_contains(ssid,s))
			{
				LOGE("Jump the same ssid:%s\n",s);
				ptr_pre = ptr + 2;
				ptr = strstr(ptr_pre,"\r\n");
				continue;
			}

			if(strlen(ssid) > 0){
				ssid[strlen(ssid)] = ',';
			}
			memcpy(ssid + strlen(ssid),s,len);

			memcpy(data_base + strlen(data_base),ptr_pre,ptr + 2 - ptr_pre);
			LOGE("Copy ssid:\"%s\"\n",s);
		}
		ptr_pre = ptr + 2;
		ptr = strstr(ptr_pre,"\r\n");
	}

	LOGE("Scan parse end.\n");

	free(tmp);
	tmp = NULL;

	LOGE("SCAN 1:\n%s\n",data_base);

    return STA_ERR_SUCCESS;
}

static sta_err_enum
sta_cli_cmd_status_parse
(
    const char *reply,
    char *data,
    size_t data_len
)
{
    LOGE("STATUS:\n%s\n",reply);

    bzero(data,data_len);

//	  const char *ptr = reply;
//    while(*ptr){
//        if(*ptr == '\r' || *ptr == '\n'){
//            *data++ = '\r';
//            *data++ = '\n';
//            while(*++ptr == '\r' || *ptr == '\n')
//                ;
//        }else{
//            *data++ = *ptr++;
//        }
//    }

#define BUF_SIZE 500
	int len = 0;
	char buf[BUF_SIZE];
	char mac_ap[STA_MAC_LEN + 1];
	int size;
	if(sta_cli_value_get(reply,
			"bssid=",
			mac_ap,
			STA_MAC_LEN + 1)) // Connected.
	{
		// State
		memcpy(data + len,"1",1);
		len += 1;

		// mac_own
		if(sta_cli_value_get(reply,
			"\naddress=",
			buf,
			BUF_SIZE))
		{
			size = snprintf(data + len,data_len - len,
				",%s",buf);
			len += size;
		}else{
			memcpy(data + len,",",1);
			len += 1;
			LOGE("Not get own MAC address.\n");
		}

		// net_id
		if(sta_cli_value_get(reply,
			"\nid=",
			buf,
			BUF_SIZE))
		{
			size = snprintf(data + len,data_len - len,
				",%s",buf);
			len += size;
		}else{
			memcpy(data + len,",",1);
			len += 1;
			LOGE("Not get net id.\n");
		}

		// ssid
		if(sta_cli_value_get(reply,
			"\nssid=",
			buf,
			BUF_SIZE))
		{
			size = snprintf(data + len,data_len - len,
				",%s",buf);
			len += size;
		}else{
			memcpy(data + len,",",1);
			len += 1;
			LOGE("Not get ssid.\n");
		}

		// freq
		if(sta_cli_value_get(reply,
			"freq=",
			buf,
			BUF_SIZE))
		{
			int freq = atoi(buf);
			int channel = (freq - 2412) / 5 + 1;
			size = snprintf(data + len,data_len - len,
				",%d,%s",channel,buf);
			len += size;
		}else{
			memcpy(data + len,",",1);
			len += 1;
			LOGE("Not get freq.\n");
		}

		// auth
		if(sta_cli_value_get(reply,
			"key_mgmt=",
			buf,
			BUF_SIZE))
		{
			// WPA/WPA2
			if(strncmp(buf,"WPA",3)== 0)
			{
				size = snprintf(data + len,data_len - len,
					",%d",2);
				len += size;
			}else{
				if(sta_cli_value_get(reply,
					"group_cipher=",
					buf,
					BUF_SIZE))
				{
					// Open
					if(strncmp(buf,"NONE",4) == 0)
					{
						size = snprintf(data + len,data_len - len,
							",%d",0);
						len += size;
					}else{// WEP
						size = snprintf(data + len,data_len - len,
							",%d",1);
						len += size;
					}
				}else{
					memcpy(data + len,",",1);
					len += 1;
					LOGE("Not get group_cipher.\n");
				}
			}
		}else{
			memcpy(data + len,",",1);
			len += 1;
			LOGE("Not get key_mgmt.\n");
		}

		// mac_ap
		size = snprintf(data + len,data_len - len,
			",%s",mac_ap);
		len += size;

		// ip
		if(sta_cli_value_get(reply,
			"ip_address=",
			buf,
			BUF_SIZE))
		{
			size = snprintf(data + len,data_len - len,
				",%s",buf);
			len += size;
		}else{
			memcpy(data + len,",",1);
			len += 1;
			LOGE("Not get IP.\n");
		}
	}else{
		memcpy(data + len,"0",1);
		len += 1;

		if(sta_cli_value_get(reply,
			"\naddress=",
			buf,
			BUF_SIZE))
		{
			size = snprintf(data + len,data_len - len,
				",%s",buf);
			len += size;

		}else{
			memcpy(data + len,",",1);
			len += 1;
			LOGE("Not get MAC address.\n");
		}

		memcpy(data + len,",,,,,,,",7);
		len += 7;
	}

	memcpy(data + len,"\r\n",2);
	len += 2;
	data[len] = '\0';

    LOGE("STATUS:\n%s\n",data);
#undef BUF_SIZE
    return STA_ERR_SUCCESS;
}

static sta_err_enum
sta_cli_cmd_mib_parse
(
    const char *reply,
    char *data,
    size_t len
)
{
    LOGE("MIB:\n%s\n",reply);

    memcpy(data,reply,strlen(reply));

    return STA_ERR_SUCCESS;
}

static sta_err_enum
sta_cli_cmd_list_network_parse
(
    const char *reply,
    char *data,
    size_t len
)
{
    LOGE("LIST_NETWORK:\n%s\n",reply);

    bzero(data,len);
    const char *ptr = reply;
    bool start = FALSE;
    bool skip = FALSE;
    int count = 0; // count for ',' by every line.
    while(*ptr){
        if(!start && *ptr == '\n'){
            start = TRUE;
            ptr++;
        }

        if(start){
            if(sta_cli_is_empty_char(*ptr)){
                if(*ptr == '\r' || *ptr == '\n'){
                    *data++ = '\r';
                    *data++ = '\n';
                    while(*++ptr == '\r' || *ptr == '\n')
                        ;
                    count = 0;
                    skip = FALSE;
                }else{
                    if(count < 1) {
                        *data++ = ',';
                        count++;
                        while(*++ptr == ' ' || *ptr == '\t')
                            ;
                    } else {
                        skip = TRUE;
                        ptr++;
                    }
                }
            }else{
                if(!skip)
                    *data++ = *ptr++;
                else
                    ptr++;
            }
        }else{
            ptr++;
        }
    }

    //memcpy(data,reply,strlen(reply));

    LOGE("LIST_NETWORK:\n%s\n",data);

    return STA_ERR_SUCCESS;
}

static sta_err_enum
sta_cli_process_cmd
(
    const char *cmd
)
{
    sta_err_enum err = sta_ctrl_cmd_process(cmd,sta_cli_cmd_reply,STA_BUF_SIZE);
    if(err == STA_ERR_SUCCESS){
        if(strncmp(cmd,STA_CMD_SCAN,strlen(STA_CMD_SCAN)) == 0
            && strncmp(sta_cli_cmd_reply,STA_TAG_CMD_FAIL_BUSY,strlen(STA_TAG_CMD_FAIL_BUSY)) == 0){
            LOGE("\"%s\" busy.\n",cmd);
            return STA_ERR_SUCCESS;
        }

        if(strncmp(sta_cli_cmd_reply,STA_TAG_CMD_FAIL,strlen(STA_TAG_CMD_FAIL)) == 0){
            LOGE("\"%s\" fail.\n",cmd);
            return STA_ERR_UNKNOWN;
        }
        LOGE("[%s]:\n%s\n",cmd,sta_cli_cmd_reply);
    }else{
        LOGE("[%s]:FAIL\n",cmd);
    }
    return err;
}

static sta_err_enum
sta_cli_cmd_scan
(
    const char *cmd,
    char *data,
    size_t len
)
{
    bzero(data,len);
    sta_cli_cmd_id = CMD_ID_SCAN;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0
            || strncmp(sta_cli_cmd_reply,STA_TAG_CMD_FAIL_BUSY,strlen(STA_TAG_CMD_FAIL_BUSY)) == 0){// Is scanning ...
            sta_cli_thread_pause(STA_CLI_TIMEOUT);

            // Scan end.

            sta_cli_cmd_id = CMD_ID_SCAN_RESULTS;
            err = sta_cli_process_cmd("SCAN_RESULTS");
            sta_cli_cmd_id = CMD_ID_NON;
            if(STA_ERR_SUCCESS == err){
                return sta_cli_cmd_scan_parse(sta_cli_cmd_reply,
                    data,
                    len);
            }else{
                LOGE("SCAN_RESULTS cmd fail.\n");
                return STA_ERR_UNKNOWN;
            }
        }else{
            sta_cli_cmd_id = CMD_ID_NON;
            LOGE("SCAN cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("SCAN cmd fail.\n");
        return err;
    }
}


static char*
sta_cli_flag_get
(
	const char *ssid,
	char *flag,
	size_t len
)
{
	sta_err_enum err;
    char data[STA_BUF_SIZE];
	bzero(flag,len);
    err = sta_cli_cmd_scan("SCAN", data,STA_BUF_SIZE);
    if(err == STA_ERR_SUCCESS){
		if(strlen(data) == 0)
		{
			return NULL;
		}
		ssize_t end = str_indexof(data,ssid) - 1; // Point to ','
		if(end > 0)
		{
			char *ptr = data + end - 1;// Jump the ','
			int len = 0;
			while(*ptr != ',' && ptr != data)
			{
				ptr--;
				len++;
			}
			ptr++; // Point to flag.

			memcpy(flag,ptr,len);
			LOGE("%s : %s\n",ssid,flag);
			return flag;
		}
    }else{
		LOGE("SCAN_RESULTS cmd fail.");
		return NULL;
    }
    return NULL;
}


static sta_err_enum
sta_cli_cmd_status
(
    const char *cmd,
    char *data,
    size_t len
)
{
    bzero(data,len);
    sta_cli_cmd_id = CMD_ID_STATUS;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    sta_cli_cmd_id = CMD_ID_NON;
    if(STA_ERR_SUCCESS == err){
        return sta_cli_cmd_status_parse(sta_cli_cmd_reply,
            data,
            len);
    }else{
        LOGE("STATUS cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_mib
(
    const char *cmd,
    char *data,
    size_t len
)
{
    bzero(data,len);
    sta_cli_cmd_id = CMD_ID_MIB;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    sta_cli_cmd_id = CMD_ID_NON;
    if(STA_ERR_SUCCESS == err){
        return sta_cli_cmd_mib_parse(sta_cli_cmd_reply,
            data,
            len);
    }else{
        LOGE("MIB cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_reconfigure
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_RECONFIGURE;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("RECONFIGURE cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("RECONFIGURE cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_disconnect
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_DISCONNECT;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("DISCONNECT cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("DISCONNECT cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_reconnect
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_RECONNECT;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("RECONNECT cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("RECONNECT cmd fail.\n");
        return err;
    }
}


static sta_err_enum
sta_cli_cmd_save_config
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_SAVE_CONFIG;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("SAVE_CONFIG cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("SAVE_CONFIG cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_set_network_process
(
	const char *c
)
{
	LOGE("cmd = %s\n",c);
	const char *ptr = c;

    sta_cli_cmd_id = CMD_ID_SET_NETWORK;
	sta_err_enum err = STA_ERR_SUCCESS;
	char cmd[100];
	int index = str_indexof(ptr,"#");
	bzero(cmd,100);
	if(index > 0)
	{
		memcpy(cmd,ptr,index);
		ptr += (index + 1);
	}else
	{
		memcpy(cmd,ptr,strlen(ptr));
		ptr = NULL;
	}

	while(TRUE)
	{
	    err = sta_cli_process_cmd(c);
	    if(STA_ERR_SUCCESS == err){
	        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
	            //return STA_ERR_SUCCESS;
	            LOGE("Success:%s\n",cmd);
	        }else{
	            LOGE("Fail:%s\n",cmd);
				sta_cli_cmd_id = CMD_ID_NON;
	            return STA_ERR_UNKNOWN;
	        }
	    }else{
	        sta_cli_cmd_id = CMD_ID_NON;
	        LOGE("Fail:%s\n",cmd);
	        return err;
	    }

		if(ptr == NULL)
			break;

		LOGE("ptr = %s",ptr);

		index = str_indexof(ptr,"#");
		bzero(cmd,100);
		if(index > 0)
		{
			memcpy(cmd,ptr,index);
			ptr += (index + 1);
		}else
		{
			memcpy(cmd,ptr,strlen(ptr));
			ptr = NULL;
		}
	}

	sta_cli_cmd_id = CMD_ID_NON;
	return STA_ERR_SUCCESS;
}

static sta_err_enum
sta_cli_cmd_set_network
(
    const char *cmd,
    const char *flag
)
{
	LOGE("cmd = %s\n",cmd);
	char buf[500];
    LOGE("test11\n");
	int index = str_indexof(cmd," psk ");
    LOGE("test12\n");
	int net_id = atoi(cmd + strlen(STA_CMD_SET_NETWORK) + 1);
    LOGE("test13\n");
	if(index > 0){ // Is set "psk"
	    LOGE("test14\n");
		char psk[64] = {0};
		int start = index + 5; // " psk "
		if(*(cmd + start) == '"')
		{
		    LOGE("test15\n");
			memcpy(psk,cmd + start + 1,strlen(cmd) - start - 2);
		}else{
            LOGE("test16\n");
			memcpy(psk,cmd + start,strlen(cmd) - start);
		}
		LOGE("psk = %s\n",psk);

		// Set to OPEN (No psk)
		// SET_NETWORK <net_id> key_mgmt NONE
		if(strcmp(psk,"0") == 0)
		{
			int size = snprintf(buf,500,
					"%s %d key_mgmt NONE",
					STA_CMD_SET_NETWORK,
					net_id);
			buf[size] = '\0';
			return sta_cli_cmd_set_network_process(buf);
		}

		// WEP
		// key_mgmt=NONE
		// auth_alg=OPEN SHARED
		// wep_key0="0123456789abc"
		if(flag && str_contains(flag, "WEP")
			&&(strlen(psk) == 5
				|| strlen(psk) == 13
				|| strlen(psk) == 10
				|| strlen(psk) == 26))
		{
			int size = 0;
			if(strlen(psk) == 5
				|| strlen(psk) == 13)
			{
				size = snprintf(buf,500,
					"%s %d key_mgmt NONE#%s %d auth_alg SHARED#%s %d wep_key0 \"%s\"",
					STA_CMD_SET_NETWORK,
					net_id,
					STA_CMD_SET_NETWORK,
					net_id,
					STA_CMD_SET_NETWORK,
					net_id,
					psk);
			}else{
				size = snprintf(buf,500,
					"%s %d key_mgmt NONE#%s %d auth_alg SHARED#%s %d wep_key0 %s",
					STA_CMD_SET_NETWORK,
					net_id,
					STA_CMD_SET_NETWORK,
					net_id,
					STA_CMD_SET_NETWORK,
					net_id,
					psk);
			}

			buf[size] = '\0';
			return sta_cli_cmd_set_network_process(buf);
		}

		// Default is "WPA/WPA2"
		int size = snprintf(buf,500,
				"%s#%s %d key_mgmt WPA-PSK",
				cmd,
				STA_CMD_SET_NETWORK,
				net_id);
		buf[size] = '\0';
		return sta_cli_cmd_set_network_process(buf);
	}
	else // SSID
	{
	    LOGE("test21\n");
		index = str_indexof(cmd," ssid ");
		char ssid[STA_BUF_SIZE] = {0};
		int start = index + 6; // " ssid "
		if(*(cmd + start) == '"')
		{
			memcpy(ssid,cmd + start + 1,strlen(cmd) - start - 2);
		}else{
			memcpy(ssid,cmd + start,strlen(cmd) - start);
		}
		LOGE("ssid = %s\n",ssid);


		//char ssid_result[STA_SSID_MAX_LEN + 1];
		//sta_cli_ssid_process(ssid,ssid_result,STA_SSID_MAX_LEN + 2 + 1);
       // LOGE("test22, ssid_result: %s\n", ssid_result);
		char cmd_result[STA_BUF_SIZE];
		int size = snprintf(cmd_result,STA_BUF_SIZE,
			"%s %d ssid %s",
			STA_CMD_SET_NETWORK,
			net_id,
			ssid);
		cmd_result[size] = '\0';
		LOGE("cmd = %s\n",cmd_result);

		return sta_cli_cmd_set_network_process(cmd);
	}
}


static sta_err_enum
sta_cli_cmd_get_network
(
    const char *cmd,
    char *value,
    int len
)
{
    bzero(value,len);
    sta_cli_cmd_id = CMD_ID_GET_NETWORK;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;

        char *tmp = sta_cli_cmd_reply;
        while(*tmp == '\"'){
            tmp++;
        }
        // Copy with '\0'
        memcpy(value,tmp,strlen(tmp) + 1);

        tmp = value + strlen(value) -1;
        while(*tmp == '\"'){
            tmp = '\0';
            tmp--;
        }

        LOGE("GET_NETWORK:%s.\n",value);
        return STA_ERR_SUCCESS;
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("GET_NETWORK cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_remove_network
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_REMOVE_NETWORK;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("REMOVE_NETWORK cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("REMOVE_NETWORK cmd fail.\n");
        return err;
    }
}


static sta_err_enum
sta_cli_cmd_add_network
(
    const char *cmd
)
{
	LOGE("cmd = %s\n",cmd);
    sta_cli_cmd_id = CMD_ID_ADD_NETWORK;
    sta_err_enum err = sta_cli_process_cmd(STA_CMD_ADD_NETWORK);
    LOGE("test1\n");
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        int net_id = atoi(sta_cli_cmd_reply);
        LOGE("test2\n");
        if(net_id >= 0){ // Add network success.
            // Point to ssid
            LOGE("test3\n");
            /*
            const char *ptr = cmd + strlen(STA_CMD_ADD_NETWORK) + 1;

            //int index = str_indexof(ptr," ");

            char *pass_ptr = cmd + strlen(cmd);
            while(*--pass_ptr != ' ')
                ;
            pass_ptr++; // Point to pass.


            char ssid[STA_BUF_SIZE] = {0};
            LOGE("test4\n");
            memcpy(ssid,ptr,pass_ptr - ptr - 1);
            */

            char buf[STA_BUF_SIZE] = {'\0'};
            char ssid[STA_BUF_SIZE] = {'\0'};
            char psk[STA_BUF_SIZE] = {'\0'};
            int len = 0;
            LOGE("test5\n");

            sta_cli_ssid_get(ssid);
            len = strlen(ssid);
            ssid[len - 1] = '\0';

            sta_cli_psk_get(psk);
            len = strlen(psk);
            psk[len - 1] = '\0';


            int size = snprintf(buf,STA_BUF_SIZE,
                "%s %d ssid \"%s\"",
                STA_CMD_SET_NETWORK,
                net_id,
                ssid);
            LOGE("test6\n");
            buf[size] = '\0';


            err = sta_cli_cmd_set_network(buf,NULL);
            LOGE("test7\n");
            if(STA_ERR_SUCCESS == err){
				char flag[50];
				sta_cli_flag_get(ssid,flag,50);
                size = snprintf(buf,100,
                        "%s %d psk \"%s\"",
                        STA_CMD_SET_NETWORK,
                        net_id,
                        psk);
                buf[size] = '\0';
                err = sta_cli_cmd_set_network(buf,flag);
                if(STA_ERR_SUCCESS == err){
                    return STA_ERR_SUCCESS;
                }
            }

			if(err != STA_ERR_SUCCESS) // remove network
			{
				int size = snprintf(buf,STA_BUF_SIZE,
	                "%s %d",
	                STA_CMD_REMOVE_NETWORK,
	                net_id);
	            buf[size] = '\0';
				sta_cli_process_cmd(buf);
			}

            return err;
        }else{
            LOGE("ADD_NETWORK cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        LOGE("ADD_NETWORK cmd fail.\n");
        sta_cli_cmd_id = CMD_ID_NON;
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_disable_network
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_DISABLE_NETWORK;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("DISABLE_NETWORK cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("DISABLE_NETWORK cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_enable_network
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_ENABLE_NETWORK;
    sta_err_enum err = sta_cli_process_cmd("ENABLE_NETWORK 1");
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("ENABLE_NETWORK cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("ENABLE_NETWORK cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_select_network
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_SELECT_NETWORK;
    sta_err_enum err = sta_cli_process_cmd("SELECT_NETWORK 1");
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("SELECT_NETWORK cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("SELECT_NETWORK cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_list_networks
(
    const char *cmd,
    char *data,
    size_t len
)
{
    bzero(data,len);
    sta_cli_cmd_id = CMD_ID_LIST_NETWORKS;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    sta_cli_cmd_id = CMD_ID_NON;
    if(STA_ERR_SUCCESS == err){
        return sta_cli_cmd_list_network_parse(sta_cli_cmd_reply,
            data,
            len);
    }else{
        LOGE("LIST_NETWORKS cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_reassociate
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_REASSOCIATE;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("REASSOCIATE cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("REASSOCIATE cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_cmd_reattach
(
    const char *cmd
)
{
    sta_cli_cmd_id = CMD_ID_REATTACH;
    sta_err_enum err = sta_cli_process_cmd(cmd);
    if(STA_ERR_SUCCESS == err){
        sta_cli_cmd_id = CMD_ID_NON;
        if(strncmp(sta_cli_cmd_reply,"OK",2) == 0){
            return STA_ERR_SUCCESS;
        }else{
            LOGE("REATTACH cmd fail.\n");
            return STA_ERR_UNKNOWN;
        }
    }else{
        sta_cli_cmd_id = CMD_ID_NON;
        LOGE("REATTACH cmd fail.\n");
        return err;
    }
}

static sta_err_enum
sta_cli_init
(
    void
)
{
    sta_err_enum result = STA_ERR_SUCCESS;
    if((result = sta_ctrl_driver_init(TRUE)) != STA_ERR_SUCCESS){
        LOGE("Driver init fail(%d).\n",result);
        return result;
    }

    if((result = sta_ctrl_wpa_init(
        "/etc/wifi/wpa_supplicant.conf",
        "wlan0",
        sta_cli_wpa_msg_cb)) != STA_ERR_SUCCESS){
        LOGE("wpa_supplicant init fail(%d).\n",result);
        return result;
    }
	//pthread_mutex_init(&sta_mutex,NULL);
    return result;
}

static sta_err_enum
sta_cli_deinit
(
    void
)
{
    sta_err_enum result = STA_ERR_SUCCESS;
    if((result = sta_ctrl_wpa_deinit()) != STA_ERR_SUCCESS){
        LOGE("sta_ctrl_wpa_deinit fail(%d).",result);
        return result;
    }

    if((result = sta_ctrl_driver_init(FALSE)) != STA_ERR_SUCCESS){
        LOGE("Driver close fail(%d).\n",result);
        return result;
    }
	//pthread_mutex_destroy(&sta_mutex);
    return result;
}

/**
* CMD-CLOSE-SUCCESS
* CMD-CLOSE-FAIL:2
*
* CMD-SCAN-XXX
*
* IND-XXX
*
*/
bool sta_cli_cmd_parse
(
    const char *cmd,
    char *reply,
    size_t reply_len
)
{
	LOGE("cmd:%s\n",cmd);
    bzero(reply,reply_len);
    sta_err_enum err = STA_ERR_UNKNOWN;
    if(strncmp(cmd,(STA_CMD_OPEN),strlen(STA_CMD_OPEN)) == 0){
        // Will OPEN connection with wpa_supplicant.
        err = sta_cli_init();
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
            sta_should_send_connected_msg = FALSE;
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_CLOSE,strlen(STA_CMD_CLOSE)) == 0){
        err = sta_cli_deinit();
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
            sta_should_send_connected_msg = TRUE;
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_SCAN,strlen(STA_CMD_SCAN)) == 0){
        char data[STA_BUF_SIZE];
        err = sta_cli_cmd_scan(cmd, data,STA_BUF_SIZE);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s"STA_CMD_SEPARATED,
                data);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_STATUS,strlen(STA_CMD_STATUS)) == 0){
        char data[STA_BUF_SIZE];
        err = sta_cli_cmd_status(cmd, data,STA_BUF_SIZE);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                data);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_MIB,strlen(STA_CMD_MIB)) == 0){
        char data[STA_BUF_SIZE];
        err = sta_cli_cmd_mib(cmd, data,STA_BUF_SIZE);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                data);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_RECONFIGURE,strlen(STA_CMD_RECONFIGURE)) == 0){
        err = sta_cli_cmd_reconfigure(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_DISCONNECT,strlen(STA_CMD_DISCONNECT)) == 0){
		sta_disconnectting = TRUE;
		err = sta_cli_cmd_disconnect(cmd);
		// Not reply(Reply after disconnecd).
#if 0
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
#endif
		if(err == STA_ERR_SUCCESS)
		{
			LOGE("sta_cli_cmd_disconnect success.\n");
			//pthread_mutex_lock(&sta_mutex);
			//if(sta_connected)
			//{
				#define GET_STATUS_MAX 5
				int count = 0;
				bool ok = FALSE;
				usleep(500);
				while(count++ < GET_STATUS_MAX)
				{
					sta_err_enum err = sta_cli_process_cmd(STA_CMD_STATUS);
				    if(STA_ERR_SUCCESS == err){
				        char mac_ap[STA_MAC_LEN + 1];
						if(!sta_cli_value_get(sta_cli_cmd_reply,
							"bssid=",
							mac_ap,
							STA_MAC_LEN + 1)) // Disconnected.
						{
							LOGE("Disconnected success.\n");
							snprintf(reply,reply_len,
								"%s-%s-%s"STA_CMD_SEPARATED,
								STA_TAG_CMD,
								cmd,
								STA_TAG_CMD_SUCCESS);
							ok = TRUE;
							break;
						}else{ // Connected.
							LOGE("Not disconnected.Try again(STATUS).\n");
							usleep(500);
						}
				    }else{
				        LOGE("STATUS cmd fail.\n");
				        break;
				    }
				}

				if(!ok) // fail
				{
					LOGE("Disconnect fail.\n");
		            snprintf(reply,reply_len,
		                "%s-%s-%s:%d"STA_CMD_SEPARATED,
		                STA_TAG_CMD,
		                cmd,
		                STA_TAG_CMD_FAIL,
		                STA_ERR_UNKNOWN);
				}
				//sta_connected = FALSE;
			//}
			//pthread_mutex_unlock(&sta_mutex);
		}else{
			LOGE("sta_cli_cmd_disconnect fail.\n");
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
		}
		sta_disconnectting = FALSE;
    }else if(strncmp(cmd,STA_CMD_RECONNECT,strlen(STA_CMD_RECONNECT)) == 0){
        err = sta_cli_cmd_reconnect(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_SAVE_CONFIG,strlen(STA_CMD_SAVE_CONFIG)) == 0){
        err = sta_cli_cmd_save_config(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_SET_NETWORK,strlen(STA_CMD_SET_NETWORK)) == 0){
        err = sta_cli_cmd_set_network(cmd,NULL);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_GET_NETWORK,strlen(STA_CMD_GET_NETWORK)) == 0){
        char data[100];
        err = sta_cli_cmd_get_network(cmd,data,100);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                data);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_REMOVE_NETWORK,strlen(STA_CMD_REMOVE_NETWORK)) == 0){
        err = sta_cli_cmd_remove_network(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_ADD_NETWORK,strlen(STA_CMD_ADD_NETWORK)) == 0){
        err = sta_cli_cmd_add_network(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_DISABLE_NETWORK,strlen(STA_CMD_DISABLE_NETWORK)) == 0){
        err = sta_cli_cmd_disable_network(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_ENABLE_NETWORK,strlen(STA_CMD_ENABLE_NETWORK)) == 0){
        err = sta_cli_cmd_enable_network(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_SELECT_NETWORK,strlen(STA_CMD_SELECT_NETWORK)) == 0){
        err = sta_cli_cmd_select_network(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_LIST_NETWORKS,strlen(STA_CMD_REASSOCIATE)) == 0){
        char data[STA_BUF_SIZE];
        err = sta_cli_cmd_list_networks(cmd, data,STA_BUF_SIZE);

//		char reply_tmp[STA_BUF_SIZE];
//		memset(reply_tmp,0,STA_BUF_SIZE);
//		char *reply_ptr = data;
//		int index = 0;
//		int pos = 0;
//		while(*reply_ptr != '\0'){
//			if(*reply_ptr == ','){
//				index++;
//			}

//			if(index == 3){
//				if(*reply_ptr == '\n'){
//					index = 0;
//					reply_tmp[pos++] = '\r';
//					reply_tmp[pos++] = '\n';
//				}
//			}else{
//				reply_tmp[pos++] = *reply_ptr;
//			}

//			reply_ptr++;
//		}

        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                data);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_REASSOCIATE,strlen(STA_CMD_REASSOCIATE)) == 0){
        err = sta_cli_cmd_reassociate(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else if(strncmp(cmd,STA_CMD_REATTACH,strlen(STA_CMD_REATTACH)) == 0){
        err = sta_cli_cmd_reattach(cmd);
        if(err == STA_ERR_SUCCESS){
            snprintf(reply,reply_len,
                "%s-%s-%s"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_SUCCESS);
        }else{
            snprintf(reply,reply_len,
                "%s-%s-%s:%d"STA_CMD_SEPARATED,
                STA_TAG_CMD,
                cmd,
                STA_TAG_CMD_FAIL,
                err);
        }
    }else{
        LOGE("Unknown cmd:%s\n",cmd);
        return FALSE;
    }
    return TRUE;
}


