#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <errno.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <signal.h>

#include "audio_if_api.h"
#include "mbtk_audio2.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"

#define BUFF_SIZE 4096

#define ID_RIFF 0x46464952
#define ID_WAVE 0x45564157
#define ID_FMT  0x20746d66
#define ID_DATA 0x61746164
#define FORMAT_PCM 1

#define PCM_WB_BUF_SIZE     640
#define PCM_NARROW_BUF_SIZE 320

static int record_fd = -1;
static bool running = FALSE;

static void recorder_cb(void *data, uint32 data_len)
{
    if(record_fd > 0) {
        if(data_len > 0) {
            LOGD("Recorver data:%d", data_len);
            mbtk_write(record_fd, data, data_len);
        } else {
            LOGD("Recorver data end.");
        }
    }
}

static void voip_playback_run(void *arg)
{
    int rc, len, fd, frames = 0;
    int pack_size = 1024;
    //char buf[MBTK_PCM_WB_BUF_SIZE];
    char buf[BUFF_SIZE];
    char *path = "/data/voip_playback.wav";
    struct stat st;
    struct riff_wave_header riff_wave_header;
    struct chunk_header chunk_header;
    struct chunk_fmt chunk_fmt = {0};
    unsigned int more_chunks = 1;

    /* Check and open source file */
    if (access(path, F_OK) || stat(path, &st)) {
        printf("%s: error reading from file %s\n", __FUNCTION__, path);
        return;
    }

    if (!st.st_size) {
        printf("%s: empty file %s\n", __FUNCTION__, path);
        return;
    }

    fd = open(path, O_RDONLY);
    if (fd < 0) {
        printf("%s: error opening file %s\n", __FUNCTION__, path);
        return;
    }

    lseek(fd, sizeof(struct wav_header), SEEK_SET);


    if(mbtk_audio_voice_pcm_playback_start()) {
        printf("mbtk_audio_voice_pcm_playback_start() fail.\n");
        return;
    }

#if 1
    if(mbtk_audio_voice_pcm_record_start(recorder_cb)) {
        printf("mbtk_audio_voice_pcm_record_start() fail.\n");
        //goto exit;
    }
#endif

    while (running) {
        /* Playback loop */
        memset(buf, 0x00, sizeof(buf));
        len = read(fd, buf, pack_size);
        if (len == -1) {
            printf("%s: error reading from file\n", __FUNCTION__);
            break;
        }

        if (len == 0) {
            /* reached EOF */
            printf("%s: nothing to read\n", __FUNCTION__);
            break;
        }

        if((rc = mbtk_audio_pcm_play_data_send(buf, len)) < len) {
            printf("Send data %d/%d\n", rc, len);
            break;
        }

        printf("%s: No.%d frame playback[len - %d]\n", __FUNCTION__, ++frames, len);
    }

#if 1
    if(mbtk_audio_pcm_recorder_stop()) {
        printf("mbtk_audio_pcm_recorder_stop() fail.\n");
        //goto exit;
    }
#endif

    LOGD("playback_thread exit.");
}

#if 0
static void voip_record_run(void *arg)
{

}
#endif

static void sig_handler(int sig)
{
    running = FALSE;

    printf("Success exit by signal...\n");

    sleep(1);

    exit(0);
}


int main(int argc, char *argv[])
{
    mbtk_log_init("radio", "RTP_TEST");

    signal(SIGINT, sig_handler);
    signal(SIGTERM, sig_handler);

    if(mbtk_audio_pcm_init()) {
        printf("mbtk_audio_pcm_init() fail.\n");
        return -1;
    }

    struct wav_header header;
    int rc = 0;
    char *path = "/data/voip_record.wav";

    header.riff_id = ID_RIFF;
    header.riff_sz = 0;
    header.riff_fmt = ID_WAVE;
    header.fmt_id = ID_FMT;
    header.fmt_sz = 16;
    header.audio_format = 1;        //FORMAT_PCM;
    header.num_channels = 1;        //Modem ONLY support mono recording
    header.sample_rate = 8000;
    header.bits_per_sample = 16;    //PCM_SAMPLEBITS_S16_LE;
    header.byte_rate = (header.bits_per_sample / 8) * header.num_channels * header.sample_rate;
    header.block_align = header.num_channels * (header.bits_per_sample / 8);
    header.data_id = ID_DATA;

    record_fd = open(path, O_WRONLY | O_CREAT | O_TRUNC, 0644);
    if (record_fd < 0) {
        printf("%s: error opening file %s!\n", __FUNCTION__, path);
        rc = -1;
        goto exit;
    }

    //leave enough room for header
    lseek(record_fd, sizeof(struct wav_header), SEEK_SET);

    running = TRUE;

    pthread_t playabck_thread/*, record_thread*/;
    rc = pthread_create(&playabck_thread, NULL, (void *)&voip_playback_run, NULL);
    if (rc < 0) {
        LOGE("error creating thread_start!");
        rc = -1;
        goto exit;
    }

#if 0
    rc = pthread_create(&record_thread, NULL, (void *)&voip_record_run, NULL);
    if (rc < 0) {
        LOGE("error creating thread_start!");
        rc = -1;
        goto exit;
    }
#endif

    if (pthread_join(playabck_thread, NULL)){
        printf("error join thread!\n");
        abort();
    }
    LOGD("playabck_thread() join exit.");

    lseek(record_fd, 0, SEEK_SET);
    mbtk_write(record_fd, &header, sizeof(struct wav_header));
    close(record_fd);

#if 0
    if (pthread_join(record_thread, NULL)){
        printf("error join thread!\n");
        abort();
    }
    LOGD("record_thread() join exit.");
#endif

exit:
    if(mbtk_audio_pcm_deinit()) {
        printf("mbtk_audio_pcm_deinit() fail.\n");
        return -1;
    }
    return rc;
}

