#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>

#include "mbtk_info_api.h"

static mbtk_info_handle_t* info_handle = NULL;


static void help()
{
    printf("msdcfg <item> <value>: Set MSD item value.\n");
    printf("msdgen: Generate MSD by items.\n");
    printf("msd <MSD>: Get/Set MSD.\n");
    printf("msdpush: PUSH MSD.\n");
    printf("only <0-5> <test_num> <reconfig_num>: Get/Set ecall only mode.\n");
    printf("reg 0/1: Set ecall reg mode.\n");
    printf("dial <0-5>: Get/Start ecall dial.\n");
    printf("mode EU/ERA: Get/Set ecall mode\n");
    printf("cfg_get <type1> ... <type14>: Get ecall config item.\n");
    printf("cfg_set <value1> ... <value14>: Set ecall config item.\n");
    printf("sms_num <number>: Get/Set sms number.\n");
    printf("mute_spk <0/1>: Set spk mute or not.\n");
    printf("gain <0/1/2> <gain>: Set ecall DSP gain.\n");
}

static void ecall_state_change_cb(const void* data, int data_len)
{
    if(data)
    {
        mbtk_ril_ecall_state_info_t *ecall_data = (mbtk_ril_ecall_state_info_t*)data;
        printf("ecall state change : urc_id - %d, urc_data - %s\n", ecall_data->urc_id, ecall_data->urc_data);
    }
}


static void sig_process(int sig)
{
    LOGI("I got signal %d\n", sig);
    switch(sig)
    {
        case SIGINT: // Ctrl + C
        {
            LOGI("Exit by SIGINT.\n");
            mbtk_info_handle_free(&info_handle);
            exit(0);
        }
        case SIGQUIT: // Ctrl + \ (类似 SIGINT ，但要产生core文件)
        {
            LOGI("Exit by SIGQUIT.\n");
            mbtk_info_handle_free(&info_handle);
            exit(0);
        }
        case SIGTERM:// 默认kill   (同 SIGKILL ，但 SIGKILL 不可捕获)
        {
            LOGI("Exit by SIGTERM.\n");
            mbtk_info_handle_free(&info_handle);
            exit(0);
        }
        case SIGTSTP:// Ctrl + Z (同 SIGSTOP ，但 SIGSTOP 不可捕获)
        {
            LOGI("Exit by SIGTSTP.\n");
            exit(0);
        }
        case SIGSEGV: // 如空指针
        {
            LOGI("Exit by SIGSEGV.\n");
            exit(0);
        }
        default:
        {
            LOGI("Unknown sig:%d\n",sig);
            break;
        }
    }
}

int main(int argc, char *argv[])
{
    signal(SIGINT, sig_process);
    signal(SIGQUIT, sig_process);
    signal(SIGTERM, sig_process);
    //signal(SIGTSTP, sig_process);
    //signal(SIGSEGV, sig_process);

    mbtk_log_init("radio","ECALL_CLI");

#ifdef MBTK_DUMP_SUPPORT
    mbtk_debug_open(NULL, TRUE);
#endif

    //test2(0, "192.168.1.198");
    //test2(1, "2409:8162:140:cd3c:1:2:1494:72ba");
    //test2(1, "254.128.0.0.0.0.0.0.0.1.0.2.144.5.212.239");
    //test2(1, "2400:3200::1");

    info_handle = mbtk_info_handle_get();
    if(!info_handle)
    {
        return -1;
    }

    mbtk_ecall_state_change_cb_reg(info_handle, ecall_state_change_cb);

    printf(">>>>>>>>>>>>>>>>>>>>>>>>Enter cmd:\n");
    char cmd[1024];
    while(1)
    {
        memset(cmd, 0, sizeof(cmd));
        int err;
        if(fgets(cmd, sizeof(cmd), stdin))
        {
            char *ptr = cmd + strlen(cmd) - 1;
            while(ptr >= cmd && (*ptr == '\r' || *ptr == '\n'))
            {
                *ptr-- = '\0';
            }

            if(!strncasecmp(cmd, "msdcfg", 6)) // msdcfg <item> <value>
            {
                mbtk_ecall_msd_cfg_info_t cfg;
                memset(&cfg, 0, sizeof(mbtk_ecall_msd_cfg_info_t));
                int item;
                int count = sscanf(cmd, "msdcfg %d %s", &item, cfg.data);
                if(count == 2 && strlen((char*)cfg.data) > 0) {
                    cfg.item_type = (mbtk_ecall_msd_item_enum)item;
                    err = mbtk_ecall_msd_item_set(info_handle, &cfg);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("MSD item set success\n");
                    }
                }
            }
            else if(!strncasecmp(cmd, "msdgen", 6)){
                err = mbtk_ecall_msd_gen(info_handle);
                if(err) {
                    printf("Error : %d\n", err);
                } else {
                    printf("MSD gen success\n");
                }
            } else if(!strncasecmp(cmd, "msdpush", 7)){
                err = mbtk_ecall_push(info_handle);
                if(err) {
                    printf("Error : %d\n", err);
                } else {
                    printf("MSD PUSH success\n");
                }
            } else if(!strncasecmp(cmd, "msd", 3)){ // msd <MSD>
                uint8 msd[500] = {0};
                if(!strcasecmp(cmd, "msd")) { // Get
                    err = mbtk_ecall_msd_get(info_handle, msd);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("MSD : %s\n", msd);
                    }
                } else { // Set
                    int count = sscanf(cmd, "msd %s", msd);
                    if(count == 1 && strlen((char*)msd) > 0) { // set
                        err = mbtk_ecall_msd_set(info_handle, msd);
                        if(err) {
                            printf("Error : %d\n", err);
                        } else {
                            printf("MSD set success\n");
                        }
                    }
                }
            } else if(!strncasecmp(cmd, "only", 4)){ // only <0-5> <test_num> <reconfig_num>
                mbtk_ecall_only_info_t only_info;
                if(strcasecmp(cmd, "only") == 0) { // Get
                    memset(&only_info, 0, sizeof(mbtk_ecall_only_info_t));
                    err = mbtk_ecall_only_get(info_handle, &only_info);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Only : active-%d,sim_type-%d,test_num-%s,reconfig_num-%s\n", only_info.active, only_info.sim_type, only_info.test_num, only_info.reconfig_num);
                    }
                } else { // Set
                    memset(&only_info, 0, sizeof(mbtk_ecall_only_info_t));
                    int tmp_int = -1;
                    int count = sscanf(cmd, "only %d %s %s", &tmp_int, only_info.test_num, only_info.reconfig_num);
                    if(count > 0 && tmp_int >= 0) { // set
                        only_info.active = (mbtk_ecall_only_type_enum)tmp_int;
                        err = mbtk_ecall_only_set(info_handle, &only_info);
                        if(err) {
                            printf("Error : %d\n", err);
                        } else {
                            printf("MSD set success\n");
                        }
                    }
                }
            } else if(!strncasecmp(cmd, "dial", 4)){ // dial <0-5>
                mbtk_ecall_dial_type_enum type;
                if(!strcasecmp(cmd, "dial")) { // Get
                    err = mbtk_ecall_dial_state_get(info_handle, &type);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Type : %d\n", type);
                    }
                } else { // Set
                    int reset;
                    int count = sscanf(cmd, "dial %d", &reset);
                    if(count == 1) {
                        err = mbtk_ecall_dial_start(info_handle, (mbtk_ecall_dial_type_enum)reset);
                        if(err) {
                            printf("Error : %d\n", err);
                        } else {
                            printf("Start ecall dial success\n");
                        }
                    }
                }
            } else if(!strncasecmp(cmd, "reg", 3)){ // reg <0/1>
                if(!strcasecmp(cmd, "reg 0")) {
                    err = mbtk_ecall_reg_set(info_handle, 0);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Set net reg 0\n");
                    }
                } else if(!strcasecmp(cmd, "reg 1")) {
                    err = mbtk_ecall_reg_set(info_handle, 1);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Set net reg 1\n");
                    }
                }
            } else if(!strncasecmp(cmd, "mode", 4)){ // mode EU/ERA
                if(!strcasecmp(cmd, "mode")) {
                    mbtk_ecall_mode_type_enum mode;
                    err = mbtk_ecall_mode_get(info_handle, &mode);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Ecall mode[%d] : %s\n", mode, mode == MBTK_ECALL_MODE_TYPE_EU ? "EU" : "ERA");
                    }
                } else if(!strcasecmp(cmd, "mode EU")) {
                    err = mbtk_ecall_mode_set(info_handle, MBTK_ECALL_MODE_TYPE_EU);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Set mode EU\n");
                    }
                } else if(!strcasecmp(cmd, "mode ERA")) {
                    err = mbtk_ecall_mode_set(info_handle, MBTK_ECALL_MODE_TYPE_ERA);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Set mode ERA\n");
                    }
                }
            } else if(!strncasecmp(cmd, "cfg_get", 7)){ // cfg_get <type1> ... <type14>
                int tmp[MBTK_ECALL_CFG_ITEM_MAX] = {0};
                int count = sscanf(cmd, "cfg_get %d %d %d %d %d %d %d %d %d %d %d %d %d %d",
                                &tmp[0], &tmp[1], &tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7],
                                &tmp[8], &tmp[9], &tmp[10], &tmp[11], &tmp[12], &tmp[13]);
                mbtk_ecall_cfg_info_t cfg;
                if(count == MBTK_ECALL_CFG_ITEM_MAX) { // Get
                    memset(&cfg, 0, sizeof(cfg));
                    cfg.type = 0;
                    if(tmp[MBTK_ECALL_CFG_ITEM_T3])
                        cfg.type |= MBTK_ECALL_CFG_T3;
                    if(tmp[MBTK_ECALL_CFG_ITEM_T5])
                        cfg.type |= MBTK_ECALL_CFG_T5;
                    if(tmp[MBTK_ECALL_CFG_ITEM_T6])
                        cfg.type |= MBTK_ECALL_CFG_T6;
                    if(tmp[MBTK_ECALL_CFG_ITEM_T7])
                        cfg.type |= MBTK_ECALL_CFG_T7;
                    if(tmp[MBTK_ECALL_CFG_ITEM_TH])
                        cfg.type |= MBTK_ECALL_CFG_TH;
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_CALLBACK])
                        cfg.type |= MBTK_ECALL_CFG_TIMER_CALLBACK;
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_CLEARDOWN])
                        cfg.type |= MBTK_ECALL_CFG_TIMER_CLEARDOWN;
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_DEREG])
                        cfg.type |= MBTK_ECALL_CFG_TIMER_DEREG;
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_DIAL])
                        cfg.type |= MBTK_ECALL_CFG_TIMER_DIAL;
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_REDIAL])
                        cfg.type |= MBTK_ECALL_CFG_TIMER_REDIAL;
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_SMS])
                        cfg.type |= MBTK_ECALL_CFG_TIMER_SMS;
                    if(tmp[MBTK_ECALL_CFG_ITEM_REDIALCNT])
                        cfg.type |= MBTK_ECALL_CFG_REDIALCNT;
                    if(tmp[MBTK_ECALL_CFG_ITEM_SMSPROCESS])
                        cfg.type |= MBTK_ECALL_CFG_SMSPROCESS;
                    if(tmp[MBTK_ECALL_CFG_ITEM_SMSMSDCNT])
                        cfg.type |= MBTK_ECALL_CFG_SMSMSDCNT;

                    err = mbtk_ecall_cfg_get(info_handle, &cfg);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Ecall config[%d]:\n", cfg.type);
                        int i = 0;
                        while(i < MBTK_ECALL_CFG_ITEM_MAX) {
                            printf("Item(%d) - %d\n", i, cfg.data[i]);
                            i++;
                        }
                    }
                }
            } else if(!strncasecmp(cmd, "cfg_set", 7)){ // cfg_set <value1> ... <value14>
                int tmp[MBTK_ECALL_CFG_ITEM_MAX] = {-1};
                int count = sscanf(cmd, "cfg_set %d %d %d %d %d %d %d %d %d %d %d %d %d %d",
                                &tmp[0], &tmp[1], &tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7],
                                &tmp[8], &tmp[9], &tmp[10], &tmp[11], &tmp[12], &tmp[13]);
                mbtk_ecall_cfg_info_t cfg;
                if(count == MBTK_ECALL_CFG_ITEM_MAX) { // Set
                    memset(&cfg, 0, sizeof(cfg));
                    cfg.type = 0;
                    if(tmp[MBTK_ECALL_CFG_ITEM_T3] >= 0) {
                        cfg.type |= MBTK_ECALL_CFG_T3;
                        cfg.data[MBTK_ECALL_CFG_ITEM_T3] = tmp[MBTK_ECALL_CFG_ITEM_T3];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_T5] >= 0) {
                        cfg.type |= MBTK_ECALL_CFG_T5;
                        cfg.data[MBTK_ECALL_CFG_ITEM_T5] = tmp[MBTK_ECALL_CFG_ITEM_T5];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_T6] >= 0) {
                        cfg.type |= MBTK_ECALL_CFG_T6;
                        cfg.data[MBTK_ECALL_CFG_ITEM_T6] = tmp[MBTK_ECALL_CFG_ITEM_T6];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_T7] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_T7;
                        cfg.data[MBTK_ECALL_CFG_ITEM_T7] = tmp[MBTK_ECALL_CFG_ITEM_T7];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_TH] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_TH;
                        cfg.data[MBTK_ECALL_CFG_ITEM_TH] = tmp[MBTK_ECALL_CFG_ITEM_TH];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_CALLBACK] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_TIMER_CALLBACK;
                        cfg.data[MBTK_ECALL_CFG_ITEM_TIMER_CALLBACK] = tmp[MBTK_ECALL_CFG_ITEM_TIMER_CALLBACK];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_CLEARDOWN] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_TIMER_CLEARDOWN;
                        cfg.data[MBTK_ECALL_CFG_ITEM_TIMER_CLEARDOWN] = tmp[MBTK_ECALL_CFG_ITEM_TIMER_CLEARDOWN];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_DEREG] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_TIMER_DEREG;
                        cfg.data[MBTK_ECALL_CFG_ITEM_TIMER_DEREG] = tmp[MBTK_ECALL_CFG_ITEM_TIMER_DEREG];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_DIAL] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_TIMER_DIAL;
                        cfg.data[MBTK_ECALL_CFG_ITEM_TIMER_DIAL] = tmp[MBTK_ECALL_CFG_ITEM_TIMER_DIAL];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_REDIAL] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_TIMER_REDIAL;
                        cfg.data[MBTK_ECALL_CFG_ITEM_TIMER_REDIAL] = tmp[MBTK_ECALL_CFG_ITEM_TIMER_REDIAL];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_TIMER_SMS] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_TIMER_SMS;
                        cfg.data[MBTK_ECALL_CFG_ITEM_TIMER_SMS] = tmp[MBTK_ECALL_CFG_ITEM_TIMER_SMS];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_REDIALCNT] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_REDIALCNT;
                        cfg.data[MBTK_ECALL_CFG_ITEM_REDIALCNT] = tmp[MBTK_ECALL_CFG_ITEM_REDIALCNT];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_SMSPROCESS] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_SMSPROCESS;
                        cfg.data[MBTK_ECALL_CFG_ITEM_SMSPROCESS] = tmp[MBTK_ECALL_CFG_ITEM_SMSPROCESS];
                    }
                    if(tmp[MBTK_ECALL_CFG_ITEM_SMSMSDCNT] >= 0){
                        cfg.type |= MBTK_ECALL_CFG_SMSMSDCNT;
                        cfg.data[MBTK_ECALL_CFG_ITEM_SMSMSDCNT] = tmp[MBTK_ECALL_CFG_ITEM_SMSMSDCNT];
                    }

                    err = mbtk_ecall_cfg_set(info_handle, &cfg);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Set ecall config[%d] success\n", cfg.type);
                    }
                }
            } else if(!strncasecmp(cmd, "sms_num", 7)){ // sms_num <number>
                uint8 number[RIL_MAX_NUMBER_LEN] = {0};
                if(!strcasecmp(cmd, "sms_num")) { // Get
                    err = mbtk_ecall_sms_number_get(info_handle, number);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("SMS number : %s\n", number);
                    }
                } else { // Set
                    int count = sscanf(cmd, "sms_num %s", number);
                    if(count == 1 && strlen((char*)number) > 0) {
                        err = mbtk_ecall_sms_number_set(info_handle, number);
                        if(err) {
                            printf("Error : %d\n", err);
                        } else {
                            printf("Set SMS number[%s] success\n", number);
                        }
                    }
                }
            } else if(!strncasecmp(cmd, "mute_spk", 8)){ // mute_spk <0/1>
                if(!strcasecmp(cmd, "mute_spk 0")) {
                    err = mbtk_ecall_mute_spk_set(info_handle, 0);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Set mute spk to 0\n");
                    }
                } else if(!strcasecmp(cmd, "mute_spk 1")) {
                    err = mbtk_ecall_mute_spk_set(info_handle, 1);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Set mute spk to 1\n");
                    }
                }
            } else if(!strncasecmp(cmd, "gain", 4)){    // gain <0/1/2> <gain>
                int tmp1 = -1, tmp2 = -1;
                int count = sscanf(cmd, "gain %d %d", &tmp1, &tmp2);
                mbtk_ecall_gain_info_t gain;
                if(count == 2 && tmp1 >= 0) { // Get
                    memset(&gain, 0, sizeof(gain));
                    gain.mode = (mbtk_ecall_gain_mode_enum)tmp1;
                    gain.gain = (int8)tmp2;
                    err = mbtk_ecall_dsp_gain_set(info_handle, &gain);
                    if(err) {
                        printf("Error : %d\n", err);
                    } else {
                        printf("Set DSP gain[%d] to %d\n", gain.mode, gain.gain);
                    }
                }
            }
            else if(!strcasecmp(cmd, "h") || !strcasecmp(cmd, "help")) {
                help();
            } else if(!strcasecmp(cmd, "q")) {
                break;
            } else {
                printf("\n");
            }
        }
    }

//exit:
    mbtk_info_handle_free(&info_handle);

    LOG("Client exec complete.");

    return 0;
}

