#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>

#include "mbtk_rtp.h"
#include "mbtk_log.h"


static void help()
{
    printf("rtp_mode <0/1>: Disable/Enable RTP.\n");
    printf("volume <0-7>: Set volume.\n");
    printf("remote_ip <xxx:xxx:xxx:xxx>: Set remote ip.\n");
    printf("vlan <dev>: Set local device.\n");
    printf("client_port <port>: Set client(local) port.\n");
    printf("server_port <port>: Set server(remote) port.\n");
    printf("sample_rate <8000/16000>: Set sample rate.\n");
    printf("channel <1>: Set channel.\n");
}


static void sig_handler(int sig)
{
    if(mbtk_rtp_deinit()) {
        printf("mbtk_rtp_deinit() fail.\n");
    }

    printf("Success exit by signal...\n");
    exit(0);
}

int main(int argc, char *argv[])
{
    mbtk_log_init("radio", "RTP_CLI");

    if(mbtk_rtp_init()) {
        printf("mbtk_rtp_init() fail.\n");
        return -1;
    }

    signal(SIGINT, sig_handler);
    signal(SIGTERM, sig_handler);

    char cmd[100];
    bool running = TRUE;
    while(running)
    {
        memset(cmd, 0, 100);
//        int err;
        // printf("0 : Disable    1 : Enable    Other : Exit\n");
        help();
        if(fgets(cmd, 100, stdin))
        {
            if(cmd[0] == '\r' || cmd[0] == '\n')
                continue;
            char *ptr = cmd + strlen(cmd) - 1;
            while(ptr >= cmd && (*ptr == '\r' || *ptr == '\n'))
            {
                *ptr-- = '\0';
            }

            if(!strncasecmp(cmd, "rtp_mode", 8))
            {
                int temp;
                if(1 == sscanf(cmd, "rtp_mode %d", &temp)) {
                    if(mbtk_rtp_enable((bool)temp)) {
                        printf("Error\n");
                    } else {
                        printf("Success\n");
                    }
                }
            }
            else if(!strncasecmp(cmd, "volume", 6)){
                int temp;
                if(1 == sscanf(cmd, "volume %d", &temp)) {
                    if(mbtk_rtp_volume_set(temp)) {
                        printf("Error\n");
                    } else {
                        printf("Success\n");
                    }
                }
            }
            else if(!strncasecmp(cmd, "remote_ip", 9)){
                char ipv4[20] = {0};
                if(1 == sscanf(cmd, "remote_ip %s", ipv4)) {
                    if(mbtk_rtp_remote_ip_set(ipv4)) {
                        printf("Error\n");
                    } else {
                        printf("Success\n");
                    }
                }
            }
            else if(!strncasecmp(cmd, "vlan", 4)){
                char vlan[20] = {0};
                if(1 == sscanf(cmd, "vlan %s", vlan)) {
                    if(mbtk_rtp_vlan_set(vlan)) {
                        printf("Error\n");
                    } else {
                        printf("Success\n");
                    }
                }
            }
            else if(!strncasecmp(cmd, "client_port", 11)){
                int temp;
                if(1 == sscanf(cmd, "client_port %d", &temp)) {
                    if(mbtk_rtp_client_port_set(temp)) {
                        printf("Error\n");
                    } else {
                        printf("Success\n");
                    }
                }
            }
            else if(!strncasecmp(cmd, "server_port", 11)){
                int temp;
                if(1 == sscanf(cmd, "server_port %d", &temp)) {
                    if(mbtk_rtp_server_port_set(temp)) {
                        printf("Error\n");
                    } else {
                        printf("Success\n");
                    }
                }
            }
            else if(!strncasecmp(cmd, "sample_rate", 11)){
                int temp;
                if(1 == sscanf(cmd, "sample_rate %d", &temp)) {
                    if(mbtk_rtp_sample_rate_set(temp)) {
                        printf("Error\n");
                    } else {
                        printf("Success\n");
                    }
                }
            }
            else if(!strncasecmp(cmd, "channel", 7)){
                int temp;
                if(1 == sscanf(cmd, "channel %d", &temp)) {
                    if(mbtk_rtp_channel_set(temp)) {
                        printf("Error\n");
                    } else {
                        printf("Success\n");
                    }
                }
            }

            else if(!strcasecmp(cmd, "h") || !strcasecmp(cmd, "help")) {
                help();
            } else if(!strcasecmp(cmd, "q")) {
                break;
            } else {
                printf("\n");
            }
        }
    }

//exit:
    if(mbtk_rtp_deinit()) {
        printf("mbtk_rtp_deinit() fail.\n");
        return -1;
    }

    printf("Success exit.\n");
    return 0;
}
