/*-----------------------------------------------------------------------------------------------*/
/**
  @file NULL
  @brief libmbedtls.so.3.6.2 function test
*/
/*-----------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  Copyright (c) 2024 mobiletek Wireless Solution, Co., Ltd. All Rights Reserved.
  mobiletek Wireless Solution Proprietary and Confidential.
-------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when       who          what, where, why
  --------   ---------    -----------------------------------------------------------------
  20241022    yq.wang      Created .
-------------------------------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdbool.h>
#include <arpa/inet.h>
#include <sys/socket.h>

#ifdef MBTK_MBEDTLS_V3_6_2_SUPPORT
#include "mbtk_mbedtls.h"

#define BUFFER_SIZE 1024

static int tcp_connect_init(int *client_fd, int port, char *ip)
{
    int ret = -1;
    struct sockaddr_in server_addr;

    if(port < 1 || port > 65535)
    {
        printf("[%s] Invalid port number\n", __func__);
        goto error;
    }

    *client_fd = socket(AF_INET, SOCK_STREAM, 0);
    if(*client_fd < 0)
    {
        printf("[%s] socket creation failed\n", __func__);
        goto error;
    }

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);
    ret = inet_pton(AF_INET, ip, &server_addr.sin_addr);
    if(ret <= 0)
    {
        perror("invalid address");
        goto error;
    }

    ret = connect(*client_fd, (struct sockaddr *)&server_addr, sizeof(server_addr));
    if(ret< 0)
    {
        perror("connection failed");
        goto error;
    }

    printf("[%s] Connected to %s:%d\n", __func__, ip, port);
    return 0;
error:
    if(*client_fd >= 0)
    {
        close(*client_fd);
        *client_fd = -1;
    }
    return -1;
}
    
int main(int argc, char *argv[])
{
    if(argc != 3)
    {
        printf("Usage: %s <IP> <PORT>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    int ret = -1;
    int client_fd = -1;
    ssize_t bytes_recv = 0;
    char buffer[BUFFER_SIZE] = {0};
    mbtk_mbedtls_ssl_result_e mbtk_ssl_ret = MBTK_MBEDTLS_SSL_RESULT_SUCCESS;
    mbtk_mbedtls_ssl_info_s inter_info = {0};
    mbtk_mbedtls_ssl_options_s opt = {0};

    ret = tcp_connect_init(&client_fd, atoi(argv[2]), argv[1]);
    if(ret < 0)
    {
        printf("tcp_connect_init() fail\n");
        exit(EXIT_FAILURE);
    }

    mbtk_mbedtls_ssl_options_default(&opt);
    opt.load_cert = true;
    opt.ca_file = "/ca.crt";
    opt.crt_file = "/client.crt";
    opt.key_file = "/client.key";
    opt.auth_mode = MBTK_MBEDTLS_SSL_VERIFY_REQUIRED;
    opt.allowed_mds |= MBTK_MBEDTLS_SSL_MD_SHA1;
    memset(&inter_info, 0x00, sizeof(mbtk_mbedtls_ssl_info_s));
    mbtk_ssl_ret = mbtk_mbedtls_ssl_init(client_fd, &opt, &inter_info);
    if(mbtk_ssl_ret != MBTK_MBEDTLS_SSL_RESULT_SUCCESS)
    {
        printf("mbtk_mbedtls_ssl_init() fail\n");
        close(client_fd);
        client_fd = -1;
        exit(EXIT_FAILURE);
    }

    while(1) 
    {
        printf("Enter message: \n");
        fgets(buffer, BUFFER_SIZE, stdin);

        if(memcmp(buffer, "exit", 4) == 0)
        {
            printf("process exit\n");
            break;
        }
        
        ret = mbtk_mbedtls_ssl_write(inter_info.ssl, (const unsigned char*)buffer, strlen(buffer));
        if(ret < 0)
        {
            perror("send failed");
            break;
        }
        
        bytes_recv = mbtk_mbedtls_ssl_read(inter_info.ssl, (unsigned char*)buffer, BUFFER_SIZE-1);
        if (bytes_recv <= 0)
        {
            bytes_recv == 0 ? printf("Connection closed\n") : perror("recv failed");
            break;
        }
        buffer[bytes_recv] = '\0';
        printf("Server response: %s\n", buffer);
    }

    mbtk_mbedtls_ssl_deinit(&inter_info);
    close(client_fd);
    client_fd = -1;
    
    return 0;
}

#else
int main(int argc, char *argv[])
{
	printf("No support polarssl.\n");
	return 0;
}
#endif

