/*-----------------------------------------------------------------------------------------------*/
/**
  @file NULL
  @brief libssl.so.3 function test
*/
/*-----------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  Copyright (c) 2024 mobiletek Wireless Solution, Co., Ltd. All Rights Reserved.
  mobiletek Wireless Solution Proprietary and Confidential.
-------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when       who          what, where, why
  --------   ---------    -----------------------------------------------------------------
  20250409    yq.wang      Created .
-------------------------------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef MBTK_OPENSSL_V3_0_0_SUPPORT
#include "mbtk_openssl.h"

#define BUFFER_SIZE 1024
    
void* recv_thread(void *arg)
{
    mbtk_openssl_info_s *inter_info = (mbtk_openssl_info_s *)(intptr_t)arg;
    char buffer[BUFFER_SIZE + 1] = {0};
    
    while(1)
    {
        memset(buffer, 0x00, BUFFER_SIZE + 1);
        ssize_t len = mbtk_openssl_read(inter_info->ssl, buffer, BUFFER_SIZE);
        if(len <= 0)
        {
            if(len == 0)
            {
                printf("Connection closed by server\n");
            }
            else
            {
                printf("mbtk_openssl_read() fail.[%d]\n", len);
            }
            break;
        }
        buffer[len] = '\0';
        printf("\nReceived: %s\n", buffer);
    }
    
    return NULL;
}

static int tcp_connect_init(int *client_fd, int port, char *ip)
{
    int ret = -1;
    struct sockaddr_in server_addr;

    if(port < 1 || port > 65535)
    {
        printf("[%s] Invalid port number\n", __func__);
        goto error;
    }

    *client_fd = socket(AF_INET, SOCK_STREAM, 0);
    if(*client_fd < 0)
    {
        printf("[%s] socket creation failed\n", __func__);
        goto error;
    }

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);
    ret = inet_pton(AF_INET, ip, &server_addr.sin_addr);
    if(ret <= 0)
    {
        perror("invalid address");
        goto error;
    }

    ret = connect(*client_fd, (struct sockaddr *)&server_addr, sizeof(server_addr));
    if(ret< 0)
    {
        perror("connection failed");
        goto error;
    }

    printf("[%s] Connected to %s:%d\n", __func__, ip, port);
    return 0;
error:
    if(*client_fd >= 0)
    {
        close(*client_fd);
        *client_fd = -1;
    }
    return -1;
}
    
int main(int argc, char *argv[])
{
    if(argc != 3)
    {
        printf("Usage: %s <IP> <PORT>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    int ret = -1;
    int client_fd = -1;
    ssize_t bytes_recv = 0;
    char buffer[BUFFER_SIZE + 1] = {0};
    mbtk_openssl_result_e mbtk_ret = MBTK_OPENSSL_RESULT_SUCCESS;
    mbtk_openssl_info_s inter_info = {0};
    mbtk_openssl_options_s opt = {0};
    
    pthread_t tid;

    ret = tcp_connect_init(&client_fd, atoi(argv[2]), argv[1]);
    if(ret < 0)
    {
        printf("tcp_connect_init() fail\n");
        exit(EXIT_FAILURE);
    }

    mbtk_openssl_options_default(&opt);
    opt.load_cert = true;
    opt.ca_file = "/ca.crt";
    opt.crt_file = "/client.crt";
    opt.key_file = "/client.key";
    opt.safety_level = MBTK_OPENSSL_SAFETY_LEVEL_0;//Use level 0 for testing only
    mbtk_ret = mbtk_openssl_init(client_fd, &opt, &inter_info);
    if(mbtk_ret != MBTK_OPENSSL_RESULT_SUCCESS)
    {
        printf("mbtk_openssl_init() fail\n");
        close(client_fd);
        client_fd =-1;
        exit(EXIT_FAILURE);
    }
    
    ret = pthread_create(&tid, NULL, recv_thread, (void*)(intptr_t)&inter_info);
    if(ret != 0)
    {
        perror("thread creation failed");
        close(client_fd);
        client_fd = -1;
        exit(EXIT_FAILURE);
    }

    while(1) 
    {
        printf("Enter message: \n");
        memset(buffer, 0x00, BUFFER_SIZE);
        fgets(buffer, BUFFER_SIZE, stdin);

        if(memcmp(buffer, "exit", 4) == 0)
        {
            printf("process exit\n");
            break;
        }
        
        ret = mbtk_openssl_write(inter_info.ssl, buffer, strlen(buffer));
        if(ret < 0)
        {
            printf("mbtk_openssl_write() fail.[%d]\n", ret);
            break;
        }
    }

    mbtk_openssl_deinit(&inter_info);
    close(client_fd);
    client_fd = -1;
    
    return 0;
}
#else
int main(int argc, char *argv[])
{
	printf("No support openssl.\n");
	return 0;
}
#endif