#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/un.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <stddef.h>
#include <sys/types.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <linux/input.h>


#include "mbtk_lpm.h"
#include "mbtk_type.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"

static mbtk_lpm_handler_t lpm_init;

static pthread_t lpm_t;
static int epoll_fd_t = -1;
static int fd_t = -1;
static int socket_t[2];

static int sleep_epoll_deregister(int epoll_fd,int fd )
{
    int  ret;
    do {
        ret = epoll_ctl( epoll_fd, EPOLL_CTL_DEL, fd, NULL );
    } while (ret < 0 && errno == EINTR);
    return ret;
}

static int sleep_epoll_register(int epoll_fd, int fd)
{
    struct epoll_event  ev;
    int    ret, flags;

    /* important: make the fd non-blocking */
    flags = fcntl(fd, F_GETFL);
    fcntl(fd, F_SETFL, flags | O_NONBLOCK);

    ev.events  = EPOLLIN;
    ev.data.fd = fd;
    do {
        ret = epoll_ctl( epoll_fd, EPOLL_CTL_ADD, fd, &ev );
    } while (ret < 0 && errno == EINTR);

    return ret;
}


void *threadFunction(void *arg)
{
    int pinValue;
    int i;
    char buf[8] = {0};
    struct input_event ev_input = { 0 };
    const int size = sizeof(struct input_event);

    epoll_fd_t = epoll_create(2);

    fd_t = open("/dev/input/event2", O_RDONLY);
    LOGI("init pthread_event2");

    sleep_epoll_register(epoll_fd_t, fd_t);
    sleep_epoll_register(epoll_fd_t, socket_t[1]);

    while (true)
    {
        struct epoll_event events[2];

        int numEvents = epoll_wait(epoll_fd_t, events, 2, -1);

        for (i = 0; i < numEvents; ++i)
        {
            if ((events[i].events & EPOLLERR) || (events[i].events & EPOLLHUP))
            {
                LOGE("Error on GPIO device.");
                return NULL;
            }
            else if ((events[i].events & EPOLLIN) || (events[i].events & EPOLLET))
            {
                //handleInterrupt(events[i].data.fd);
                if (events[i].data.fd == socket_t[1])
                {
                    memset(buf, 0, sizeof(buf));
                    mbtk_read(socket_t[1], buf, sizeof(buf));
                    if (1 == atoi(buf))
                    {
                        if(close(fd_t) == 0)
                            LOGI("close(fd_t)ing");

                        sleep_epoll_deregister(epoll_fd_t, socket_t[1]);
                        sleep_epoll_deregister(epoll_fd_t, fd_t);

                        LOGI("do pthread_exit");
                        return NULL;
                    }
                }
                else if (events[i].data.fd == fd_t)
                {
                    LOGI("go pthread_event");
                    memset(&ev_input, 0x00, size);
                    mbtk_read(fd_t, &ev_input, size);
                    LOGI("ev_input type = %x, code = %x, value = %x", ev_input.type, ev_input.code,ev_input.value);

                    if (ev_input.type == 4 && ev_input.code == 3)
                    {
                        LOGI(">>>>ev_input.value = [%d]",ev_input.value);
                        pinValue = (int)ev_input.value;
                        lpm_init(pinValue);
                    }
                }
                else
                {
                    LOGE("Unknown events[i].data.fd = %d", events[i].data.fd);
                }
            }
       }
    }
    return NULL;
}

int mbtk_lpm_init(mbtk_lpm_handler_t mbtk_lpm_handler)
{
    if (socketpair( AF_LOCAL, SOCK_STREAM, 0, socket_t ) < 0 )
    {
        LOGE("[mbtk_lpm_init] could not create thread control socket pair: %s", strerror(errno));

        /*close the control socket pair && Retry again.*/
        if(socket_t[0] > 0)
        {
            close(socket_t[0] );
            socket_t[0] = -1;
        }

        if(socket_t[1] > 0)
        {
            close(socket_t[1] );
            socket_t[1] = -1;
        }
        return -1;
    }

    lpm_init = mbtk_lpm_handler;

    pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);

    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOGE("pthread_attr_setdetachstate() fail");
        return -1;
    }

    if(pthread_create(&lpm_t, &thread_attr, threadFunction, NULL))
    {
        LOGE("mbtk_lpm_init can't create thread");
        return -1;
    }

    pthread_attr_destroy(&thread_attr);

    return 0;
}

int mbtk_lpm_deinit(void)
{
    char buf[4]={0};

    if (fd_t == -1)
        return 0;

    if (fd_t != -1)
    {
        //char   cmd = 1;
        strcpy(buf, "1");
//        void*  dummy = NULL;
        mbtk_write( socket_t[0], buf, sizeof(buf) );

        sleep(1);
        // close the control socket pair
        if(socket_t[0] > 0)
        {
            close(socket_t[0] );
            socket_t[0] = -1;
        }
        if(socket_t[1] > 0)
        {
            close(socket_t[1] );
            socket_t[1] = -1;
        }

        //重置还原
        fd_t = -1;

    }

    return 0;
}


