#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <limits.h>
#include <stdarg.h>
#include <unistd.h>
#include <time.h>
#include <fcntl.h>
#include <include/log.h>

#include "jacana_download.h"
#include "jacana_mem.h"
#include "jacana_log.h"
#include "jacana_usleep.h"

#undef LOG_TAG
#define LOG_TAG	"ABoot"

#ifdef PATH_MAX
#undef PATH_MAX
#define PATH_MAX    127
#else
#define PATH_MAX    127
#endif
/*---------------------------------------------------------------------------*/
char jacana_firmware_file_name[PATH_MAX];
char jacana_pvt_file_name[PATH_MAX];
#define ABOOT_PM_NAME	  "aboot.pm"
#define ABOOT_CPU_FREQ  "aboot 1248000"
#define ABOOT_CPU       "aboot"

char gpioCtrlPath[128] = "/sys/devices/platform/asr-gps/ctrl";


static void dubheWrite(char* str)
{
    int fd;
    fd = open((const char*)gpioCtrlPath, O_WRONLY);

    if (fd >= 0)    {
        if(write(fd, str, strlen(str))) {

        }
        close(fd);
    }
}



static int gpsHalReset()
{
	dubheWrite("reset 0");
    jacana_delay_msleep(100);
    dubheWrite("reset 1");
    jacana_delay_msleep(100);
    return 0;
}

static int gpsHalFWDone()
{
    dubheWrite("on");
    return 0;
}

static int gpsHalFWFail()
{
    dubheWrite("off");
    return 0;
}
/*---------------------------------------------------------------------------*/
void *
jacana_mem_alloc(size_t size)
{
  void *ptr;
  ptr = malloc(size);
  return ptr;
}
/*---------------------------------------------------------------------------*/
void
jacana_mem_free(void *ptr)
{
  free(ptr);
}
/*---------------------------------------------------------------------------*/
extern int slogFd;
int
jacana_log_printf(const char *format, ...)
{
  int write_length = 0;
  va_list args;
  char buf[1024];
  va_start(args, format);
  write_length = vsnprintf(buf, 1024, format, args);
  va_end(args);

  __android_log_printf(LOG_ID_RADIO, LOG_ERR_LEVEL, "%s", buf);

  return write_length;
}

/*---------------------------------------------------------------------------*/
int
jacana_delay_usleep(unsigned long useconds)
{

  (void)useconds;
  jacana_log_printf("jacana_delay_usleep: %d\n", useconds);

  return 0;
}


/*---------------------------------------------------------------------------*/
int
jacana_delay_msleep(unsigned long mseconds)
{
  struct timespec wait;
  wait.tv_sec = mseconds / 1000;
  wait.tv_nsec = (mseconds % 1000) * 1000 * 1000;
  nanosleep(&wait, NULL);

  return 0;
}

/*---------------------------------------------------------------------------*/
static int
gnss_module_lock( void )
{
    FILE *flk;
    int ret = -1;

    flk = fopen("/sys/power/wake_lock", "w");
    if(flk) {
        fprintf(flk, ABOOT_PM_NAME);
        ret = fclose(flk);
    }

    flk = fopen("/sys/power/cpu_freq_min_pm_qos", "w");
    if(flk) {
        fprintf(flk, ABOOT_CPU_FREQ);
        ret = fclose(flk);
    }
    return ret;
}

/*---------------------------------------------------------------------------*/
static int
gnss_module_unlock( void )
{
    FILE *flk;
    int ret = -1;

    flk = fopen("/sys/power/wake_unlock", "w");
    if(flk) {
        fprintf(flk, ABOOT_PM_NAME);
        ret = fclose(flk);
    }

    flk = fopen("/sys/power/cpu_freq_min_pm_unqos", "w");
    if(flk) {
        fprintf(flk, ABOOT_CPU);
        ret = fclose(flk);
    }
    return ret;
}

/*---------------------------------------------------------------------------*/
static void
usage(const char *prog)
{
  fprintf(stderr, "usage:  %s [options]\n", prog);
  fprintf(stderr, "example: jacana_download -B 115200 -s ttyUSB1 -F firmware.bin -P pvt.bin\n");
  fprintf(stderr, "Options are:\n");
  fprintf(stderr, " -B baudrate    9600,19200,38400,57600,115200,921600 (default 115200)\n");
  fprintf(stderr, " -s siodev      Serial device (e.x. /dev/ttyUSB0)\n");
  fprintf(stderr, " -F firmware    Firmware file name\n");
  fprintf(stderr, " -P pvt         PVT file name\n");
}
/*---------------------------------------------------------------------------*/
int
main(int argc, char *argv[])
{
  const char *prog;
  char serial_dev[32];
  int baudrate = 115200;
  int c;
  int ret = 0;
//  int i = 0;

  /*LOGCAT showing with ACAT Tool */
  set_service_log_tag(LOG_TAG);

    prog = argv[0];
    while((c = getopt(argc, argv, "B:s:F:P:h?")) != -1) {
    switch(c) {
    case 'B':
      baudrate = atoi(optarg);
      break;

    case 's':
      if(strncmp("/dev/", optarg, 5) == 0) {
        strcpy(serial_dev, optarg);
      } else {
        sprintf(serial_dev, "/dev/%s", optarg);
      }
      break;

    case 'F':
      strcpy(jacana_firmware_file_name, optarg);
      break;

    case 'P':
      strcpy(jacana_pvt_file_name, optarg);
      break;

    case '?':
    case 'h':
    default:
      usage(prog);
      exit(1);
      break;
    }
  }

  if(!strlen(serial_dev) || !strlen(jacana_firmware_file_name)
     || !strlen(jacana_pvt_file_name)) {
    usage(prog);
    exit(1);
  }

//for( i=0; i<3; i++)   {
    /* Reset Jacana Module..*/
    gpsHalReset();

    /* Disable PM. */
    gnss_module_lock();
    ret = jacana_aboot_tiny_download(serial_dev, baudrate);
    gnss_module_unlock();

//    if (!ret)
//      break;
//  }

  /* Mark Done. */
  if (!ret)
    gpsHalFWDone();
  else
    gpsHalFWFail();

  return ret;
}
