#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <pthread.h>
#include <signal.h>

#include "json-c/json.h"
#include "json-c/printbuf.h"
#include "log_config.h"

#include "mbtk_type.h"
//#define DEBUG 1

#ifdef MBTK_DUMP_SUPPORT
void mbtk_debug_open(const char *log_file, bool thread_support);
#endif

#ifdef DEBUG
#define mbtk_log(...)                    printf(__VA_ARGS__)
#else
#define mbtk_log(...)
#endif


#define    MAX_BUFFER_SIZE (8*1024)
#define    MAX_SLEEP_TIME 2147483647

int tmp_syslog_fd = -1;
int tmp_rd_fd = -1;

//char syslog_buff[MAX_BUFFER_SIZE] = {0};
//char radiolog_buff[MAX_BUFFER_SIZE] = {0};

char *radio_globalPtr = NULL;
char *sys_globalPtr = NULL;

int radio_len = 0;
int sys_len = 0;

static void signal_handler(int signum)
{
    printf("Received SIGTERM signal, fflush buffer");
    if(fcntl(tmp_syslog_fd, F_GETFL) != -1 && sys_globalPtr !=NULL )
    {
        if(write(tmp_syslog_fd, sys_globalPtr, sys_len) < 0)
        {
            perror("write error");
        }
       // memset(syslog_buff,0,MAX_BUFFER_SIZE);
       memset(sys_globalPtr, 0, MAX_BUFFER_SIZE); 
       sys_globalPtr =NULL;
    }

    if(fcntl(tmp_rd_fd, F_GETFL) != -1 && radio_globalPtr !=NULL)
    {
        if(write(tmp_rd_fd, radio_globalPtr, radio_len) < 0)
        {
            perror("write error");
        }
        
        //memset(radiolog_buff,0,MAX_BUFFER_SIZE);
        memset(radio_globalPtr, 0, MAX_BUFFER_SIZE); 
        radio_globalPtr =NULL;
        
    }

}

static void handler_free(log_config_entry* listdata)
{
    int i, n;
    struct filter_list_t* _filter_list = NULL;
    log_config_entry* entry;

    for (i = 0; i < 5; i++) {
        entry = listdata + i;
        if (entry->name) {
            //free(entry->name);
            if (entry->out_path) {
                //free(entry->out_path);
            }
            if (entry->ip) {
                free(entry->ip);
            }
            _filter_list = entry->filter_list;
            for (n = 0; n < 10; n++) {
                printf("%s %d: malloc %p!\n", __FUNCTION__, __LINE__, _filter_list);
                if (_filter_list) {
                    printf("%s %d: malloc %p!\n", __FUNCTION__, __LINE__, _filter_list->next);
                    if (_filter_list->tag && _filter_list->tag[0] != '\0') {
                        free(_filter_list->tag);
                    }
                    free(_filter_list);
                    _filter_list = _filter_list->next;
                } else {
                    break;
                }
            }
        } else {
            break;
        }
    }
}

int parse_config(log_config_entry* listdata)
{
    json_object* jsonobj = NULL;
    json_object* tmpjson = NULL;
    json_object* datajson = NULL;
    json_object* listjson = NULL;
    json_object* fileterjson = NULL;
    json_object* fileter_listjson = NULL;
    log_config_entry* entry;
    int i, n, ret, array_length;
    char* cmdval = NULL;

    printf("MBTK_LOGD: in parse_config\n");
    jsonobj = json_object_from_file(LOG_CONFIG_PATH);
    if (NULL == jsonobj) {
        printf("Can't open config file: %s\n", LOG_CONFIG_PATH);
        return -1;
    }
    ret = json_object_object_get_ex(jsonobj, "logd", &tmpjson);
    if (!ret) {
        printf("get jsondata error ...\n");
    }

    if (NULL == tmpjson) {
        printf("the tmpjson : [%s]\n", json_object_to_json_string(tmpjson));
    }
    /**获取total***/
    cmdval = (char*)json_object_get_string(tmpjson);
    printf("logd enable : %s\n", cmdval);
    json_object_put(tmpjson);

    /***获取data***/
    json_object_object_get_ex(jsonobj, "buffer_list", &tmpjson);

    for (i = 0 ; i < 5; i++) {
        struct filter_list_t* _filter_list = NULL;
        struct filter_list_t* tmp_filter_list = NULL;
        datajson = json_object_array_get_idx(tmpjson, i);
        if (NULL == datajson) {
            mbtk_log("the datajson exit\n");
            break;
        }
        entry = listdata + i;
        json_object_object_get_ex(datajson, "enable", &listjson);
        entry->enable = json_object_get_int(listjson);
        mbtk_log("enable: %d\n", entry->enable);

        json_object_object_get_ex(datajson, "name", &listjson);
        entry->name = (char*)json_object_get_string(listjson);
        printf("cmdval: %s\n", entry->name);

        json_object_object_get_ex(datajson, "log_file", &listjson);
        entry->out_path = (char*)json_object_get_string(listjson);
        mbtk_log("cmdval: %s\n", entry->out_path);

        json_object_object_get_ex(datajson, "log_stream", &listjson);
        if (listjson) {
            entry->ip = (char*)json_object_get_string(listjson);

            cmdval = strstr(entry->ip, ":");
            if (cmdval) {
                entry->port = &cmdval[1];
                cmdval[0] = 0;
                mbtk_log("cmdval: %s [%s]\n", entry->ip, entry->port);
            } else {
                printf("Can't find port!!\n");
                free(entry->ip);
                entry->ip = NULL;
            }
        }
        json_object_object_get_ex(datajson, "rotate_file_size", &listjson);
        entry->rotate_file_size = json_object_get_int(listjson) * 1024;
        mbtk_log("rotate_file_size: %d\n", entry->rotate_file_size);

        json_object_object_get_ex(datajson, "rotate_file_count", &listjson);
        entry->rotate_file_count = json_object_get_int(listjson);
        mbtk_log("rotate_file_count: %d\n", entry->rotate_file_count);

        json_object_object_get_ex(datajson, "filter_list", &listjson);
        if (NULL == listjson) {
            printf("%s %d: object failure!\n", __FUNCTION__, __LINE__);
            json_object_put(listjson);
            continue;
        }
        entry->filter_list = (struct filter_list_t*)malloc(sizeof(struct filter_list_t));
        _filter_list = entry->filter_list;

        array_length = json_object_array_length(listjson);
        for (n = 0 ; n <= array_length; n++) {
            fileterjson = json_object_array_get_idx(listjson, n);
            if (NULL == fileterjson) {
                mbtk_log("the fileterjson exit\n");
                free(tmp_filter_list->next);
                tmp_filter_list->next = NULL;
                break;
            }
            memset(_filter_list, 0, sizeof(struct filter_list_t));
            json_object_object_get_ex(fileterjson, "priority", &fileter_listjson);
            const char* str = json_object_get_string(fileter_listjson);
            if (str) {
                _filter_list->priority = str[0];
                mbtk_log("fileter_listjson: %c\n", _filter_list->priority);
            }
            json_object_object_get_ex(fileterjson, "tag", &fileter_listjson);
            // if (NULL == fileter_listjson) {
            //     printf("%s %d: object failure!\n", __FUNCTION__, __LINE__);
            // }
            str = json_object_get_string(fileter_listjson);
            if (str) {
                _filter_list->tag = strdup(str);
                mbtk_log("fileter_listjson: %s\n", _filter_list->tag);
            }
            else
            {
                _filter_list->tag = "\0";
            }

            //json_object_put(fileter_listjson);
            _filter_list->next = (struct filter_list_t*)malloc(sizeof(struct filter_list_t));
            if (NULL == _filter_list->next) {
                printf("%s %d: malloc failure!\n", __FUNCTION__, __LINE__);
                break;
            }
            tmp_filter_list = _filter_list;
            _filter_list = _filter_list->next;
        }
    }

    /***释放json对象***/
    json_object_put(jsonobj);
    printf("MBTK_LOGD: parse_config end\n");
    return 0;
}

#define  LOGD_PID  "/var/run/mbtk_logd.pid"
#if 0
static int save_pid(void)
{
    pid_t process_id;
    int fd, ret;
    char buf[12] = {0};

    process_id  = getpid();
    if(access(LOGD_PID, F_OK) == 0)
    {
        printf("mbtk_logd 进程已经存在\n");
        return -1;
    }
    fd = open(LOGD_PID, O_CREAT | O_WRONLY, 0600);
    if (fd < 0) {
        fprintf(stderr, "failed to open %s: %s\n", LOGD_PID, strerror(errno));
        return -2;
    }
    snprintf(buf, sizeof(buf), "%d\n", process_id);
    ret = write(fd, buf, strlen(buf));
    close(fd);

    if(ret > 0)
        return 0;
    else
        return -2;
}
#endif

int main(int argc, char* argv[])
{
    log_config_entry listdata[5];
    pthread_t pid[5] = {0};
    int i, ret;
    void* tret;
    //struct filter_list_t* _filter_list = NULL;

    signal(SIGTERM, signal_handler);
#ifdef MBTK_DUMP_SUPPORT
    mbtk_debug_open(NULL, TRUE);
#endif

    int lock_file = open("/tmp/mbtk_logd.lock", O_CREAT|O_RDWR, 0666);
    int rc = flock(lock_file,LOCK_EX|LOCK_NB);
    if(rc) {
        if(EWOULDBLOCK == errno) {
            printf("Error: cannot restart the mbtk_logd repeatedly\n");
            exit(0);
        }
    }

    memset(listdata, 0, sizeof(log_config_entry) * 5);
    ret = parse_config(listdata);
    if (ret) {
        return -1;
    }

    printf("logd %s start !\n", __FUNCTION__);

    for (i = 0; i < 5; ++i) {
        if (NULL == listdata[i].name) {
            break;
        }

        if (0 == listdata[i].enable) {
            printf("%s log disabled !\n", listdata[i].name);
            continue;
        }

        if (0 == memcmp(listdata[i].name, "radio", 5)) {
            ret = pthread_create(&pid[i], NULL, alog_thread, &listdata[i]);
            if (ret != 0) {
                fprintf(stderr, "\n%s: Failed to create pthread\n", __FUNCTION__);
            }
        } else if (0 == memcmp(listdata[i].name, "syslog", 6)) {
            ret = pthread_create(&pid[i], NULL, syslog_main, &listdata[i]);
            if (ret != 0) {
                fprintf(stderr, "\n%s %d: Failed to create pthread\n", __FUNCTION__, __LINE__);
            }
        } else if (0 == memcmp(listdata[i].name, "local_socket", 12)) {
            ret = pthread_create(&pid[i], NULL, socket_log_thread, &listdata[i]);
            if (ret != 0) {
                fprintf(stderr, "\n%s %d: Failed to create pthread\n", __FUNCTION__, __LINE__);
            }
        } else if (0 == memcmp(listdata[i].name, "/dev/ttyS0", 8)) {
            ret = pthread_create(&pid[i], NULL, common_log_thread, &listdata[i]);
            if (ret != 0) {
                fprintf(stderr, "\n%s %d: Failed to create pthread\n", __FUNCTION__, __LINE__);
            }
        }
    }


    for (i = 0; i < 5; ++i) {
        if (NULL == listdata[i].name) {
            break;
        }
        if (pid[i]) {
            if (pthread_join(pid[i], &tret) != 0) {
                printf("Join thread %d : %ld error!\n", i, pid[i]);
                exit(1);
            }
        }
    }
    handler_free(listdata);
    sleep(MAX_SLEEP_TIME);
    return 0;
}
