#ifndef MBTK_INFO_INCLUDE
#define MBTK_INFO_INCLUDE
#include <netinet/in.h>
#include <pthread.h>

#include "mbtk_type.h"
#include "mbtk_list.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"
#include "mbtk_ril_api.h"

#define RIL_SOCK_PACKET_TAG 0x5F6F7F8F
#define RIL_SOCK_NAME "/tmp/mbtk_ril_sock"
#define RIL_SOCK_MSG_LEN_MAX (1024 * 6)

#define IND_REGISTER_MAX 20
#define PACK_PROCESS_QUEUE_MAX 20


// Tag(4) + Packet_Length(2)
#define RIL_SOCK_PACK_EXTRA_LEN 6
// RIL_SOCK_PACK_EXTRA_LEN + at_port(1) + Index(2) + Type(2) + Id(2) + Error(2) + data_len(2)
#define RIL_SOCK_PACK_LEN_MIN (RIL_SOCK_PACK_EXTRA_LEN + 11)

#define RIL_MSG_INDEX_AUTO      (-1)         // automatically , refor to :  ril_index
#define RIL_MSG_INDEX_INVALID   (0)       // Invalid msg index.

typedef enum
{
    RIL_MSG_TYPE_REQ,
    RIL_MSG_TYPE_RSP,
    RIL_MSG_TYPE_IND
} ril_msg_type_enum;

typedef enum
{
    // Device Information
    RIL_MSG_ID_DEV_BEGIN = 0x0,
    // <string> IMEI
    RIL_MSG_ID_DEV_IMEI,
    // <string> SN
    RIL_MSG_ID_DEV_SN,
    // <string> MEID
    RIL_MSG_ID_DEV_MEID,
    // <string> VERSION
    RIL_MSG_ID_DEV_VERSION,
    // <string> MODEL
    RIL_MSG_ID_DEV_MODEL,
    // <uint8> 0:Close 1:Open
    RIL_MSG_ID_DEV_VOLTE,
    // <string> Temperature
    RIL_MSG_ID_DEV_TEMP,  // Temperature
    // <string>  23/03/20,01:58:00+32
    RIL_MSG_ID_DEV_CELL_TIME,  // Time
    // <uint8><uint8>
    RIL_MSG_ID_DEV_MODEM,
    // <uint8>
    RIL_MSG_ID_DEV_POWERIND,

    RIL_MSG_ID_DEV_END,

    // Sim Information
    RIL_MSG_ID_SIM_BEGIN = 0x100,
    // <uint8> 0:NOT_EXIST 1:READY ...
    RIL_MSG_ID_SIM_STATE,
    // <uint8> 0: SIM 1: USIM 2: TEST SIM 3: TEST USIM 4: UNKNOWN
    RIL_MSG_ID_SIM_TYPE,
    // <string> IMSI
    RIL_MSG_ID_SIM_IMSI,
    // <string> ICCID
    RIL_MSG_ID_SIM_ICCID,
    // <string> Phone Number
    RIL_MSG_ID_SIM_PN,
    // <string> PUK
    RIL_MSG_ID_SIM_LOCK,
    // <uint8> <uint8> <uint8> <uint8> PIN PUK LAST TIMES
    RIL_MSG_ID_SIM_PINPUK_TIMES,
    // <string> PLMN
    RIL_MSG_ID_SIM_PLMN,

    RIL_MSG_ID_SIM_END,

    // Network Information
    RIL_MSG_ID_NET_BEGIN = 0x200,
    // sel_mode(uint8)type(uint8)plmn(uint32)...sel_mode(uint8)type(uint8)plmn(uint32)
    RIL_MSG_ID_NET_AVAILABLE,
    // <uint8> 0: automatic 1: manual
    // or
    // sel_mode(uint8)type(uint8)plmn(uint32)
    RIL_MSG_ID_NET_SEL_MODE,
    // mbtk_band_info_t
    RIL_MSG_ID_NET_BAND,
    // mbtk_signal_info_t
    RIL_MSG_ID_NET_SIGNAL,
    // mbtk_net_reg_info_t
    RIL_MSG_ID_NET_REG,
    // mbtk_cell_info_t[]
    RIL_MSG_ID_NET_CELL,
    // mbtk_ril_oos_info_t
    RIL_MSG_ID_NET_OOS,

    RIL_MSG_ID_NET_END,


    // Network Information
    RIL_MSG_ID_DATA_CALL_BEGIN = 0x300,
    // mbtk_apn_info_t
    RIL_MSG_ID_DATA_CALL_APN,
    // REQ:
    // <call_type[1]><cid[1]><timeout[1]>
    //  call_type : mbtk_data_call_type_enum
    //  cid : 1 - 15
    //  timeout : second
    // RSP:
    //  <type[1]><ipv4><ipv6>
    //  type : 0-IPV4   1-IPV6  2-IPV4V6
    //  ipv4 : mbtk_ipv4_info_t
    //  ipv6 : mbtk_ipv6_info_t
    RIL_MSG_ID_DATA_CALL_OPT,

    RIL_MSG_ID_DATA_CALL_END,


    // Call Information
    RIL_MSG_ID_CALL_BEGIN = 0x400,
    RIL_MSG_ID_CALL_STATE,

    // Start call.
    RIL_MSG_ID_CALL_START,
    //answer call
    RIL_MSG_ID_CALL_ANSWER,
    //hang up all call
    RIL_MSG_ID_CALL_HANGUP,
    //hang up a call
    RIL_MSG_ID_CALL_HANGUP_A,
    //hang up waiting or background call
    RIL_MSG_ID_CALL_HANGUP_B,
    //hang up foreground resume background
    RIL_MSG_ID_CALL_HANGUP_C,
    //wait in call
    RIL_MSG_ID_CALL_WAITIN,
    //mute call
    RIL_MSG_ID_CALL_MUTE,
    //dtmf call
    RIL_MSG_ID_CALL_DTMF,
    RIL_MSG_ID_CALL_END,

    // SMS Information
    RIL_MSG_ID_SMS_BEGIN = 0x500,
    RIL_MSG_ID_SMS_STATE,
    RIL_MSG_ID_SMS_CMGF,
    RIL_MSG_ID_SMS_CPMS,
    RIL_MSG_ID_SMS_CMGS,
    RIL_MSG_ID_SMS_CMSS,
    RIL_MSG_ID_SMS_CMGR,
    RIL_MSG_ID_SMS_CMGW,
    RIL_MSG_ID_SMS_CMGD,
    RIL_MSG_ID_SMS_CMGL,
    RIL_MSG_ID_SMS_CSCA,
    RIL_MSG_ID_SMS_CSMP,
    RIL_MSG_ID_SMS_CSCB,
    RIL_MSG_ID_SMS_CNMI,

    RIL_MSG_ID_SMS_END,

    // PhoneBook Information
    RIL_MSG_ID_PB_BEGIN = 0x600,
    RIL_MSG_ID_PB_STATE,

    RIL_MSG_ID_PB_END,

    // Ecall Information
    RIL_MSG_ID_ECALL_BEGIN = 0x700,
    // mbtk_ecall_msd_cfg_info_t
    RIL_MSG_ID_ECALL_MSDCFG,
    // NULL
    RIL_MSG_ID_ECALL_MSDGEN,
    // uint8[]
    RIL_MSG_ID_ECALL_MSD,
    // NULL
    RIL_MSG_ID_ECALL_PUSH,
    // mbtk_ecall_only_info_t
    RIL_MSG_ID_ECALL_ONLY,
    // reg <uint8>
    RIL_MSG_ID_ECALL_REG,
    // mbtk_ecall_dial_type_enum
    RIL_MSG_ID_ECALL_DIAL,
    // mbtk_ecall_mode_type_enum
    RIL_MSG_ID_ECALL_MODE,
    // mbtk_ecall_cfg_item_enum / mbtk_ecall_cfg_info_t
    RIL_MSG_ID_ECALL_CFG,
    // uint8[]
    RIL_MSG_ID_ECALL_SMS_NUM,
    // uint8
    RIL_MSG_ID_ECALL_MUTESPK,
    // mbtk_ecall_gain_info_t
    RIL_MSG_ID_ECALL_DSP_GAIN,

    RIL_MSG_ID_ECALL_END,

    // IND Information
    RIL_MSG_ID_IND_BEGIN = 0x1000,
    // mbtk_ril_ser_state_enum
    RIL_MSG_ID_IND_SER_STATE_CHANGE,
    // mbtk_ril_net_reg_state_info_t
    RIL_MSG_ID_IND_NET_REG_STATE_CHANGE,
    // <uint8>  State
    RIL_MSG_ID_IND_CALL_STATE_CHANGE,
    // <uint8>  State
    RIL_MSG_ID_IND_SMS_STATE_CHANGE,
    // mbtk_ril_radio_state_info_t
    RIL_MSG_ID_IND_RADIO_STATE_CHANGE,
    // mbtk_ril_sim_state_info_t
    RIL_MSG_ID_IND_SIM_STATE_CHANGE,
    // mbtk_ril_pdp_state_info_t
    RIL_MSG_ID_IND_PDP_STATE_CHANGE,
    // mbtk_ril_signal_state_info_t
    RIL_MSG_ID_IND_SIGNAL_STATE_CHANGE,
    // mbtk_ril_ecall_state_info_t
    RIL_MSG_ID_IND_ECALL_STATE_CHANGE,


    RIL_MSG_ID_IND_END,

    // URC message
    RIL_URC_MSG_BEGIN = 0x2000,
    RIL_URC_MSG_GET_SIM_STATE,     //check sim status
    RIL_URC_MSG_NET_STATE_LOG,      // Save Network state into file.
    RIL_URC_MSG_END,

    RIL_MSG_ID_UNKNOWN = 0xFFFF        // Unknown information.
} ril_msg_id_enum;

typedef struct {
    uint32 tag;     // Refor to : RIL_SOCK_PACKET_TAG
    uint16 msg_len;

    uint8 at_port;  // ATPortType_enum
    uint16 msg_index;   // Message index(Start from 1)
            // 0 : For unknown msg id
    uint16 msg_type;    // Refor to : ril_msg_type_enum
    uint16 msg_id;      // Refor to : ril_msg_id_enum
    uint16 err;     // Only for RSP(Refor to : mbtk_ril_err_enum)
    uint16 data_len;
    uint8 *data;
} __attribute__((packed)) ril_msg_pack_info_t;

typedef struct {
    pthread_t pid;
    char name[20];
    bool is_waitting;
    pthread_cond_t cond;
    pthread_mutex_t mutex;
} ril_cli_thread_info_t;

typedef struct {
    pthread_t pid;
    bool is_async;
    int *rsp_data_len;  // Save response data length.
    char *rsp_data;     // Save response date.
    int *rsp_err;       // Save response error, refor to mbtk_ril_err_enum .
    ril_msg_pack_info_t *pack;
} ril_msg_info_t;

/*
GSM band��
    1 �C PGSM 900 (standard or primary)
    2 �C DCS GSM 1800
    4 �C PCS GSM 1900
    8 �C EGSM 900 (extended)
    16 �C GSM 450
    32 �C GSM 480
    64 �C GSM 850
    512 - BAND_LOCK_BIT // used for GSM band setting
*/
typedef enum
{
    MBTK_GSM_BAND_PGSM_900 = 1,
    MBTK_GSM_BAND_DCS_GSM_1800 = 2,
    MBTK_GSM_BAND_PCS_GSM_1900 = 4,
    MBTK_GSM_BAND_EGSM_900 = 8,
    MBTK_GSM_BAND_GSM_450 = 16,
    MBTK_GSM_BAND_GSM_480 = 32,
    MBTK_GSM_BAND_GSM_850 = 64,
    MBTK_GSM_BAND_BAND_LOCK_BIT = 512
} mbtk_gsm_band_enum;

/*
UMTS band��
    1 �C UMTS_BAND_1
    2 �C UMTS_BAND_2
    4 �C UMTS_BAND_3
    8 �C UMTS_BAND_4
    16 �C UMTS_BAND_5
    32 �C UMTS_BAND_6
    64 �C UMTS_BAND_7
    128 �C UMTS_BAND_8
    256 �C UMTS_BAND_9
*/
typedef enum
{
    MBTK_UMTS_BAND_1 = 1,
    MBTK_UMTS_BAND_2 = 2,
    MBTK_UMTS_BAND_3 = 4,
    MBTK_UMTS_BAND_4 = 8,
    MBTK_UMTS_BAND_5 = 16,
    MBTK_UMTS_BAND_6 = 32,
    MBTK_UMTS_BAND_7 = 64,
    MBTK_UMTS_BAND_8 = 128,
    MBTK_UMTS_BAND_9 = 256
} mbtk_umts_band_enum;

/*
LTEbandH(TDD-LTE band)
    32 �C TDLTE_BAND_38
    64 �C TDLTE_BAND_39
    128 �C TDLTE_BAND_40
    256 �C TDLTE_BAND_41
*/
typedef enum
{
    MBTK_TDLTE_BAND_38 = 32,
    MBTK_TDLTE_BAND_39 = 64,
    MBTK_TDLTE_BAND_40 = 128,
    MBTK_TDLTE_BAND_41 = 256
} mbtk_tdlte_band_enum;

/*
LTEbandL(FDD-LTE band)
    1 �C FDDLTE_BAND_1
    4 �C FDDLTE _BAND_3
    8 �C FDDLTE _BAND_4
    64 �C FDDLTE _BAND_7
    65536 �C FDDLTE _BAND_17
    524288 �C FDDLTE _BAND_20
*/
typedef enum
{
    MBTK_FDDLTE_BAND_1 = 1,
    MBTK_FDDLTE_BAND_3 = 4,
    MBTK_FDDLTE_BAND_4 = 8,
    MBTK_FDDLTE_BAND_7 = 64,
    MBTK_FDDLTE_BAND_17 = 65536,
    MBTK_FDDLTE_BAND_20 = 524288
} mbtk_fddlte_band_enum;

typedef enum
{
    MBTK_LTE_EXT_BAND_65 = 1,
    MBTK_LTE_EXT_BAND_66 = 2,
    MBTK_LTE_EXT_BAND_67 = 4,
    MBTK_LTE_EXT_BAND_68 = 8,
    MBTK_LTE_EXT_BAND_69 = 16
} mbtk_lte_ext_band_enum;

typedef struct
{
    uint8 type; // 0: GSM 1: UMTS 2: LTE
    bool running;

    int cell_num;
    mbtk_cell_info_t cell[CELL_NUM_MAX];
} mbtK_cell_pack_info_t;

#ifdef __cplusplus
extern "C" {
#endif

char* type2str(ril_msg_type_enum type);

char* apn2str(mbtk_ip_type_enum type);

/*
IPv6 : 254.128.0.0.0.0.0.0.0.1.0.2.144.5.212.239 -> uint128
*/
int str_2_ipv6(const void *ip_str, void *ipv6);

/*
IPv6 : uint128 -> fe80::215:1dff:fe81:484c
*/
int ipv6_2_str(const void *ipv6, void *ipv6_str);

char* id2str(int id);

char* err2str(mbtk_ril_err_enum err);

void *mbtk_memcpy(const void *src, unsigned int n);

/*
0   GSM
1   GSM_COMPACT
2   UTRAN
3   GSM_EGPRS
4   UTRAN_HSDPA
5   UTRAN_HSUPA
6   UTRAN_HSDPA_HSUPA
7   EUTRAN
8   ECGSM
*/
mbtk_net_type_enum mbtk_net_type_get(mbtk_radio_technology_enum radio_tech);

void ril_msg_pack_free(ril_msg_pack_info_t* pack);

ril_msg_pack_info_t* ril_msg_pack_creat(ATPortType_enum port, int msg_type, int msg_id, int msg_index, const void *data, int data_len);

int ril_pack_send(int fd, ril_msg_pack_info_t *pack);

ril_msg_pack_info_t** ril_pack_recv(int fd, bool is_server, mbtk_ril_err_enum *err);

#ifdef __cplusplus
}
#endif


#endif /* MBTK_INFO_INCLUDE */


