#ifndef __MBTK_DATA_CALL_H__
#define __MBTK_DATA_CALL_H__
#include <string.h>
#include <stdlib.h>
#include <cutils/properties.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <arpa/inet.h>

#include "atchannel.h"
#include "at_tok.h"
#include "mbtk_log.h"
#include "mbtk_type.h"
#include "mbtk_list.h"
#include "mbtk_utils.h"
#include "mbtk_info_api.h"
#include "info_data.h"
#include "mbtk_str.h"

#define MBTK_QSER_APN_NAME_SIZE 150
#define DATA_CALL_APN_GET_FD 0x5f6f7f8f
//#define MBTK_QSER_DATA_CONFIG_FILE "/etc/config/mbtk_data_call_config"

void mbtk_set_default_pdp_state(bool state, int cid);
int mbtk_check_cid(int cid);
int mbtk_check_default_pdp_state(int cid);
int mbtk_qser_route_config(int cid, mbtk_ipv4_info_t *ipv4, mbtk_ipv6_info_t *ipv6);
int mbtk_qser_apn_del(int cid);
int mbtk_qser_req_apn_get(void *data, int *data_len, int *cme_err);
int mbtk_qser_apn_save(mbtk_apn_info_t apn, const uint8 *apn_type, bool state_save);
int mbtk_strdata_to_apn(const uint8 *str, mbtk_apn_info_t *apn, uint8 *apn_type, mbtk_apn_req_type_enum *req_type);
void mbtk_qser_apn_init(void);
#endif
