/*
* ril_info.h
*
* MBTK Ril information header.
*
* Author : lb
* Date   : 2024/8/6 10:53:08
*/
#ifndef _RIL_INFO_H
#define _RIL_INFO_H
#include <stdio.h>

#include "mbtk_type.h"
#include "mbtk_ril_api.h"
#include "mbtk_log.h"
#include "atchannel.h"
#include "at_tok.h"
#include "mbtk_list.h"
#ifdef MBTK_DEV_INFO_VERSION_2
#include "mbtk_device_v2.h"
#else
#include "mbtk_device.h"
#endif
#include "mbtk_queue.h"
#include "mbtk_ril.h"

#define SOCK_CLIENT_MAX 100
#define EPOLL_LISTEN_MAX 100

#if 0
#define MBTK_APN_PROP       "persist.mbtk.apn"
#else
#define MBTK_APN_PROP       "/etc/mbtk/apn"
#endif

#define MBTK_DEF_ROUTE_CID  "persist.mbtk.def_route_cid"
#define MBTK_DEF_DNS_CID  "persist.mbtk.def_dns_cid"

typedef struct
{
    int fd;
    ATPortType_enum port;

    uint32 ind_num;
    uint16 ind_register[IND_REGISTER_MAX];
} sock_cli_info_t;

typedef struct
{
    sock_cli_info_t *cli_info;
    void* pack;     // Refro to : ril_msg_pack_info_t
} ril_msg_queue_info_t;

typedef struct {
    mbtk_radio_state_enum radio_state;
    mbtk_sim_state_enum sim_state;
    mbtk_sim_card_type_enum sim_type;
    int sock_listen_fd;
    int epoll_fd;
    bool at_process[ATPORTTYPE_NUM];

    list_node_t *sock_client_list;      // Refor to : sock_cli_info_t
    mbtk_queue_node_t msg_queue[ATPORTTYPE_NUM];        // Refor to : ril_msg_queue_info_t
    pthread_cond_t msg_cond[ATPORTTYPE_NUM];
    pthread_mutex_t msg_mutex[ATPORTTYPE_NUM];
} ril_info_t;

typedef struct {
    bool band_set_success;
    uint32 net_support; // MBTK_NET_SUPPORT_2G / MBTK_NET_SUPPORT_3G / MBTK_NET_SUPPORT_4G / MBTK_NET_SUPPORT_5G
    mbtk_modem_band_area_enum band_area;
    mbtk_band_info_t band_support;
} ril_band_info_t;

/*
0: unknown
1: available
2: current
3: forbidden
*/
typedef enum
{
    MBTK_NET_AVIL_STATE_UNKNOWN = 0,
    MBTK_NET_AVIL_STATE_AVAILABLE,
    MBTK_NET_AVIL_STATE_CURRENT,
    MBTK_NET_AVIL_STATE_FORBIDDEN
} mbtk_net_avil_state_enum;

typedef enum {
    RIL_DATA_CALL_STATE_STOP,
    RIL_DATA_CALL_STATE_STARTED,
    RIL_DATA_CALL_STATE_STARTING,       // Data dialing in progress
    RIL_DATA_CALL_STATE_STOPPING        // Ending data dialing
} ril_data_call_state_enum;

typedef struct {
    ril_msg_id_enum msg;

    void *data;
    int data_len;
} ril_urc_msg_info_t;

typedef struct
{
    int cid;
    bool act;
    bool waitting;
} ril_cgact_wait_t;

typedef enum {
    RIL_ACT_STATE_DISCONNECTED = 0,
    RIL_ACT_STATE_CONNECTING,
    RIL_ACT_STATE_CONNECTED,
    RIL_ACT_STATE_CONNECTED_RETRY,   // Network disconnection, retry after network recovery.
    RIL_ACT_STATE_DISCONNECTING
} ril_act_state_enum;

typedef struct {
    bool valid;

    bool manual_call;
    mbtk_apn_info_t apn_info;
    ril_act_state_enum act_state;
} ril_data_call_info_t;

extern ril_info_t ril_info;


mbtk_radio_state_enum ril_radio_state_get(ATPortType_enum port);
mbtk_ril_err_enum ril_radio_state_set(ATPortType_enum port, mbtk_radio_state_enum state, bool reset);

mbtk_sim_state_enum ril_sim_state_get(ATPortType_enum port);

void apn_auto_conf_from_prop(ATPortType_enum port);

bool is_ipv4(const char *ip);

int net_ifc_config(mbtk_ril_cid_enum cid, bool def_route, bool as_dns, mbtk_ip_info_t *ip_info);

int net_ifc_reconfig(mbtk_ril_cid_enum cid, bool def_route, bool as_dns, mbtk_ip_info_t *ip_info);

#endif /* _RIL_INFO_H */
