#!/bin/bash

if [ ! -f config ];then
	echo "Exec init.sh in the first."
	exit 1
fi

# static / shared
export BUILD_LIB_TYPE=shared

export STAGING_DIR=

ROOT_DIR=`pwd`

BUILD_LIBC_TEMP=`cat config | grep CONFIG_MBTK_LIBC | cut -d '=' -f 2`
if [ "$BUILD_LIBC_TEMP" == "musl" ];then
	export BUILD_STD_LIBC=musl
else
	export BUILD_STD_LIBC=glibc
fi

export BUILD_GCC_VERSION=`cat config | grep CONFIG_GCC_VERSION | cut -d '=' -f 2`

export MBTK_DEV_INFO_VERSION=`cat config | grep CONFIG_DEV_INFO_VERSION | cut -d '=' -f 2`
export CONFIG_MBTK_5G_SUPPORT=`cat config | grep CONFIG_MBTK_5G_SUPPORT | cut -d '=' -f 2`

if [ -n "$1" ] ;then
	case "$1" in
		v1)
			export MBTK_SOURCE_VERSION=1
			;;
		v2)
			export MBTK_SOURCE_VERSION=2
			;;
		*)
			MBTK_SOURCE_VERSION_TEMP=`cat config | grep CONFIG_MBTK_SOURCE_VERSION | cut -d '=' -f 2`
			if [ "$MBTK_SOURCE_VERSION_TEMP" == "2" ];then
				export MBTK_SOURCE_VERSION=2
			else
				export MBTK_SOURCE_VERSION=1
			fi
	esac
else
	MBTK_SOURCE_VERSION_TEMP=`cat config | grep CONFIG_MBTK_SOURCE_VERSION | cut -d '=' -f 2`
	if [ "$MBTK_SOURCE_VERSION_TEMP" == "2" ];then
		export MBTK_SOURCE_VERSION=2
	else
		export MBTK_SOURCE_VERSION=1
	fi
fi

function build()
{
	cd mbtk

	if [ -n "$1" ] ;then
		case "$1" in
			clean)
				make clean
				;;
			*)
#				exit 1;;
				make -C $1
		esac
	else	# 无参数
		make || exit 1
	fi

	cd $ROOT_DIR

	echo "Build MBTK success."
}

function copy_bin_and_lib()
{
	# Copy All SO Files.
#	cp -f mbtk/libmbtk_lib/wifi/libs out/lib
	cp -f out/lib/* $1/lib

	# Copy All Bin Files.
	#cp -f out/bin/* $1/bin
	[ -f out/bin/at ] && cp -f out/bin/at $1/bin
	[ -f out/bin/mbtk_rild ] && cp -f out/bin/mbtk_rild $1/bin
	[ -f out/bin/mbtk_rtpd ] && cp -f out/bin/mbtk_rtpd $1/bin
	[ -f out/bin/mbtk_logd ] && cp -f out/bin/mbtk_logd $1/bin
	[ -f out/bin/mbtk_adbd ] && cp -f out/bin/mbtk_adbd $1/bin
	[ -f out/bin/mbtk_mdio ] && cp -f out/bin/mbtk_mdio $1/bin
	[ -f out/bin/device_info_generate ] && cp -f out/bin/device_info_generate $1/..
	[ -f out/bin/ota_update ] && cp -f out/bin/ota_update $1/..
	[ -f out/bin/device_info ] && cp -f out/bin/device_info $1/bin
	[ -f out/bin/mtd_info ] && cp -f out/bin/mtd_info $1/bin
	[ -f out/bin/mbtk_sdk_ready ] && cp -f out/bin/mbtk_sdk_ready $1/bin
	[ -f out/bin/mbtk_reboot ] && cp -f out/bin/mbtk_reboot $1/bin
	[ -f out/bin/mbtk_gnssd ] && cp -f out/bin/mbtk_gnssd $1/bin
	[ -f out/bin/mbtk_version ] && cp -f out/bin/mbtk_version $1/bin
	[ -f out/bin/mbtk_servicesd ] && cp -f out/bin/mbtk_servicesd $1/bin
	[ -f out/bin/aboot-tiny ] && cp -f out/bin/aboot-tiny $1/bin
	[ -f out/bin/mbtk_rtpd ] && cp -f out/bin/mbtk_rtpd $1/bin


	# Copy GNSS(5311) bin files.
	[ -f mbtk/aboot-tiny/files/release/jacana_fw.bin ] && cp -f mbtk/aboot-tiny/files/release/jacana_fw.bin $1/etc
	[ -f mbtk/aboot-tiny/files/config/jacana_pvt.bin ] && cp -f mbtk/aboot-tiny/files/config/jacana_pvt.bin $1/etc
}

function file_copy()
{
	ROOTFS_DIR=$ROOT_DIR/../asr_code/mbtk/rootfs

	if [ -d $ROOTFS_DIR ];then
		echo "Copy MBTK out files..."
		if [ ! -d $ROOTFS_DIR/bin ];then
			mkdir $ROOTFS_DIR/bin
		fi
		if [ ! -d $ROOTFS_DIR/lib ];then
			mkdir $ROOTFS_DIR/lib
		fi

		copy_bin_and_lib $ROOTFS_DIR
	else
		echo "No found rootfs : $ROOTFS_DIR"
	fi
}

function temp_mbtk_copy()
{
	TEMP_MBTK_DIR=$ROOT_DIR/../temp_open
	if [ -d $TEMP_MBTK_DIR ];then
		rm -rf $TEMP_MBTK_DIR
	fi

	mkdir -p $TEMP_MBTK_DIR/mbtk/include
	mkdir -p $TEMP_MBTK_DIR/mbtk/rootfs/bin
	mkdir -p $TEMP_MBTK_DIR/mbtk/rootfs/lib
	mkdir -p $TEMP_MBTK_DIR/mbtk/rootfs/etc
	mkdir -p $TEMP_MBTK_DIR/mbtk/test

	copy_bin_and_lib $TEMP_MBTK_DIR/mbtk/rootfs

	# Copy include file.
	if [ -d mbtk/include ];then
		cp -rf mbtk/include/* $TEMP_MBTK_DIR/mbtk/include
	fi

	# Copy test source.
	if [ -d mbtk/test ];then
		cope_file="mbtk/test/*"
		files=$(ls $cope_file 2> /dev/null | wc -l)
		if [ "$files" != "0" ] ;then  #如果存在文件
			cp -rf $cope_file $TEMP_MBTK_DIR/mbtk/test
		fi
	fi
}

function print_arg()
{
	echo BUILD_STD_LIBC=$BUILD_STD_LIBC
	echo MBTK_SOURCE_VERSION=$MBTK_SOURCE_VERSION
	echo MBTK_DEV_INFO_VERSION=$MBTK_DEV_INFO_VERSION
}

function main()
{
	if [ ! -d out/lib ];then
		mkdir -p out/lib
	fi

	if [ ! -d out/bin ];then
		mkdir -p out/bin
	fi

	if [ "$BUILD_LIBC_TEMP" == "musl" ];then
		[ -f mbtk/libmbtk_lib/wifi/libs/libwpa_client_musl.so ] && cp -f mbtk/libmbtk_lib/wifi/libs/libwpa_client_musl.so mbtk/libmbtk_lib/wifi/libs/libwpa_client.so
	else
		[ -f mbtk/libmbtk_lib/wifi/libs/libwpa_client_glibc.so ] && cp -f mbtk/libmbtk_lib/wifi/libs/libwpa_client_glibc.so mbtk/libmbtk_lib/wifi/libs/libwpa_client.so
	fi

	if [ -n "$1" ] ;then
		if [ "$1" == "v1" -o "$1" == "v2" ];then
			build clean


		else
			build $1
			exit 0
		fi
	fi

	if [ ! -d out/lib ];then
		mkdir -p out/lib
	fi

	if [ ! -d out/bin ];then
		mkdir -p out/bin
	fi

	build

	print_arg

	file_copy

	temp_mbtk_copy
}

# exit 1
print_arg

main $1
