#!/bin/bash

current_branch=`cat ../scripts/current_branch`
brance_right=0

function help()
{
	echo "可用分支："
	for brance in $current_branch;
	do
		echo $brance
	done
}

function brance_check()
{
	for brance in $current_branch;
	do
		if [ "$brance" == "$1" ];then
			brance_right=1
		fi
	done
}


cd ..
MBTK_SOURCE_DIR="mbtk_source"
ASR_RLS_BRANCH=`git branch | grep "*" | cut -d " " -f 2`
cd $MBTK_SOURCE_DIR

if [ -n "$1" ] ;then
	brance_check $1
	if [ $brance_right -eq 1 ]; then
	#if [ ! $1 in $current_branch ];then
		echo "Brance : $1"
		ASR_CUSTOM_BRANCH=$1
	else
		help
		exit 1
	fi
else
	help
	exit 1
fi

CONFIG_FILE_NAME=config-$ASR_RLS_BRANCH-$ASR_CUSTOM_BRANCH

if [ ! -f configs/$CONFIG_FILE_NAME ];then
	echo "No found config file : $CONFIG_FILE_NAME , use default config file."
	CONFIG_FILE_NAME=config-default
fi

if [ -f configs/$CONFIG_FILE_NAME ];then
	cp -f configs/$CONFIG_FILE_NAME config
	./build.sh clean
	echo "Use config file : $CONFIG_FILE_NAME"
	cat config | grep =
else
	echo "No found config file : $CONFIG_FILE_NAME"
fi

