#ifndef  __HD8040_UPGRADE_H
#define  __HD8040_UPGRADE_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "custom_upgrade_api.h"
#include "stdint.h"

//cfg
#define SWITCH_BAUD_460800 1
#define UPG_CHECK_VER 1

typedef int  sys_err_t;

#define sys_TRUE       (1)
#define sys_FALSE      (0)  

#define sys_SUCCESS   (0)
#define sys_FAILED    (-1)


typedef unsigned char  uint8_t;
typedef unsigned short int uint16_t;

#define HDBD_LOG printf


/*
HDBD_UPG_SUCESS£ºÉý¼¶³É¹¦
HDBD_UPG_ENTER_BOOTMODE_ERROR£º½øÈëbootÊ§°Ü£¨¶ÁÈ¡²»µ½°æ±¾ºÅ»òÕß´®¿Ú·¢ËÍÊ±Ðò²»ÕýÈ·£©
HDBD_UPG_FAIL£ºÉý¼¶Ê§°Ü
HDBD_UPG_GETVER_ERROR£ºÉý¼¶Ö®ºó¶ÁÈ¡°æ±¾ºÅÊ§°Ü
HDBD_UPG_COM_CFG_ERROR£º´®¿ÚÅäÖÃ´íÎó
HDBD_UPG_IN_INFO_ERROR£ºÊäÈëµÄclientID´íÎó»òÕßÊäÈëµÄ°æ±¾²ÎÊý²»ÕýÈ·
HDBD_BIN_FILE_ERROR£ºBinÎÄ¼þ´íÎó*/
typedef enum {
    HDBD_UPG_SUCESS = 0,
    HDBD_UPG_ENTER_BOOTMODE_ERROR  = 1,
    HDBD_UPG_FAIL  = 2,
    HDBD_UPG_GETVER_ERROR = 3,
    HDBD_UPG_COM_CFG_ERROR = 4,
    HDBD_UPG_IN_INFO_ERROR = 5,
    HDBD_BIN_FILE_ERROR = 6,
	HDBD_UPG_CHECK_ERR = 7
}HDBD_RET;

#define COMM_BAUDRATE_PHONE 115200


#define ADDR_FLASH_BIN_INFO_ADDR 0x0000000//

/**
 * @brief  upgrade entry
 * @param  fd:uart fd
 * @param  uart_baud_max:uart max baud
 * @param  binSize:upgrade file bin size
 * @param  upgrade_clientID:need upgrade clientID
 * @param  new_ver:upgrade success version
 * @retval hd8040_upgrade.h  ERROR_LIST
 */

//#define PYTHON_CALL_BACK_SUPPORT 0

#ifdef PYTHON_CALL_BACK_SUPPORT
typedef struct python_callback_str
{
	int (*gnss_gpio_init_callback)();
	int (*gnss_enter_boot_callback)();
	int (*gnss_reset_callback)();
	int (*set_gnss_baud_callback)(int32_t, uint8_t);
	int (*uart_send_callback)(int32_t, uint8_t *, int32_t);
	int (*uart_recv_callback)(int32_t, uint8_t *, int32_t *, int32_t);
	int (*bsp_flash_readbytes_callback)(uint32_t, uint8_t *, uint32_t);
	int (*uart_clear_buf_callback)(int32_t);
	int (*uart_control_callback)(int32_t, uint16_t);
}PYTHON_CALLBACK;

typedef int (callback)(uint8_t *, uint16_t);
typedef int (*gnss_gpio_init_callback_)();
typedef int (*gnss_enter_boot_callback_)();
typedef int (*gnss_reset_callback_)();
typedef int (*set_gnss_baud_callback_)(int32_t, uint8_t);
typedef int (*uart_send_callback_)(int32_t, uint8_t *, int32_t);
typedef int (*uart_recv_callback_)(int32_t, uint8_t *, int32_t *, int32_t);
typedef int (*bsp_flash_readbytes_callback_)(uint32_t, uint8_t *, uint32_t);
typedef int (*uart_clear_buf_callback_)(int32_t);
typedef int (*uart_control_callback_)(int32_t, uint16_t);

extern PYTHON_CALLBACK g_python_callback;
extern HDBD_RET hdbd_upgrade_entry(int32_t fd, int32_t uart_baud_max, int32_t binSize, uint8_t *upgrade_clientID, uint8_t *new_ver, 
	gnss_gpio_init_callback_ gnss_gpio_init_callback__,
	gnss_enter_boot_callback_ gnss_enter_boot_callback__,
	gnss_reset_callback_ gnss_reset_callback__,
	set_gnss_baud_callback_ set_gnss_baud_callback__,
	uart_send_callback_ uart_send_callback__,
	uart_recv_callback_ uart_recv_callback__,
	bsp_flash_readbytes_callback_ bsp_flash_readbytes_callback__,
	uart_clear_buf_callback_ uart_clear_buf_callback__,
	uart_control_callback_ uart_control_callback__
	);
#else
extern HDBD_RET hdbd_upgrade_entry(int32_t fd, int32_t uart_baud_max, int32_t binSize, uint8_t *upgrade_clientID, uint8_t *new_ver);
#endif

extern HDBD_RET hdbd_enter_boot(int32_t fd, int32_t uart_baud_max, int binSize, uint8_t *upgrade_clientID, uint8_t *new_ver);


#endif

