#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>

#include "mbtk_info.h"
#include "mbtk_list.h"
#include "mbtk_utils.h"
#include "mbtk_str.h"
#include "time.h"



#define EPOLL_LISTEN_MAX 100
#define EPOLL_LISTEN_MAX 100

static mbtk_info_callback_func ril_server_state_cb = NULL;


#if 0
struct
{
    uint8 operator[128];
    uint8 operator[128];
    uint8 mcc_mnc[10];
} operator_mcc_mnc =
{
    {"China Mobile","CMCC","46000"},
    {"China Unicom","CU","46001"},
    {"China Mobile","CMCC","46002"},
    {"China Telecom","CT","46003"},
    {"China Mobile","CMCC","46004"},
    {"China Telecom","CT","46005"},
    {"China Unicom","CU","46006"},
    {"China Mobile","CMCC","46007"},
    {"China Mobile","CMCC","46008"},
    {"China Unicom","CU","46009"},
    {"China Telecom","CT","46011"},
    {NULL, NULL, NULL}
};
#endif

static int pack_process(mbtk_info_handle_t* handle, mbtk_info_pack_t* pack)
{
    mbtk_info_type_enum info_type = mbtk_info_type_get(pack->info_id);
    LOG("Type : %s, ID : %s, Result : %s ,Length : %d", type2str(info_type),
                                                        id2str(pack->info_id),
                                                        err2str(pack->info_err),
                                                        pack->data_len);
    if(0 && pack->data_len > 0)
    {
        log_hex("DATA", pack->data, pack->data_len);
    }
    // IND Message.
    if(info_type == MBTK_INFO_TYPE_IND)
    {
        if(pack->data_len > 0 && pack->data != NULL) // IND message.
        {
            log_hex(id2str(pack->info_id), pack->data, pack->data_len);
            switch(pack->info_id)
            {
                case MBTK_INFO_ID_IND_NET_STATE_CHANGE:
                {
                    if(handle->net_state_cb)
                        handle->net_state_cb(pack->data, pack->data_len);
                    break;
                }
                case MBTK_INFO_ID_IND_CALL_STATE_CHANGE:
                {
                    if(handle->call_state_cb)
                        handle->call_state_cb(pack->data, pack->data_len);
                    break;
                }
                case MBTK_INFO_ID_IND_SMS_STATE_CHANGE:
                {
                    if(handle->sms_state_cb)
                        handle->sms_state_cb(pack->data, pack->data_len);
                    break;
                }
                case MBTK_INFO_ID_IND_RADIO_STATE_CHANGE:
                {
                    if(handle->radio_state_cb)
                        handle->radio_state_cb(pack->data, pack->data_len);
                    break;
                }
                case MBTK_INFO_ID_IND_SIM_STATE_CHANGE:
                {
                    if(handle->sim_state_cb)
                        handle->sim_state_cb(pack->data, pack->data_len);
                    break;
                }
                case MBTK_INFO_ID_IND_PDP_STATE_CHANGE:
                {
                    if(handle->pdp_state_cb)
                        handle->pdp_state_cb(pack->data, pack->data_len);
                    break;
                }
                //mbtk wyq for server_ready_status add start
                case MBTK_INFO_ID_IND_SERVER_STATE_CHANGE:
                {
                    handle->server_ready_status = 1;
                    LOG("handshake message recv ok.");
                    break;
                }
                //mbtk xr for signal_status add start
                case MBTK_INFO_ID_IND_SIGNAL_STATE_CHANGE:
                {
                    if(handle->signal_state_cb)
                        handle->signal_state_cb(pack->data, pack->data_len);
                    break;
                }

                //mbtk wyq for server_ready_status add end
                default:
                {
                    LOG("Unknown IND : %d", pack->info_id);
                    break;
                }
            }
        }
        else // Register IND response.
        {
            handle->info_err = pack->info_err;
            if(pack->info_err == MBTK_INFO_ERR_SUCCESS)
            {
                LOG("IND %s register success.", id2str(pack->info_id));
            }
            else
            {
                LOG("IND %s register fail : %s", id2str(pack->info_id), err2str(pack->info_err));
            }

            if(handle->is_waitting) {
                pthread_mutex_lock(&handle->mutex);
                pthread_cond_signal(&handle->cond);
                pthread_mutex_unlock(&handle->mutex);
            }
        }
    }
    else     // Response Information.
    {
        handle->info_err = pack->info_err;

        // Set data length.
        // If data change,will change this lenght in mbtk_info_pack_data_get().
        handle->data_len = pack->data_len;
        // Copy data buffer,because it will be released.
        if(handle->data && pack->data && pack->data_len > 0) {
            memcpy(handle->data, pack->data, handle->data_len);
        }

        if(handle->is_waitting) {
            pthread_mutex_lock(&handle->mutex);
            pthread_cond_signal(&handle->cond);
            pthread_mutex_unlock(&handle->mutex);
        }


#if 0
        if(pack->info_err == MBTK_INFO_ERR_SUCCESS)
        {
            LOG("REQ %s success.", id2str(pack->info_id));
#if 0
            if(pack->data_len > 0)
            {
                log_hex("DATA", pack->data, pack->data_len);
            }
#endif
            switch(pack->info_id)
            {
                case MBTK_INFO_ID_NET_AVAILABLE_RSP:
                {
                    mbtk_net_array_info_t* nets = (mbtk_net_array_info_t*)mbtk_info_pack_data_get(pack);
                    if(nets)
                    {
                        mbtk_net_info_t *net = NULL;
                        list_first(nets->net_list);
                        while ((net = (mbtk_net_info_t*) list_next(nets->net_list)))
                        {
                            LOG("NET : %d, %d, %s", net->net_sel_mode, net->net_type, net->plmn);
                        }
                        list_free(nets->net_list);
                        free(nets);
                    }
                    else
                    {
                        LOG("mbtk_info_pack_data_get() fail.");
                    }

                    break;
                }
                case MBTK_INFO_ID_NET_SEL_MODE_RSP:
                {
                    mbtk_net_info_t* net = (mbtk_net_info_t*)mbtk_info_pack_data_get(pack);
                    if(net)
                    {
                        LOG("NET : %d, %d, %d", net->net_sel_mode, net->net_type, net->plmn);
                        free(net);
                    }
                    else
                    {
                        LOG("mbtk_info_pack_data_get() fail.");
                    }

                    break;
                }
                case MBTK_INFO_ID_NET_BAND_RSP:
                {
                    mbtk_band_info_t* band = (mbtk_band_info_t*)mbtk_info_pack_data_get(pack);
                    if(band) {
                        LOG("BAND : %d, %d, %d, %d, %d", band->net_pref,
                                                         band->gsm_band,
                                                         band->umts_band,
                                                         band->tdlte_band,
                                                         band->fddlte_band);
                    } else {
                        LOG("mbtk_info_pack_data_get() fail.");
                    }

                    break;
                }
                default:
                {
                    break;
                }
            }
        }
        else
        {
            LOG("REQ %s fail : %s", id2str(pack->info_id), err2str(pack->info_err));
        }
#endif
    }
    return 0;
}


static void* info_read_run(void* arg)
{
    int epoll_fd = epoll_create(5);
    if(epoll_fd < 0)
    {
        LOG("epoll_create() fail[%d].", errno);
        return NULL;
    }
    mbtk_info_handle_t* handle = (mbtk_info_handle_t*)arg;

    uint32 event = EPOLLIN | EPOLLET;
    struct epoll_event ev_cli, ev_exit;
    ev_cli.data.fd = handle->client_fd;
    ev_cli.events = event; //EPOLLIN | EPOLLERR | EPOLLET;
    epoll_ctl(epoll_fd,EPOLL_CTL_ADD,handle->client_fd,&ev_cli);

    ev_exit.data.fd = handle->exit_fd[0];
    ev_exit.events = event; //EPOLLIN | EPOLLERR | EPOLLET;
    epoll_ctl(epoll_fd,EPOLL_CTL_ADD,handle->exit_fd[0],&ev_exit);

    int nready = -1;
    struct epoll_event epoll_events[EPOLL_LISTEN_MAX];
    while(1)
    {
        nready = epoll_wait(epoll_fd, epoll_events, EPOLL_LISTEN_MAX, -1);
        if(nready > 0)
        {
            int i;
            for(i = 0; i < nready; i++)
            {
                LOGD("fd[%d] event = %x",epoll_events[i].data.fd, epoll_events[i].events);
                if(epoll_events[i].events & EPOLLHUP)   // Closed by server.
                {
                    LOGD("Closed by server.");
                    if(ril_server_state_cb) {
                        int state = 1;
                        ril_server_state_cb(&state, sizeof(int));
                    }
                }
                else if(epoll_events[i].events & EPOLLIN)
                {
                    if(handle->client_fd == epoll_events[i].data.fd)  // Server data arrive.
                    {
                        // Read and process every message.
                        mbtk_info_err_enum err = MBTK_INFO_ERR_SUCCESS;
                        mbtk_info_pack_t **pack = mbtk_info_pack_recv(handle->client_fd, false, &err);

                        // Parse packet error,send error response to client.
                        if(pack == NULL)
                        {
                            if(err != MBTK_INFO_ERR_SUCCESS)
                            {
                                LOG("RSP packet error[%s].", err2str(err));
                            }
                        }
                        else
                        {
                            mbtk_info_pack_t** pack_ptr = pack;
                            while(*pack_ptr)
                            {
                                pack_process(handle, *pack_ptr);
                                mbtk_info_pack_free(pack_ptr);
                                pack_ptr++;
                            }
                            free(pack);
                        }
                    }
                    else if(handle->exit_fd[0] == epoll_events[i].data.fd) //
                    {
                        char buff[100] = {0};
                        int len = read(handle->exit_fd[0], buff, 100);
                        if(len > 0) {
                            LOGI("CMD : %s", buff);
                            if(strcmp(buff, "EXIT") == 0) {
                                goto read_thread_exit;
                            } else {
                                LOGD("Unkonw cmd : %s", buff);
                            }
                        } else {
                            LOGE("sock_read() fail.");
                        }
                    }
                    else
                    {
                        LOG("Unknown socket : %d", epoll_events[i].data.fd);
                    }
                }
                else
                {
                    LOG("Unknown event : %x", epoll_events[i].events);
                }
            }
        }
        else
        {
            LOG("epoll_wait() fail[%d].", errno);
        }
    }

read_thread_exit:
    if(epoll_fd >= 0)
    {
        close(epoll_fd);
        epoll_fd = 0;
    }
    LOGD("info_read thread exit.");
    return NULL;
}

#if 0
static int info_item_get(mbtk_info_handle_t* handle, mbtk_info_id_enum id, void* data)
{
    int data_len = 0;
    if(data == NULL) {
        LOG("data is null.");
        return -1;
    }
    mbtk_info_pack_t* pack = mbtk_info_pack_creat(id);
    if(pack == NULL) {
        LOG("mbtk_info_item_get() fail.");
        return -1;
    }

    mbtk_info_pack_send(handle->client_fd, pack);
    mbtk_info_pack_free(&pack);
    handle->data = data;

    // Wait for server response.
    pthread_mutex_lock(&handle->mutex);
    handle->is_waitting = true;
    pthread_cond_wait(&handle->cond, &handle->mutex);
    handle->is_waitting = false;
    pthread_mutex_unlock(&handle->mutex);

    if(handle->info_err == MBTK_INFO_ERR_SUCCESS)
    {
        LOG("REQ %s success.", id2str(id));
        if(data && handle->data_len > 0) {
            data_len = handle->data_len;
            handle->data_len = 0;
            handle->data = NULL;
        }
        return data_len;
    } else {
        LOG("REQ %s fail : %s", id2str(id), err2str(handle->info_err));
        return -1;
    }
}
#endif

/*
* Return recv data length.
* -1 : fail.
*/
static int info_item_process(mbtk_info_handle_t *handle,
                             mbtk_info_id_enum  id,
                             const void         *send_buff,
                             int                send_buff_len,
                             void               *recv_buff)
{
    if(handle == NULL/* || ((send_buff == NULL || send_buff_len == 0) && recv_buff == NULL)*/) {
        LOG("ARG error.");
        return -1;
    }
    mbtk_info_pack_t* pack = mbtk_info_pack_creat(id);
    if(pack == NULL) {
        return -1;
    }
    if(send_buff && send_buff_len > 0) { // Set the data to be sent.
        // log_hex("data", send_buff, send_buff_len);
        // mbtk_info_pack_data_set(pack, data, data_len);
        pack->data_len = (uint16)send_buff_len;
        pack->data = (uint8*)send_buff;
    }

    pthread_mutex_lock(&handle->send_mutex);
    pthread_mutex_lock(&handle->mutex);
    handle->is_waitting = true;

    mbtk_info_pack_send(handle->client_fd, pack);
    mbtk_info_pack_free(&pack);

    if(recv_buff != NULL)
        handle->data = recv_buff;
    // Wait for server response.
    pthread_cond_wait(&handle->cond, &handle->mutex);
    handle->is_waitting = false;
    pthread_mutex_unlock(&handle->mutex);
    if(handle->info_err == MBTK_INFO_ERR_SUCCESS)
    {
        LOG("REQ %s success.", id2str(id));
        int recv_len = 0;
        if(recv_buff && handle->data_len > 0) {
            recv_len = handle->data_len;
            handle->data_len = 0;
            handle->data = NULL;
        }
        pthread_mutex_unlock(&handle->send_mutex);

        return recv_len;
    } else {
        LOG("REQ %s fail : %s", id2str(id), err2str(handle->info_err));
        pthread_mutex_unlock(&handle->send_mutex);

        return -1;
    }
}

void mbtk_ril_lib_info_print()
{
    MBTK_SOURCE_INFO_PRINT("mbtk_ril_lib");
}

mbtk_info_handle_t* mbtk_info_handle_get()
{
    mbtk_info_handle_t* handle = (mbtk_info_handle_t*)malloc(sizeof(mbtk_info_handle_t));
    if(!handle)
    {
        LOG("malloc() error[%d].", errno);
        return NULL;
    }
    memset(handle, 0, sizeof(mbtk_info_handle_t));
    handle->client_fd = socket(AF_LOCAL, SOCK_STREAM, 0);
    if(handle->client_fd < 0)
    {
        LOG("socket() fail[%d].", errno);
        goto error;
    }

    // Set O_NONBLOCK
    int flags = fcntl(handle->client_fd, F_GETFL, 0);
    if (flags < 0)
    {
        LOG("Get flags error:%d", errno);
        goto error;
    }
    flags |= O_NONBLOCK;
    if (fcntl(handle->client_fd, F_SETFL, flags) < 0)
    {
        LOG("Set flags error:%d", errno);
        goto error;
    }

    struct sockaddr_un cli_addr;
    memset(&cli_addr, 0, sizeof(cli_addr));
    cli_addr.sun_family = AF_LOCAL;
    strcpy(cli_addr.sun_path, SOCK_INFO_PATH);
    if(connect(handle->client_fd, (struct sockaddr *)&cli_addr, sizeof(cli_addr)))
    {
        LOG("connect() fail[%d].", errno);
        goto error;
    }

    if(pipe(handle->exit_fd)) {
        LOG("pipe() fail[%d].", errno);
        goto error;
    }
#if 0
    pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOG("pthread_attr_setdetachstate() fail.");
        goto error;
    }

    if(pthread_create(&(handle->read_thread_id), &thread_attr, info_read_run, handle))
    {
        LOG("pthread_create() fail.");
        goto error;
    }
    pthread_attr_destroy(&thread_attr);
#else
    if(pthread_create(&(handle->read_thread_id), NULL, info_read_run, handle))
    {
        LOG("pthread_create() fail.");
        goto error;
    }
#endif

    pthread_mutex_init(&handle->mutex, NULL);
#ifndef MBTK_SG_SUPPORT
    pthread_mutex_init(&handle->send_mutex, NULL);
#endif
    pthread_cond_init(&handle->cond, NULL);
    handle->is_waitting = false;

    //mbtk wyq for server_ready_status add start
    int timeout = 5;//The wait server timeout by default
    LOG("wait server handshake message--->.");
    while(timeout)
    {
        if(handle->server_ready_status)
        {
            break;
        }
        else
        {
            sleep(1);
            timeout--;
        }
    }

    if(timeout <= 0)
    {
        if(handle->exit_fd[1] > 0)
        {
            mbtk_write(handle->exit_fd[1], "EXIT", 4);
        }
        pthread_join(handle->read_thread_id,NULL);
        LOG("mbtk_info_handle_get() server not ready.");
        goto error;
    }
    else
    {
        LOG("mbtk_info_handle_get() server ready ok.");
    }
    //mbtk wyq for server_ready_status add end
    return handle;
error:
    if(handle)
    {
        if(handle->client_fd > 0)
        {
            close(handle->client_fd);
        }
        if(handle->exit_fd[0] > 0) {
            close(handle->exit_fd[0]);
        }
        if(handle->exit_fd[1] > 0) {
            close(handle->exit_fd[1]);
        }
        free(handle);
        handle = NULL;
    }

    return NULL;
}

int mbtk_info_handle_free(mbtk_info_handle_t** handle)
{
    if(handle == NULL || *handle == NULL)
    {
        LOG("Handle is NULL.");
        return -1;
    }

    if((*handle)->exit_fd[1] > 0) {
        mbtk_write((*handle)->exit_fd[1], "EXIT", 4);
    }

    // Wait read_thread exit.
    pthread_join((*handle)->read_thread_id,NULL);

    if((*handle)->exit_fd[0] > 0) {
        close((*handle)->exit_fd[0]);
        (*handle)->exit_fd[0] = -1;
    }

    if((*handle)->exit_fd[1] > 0) {
        close((*handle)->exit_fd[1]);
        (*handle)->exit_fd[1] = -1;
    }

    if((*handle)->client_fd > 0)
    {
        close((*handle)->client_fd);
        (*handle)->client_fd = -1;
    }
    free(*handle);
    *handle = NULL;
    return 0;
}

/*
* Get platform version.
*/
int mbtk_version_get(mbtk_info_handle_t* handle, void *version)
{
    if(handle == NULL || version == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, MBTK_INFO_ID_DEV_VERSION_REQ, NULL, 0, version) > 0) {
        LOG("Version : %s", version);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get platform version.
*/
int mbtk_model_get(mbtk_info_handle_t* handle, void *model)
{
    if(handle == NULL || model == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, MBTK_INFO_ID_DEV_MODEL_REQ, NULL, 0, model) > 0) {
        LOG("Version : %s", model);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get platform IMEI.
*/
int mbtk_imei_get(mbtk_info_handle_t* handle, void *imei)
{
    if(handle == NULL || imei == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_DEV_IMEI_REQ, NULL, 0, imei) > 0) {
        LOG("IMEI : %s", imei);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get platform SN.
*/
int mbtk_sn_get(mbtk_info_handle_t* handle, void *sn)
{
    if(handle == NULL || sn == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_DEV_SN_REQ, NULL, 0, sn) > 0) {
        LOG("SN : %s", sn);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get platform MEID.
*/
int mbtk_meid_get(mbtk_info_handle_t* handle, void *meid)
{
    if(handle == NULL || meid == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_DEV_MEID_REQ, NULL, 0, meid) > 0) {
        LOG("MEID : %s", meid);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Return VoLTE state.
*/
int mbtk_volte_state_get(mbtk_info_handle_t* handle, int *volte_state)
{
    uint8 state;
    if(handle == NULL || volte_state == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_DEV_VOLTE_REQ, NULL, 0, &state) > 0) {
        LOG("VoLTE State : %d", state);
        *volte_state = state;
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set VoLTE state.
*
* volte_state:
* 0 : Close VoLTE.
* 1 : Open VoLTE.
*
* Restarting takes effect after execution.
*/
int mbtk_volte_state_set(mbtk_info_handle_t* handle, int volte_state)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    return info_item_process(handle, MBTK_INFO_ID_DEV_VOLTE_REQ, (uint8*)&volte_state, sizeof(uint8), NULL) ? handle->info_err : 0;
}

/*
* Get platform IMSI.
*/
int mbtk_imsi_get(mbtk_info_handle_t* handle, void *imsi)
{
    if(handle == NULL || imsi == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_IMSI_REQ, NULL, 0, imsi) > 0) {
        LOG("IMSI : %s", imsi);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get platform ICCID.
*/
int mbtk_iccid_get(mbtk_info_handle_t* handle, void *iccid)
{
    if(handle == NULL || iccid == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_ICCID_REQ, NULL, 0, iccid) > 0) {
        LOG("ICCID : %s", iccid);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get current phone number.
*/
int mbtk_phone_number_get(mbtk_info_handle_t* handle, void *phone_number)
{
    if(handle == NULL || phone_number == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_PN_REQ, NULL, 0, phone_number) > 0) {
        LOG("Phone Number : %s", phone_number);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get PIN’s number of remaining retry
*/
int mbtk_pin_last_num_get(mbtk_info_handle_t* handle, mbtk_pin_puk_last_times *last_times)
{
    if(handle == NULL || last_times == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_PINPUK_TIMES_REQ, NULL, 0, last_times) > 0) {
        LOG("Sim sim_pin_puk_last_times : %d, %d, %d, %d", last_times->p1_retry,last_times->p2_retry,last_times->puk1_retry,last_times->puk2_retry);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* emable PIN
*/
int mbtk_enable_pin(mbtk_info_handle_t* handle, mbtk_enable_pin_info *pin)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_ENABLE_PIN_REQ, pin, sizeof(mbtk_enable_pin_info), NULL) >= 0) {
        LOG("pin Number : %s", pin->pin_value);
        return 0;
    } else {
        return handle->info_err;
    }

}

/*
* GET PIN STATE
*/
int mbtk_get_pin_state(mbtk_info_handle_t* handle, mbtk_pin_state_enum *pin_state)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_ENABLE_PIN_REQ, NULL, 0, pin_state) >= 0) {
        LOGD("pin state: %d", *pin_state);
        return 0;
    } else {
        return handle->info_err;
    }

}


/*
* Verify PIN
*/
int mbtk_verify_pin(mbtk_info_handle_t* handle, char *pin)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_PIN_REQ, pin, strlen(pin), NULL) >= 0) {
        LOG("pin Number : %s", pin);
        return 0;
    } else {
        return handle->info_err;
    }

}

/*
* Verify PIN
*/
int mbtk_change_pin(mbtk_info_handle_t* handle, mbtk_change_pin_info *pin)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_CHANGE_PIN_REQ, pin, sizeof(mbtk_change_pin_info), NULL) >= 0) {
        LOG("Change PIN : %s -> %s", pin->old_pin_value, pin->new_pin_value);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* unblock_pin
*/
int mbtk_unlock_pin(mbtk_info_handle_t* handle, mbtk_unlock_pin_info *pin)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_PUK_REQ, pin, sizeof(mbtk_unlock_pin_info), NULL) >= 0) {
        LOG("Unlock : %s , %s", pin->pin_value , pin->puk_value);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get plmn list
*/
int mbtk_get_plmn_list(mbtk_info_handle_t* handle, mbtk_plmn_info *pin)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_PLMN_REQ, NULL, 0, pin) >= 0) {
        //LOG("pin Number : %s", pin);
        return 0;
    } else {
        return handle->info_err;
    }
}


/*
* Get available network.
*/
int mbtk_available_net_get(mbtk_info_handle_t* handle, list_node_t **net_list)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    *net_list = list_create(NULL);
    if(*net_list == NULL)
    {
        LOG("list_create() fail.");
        return MBTK_INFO_ERR_MEMORY;
    }

    uint8 buff[SOCK_MSG_LEN_MAX] = {0};
    int buff_len;
    if((buff_len = info_item_process(handle, MBTK_INFO_ID_NET_AVAILABLE_REQ, NULL, 0, buff)) > 0) {
        int i = 0;
        while (i < buff_len / sizeof(mbtk_net_info_t))
        {
            mbtk_net_info_t* net = (mbtk_net_info_t*)malloc(sizeof(mbtk_net_info_t));
            if(net == NULL)
            {
                LOG("malloc() fail.");
                list_free(*net_list);
                return MBTK_INFO_ERR_MEMORY;
            }
            memcpy(net, buff + i * sizeof(mbtk_net_info_t), sizeof(mbtk_net_info_t));
            list_add(*net_list, net);

            LOG("NET-%d: %d, %d, %d, %d", i + 1, net->net_sel_mode, net->net_type, net->net_state, net->plmn);
            i++;
        }

        return 0;
    } else {
        list_free(*net_list);
        return handle->info_err;
    }
}

/*
* Set network select mode. (+COPS=...)
*/
int mbtk_net_sel_mode_set(mbtk_info_handle_t* handle, const mbtk_net_info_t *net)
{
    if(handle == NULL || net == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    return info_item_process(handle, MBTK_INFO_ID_NET_SEL_MODE_REQ, net, sizeof(mbtk_net_info_t), NULL) ? handle->info_err : 0;
}

/*
* Get network select mode. (+COPS?)
*/
int mbtk_net_sel_mode_get(mbtk_info_handle_t* handle, mbtk_net_info_t *net)
{
    if(handle == NULL || net == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_NET_SEL_MODE_REQ, NULL, 0, net) > 0) {
        LOG("NET : %d, %d, %d, %d", net->net_sel_mode, net->net_type, net->net_state, net->plmn);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get platform support bands.
*/
int mbtk_support_band_get(mbtk_info_handle_t* handle, mbtk_band_info_t *band)
{
    uint8 type = 0; // Get support bands.
    if(handle == NULL || band == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_NET_BAND_REQ, &type, sizeof(uint8), band) > 0) {
        LOG("BAND : %d, %d, %d, %d, %d", band->net_pref, band->gsm_band, band->umts_band, band->tdlte_band, band->fddlte_band);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get platform current bands.
*/
int mbtk_current_band_get(mbtk_info_handle_t* handle, mbtk_band_info_t *band)
{
    uint8 type = 1; // Get current bands.
    if(handle == NULL || band == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_NET_BAND_REQ, &type, sizeof(uint8), band) > 0) {
        LOG("BAND : %d, %d, %d, %d, %d", band->net_pref, band->gsm_band, band->umts_band, band->tdlte_band, band->fddlte_band);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set platform current bands.
*/
int mbtk_current_band_set(mbtk_info_handle_t* handle, const mbtk_band_info_t *band)
{
    if(handle == NULL || band == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    return info_item_process(handle, MBTK_INFO_ID_NET_BAND_REQ, band, sizeof(mbtk_band_info_t), NULL) ? handle->info_err : 0;
}

/*
* Get current cell infomation.
*/
int mbtk_cell_get(mbtk_info_handle_t* handle, mbtk_cell_type_enum *type, list_node_t **cell_list)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    *cell_list = list_create(NULL);
    if(*cell_list == NULL)
    {
        LOG("list_create() fail.");
        return MBTK_INFO_ERR_MEMORY;
    }

    uint8 buff[SOCK_MSG_LEN_MAX] = {0};
    int buff_len;
    if((buff_len = info_item_process(handle, MBTK_INFO_ID_NET_CELL_REQ, NULL, 0, buff)) > 0) {
        int i = 0;
        *type = buff[0]; // Set network type.
        while (i < (buff_len - sizeof(uint8)) / sizeof(mbtk_cell_info_t))
        {
            mbtk_cell_info_t* cell = (mbtk_cell_info_t*)malloc(sizeof(mbtk_cell_info_t));
            if(cell == NULL)
            {
                LOG("malloc() fail.");
                list_free(*cell_list);
                return MBTK_INFO_ERR_MEMORY;
            }
            memcpy(cell, buff + sizeof(uint8) + i * sizeof(mbtk_cell_info_t), sizeof(mbtk_cell_info_t));
            list_add(*cell_list, cell);

            // LOG("Cell-%d: %d, %d, %d, %d, %d", i + 1, cell->value1, cell->value2, cell->value3, cell->value4, cell->value5);
            i++;
        }

        return 0;
    } else {
        list_free(*cell_list);
        return handle->info_err;
    }
}
/*
* Set cell info.
*
* at*CELL=<mode>,<act>,< band>,<freq>,<cellId>
* at*cell=2,3,,40936,429   //
* at*cell=0  //
*
* Restarting takes effect after execution.
*/
int mbtk_cell_set(mbtk_info_handle_t* handle, char * info, char* response)
{
    printf("mbtk_cell_set() info:%s, len:%d",info, strlen(info));
    char req[128] = {0};
    if( info_item_process(handle, MBTK_INFO_ID_NET_CELL_REQ, info, strlen(info), req) > 0){
        memcpy(response, req, strlen(req));
        return 0;
    }
    else{
        return 0;
    //    return handle->info_err;
    }
}

/*
* Get all APN informations.
*/
int mbtk_apn_get(mbtk_info_handle_t* handle, int *apn_num, mbtk_apn_info_t apns[])
{
    int len;
    if(handle == NULL || apn_num == NULL || apns == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    uint8 data[SOCK_MSG_LEN_MAX];
    if((len = info_item_process(handle, MBTK_INFO_ID_NET_APN_REQ, NULL, 0, data)) > 0) {
        /*
        <apn_num[1]><cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth_len[2]><auth>...
                    <cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth_len[2]><auth>
        */
        uint8* ptr = data;
        if(apn_num == NULL || apns == NULL || *apn_num < *ptr) {
            *apn_num = 0;
            LOGE("APN array size to not enough.");
            return -1;
        }
        *apn_num = *ptr++;
        LOG("APN Number : %d", *apn_num);
        int i = 0;
        while(i < *apn_num) {
            memset(&(apns[i]), 0 ,sizeof(mbtk_apn_info_t));
            apns[i].cid = *ptr++;
            apns[i].ip_type = (mbtk_ip_type_enum)(*ptr++);

            // apn
            len = byte_2_uint16(ptr, false);
            ptr += sizeof(uint16);
            if(len > 0) { // Has APN
                memcpy(apns[i].apn, ptr, len);
                ptr += len;
            }
            // user
            len = byte_2_uint16(ptr, false);
            ptr += sizeof(uint16);
            if(len > 0) { // Has APN
                memcpy(apns[i].user, ptr, len);
                ptr += len;
            }

            // pass
            len = byte_2_uint16(ptr, false);
            ptr += sizeof(uint16);
            if(len > 0) { // Has APN
                memcpy(apns[i].pass, ptr, len);
                ptr += len;
            }
            // auth
            len = byte_2_uint16(ptr, false);
            ptr += sizeof(uint16);
            if(len > 0) { // Has APN
                memcpy(apns[i].auth, ptr, len);
                ptr += len;
            }

            i++;
        }
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get all APN informations.
*/
int mbtk_qser_apn_get(mbtk_info_handle_t* handle, int *apn_num, mbtk_qser_apn_info_s apns[])
{
    int len;
    if(handle == NULL || apn_num == NULL || apns == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    uint8 data[SOCK_MSG_LEN_MAX];
    if((len = info_item_process(handle, MBTK_INFO_ID_NET_QSER_APN_REQ, NULL, 0, data)) > 0) {
        /*
        <apn_num[1]><cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth[1]><apn_type_len[2]><apn_type_len>...
                    <cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth[1]><apn_type_len[2]><apn_type_len>
        */
        uint8* ptr = data;
        if(apn_num == NULL || apns == NULL || *apn_num < *ptr) {
            *apn_num = 0;
            LOGE("APN array size to not enough.");
            return -1;
        }
        *apn_num = *ptr++;
        LOGD("APN Number : %d", *apn_num);
        int i = 0;
        while(i < *apn_num) {
            memset(&(apns[i]), 0x0 ,sizeof(mbtk_qser_apn_info_s));
            apns[i].cid = *ptr++;
            apns[i].ip_type = (mbtk_ip_type_enum)(*ptr++);

            // apn
            len = byte_2_uint16(ptr, false);
            ptr += sizeof(uint16);
            if(len > 0) { // Has APN
                memcpy(apns[i].apn_name, ptr, len);
                ptr += len;
            }
            // user
            len = byte_2_uint16(ptr, false);
            ptr += sizeof(uint16);
            if(len > 0) { // Has APN
                memcpy(apns[i].user_name, ptr, len);
                ptr += len;
            }

            // pass
            len = byte_2_uint16(ptr, false);
            ptr += sizeof(uint16);
            if(len > 0) { // Has APN
                memcpy(apns[i].user_pass, ptr, len);
                ptr += len;
            }
            // auth
            apns[i].auth_proto = (mbtk_apn_auth_proto_enum)(*ptr++);

            //apn_type
            len = byte_2_uint16(ptr, false);
            ptr += sizeof(uint16);
            if(len > 0) { // Has APN
                memcpy(apns[i].apn_type, ptr, len);
                ptr += len;
            }

            i++;
        }
    }
    else if(len == 0)
    {
        LOGD("get data len : 0.");
        *apn_num = 0;
        return 0;
    }
    else
    {
        return handle->info_err;
    }

    return 0;
}

/*
* qser Set current APN informations.
*/
int mbtk_qser_apn_set(mbtk_info_handle_t* handle, mbtk_qser_apn_info_s *apninfo, unsigned char *cid)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    uint8 data[SOCK_MSG_LEN_MAX];
    memset(data, 0, SOCK_MSG_LEN_MAX);
    // cid : 2 - 7
    if(apninfo->req_type != MBTK_APN_REQ_TYPE_ADD && (apninfo->cid < MBTK_APN_CID_MIN || apninfo->cid > MBTK_APN_CID_MAX)) {
        LOGE("CID error.");
        return -1;
    }

    uint8* ptr = data;
    // <cid[1]><ip_type[1]><req_type[1]><auth[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth_len[2]><apn_type[2]>
    *ptr++ = (uint8)apninfo->cid;
    *ptr++ = (uint8)apninfo->ip_type;
    *ptr++ = (uint8)apninfo->req_type;
    *ptr++ = (uint8)apninfo->auth_proto;
    if(str_empty(apninfo->apn_name)) {
        uint16_2_byte((uint16)0, ptr, false);
        ptr += sizeof(uint16);
    } else {
        uint16_2_byte((uint16)strlen((char *)apninfo->apn_name), ptr, false);
        ptr += sizeof(uint16);
        memcpy(ptr, apninfo->apn_name, strlen((char *)apninfo->apn_name));
        ptr += strlen((char *)apninfo->apn_name);
    }
    if(str_empty(apninfo->user_name)) {
        uint16_2_byte((uint16)0, ptr, false);
        ptr += sizeof(uint16);
    } else {
        uint16_2_byte((uint16)strlen((char *)apninfo->user_name), ptr, false);
        ptr += sizeof(uint16);
        memcpy(ptr, apninfo->user_name, strlen((char *)apninfo->user_name));
        ptr += strlen((char *)apninfo->user_name);
    }

    if(str_empty(apninfo->user_pass)) {
        uint16_2_byte((uint16)0, ptr, false);
        ptr += sizeof(uint16);
    } else {
        uint16_2_byte((uint16)strlen((char *)apninfo->user_pass), ptr, false);
        ptr += sizeof(uint16);
        memcpy(ptr, apninfo->user_pass, strlen((char *)apninfo->user_pass));
        ptr += strlen((char *)apninfo->user_pass);
    }

    if(str_empty(apninfo->apn_type)) {
        uint16_2_byte((uint16)0, ptr, false);
        ptr += sizeof(uint16);
    }
    else
    {
        uint16_2_byte((uint16)strlen((char *)apninfo->apn_type), ptr, false);
        ptr += sizeof(uint16);
        memcpy(ptr, apninfo->apn_type, strlen((char *)apninfo->apn_type));
        ptr += strlen((char *)apninfo->apn_type);
    }

    if(info_item_process(handle, MBTK_INFO_ID_NET_QSER_APN_REQ, data, ptr - data, (void *)cid) < 0)
    {
        return handle->info_err;
    }

    return 0;
}

/*
* Set current APN informations.
*/
int mbtk_apn_set(mbtk_info_handle_t* handle, int cid, mbtk_ip_type_enum ip_type, const void* apn_name,
                    const void *user_name, const void *user_pass, const void *auth)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    uint8 data[SOCK_MSG_LEN_MAX];
    memset(data, 0, SOCK_MSG_LEN_MAX);
    // cid : 2 - 7
    if(cid < MBTK_APN_CID_MIN || cid > MBTK_APN_CID_MAX) {
        LOGE("CID error.");
        return -1;
    }
    uint8* ptr = data;
    // <cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth_len[2]><auth>
    *ptr++ = (uint8)cid;
    *ptr++ = (uint8)ip_type;
    if(str_empty(apn_name)) {
        uint16_2_byte((uint16)0, ptr, false);
        ptr += sizeof(uint16);
    } else {
        uint16_2_byte((uint16)strlen(apn_name), ptr, false);
        ptr += sizeof(uint16);
        memcpy(ptr, apn_name, strlen(apn_name));
        ptr += strlen(apn_name);
    }
    if(str_empty(user_name)) {
        uint16_2_byte((uint16)0, ptr, false);
        ptr += sizeof(uint16);
    } else {
        uint16_2_byte((uint16)strlen(user_name), ptr, false);
        ptr += sizeof(uint16);
        memcpy(ptr, user_name, strlen(user_name));
        ptr += strlen(user_name);
    }

    if(str_empty(user_pass)) {
        uint16_2_byte((uint16)0, ptr, false);
        ptr += sizeof(uint16);
    } else {
        uint16_2_byte((uint16)strlen(user_pass), ptr, false);
        ptr += sizeof(uint16);
        memcpy(ptr, user_pass, strlen(user_pass));
        ptr += strlen(user_pass);
    }

    if(str_empty(auth)) {
        uint16_2_byte((uint16)0, ptr, false);
        ptr += sizeof(uint16);
    } else {
        uint16_2_byte((uint16)strlen(auth), ptr, false);
        ptr += sizeof(uint16);
        memcpy(ptr, auth, strlen(auth));
        ptr += strlen(auth);
    }

    return info_item_process(handle, MBTK_INFO_ID_NET_APN_REQ, data, ptr - data, NULL) ? handle->info_err : 0;
}

int mbtk_apn_del(mbtk_info_handle_t* handle, unsigned char profile_idx)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    profile_idx++;
    if(info_item_process(handle, MBTK_INFO_ID_NET_APN_DEL_REQ, &profile_idx, sizeof(profile_idx), NULL) >= 0)
    {
        LOG("profile_idx Number : %d", profile_idx);
        return 0;
    }
    else
    {
        return handle->info_err;
    }

}

/*
* Start data call.
*/
int mbtk_data_call_start(mbtk_info_handle_t* handle, int cid, int auto_conn_interval, bool boot_conn, int timeout)
{
    uint8 data[10];
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    memset(data, 0, 10);
    if(cid < MBTK_APN_CID_MIN || cid > MBTK_APN_CID_MAX) {
        LOGE("CID error.");
        return -1;
    }
    uint8* ptr = data;
    /* <call_type[1]><cid[1]><auto_conn_interval[1]><boot_conn[1]><timeout[1]>
     call_type : mbtk_data_call_type_enum
     cid : 2 - 7
     timeout : second
    */
    *ptr++ = (uint8)MBTK_DATA_CALL_START;
    *ptr++ = (uint8)cid;
    *ptr++ = (uint8)(auto_conn_interval > 0 ? auto_conn_interval : 0); // 拨号失败后重拨间隔（s）
    *ptr++ = (uint8)(boot_conn ? 1 : 0); // 开机自动拨号
    if(timeout <= 0) {
        *ptr++ = (uint8)MBTK_DATA_CALL_TIMEOUT_DEFAULT;
    } else {
        *ptr++ = (uint8)timeout;
    }

    return info_item_process(handle, MBTK_INFO_ID_NET_DATA_CALL_REQ, data, 5, NULL) ? handle->info_err : 0;
}

/*
* Stop data call.
*/
int mbtk_data_call_stop(mbtk_info_handle_t* handle, int cid, int timeout)
{
    uint8 data[10];
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    memset(data, 0, 10);
    if(cid < MBTK_APN_CID_MIN || cid > MBTK_APN_CID_MAX) {
        LOGE("CID error.");
        return -1;
    }
    uint8* ptr = data;
    /* <call_type[1]><cid[1]><timeout[1]>
     call_type : mbtk_data_call_type_enum
     cid : 2 - 7
     timeout : second
    */
    *ptr++ = (uint8)MBTK_DATA_CALL_STOP;
    *ptr++ = (uint8)cid;
    *ptr++ = (uint8)timeout;

    return info_item_process(handle, MBTK_INFO_ID_NET_DATA_CALL_REQ, data, 3, NULL) ? handle->info_err : 0;
}

/*
* Get data call state.
*/
int mbtk_data_call_state_get(mbtk_info_handle_t* handle, int cid, mbtk_ipv4_info_t *ipv4, mbtk_ipv6_info_t *ipv6)
{
    uint8 data[10];
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    uint8 recv_buff[SOCK_MSG_LEN_MAX]={0};
    memset(data, 0, 10);
    if(cid < MBTK_APN_CID_MIN || cid > MBTK_APN_CID_MAX) {
        LOGE("CID error.");
        return -1;
    }
    uint8* ptr = data;
    /* <call_type[1]><cid[1]><timeout[1]>
     call_type : mbtk_data_call_type_enum
     cid : 2 - 7
     timeout : second
    */
    *ptr++ = (uint8)MBTK_DATA_CALL_STATE;
    *ptr++ = (uint8)cid;
    *ptr++ = (uint8)0;

    if(ipv4) {
        memset(ipv4, 0, sizeof(mbtk_ipv4_info_t));
    }

    if(ipv6) {
        memset(ipv6, 0, sizeof(mbtk_ipv6_info_t));
    }

    if(info_item_process(handle, MBTK_INFO_ID_NET_DATA_CALL_REQ, data, 3, recv_buff) > 0) {
        if(recv_buff[0] == 0) { // IPv4 Only.
            if(ipv4) {
                memcpy(ipv4, recv_buff + sizeof(uint8), sizeof(mbtk_ipv4_info_t));
            }
        } else if(recv_buff[0] == 1) { // IPv6 Only.
            if(ipv6) {
                memcpy(ipv6, recv_buff + sizeof(uint8), sizeof(mbtk_ipv6_info_t));
            }
        } else if(recv_buff[0] == 2) { // IPv4 and IPv6.
            if(ipv4) {
                memcpy(ipv4, recv_buff + sizeof(uint8), sizeof(mbtk_ipv4_info_t));
            }

            if(ipv6) {
                memcpy(ipv6, recv_buff + sizeof(uint8) + sizeof(mbtk_ipv4_info_t), sizeof(mbtk_ipv6_info_t));
            }
        } else {
            LOGE("Unknown IP type : %d", recv_buff[0]);
            return -1;
        }
        return 0;
    } else {
        return handle->info_err;
    }
}



/*
* Get current network signal.
*/
int mbtk_net_signal_get(mbtk_info_handle_t* handle, mbtk_signal_info_t *signal)
{
    if(handle == NULL || signal == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_NET_SIGNAL_REQ, NULL, 0, signal) > 0) {
        LOG("Signal : %d, %d, %d, %d, %d, %d, %d", signal->rssi, signal->rxlev, signal->ber, signal->rscp, signal->ecno,
            signal->rsrq, signal->rsrp);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get current network register information.
*/
int mbtk_net_reg_get(mbtk_info_handle_t* handle, mbtk_net_reg_info_t *reg)
{
    if(handle == NULL || reg == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_NET_REG_REQ, NULL, 0, reg) > 0) {
        if(reg->call_state || reg->data_state || reg->ims_state) {
            LOGD("REG : call_state=%d, data_state=%d, ims_state=%d, net_type=%d, %04x, %08x", reg->call_state, reg->data_state, reg->ims_state, reg->type, reg->lac, reg->ci);
        } else {
            LOGE("Net not reg.");
        }
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get current IMS enable or not.
*/
int mbtk_net_ims_get(mbtk_info_handle_t* handle, int* enable)
{
    uint8 state;
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_NET_IMS_REQ, NULL, 0, &state) > 0) {
        LOG("IMS enable : %d", state);
        *enable = state;
        return 0;
    } else {
        return handle->info_err;
    }

}

/*
* Set IMS enable or not. This function takes effect after starting the device.
*/
int mbtk_net_ims_set(mbtk_info_handle_t* handle, int enable)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    return info_item_process(handle, MBTK_INFO_ID_NET_IMS_REQ, (uint8*)&enable, sizeof(uint8), NULL) ? handle->info_err : 0;

}

/*
* Get current network IMS register state.
*/
int mbtk_net_ims_reg_state_get(mbtk_info_handle_t* handle, int* reg)
{
    uint8 state;
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_NET_IMS_REG_STATE_REQ, NULL, 0, &state) > 0) {
        LOG("reg type : %d", state);
        *reg = state;
        return 0;
    } else {
        return handle->info_err;
    }
}


/*
* Get radio state.
*/
int mbtk_radio_state_get(mbtk_info_handle_t* handle, int *radio_state)
{
    uint8 state;
    if(handle == NULL || radio_state == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_NET_RADIO_REQ, NULL, 0, &state) > 0) {
        LOG("Radio state : %d", state);
        *radio_state = state;
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set radio state.
*/
int mbtk_radio_state_set(mbtk_info_handle_t* handle, int radio_state)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    return info_item_process(handle, MBTK_INFO_ID_NET_RADIO_REQ, (uint8*)&radio_state, sizeof(uint8), NULL) ? handle->info_err : 0;
}

/*
* get fplmn list
*/
int mbtk_fplmn_get(mbtk_info_handle_t *handle, void *fplmn)
{
    printf("enter mbtk_fplmn_get\n");
    if(handle == NULL)
    {
        LOGE("ARG error.");
        printf("mbtk_fplmn_get error");
        return -1;
    }

    uint8 recv_buff[SOCK_MSG_LEN_MAX]={0};

    printf("info_item_process,id = %d\n",MBTK_INFO_ID_NET_FPLMN_REQ);
    if(info_item_process(handle, MBTK_INFO_ID_NET_FPLMN_REQ, NULL, 0, recv_buff) > 0) {
        LOGE("fplmn : %s", recv_buff);
        strncpy(fplmn, (char *)recv_buff, strlen((char *)recv_buff));
        return 0;
    }else{
        return handle->info_err;
    }

}

/*
* set fplmn list
*/
int mbtk_fplmn_set(mbtk_info_handle_t *handle, void *fplmn)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    uint8 recv_buff[SOCK_MSG_LEN_MAX]={0};
    LOGE("mbtk_fplmn_set fplmn : %s,len = %d\n",(char *)fplmn,strlen((char *)fplmn));
    return info_item_process(handle, MBTK_INFO_ID_NET_FPLMN_REQ, (char *)fplmn, strlen((char *)fplmn), recv_buff) ? handle->info_err : 0;
}


/*
* Get time type.
*/
int mbtk_time_get(mbtk_info_handle_t* handle, int *time_type)
{
    uint8 state;
    if(handle == NULL || time_type == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_DEV_TIME_REQ, NULL, 0, &state) > 0) {
        LOG("Time type : %d", state);
        *time_type = state;
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
*Get Absolute time
*"23/05/24 06:09:32 +32 00"
*/
int mbtk_get_abs_time(char *time_str, time_t *time_out)
{
    struct tm tm_;

    char *ptr = strstr(time_str + 10, " ");
    *ptr = '\0';

    LOGD("time : \"%s\"", time_str);
#if 1
    if(strptime(time_str, "%y/%m/%d %T", &tm_) == NULL) {
        LOGE("strptime() fail.");
        return -1;
    }
#else
    int year, month, day, hour, minute,second,time_zone;
    if(strstr(time_str, "+")) {
        sscanf(time_str, "%d/%d/%d %d:%d:%d +%d",&year,&month,&day,&hour,&minute,&second,&time_zone);
    } else if(strstr(time_str, "-")) {
        sscanf(time_str, "%d/%d/%d %d:%d:%d -%d",&year,&month,&day,&hour,&minute,&second,&time_zone);
    } else {
        LOGE("Time format error:%s", time_str);
        return -1;
    }

    // 1970+
    if(year < 70) { // 20xx
        tm_.tm_year  = 2000 + year;
    } else { // 19xx
        tm_.tm_year  = 1900 + year;
    }
    tm_.tm_mon   = month - 1;
    tm_.tm_mday  = day;
    tm_.tm_hour  = hour;
    tm_.tm_min   = minute;
    tm_.tm_sec   = second;
    tm_.tm_isdst = 0;
#endif

    time_t timeStamp = mktime(&tm_);
    LOGD("tm_.tm_year = %d,tm_.tm_mon = %d,tm_.tm_mday = %d,tm_.tm_hour = %d,tm_.tm_min = %d,tm_.tm_sec = %d,tm_.tm_isdst = %d",tm_.tm_year,tm_.tm_mon,tm_.tm_mday,tm_.tm_hour,tm_.tm_min,tm_.tm_sec,tm_.tm_isdst);
    LOGD("time = %ld,%x", timeStamp,timeStamp);
    *time_out = timeStamp;

    return 0;
}

/*
* Get time type.
* "23/05/24,06:09:32+32" -> "23/05/24 06:09:32 +32 00"
*/
int mbtk_net_time_get(mbtk_info_handle_t* handle, char* time_str)
{
    char buff[SOCK_MSG_LEN_MAX] = {0};
    if(handle == NULL || time_str == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    //printf("mbtk_net_time_get begin info_item_process\n");
    if(info_item_process(handle, MBTK_INFO_ID_DEV_CELL_TIME_REQ, NULL, 0, buff) > 0) {
        memcpy(time_str,buff,strlen(buff));

        char *temp = strstr(time_str, ",");
        if(temp) {
            *temp = ' '; // ',' -> ' '

            temp = strstr(time_str, "+");
            if(temp == NULL) {
                temp = strstr(time_str, "-");
            }

            if(temp) {
                // Copy +XX or -XX
                char *last_ptr = temp + strlen(temp) + 1;
                while(last_ptr > temp) {
                    *last_ptr = *(last_ptr - 1);
                    last_ptr--;
                }

                *last_ptr = ' ';

                memcpy(temp + strlen(temp), "00", 2);

                LOGD("%s -> %s", buff, time_str);
                return 0;
            } else {
                LOGE("Time error:%s",buff);
                return MBTK_INFO_ERR_TIME_FORMAT;
            }
        } else {
            LOGE("Time error:%s",buff);
            return MBTK_INFO_ERR_TIME_FORMAT;
        }
    } else {
        return handle->info_err;
    }
}

/*
* Set time.
*
* time_type:
* 0: Cell time
* 1: NTP time
* 2: User time
* time_str: "YYYY-MM-DD HH:MM:SS"
*/
int mbtk_time_set(mbtk_info_handle_t* handle, mbtk_time_type_enum time_type, char* time_str)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    uint8 buffer[100] = {0};
    buffer[0] = (uint8)time_type;
    if(time_type == MBTK_TIME_TYPE_USER) {
        if(!str_empty(time_str)) {
            memcpy(buffer + sizeof(uint8), time_str, strlen(time_str));
            return info_item_process(handle, MBTK_INFO_ID_DEV_TIME_REQ,
                    buffer, sizeof(uint8) + strlen(time_str), NULL) ? handle->info_err : 0;
        } else {
            return -1;
        }
    } else {
        return info_item_process(handle, MBTK_INFO_ID_DEV_TIME_REQ,
                buffer, sizeof(uint8), NULL) ? handle->info_err : 0;
    }
}

/*
* Return sms cmgf.
*/
int mbtk_sms_cmgf_get(mbtk_info_handle_t* handle, int *volte_state)
{
    uint8 state;
    if(info_item_process(handle, MBTK_INFO_ID_SMS_CMGF_REQ, NULL, 0, &state) > 0) {
        LOG("mbtk_sms_cmgf_get()-----------sms cmgf : %d", state);
        *volte_state = state;
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set sms cmgf.
*
* volte_state:
* 0 : PDU mode.
* 1 :  text mode.
*
* Restarting takes effect after execution.
*/
int mbtk_sms_cmgf_set(mbtk_info_handle_t* handle, int mode)
{
    LOGD("mbtk_sms_cmgf_set()--------mode=:%d, len:%d", mode, sizeof(uint8));
    return info_item_process(handle, MBTK_INFO_ID_SMS_CMGF_REQ, (uint8*)&mode, sizeof(uint8), NULL) ? handle->info_err : 0;
}

/*
* Set sms cmgs.
*
if PDU mode (+CMGF=0):
+CMGS=<length><CR>
PDU is given<ctrl-Z/ESC>

if text mode (+CMGF=1):
+CMGS=<da>[,<toda>]<CR>
text is entered<ctrl-Z/ESC>

* Restarting takes effect after execution.
*/
int mbtk_sms_cmgs_set(mbtk_info_handle_t* handle, char * cmgs, char *resp)
{
    LOGD("mbtk_sms_cmgs_set(1)--------cmgs=:%s, len:%d", cmgs, strlen(cmgs));
//    char req[20] = {0}
    if(info_item_process(handle, MBTK_INFO_ID_SMS_CMGS_REQ, cmgs, strlen(cmgs), resp)  > 0){
        LOGD("resp:%s", resp);
        return 0;
    }else{
        return handle->info_err;
    }
}

/*
* Set sms cmgw.
*
if text mode (+CMGF=1):
+CMGW=<oa/da>[,<tooa/toda>[,<stat>]]
<CR>
text is entered<ctrl-Z/ESC>
if PDU mode (+CMGF=0):
+CMGW=<length>[,<stat>]<CR>PDU is
given<ctrl-Z/ESC>

*/

int mbtk_sms_cmgw_set(mbtk_info_handle_t* handle, char * cmgw, char *resp)
{
    printf("mbtk_sms_cmgw_set() ----------cmgw:%s, len:%d", cmgw, strlen(cmgw));
    if(info_item_process(handle, MBTK_INFO_ID_SMS_CMGW_REQ, cmgw, strlen(cmgw), resp)  > 0){
        printf("resp:%s\n", resp);
        return 0;
    }else{
        return handle->info_err;
    }
}

/*
* Set sms cmgd.
*
* +CMGD=<index>[,<delflag>]
*
* Restarting takes effect after execution.
*/
int mbtk_sms_cmgd_set(mbtk_info_handle_t* handle, char * cmdg)
{
    printf("mbtk_sms_cmgd_set() cmdg:%s, len:%d",cmdg, strlen(cmdg));
    return info_item_process(handle, MBTK_INFO_ID_SMS_CMGD_REQ, cmdg, strlen(cmdg), NULL) ? handle->info_err : 0;
}

/*
* Get sms cmgd.
*
* +CMGD: (XXX,XXX)(0-4)
*
* Restarting takes effect after execution.
*/
int mbtk_sms_cmgd_get(mbtk_info_handle_t* handle, char * cmdg)
{
    return info_item_process(handle, MBTK_INFO_ID_SMS_CMGD_REQ, NULL, 0, cmdg) ? handle->info_err : 0;
}


/*
* Set sms cmgl.
*
* AT+CMGL[=<stat>]
*
* Restarting takes effect after execution.
*/
int mbtk_sms_cmgl_set(mbtk_info_handle_t* handle, char * cmgl, char *resp)
{
    printf("0mbtk_sms_cmgl_set() cmgl:%s, len:%d\n",cmgl, strlen(cmgl));
    char reg[5*1024] ={0};
    if( info_item_process(handle, MBTK_INFO_ID_SMS_CMGL_REQ, cmgl, strlen(cmgl), reg) > 0){
        printf("len:%d , reg:%s\n", strlen(reg), reg);
    //    memcpy(resp, reg, strlen(reg));
        return 0;
    }else {
        return handle->info_err;
    }
}

/*
* Return sms csca.
*/
int mbtk_sms_csca_get(mbtk_info_handle_t* handle, char *buf)
{
  //  char  state;
    if(info_item_process(handle, MBTK_INFO_ID_SMS_CSCA_REQ, NULL, 0, buf) > 0) {
        LOG("mbtk_sms_csca_get()-----------sms csca : %s", buf);
    //    *volte_state = state;
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set sms csca.
*
* AT+CSCA=<number> [,<type>]
*
* Restarting takes effect after execution.
*/
int mbtk_sms_csca_set(mbtk_info_handle_t* handle, char * csca)
{
    printf("mbtk_sms_csca_set() csca:%s, len:%d",csca, strlen(csca));
    return info_item_process(handle, MBTK_INFO_ID_SMS_CSCA_REQ, csca, strlen(csca), NULL) ? handle->info_err : 0;
}

/*
* Set sms csmp.
*
* AT+CSMP=[<fo>[,<vp>[,<pid>[,<dcs>]]]]
*
* Restarting takes effect after execution.
*/
int mbtk_sms_csmp_set(mbtk_info_handle_t* handle, char * csmp)
{
    printf("mbtk_sms_csmp_set() csmp:%s, len:%d",csmp, strlen(csmp));
    return info_item_process(handle, MBTK_INFO_ID_SMS_CSMP_REQ, csmp, strlen(csmp), NULL) ? handle->info_err : 0;
}

/*
* Set sms cscb.
*
* AT+CSCB=<[<mode>[,<mids>[,<dcss>]]]>
*
* Restarting takes effect after execution.
*/
int mbtk_sms_cscb_set(mbtk_info_handle_t* handle, char * cscb)
{
    printf("mbtk_sms_cscb_set() cscb:%s, len:%d",cscb, strlen(cscb));
    return info_item_process(handle, MBTK_INFO_ID_SMS_CSCB_REQ, cscb, strlen(cscb), NULL) ? handle->info_err : 0;
}

/*
* Set sms cnmi.
*
at+cnmi=1,2

OK
if sending fails:
+CMS ERROR: <err>
*/
int mbtk_sms_cnmi_set(mbtk_info_handle_t* handle)
{
    printf("mbtk_sms_cnmi_set()------------start\n");

    return info_item_process(handle, MBTK_INFO_ID_SMS_CNMI_REQ, NULL, 0, NULL)? handle->info_err : 0;
}

/*
* Set sms cmss.
*
+CMSS=<index>[,<da>[,<toda>]]

if sending successful:
+CMSS: <mr>
OK
if sending fails:
+CMS ERROR: <err>
*/
int mbtk_sms_cmss_set(mbtk_info_handle_t* handle, char * cmss, char *resp)
{
    printf("mbtk_sms_cmss_set()------------cmss:%s, len:%d", cmss, strlen(cmss));
    if( info_item_process(handle, MBTK_INFO_ID_SMS_CMSS_REQ, cmss, strlen(cmss), resp) > 0){
        printf("resp:%s\n", resp);
        return 0;
    }else{
        return handle->info_err;
    }
}

/*
* Return sms cmgf.
*/
int mbtk_sms_cpms_get(mbtk_info_handle_t* handle, char * mem)
{
    char req[128] = {0};
    if(info_item_process(handle, MBTK_INFO_ID_SMS_CPMS_REQ, NULL, 0, &req) > 0) {
        LOG("mbtk_sms_cpms_get()  req : %s, strlen(mem_ptr):%d\n", req, strlen(req));
        memcpy(mem, req, strlen(req));
        return 0;
    } else {
        return handle->info_err;
    }
}


/*
* Set sms cpms.
*
* AT+CPMS=<mem1>[,<mem2>[,<mem3>]]
*
* Restarting takes effect after execution.
*/
int mbtk_sms_cpms_set(mbtk_info_handle_t* handle, char * mem, char* response)
{
    printf("mbtk_sms_cpms_set() mem:%s, len:%d",mem, strlen(mem));
    char req[128] = {0};
    if( info_item_process(handle, MBTK_INFO_ID_SMS_CPMS_REQ, mem, strlen(mem), req) > 0){
        memcpy(response, req, strlen(req));
        return 0;
    }
    else{
        return handle->info_err;
    }
}

/*
* Set sms cm.
*
* +CMGR=<index>

if PDU mode (+CMGF=0) ��command successful:
+CMGR: <stat>,[<alpha>],<length><CR><LF><pdu>
OK
if text mode (+CMGF=1), command successful and SMS-DELIVER:
+CMGR:<stat>,<oa>,[<alpha>],<scts>[,<tooa>,<fo>,<pid>,<dcs
>, <sca>,<tosca>,<length>]<CR><LF><data>
OK
if text mode (+CMGF=1), command successful and SMS-SUBMIT:
+CMGR:
<stat>,<da>,[<alpha>][,<toda>,<fo>,<pid>,<dcs>,[<vp>],
<sca>,<tosca>,<length>]<CR><LF><data>
OK
otherwise:
+CMS ERROR: <err>
*
* Restarting takes effect after execution.
*/
int mbtk_sms_cmgr_set(mbtk_info_handle_t* handle, int index, char *resp)
{
    printf("mbtk_sms_cmgr_set() --------------index:%d",index);
    if( info_item_process(handle, MBTK_INFO_ID_SMS_CMGR_REQ, (uint8*)&index, sizeof(uint8), resp) > 0){
        printf("resp:%s\n", resp);
        return 0;
    }else{
        return handle->info_err;
    }
}


/*
* Get sim state.
*/
int mbtk_sim_state_get(mbtk_info_handle_t* handle, mbtk_sim_state_enum *sim_state)
{
    uint8 state;
    if(handle == NULL || sim_state == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_STATE_REQ, NULL, 0, &state) > 0) {
        *sim_state = (mbtk_sim_state_enum)state;
        LOG("Sim state : %d", *sim_state);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get sim card type.
*/
int mbtk_sim_card_type_get(mbtk_info_handle_t* handle, mbtk_sim_card_type_enum *sim_card_type)
{
    uint8 state;
    if(handle == NULL || sim_card_type == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_SIM_STYPE_REQ, NULL, 0, &state) > 0) {
        *sim_card_type = (mbtk_sim_card_type_enum)state;
        LOG("Sim sim_card_type : %d", *sim_card_type);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get system temperature.
*
* type[IN]:
*   0: Soc temperature.
*   1: RF temperature.
* temp[OUT]:
*   temperature in celsius.
*/
int mbtk_temp_get(mbtk_info_handle_t* handle, int type, mbtk_thermal_info_t* temp)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(type != 0 && type != 1)
    {
        return -1;
    }

    uint8 temp_type = (uint8)type;

    if(info_item_process(handle, MBTK_INFO_ID_DEV_TEMP_REQ, &temp_type, sizeof(uint8), temp) > 0) {

        LOG("Temperature : %d", temp->ther);
        return 0;
    } else {
        return handle->info_err;
    }

    return 0;
}


/*
* Set sim power state.
* power:
* 0: Sim power off.
* 1: Sim power on.
*/
int mbtk_sim_power_set(int power)
{
    if(power != 0 && power != 1)
    {
        return -1;
    }

    //  /sys/devices/virtual/usim_event/usim0/send_event
    char cmd[100] = {0};
    sprintf(cmd, "echo %d > /sys/devices/virtual/usim_event/usim0/send_event", power ? 0 : 1);
    mbtk_system(cmd);

    return 0;
}

/*
* System power.
* type:
* 0: Reboot system.
* 1: Poweroff system.
* 2: Halt system.
*/
int mbtk_system_reboot(int type)
{
    if(type != 0 && type != 1 && type != 2)
    {
        return -1;
    }

    switch(type) {
        case 0: {
            mbtk_system("reboot");
            break;
        }
        case 1: {
            mbtk_system("poweroff");
            break;
        }
        case 2: {
            mbtk_system("halt");
            break;
        }
        default: {
            break;
        }
    }

    return 0;
}

/*
*   set modem fun
*
*/
int mbtk_set_modem_fun(mbtk_info_handle_t* handle, mbtk_modem_info_t *info)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    return info_item_process(handle, MBTK_INFO_ID_DEV_MODEM_REQ, info, sizeof(mbtk_modem_info_t), NULL) ? handle->info_err : 0;
}

/*
*   get modem fun
*
*/
int mbtk_get_modem_fun(mbtk_info_handle_t* handle, int* fun)
{
    uint8 state;
    if(handle == NULL || fun == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_DEV_MODEM_REQ, NULL, 0, &state) > 0) {
        LOG("modem type : %d", state);
        *fun = state;
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* call_start
*
*/
int mbtk_call_start(mbtk_info_handle_t* handle, char* phone_number)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(str_empty(phone_number))
        return -1;

    return info_item_process(handle, MBTK_INFO_ID_CALL_START_REQ,
            phone_number, strlen(phone_number), NULL) ? handle->info_err : 0;
}
/*
* Answer the phone call.
*
*/
int mbtk_call_answer(mbtk_info_handle_t* handle)
{
    return info_item_process(handle, MBTK_INFO_ID_CALL_ANSWER_REQ, NULL, 0, NULL) ? handle->info_err : 0;
}

/*
* Hang up all call.
*
*/
int mbtk_call_hang(mbtk_info_handle_t* handle)
{
    return info_item_process(handle, MBTK_INFO_ID_CALL_HANGUP_REQ, NULL, 0, NULL) ? handle->info_err : 0;
}

/*
* Hang up a call.
*
*/
int mbtk_a_call_hang(mbtk_info_handle_t* handle, int phone_id)
{
    return info_item_process(handle, MBTK_INFO_ID_CALL_HANGUP_A_REQ, (uint8*)&phone_id, sizeof(uint8), NULL) ? handle->info_err : 0;
}

/*
* Hang up waiting or background call.
*
*/
int mbtk_waiting_or_background_call_hang(mbtk_info_handle_t* handle)
{
    return info_item_process(handle, MBTK_INFO_ID_CALL_HANGUP_B_REQ, NULL, 0, NULL) ? handle->info_err : 0;
}

/*
* Hang up foreground resume background call.
*
*/
int mbtk_foreground_resume_background_call_hang(mbtk_info_handle_t* handle)
{
    return info_item_process(handle, MBTK_INFO_ID_CALL_HANGUP_C_REQ, NULL, 0, NULL) ? handle->info_err : 0;
}

/*
* Get current call phone number.
*/
int mbtk_call_reg_get(mbtk_info_handle_t* handle, mbtk_call_info_t *reg)
{
    if(info_item_process(handle, MBTK_INFO_ID_CALL_WAITIN_REQ, NULL, 0, reg) > 0) {
        LOG("CLCC : %d, %d, %d, %d, %d, %s, %d", reg->dir1, reg->dir, reg->state, reg->mode, reg->mpty, reg->phone_number, reg->type);
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Return mute state.
*/
int mbtk_mute_state_get(mbtk_info_handle_t* handle, int *mute_state)
{
    uint8 state;
    if(info_item_process(handle, MBTK_INFO_ID_CALL_MUTE_REQ, NULL, 0, &state) > 0) {
        LOG("Mute State : %d", state);
        *mute_state = state;
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set mute state.
*
* mute_state:
* 0 : of mute.
* 1 : on mute.
*
* Restarting takes effect after execution.
*/
int mbtk_mute_state_set(mbtk_info_handle_t* handle, int mute_state)
{
    return info_item_process(handle, MBTK_INFO_ID_CALL_MUTE_REQ, (uint8*)&mute_state, sizeof(uint8), NULL) ? handle->info_err : 0;
}

/*
* Set wakeup state.
*
* wakeup_state:(0~31)
* 0 : means resume all
* 1~31 means suspend
* Control the active reporting of some platform modems to reduce wakeup
*/

int mbtk_wakeup_state_set(mbtk_info_handle_t* handle, uint32 wakeup_state)
{
    return info_item_process(handle, MBTK_INFO_ID_WAKEUP_STA_REQ, (uint32*)&wakeup_state, sizeof(uint32), NULL) ? handle->info_err : 0;
}

/*
* oos get.
*/
int mbtk_oos_get(mbtk_info_handle_t* handle, mbtk_oos_info *oos_info)
{
    if(info_item_process(handle, MBTK_INFO_ID_OOS_STA_REQ, NULL, 0, oos_info) > 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* oos set .
*/
int mbtk_oos_set(mbtk_info_handle_t* handle, mbtk_oos_info *oos_info)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    return info_item_process(handle, MBTK_INFO_ID_OOS_STA_REQ, oos_info, sizeof(mbtk_oos_info), NULL) ? handle->info_err : 0;
}


/*
* Set DTMF character.
*
*/
int mbtk_dtmf_send(mbtk_info_handle_t* handle, mbtk_call_dtmf_info_t *dtmf_character)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    return info_item_process(handle, MBTK_INFO_ID_CALL_DTMF_REQ,
            dtmf_character, sizeof(mbtk_call_dtmf_info_t), NULL) ? handle->info_err : 0;
}


/*
* Get CEER character.
*
*/
int mbtk_ceer_get(mbtk_info_handle_t* handle, void *ceer)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_CALL_CEER_REQ,NULL, 0, ceer) >= 0)
    {
        LOG("mbtk_ceer_get ceer:%s", ceer);
        return 0;
    }
    else 
    {   
        LOGE("mbtk_ceer_get error");
        return handle->info_err;
    }
}


/*
* Set net led.
*
*/
int mbtk_led_set(mbtk_info_handle_t* handle, mbtk_led_type type, mbtk_led_status status)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    char buff[3] = {0};
    if(type == MBTK_LED_TYPE_NET)
    {
        buff[0] = 0;
    }
    else
    {
        buff[0] = 1;
    }

    if(status == MBTK_LED_STATUS_CLOSE)
    {
        buff[1] = 0;
    }
    else
    {
        buff[1] = 1;
    }
    return info_item_process(handle, MBTK_INFO_ID_LED_REQ, buff, 2, NULL) ? handle->info_err : 0;
}


/*
* Set msd item.
*
*/
int mbtk_ecall_msd_item_set(mbtk_info_handle_t* handle, const mbtk_ecall_msd_cfg_info_t *msd_cfg)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(msd_cfg == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_MSDCFG_REQ, msd_cfg, sizeof(mbtk_ecall_msd_cfg_info_t), NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Generate msd after msd item set.
*
*/
int mbtk_ecall_msd_gen(mbtk_info_handle_t* handle)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_MSDGEN_REQ, NULL, 0, NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set ecall msd.
*
*/
int mbtk_ecall_msd_set(mbtk_info_handle_t* handle, const void* msd)
{
    if(handle == NULL || str_empty(msd))
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_MSD_REQ, msd, strlen(msd), NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get ecall msd.
*
*/
int mbtk_ecall_msd_get(mbtk_info_handle_t* handle, void* msd)
{
    if(!handle)
    {
        return -1;
    }

    if(msd == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_MSD_REQ, NULL, 0, msd) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}


/*
* Set ecall msd item.
*
*/
int mbtk_ecall_push(mbtk_info_handle_t* handle)
{
    if(!handle)
    {
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_PUSH_REQ, NULL, 0, NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set ecall only configs.
*
*/
int mbtk_ecall_only_set(mbtk_info_handle_t* handle, const mbtk_ecall_only_info_t* info)
{
    if(!handle)
    {
        return -1;
    }

    if(info == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_ONLY_REQ, info, sizeof(mbtk_ecall_only_info_t), NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get ecall only configs.
*
*/
int mbtk_ecall_only_get(mbtk_info_handle_t* handle, mbtk_ecall_only_info_t* info)
{
    if(!handle)
    {
        return -1;
    }

    if(info == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_ONLY_REQ, NULL, 0, info) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set ecall network reg.
*
*/
int mbtk_ecall_reg_set(mbtk_info_handle_t* handle, int reg)
{
    if(!handle)
    {
        return -1;
    }

    if(reg != 0 && reg != 1)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_REG_REQ, &reg, 1, NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Start ecall dial start.
*
*/
int mbtk_ecall_dial_start(mbtk_info_handle_t* handle, mbtk_ecall_dial_type_enum type)
{
    if(!handle)
    {
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_DIAL_REQ, &type, 1, NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get ecall dial state.
*
*/
int mbtk_ecall_dial_state_get(mbtk_info_handle_t* handle, mbtk_ecall_dial_type_enum* type)
{
    if(!handle)
    {
        return -1;
    }

    if(type == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    memset(type, 0, sizeof(mbtk_ecall_dial_type_enum));

    if(info_item_process(handle, RIL_MSG_ID_ECALL_DIAL_REQ, NULL, 0, type) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set ecall mode.
*
*/
int mbtk_ecall_mode_set(mbtk_info_handle_t* handle, mbtk_ecall_mode_type_enum mode)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_MODE_REQ, &mode, 1, NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get ecall mode.
*
*/
int mbtk_ecall_mode_get(mbtk_info_handle_t* handle, mbtk_ecall_mode_type_enum *mode)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(mode == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    memset(mode, 0, sizeof(mbtk_ecall_mode_type_enum));

    if(info_item_process(handle, RIL_MSG_ID_ECALL_MODE_REQ, NULL, 0, mode) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set ecall configs.
*
*/
int mbtk_ecall_cfg_set(mbtk_info_handle_t* handle, const mbtk_ecall_cfg_info_t *cfg)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(cfg == NULL || cfg->type == 0)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_CFG_REQ, cfg, sizeof(mbtk_ecall_cfg_info_t), NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get ecall configs.
*
*/
int mbtk_ecall_cfg_get(mbtk_info_handle_t* handle, mbtk_ecall_cfg_info_t* cfg)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(cfg == NULL || cfg->type == 0)
    {
        LOGE("ARG error.");
        return -1;
    }
    uint32 type = cfg->type;

    if(info_item_process(handle, RIL_MSG_ID_ECALL_CFG_REQ, &type, sizeof(uint32), cfg) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set ecall sms number.
*
*/
int mbtk_ecall_sms_number_set(mbtk_info_handle_t* handle, const void *number)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(str_empty(number))
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_SMS_NUM_REQ, number, strlen(number), NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Get ecall sms number.
*
*/
int mbtk_ecall_sms_number_get(mbtk_info_handle_t* handle, void *number)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(number == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_SMS_NUM_REQ, NULL, 0, number) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set ecall mute speaker.
*
*/
int mbtk_ecall_mute_spk_set(mbtk_info_handle_t* handle, int mute)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(mute != 0 && mute != 1)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_MUTESPK_REQ, &mute, 1, NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}

/*
* Set ecall dsp gain.
*
*/
int mbtk_ecall_dsp_gain_set(mbtk_info_handle_t* handle, const mbtk_ecall_gain_info_t *gain_info)
{
    if(handle == NULL)
    {
        return -1;
    }

    if(gain_info == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, RIL_MSG_ID_ECALL_DSP_GAIN_REQ, gain_info, sizeof(mbtk_ecall_gain_info_t), NULL) >= 0) {
        return 0;
    } else {
        return handle->info_err;
    }
}


/*
* Set pdp state change callback function.
*/
int mbtk_pdp_state_change_cb_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_IND_PDP_STATE_CHANGE, NULL, 0, NULL) < 0) {
        return handle->info_err;
    } else {
        handle->pdp_state_cb = cb;
        return 0;
    }
}

/*
* Set network state change callback function.
*/
int mbtk_net_state_change_cb_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_IND_NET_STATE_CHANGE, NULL, 0, NULL) < 0) {
        return handle->info_err;
    } else {
        handle->net_state_cb = cb;
        return 0;
    }
}

/*
* Set call state change callback function.
*/
int mbtk_call_state_change_cb_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_IND_CALL_STATE_CHANGE, NULL, 0, NULL) < 0) {
        return handle->info_err;
    } else {
        handle->call_state_cb = cb;
        return 0;
    }
}

/*
* Set sms state change callback function.
*/
int mbtk_sms_state_change_cb_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_IND_SMS_STATE_CHANGE, NULL, 0, NULL) < 0) {
        return handle->info_err;
    } else {
        handle->sms_state_cb = cb;
        return 0;
    }
}

/*
* Set radio state change callback function.
*/
int mbtk_radio_state_change_cb_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_IND_RADIO_STATE_CHANGE, NULL, 0, NULL) < 0) {
        return handle->info_err;
    } else {
        handle->radio_state_cb = cb;
        return 0;
    }
}

/*
* Set sim state change callback function.
*/
int mbtk_sim_state_change_cb_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_IND_SIM_STATE_CHANGE, NULL, 0, NULL) < 0) {
        return handle->info_err;
    } else {
        handle->sim_state_cb = cb;
        return 0;
    }
}

/*
* Set signal state change callback function.
*/
int mbtk_signal_state_change_cb_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_IND_SIGNAL_STATE_CHANGE, NULL, 0, NULL) < 0) {
        return handle->info_err;
    } else {
        handle->signal_state_cb = cb;
        return 0;
    }
}

/*
* Set ril server state change callback function.
*/
int mbtk_ril_server_state_change_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    ril_server_state_cb = cb;
    return 0;
}

int mbtk_ecall_state_change_cb_reg(mbtk_info_handle_t* handle, mbtk_info_callback_func cb)
{
    if(handle == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
    if(info_item_process(handle, MBTK_INFO_ID_IND_ECALL_STATE_CHANGE, NULL, 0, NULL) < 0) {
        return handle->info_err;
    } else {
        handle->ecall_state_cb = cb;
        return 0;
    }
}


int mbtk_get_modem_version(mbtk_info_handle_t* handle, void *modem_version)
{
    if(handle == NULL || modem_version == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }

    if(info_item_process(handle, MBTK_INFO_ID_DEV_MD_VERSION_REQ, NULL, 0, modem_version) > 0) {
        LOG("Version : %s", modem_version);
        return 0;
    } else {
        return handle->info_err;
    }
}


