/*
*
* Data : 2022/11/1 18:27:39
* Author : LiuBin
*/
#ifndef _info_data_H
#define _info_data_H
#include "mbtk_type.h"
#include "mbtk_list.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"

#define SOCK_CLIENT_MAX 100
#define EPOLL_LISTEN_MAX 100
#define IND_REGISTER_MAX 10
#define PACK_PROCESS_QUEUE_MAX 20

#define MBTK_APN_PROP "persist.mbtk.apn"

typedef struct
{
    int fd;

    uint32 ind_num;
    uint16 ind_register[IND_REGISTER_MAX];
} sock_client_info_t;

typedef struct
{
    sock_client_info_t *cli_info;
    void* pack;
} info_queue_item_t;

typedef struct
{
    int cid;

    bool ipv4_valid;
    uint8 ipv4[20];
    bool ipv6_valid;
    uint8 ipv6[50];
} info_apn_ip_t;

typedef enum {
    INFO_URC_MSG_RADIO_STATE,
    INFO_URC_MSG_CGEV,
    INFO_URC_MSG_NET_CS_REG_STATE,
    INFO_URC_MSG_NET_PS_REG_STATE,
    INFO_URC_MSG_CALL_STATE,
    INFO_URC_MSG_SIM_STATE,
    INFO_URC_MSG_PDP_STATE,
    INFO_URC_MSG_SMS_STATE,
    INFO_URC_MSG_SET_BAND,
    INFO_URC_MSG_GET_SIM_STATE,     //check sim status
    INFO_URC_MSG_NET_STATE_LOG      // Save Network state into file.
} info_urc_msg_id_enum;

typedef struct {
    info_urc_msg_id_enum msg;

    void *data;
    int data_len;
} info_urc_msg_t;

int mbtk_get_apn_send_pack(void);
#endif /* _info_data_H */
