/*
*    mbtk_audio_gain.c
*
*    MBTK audio gain for nvm : /NVM/audio_gain.nvm.
*
*/
/******************************************************************************

                          EDIT HISTORY FOR FILE

  WHEN        WHO       WHAT,WHERE,WHY
--------    --------    -------------------------------------------------------
2024/3/1     LiuBin      Initial version

******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <cutils/properties.h>

#include "mbtk_log.h"
#include "mbtk_str.h"
#include "mbtk_audio_gain.h"

void vcm_config_dspgain(unsigned int type, unsigned int gain);

int mbtk_dsp_gain_set(CONFIG_DSPGAIN_Direction dir, int gain)
{
    if((gain < MBTK_AUDIO_GAIN_MIN || gain > MBTK_AUDIO_GAIN_MAX)
        && gain != CONFIG_DSPGAIN_MUTE_ON && gain != CONFIG_DSPGAIN_MUTE_OFF) {
        LOGE("DSP gain range: %d - %d or %d or %d", MBTK_AUDIO_GAIN_MIN, MBTK_AUDIO_GAIN_MAX,
            CONFIG_DSPGAIN_MUTE_ON, CONFIG_DSPGAIN_MUTE_OFF);
        return -1;
    }

    int fd = open(MBTK_AUDIO_GAIN_PATH, O_RDWR);
    if(fd < 0) {
        LOGE("Open file(%s) fail:%d", MBTK_AUDIO_GAIN_PATH, errno);
        return -1;
    }

    if( -1 == lseek(fd, MBTK_AUDIO_GAIN_ADD_START, SEEK_SET)) {
        LOGE("lseek(%d) fail:%d", MBTK_AUDIO_GAIN_ADD_START, errno);
        goto fail;
    }

    ACMCodec_GainT gains[VC_HEAD_NUM];
    int len;
    memset(gains, 0x0, sizeof(gains));
    if((len = read(fd, gains, sizeof(gains))) != sizeof(gains)) {
        LOGE("read(%d/%d) fail:%d", len, sizeof(gains), errno);
        goto fail;
    }

    int i = 0;
    while(i < VC_HEAD_NUM) {
        if(dir == CONFIG_DSPGAIN_RX) {
            gains[i].Rx_DSPGain[AUDIOHAL_SPK_VOL_QTY] = (int16)(gain & 0xFFFF);
        } else if(dir == CONFIG_DSPGAIN_TX) {
            gains[i].Tx_DSPGain = (int16)(gain & 0xFFFF);
        }/* else if(dir == CONFIG_DSPGAIN_SIDETONE) {
            gains[i].Rx_DSPSideToneGain = gain;
        }*/ else {
            LOGE("Unknown direction : %d", dir);
            goto fail;
        }
        i++;
    }

    if( -1 == lseek(fd, MBTK_AUDIO_GAIN_ADD_START, SEEK_SET)) {
        LOGE("lseek(%d) fail:%d", MBTK_AUDIO_GAIN_ADD_START, errno);
        goto fail;
    }

    if(write(fd, gains, sizeof(gains)) != sizeof(gains)) {
        LOGE("write(%d) fail:%d", sizeof(gains), errno);
        goto fail;
    }

    if(fsync(fd)) {
        LOGE("fsync(%d) fail:%d", fd, errno);
        goto fail;
    }

    close(fd);

    LOGD("DSP gain NVM update success.");

    char buff[10];
    memset(buff, 0, 10);
    snprintf(buff, 10, "%d", gain);
    if(dir == CONFIG_DSPGAIN_RX) {
        if(property_set("persist.mbtk.dsp_rx_gain", buff) == 0) {
            // Set gain to DSP.
            vcm_config_dspgain(dir, gain);
        }
    } else if(dir == CONFIG_DSPGAIN_TX) {
        if(property_set("persist.mbtk.dsp_tx_gain", buff) == 0) {
            // Set gain to DSP.
            vcm_config_dspgain(dir, gain);
        }
    }else {
        LOGE("Unknown direction : %d", dir);
        goto fail;
    }

    return 0;

fail:
    close(fd);
    return -1;
}

int mbtk_dsp_gain_get(int *rx_gain, int *tx_gain)
{
    if(rx_gain == NULL || tx_gain == NULL) {
        LOGE("gain is NULL.");
        return -1;
    }

    int fd = open(MBTK_AUDIO_GAIN_PATH, O_RDONLY);
    if(fd < 0) {
        LOGE("Open file(%s) fail:%d", MBTK_AUDIO_GAIN_PATH, errno);
        return -1;
    }

    if( -1 == lseek(fd, MBTK_AUDIO_GAIN_ADD_START, SEEK_SET)) {
        LOGE("lseek(%d) fail:%d", MBTK_AUDIO_GAIN_ADD_START, errno);
        goto fail;
    }

    ACMCodec_GainT gains[VC_HEAD_NUM];
    int len;
    memset(gains, 0x0, sizeof(gains));
    if((len = read(fd, gains, sizeof(gains))) != sizeof(gains)) {
        LOGE("read(%d/%d) fail:%d", len, sizeof(gains), errno);
        goto fail;
    }

    close(fd);

    *rx_gain = gains[VC_HANDSFREE].Rx_DSPGain[AUDIOHAL_SPK_VOL_QTY];
    *tx_gain = gains[VC_HANDSFREE].Tx_DSPGain;
    return 0;
fail:
    close(fd);
    return -1;
}




