#if 1
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>  
#include <fcntl.h> 
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <sys/epoll.h>
#include <time.h>
#include <arpa/inet.h>

#include "mbtk_log.h"
#include "mbtk_utils.h"
#include "mbtk_led_control.h"


#define LED_SOCK_PATH  "/tmp/mbtk_led_sock"

static int led_cli_fd = -1;

int mbtk_led_contril_init()
{
    if(led_cli_fd > 0) {
        LOGW("led_contril client has inited.");
        return 0;
    }

    led_cli_fd = socket(AF_LOCAL, SOCK_STREAM, 0);
    if(led_cli_fd < 0)
    {
        LOGE("socket() fail[%d].", errno);
        goto error;
    }

    struct sockaddr_un cli_addr;
    memset(&cli_addr, 0, sizeof(cli_addr));
    cli_addr.sun_family = AF_LOCAL;
    strcpy(cli_addr.sun_path, LED_SOCK_PATH);
    if(connect(led_cli_fd, (struct sockaddr *)&cli_addr, sizeof(cli_addr)))
    {
        LOGE("connect() fail[%d].", errno);
        goto error;
    }

    return 0;
error:
    if(led_cli_fd > 0) {
        close(led_cli_fd);
        led_cli_fd = -1;
    }

    return -1;
}

int mbtk_led_send(char *data)
{  
    int ret = mbtk_led_contril_init();
    if (ret == -1)
    {
        LOGE("mbtk_led_contril_init error");
        return -1;
    }
    //LOGI("data %s",data);
    mbtk_write(led_cli_fd, data, strlen(data)+1);

    return 0;
}

int mbtk_led_set(led_info_s led_info)
{
    char resp_buf[4];
    int type,status,ret;
    
    memset(resp_buf,0,4);
    type = led_info.led_type;
    status = led_info.status;
    sprintf(resp_buf, "%d,%d",type,status);
    ret = mbtk_led_send(resp_buf);
    if (ret)
    {
        LOGE("[led]mbtk_led_set error");
    }

    return ret;
}

#endif


