#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <mbtk_str.h>

/*
* Converts all of the characters in this String to lower.
*
* Parameters:
*   src - The string should be converted.
*   dest  - The lowercase string.
*   len - The length of result string.Must be "strlen(src) + 1"
* Returns:
*   The string, converted to lowercase,or NULL for fail.
*/
void*
str_tolower
(
    const void *src,
    void *dest,
    size_t len
)
{
    const char *s = (char*)src;
    char *d = (char*)dest;
    if(!s
        || !d
        || (strlen(d) + 1 > len)){
        return NULL;
    }

    char* temp = d;
    while(*s){
        *temp++ = tolower(*s++);
    }
    *temp = '\0';

    return dest;
}

/*
* Converts all of the characters in this String to upper case.
*
* Parameters:
*   src - The string should be converted.
*   dest  - The uppercase string.
*   len - The length of result string.Must be "strlen(str_ptr) + 1"
* Returns:
*   The string, converted to uppercase.or NULL for fail.
*/
void*
str_toupper
(
    const void *src,
    void *dest,
    size_t len
)
{
    const char *s = (char*)src;
    char *d = (char*)dest;
    if(!s
        || !d
        || (strlen(d) + 1 > len)){
        return NULL;
    }
    char* temp = d;
    while(*s){
        *temp++ = toupper(*s++);
    }
    *temp = '\0';
    return dest;
}

/*
* Remove the head and tail spaces.
*/
void*
str_trim
(
    const void* str,
    void *result,
    size_t len
)
{
    if(str == NULL || result == NULL
        || len <= strlen((char*)str))
    {
        return NULL;
    }

    char* str_ptr = (char*)str;
    while(*str_ptr && (*str_ptr == ' ' || *str_ptr == '\t' || *str_ptr == '\n' || *str_ptr == '\r')){
        str_ptr++;
    }

    memset(result,0x0,len);
    if(*str_ptr && strlen(str_ptr) > 0)
    {
        memset(result,0x0,len);
        memcpy(result,str_ptr,strlen(str_ptr));
        str_ptr = (char*)result + strlen((char*)result) - 1;
        while(*str_ptr && (*str_ptr == ' ' || *str_ptr == '\t' || *str_ptr == '\n' || *str_ptr == '\r')){
            *str_ptr = '\0';
            str_ptr--;
        }
    }

    return result;
}

/*
* Returns true if and only if this string contains the specified sequence of char values.
*
* Parameters:
*   str   -   The substring to search from.
*   sub_str - The substring to search for.
* Returns:
*   True if str contains sub_str, false otherwise.
*/
bool
str_contains
(
    const void* str,
    const void* sub_str
)
{
    const char *s = (char*)str;
    const char *s_sub = (char*)sub_str;

    if(!s || !s_sub){
        return FALSE;
    }

    return str_indexof(s,s_sub)==-1?FALSE:TRUE;
}

/*
* Returns the index within this string of the first occurrence of the specified substring.
* If no such substring, then -1 is returned.
*
* Parameters:
*   str   -   The substring to search from.
*   sub_str - The substring to search for.
* Returns:
*   The index of the first occurrence of the specified substring,
*   or -1 if there is no such occurrence.
*/
ssize_t
str_indexof
(
    const void* str,
    const void* sub_str
)
{
    const char *s = (char*)str;
    const char *s_sub = (char*)sub_str;

    if(!s || !s_sub){
            return -1;
    }
    char* position = strstr(s,s_sub);
    if(!position){
        return -1;
    }else{
        return position - s;
    }
}

/*
* Returns a new string that is a substring of this string. The substring begins
* at the specified beginIndex and extends to the character at index endIndex - 1.
* Thus the length of the substring is endIndex-beginIndex.
*
* Examples:
*   "hamburger".substring(4, 8) returns "urge"
*   "smiles".substring(1, 5) returns "mile"
*
* Parameters:
*   begin_index     The beginning index, inclusive.
*   end_index       The ending index, exclusive.
* Returns:
*   The specified substring or NULL.
*/
void*
str_substring
(
    const void* str,
    size_t begin_index,
    size_t end_index,
    void *sub_str,
    size_t len
)
{
    const char* s = (char*)str;
    char *result = (char*)sub_str;
    if(!s
        || !result
        || begin_index >= end_index
        || begin_index >= strlen(s)
        || end_index - begin_index + 1 > len){
        return NULL;
    }

    if(end_index > strlen(s)){
        end_index = strlen(s);
    }

    memcpy(result,s + begin_index,end_index - begin_index);
    result[end_index - begin_index] = '\0';

    return result;
}

bool str_startwith(const char* str, const void* prefix)
{
    if (!str || !(char*) prefix) {
        return FALSE;
    }
    if (strlen((char*) str) < strlen((char*) prefix)) {
        return FALSE;
    }
    return str_indexof(str, (char*) prefix) ? FALSE : TRUE;
}

void* strstr_hex(char *haystack,int haystack_len,
                const char *needle,int needle_len)
{
    int index = 0;
    if(haystack_len < needle_len)
        return NULL;

    while(index <= haystack_len - needle_len) {
        if(!memcmp(haystack + index,needle,needle_len)){
            return haystack + index;
        }
        index++;
    }

    return NULL;
}

bool str_empty(const void *str)
{
    if (str && strlen((char*)str) > 0)
        return false;

    return true;
}

