/**
 *   \file mbtk_adc.c
 *   \brief A Documented file.
 *
 *  Detailed description
 *   \Author:  js.wang <js.wang@mobiletek.cn>
 *   \Version: 1.0.0
 *   \Date: 2022-04-22
 */
#include <fcntl.h>
#include <stdint.h>
#include <limits.h>
#include <termios.h>
#include <stdarg.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/types.h>
#include "mbtk_log.h"
#include "mbtk_type.h"
#include "mbtk_adc.h"

#define ADC_DEVICE_802 "/sys/devices/soc.0/d4000000.apb/pxa2xx-i2c.2/i2c-2/2-0030/pm802-bat/adc"
#define ADC_DEVICE_803 "/sys/kernel/debug/adc"
#define ADC_DEVICE_PMIC802 "/sys/devices/platform/asr-adc/pm80x_adc"
#define ADC_DEVICE_AUX "/sys/devices/platform/asr-adc/aux_adc"

int mbtk_adc_close(void)
{
    int ret = 0;
    int fd = 0;
    char adc = '3';
    //system("echo 3 > /sys/kernel/debug/adc");
    if(!access(ADC_DEVICE_803, R_OK))
    {
        //LOGI("DEV:%s", ADC_DEVICE_803);
        fd = open(ADC_DEVICE_803, O_RDWR|O_CREAT|O_TRUNC, 0644);
    }
    else
    {
        LOGE("No found ADC devices.");
        return -1;
    }

    if(fd < 0) {
        LOGE("[%s]  file open error\n", __FUNCTION__);
        return -2;
    }
    ret = write(fd, &adc, 1);
    if (ret < 0) {
        LOGE("%s: error writing to file!\n", __FUNCTION__);
        close(fd);
        return -2;
    }
    close(fd);
    return 0;
}

int mbtk_adc_get(mbtk_adc_enum channle)
{
    int ret = 0;
    int fd = 0;
    char adc_buf[24] = {0};
    char *adc_value = NULL;
    char adc =(channle == MBTK_ADC0 ? '0' : (channle == MBTK_ADC1 ? '1' : '2'));

#if defined(MBTK_PROJECT_L508_X6)
    switch(channle)
    {
        case MBTK_ADC0:
        case MBTK_ADC1:
        {
            if(!access(ADC_DEVICE_PMIC802, R_OK))
            {
                LOGI("[adc] DEV:%s", ADC_DEVICE_PMIC802);
                fd = open(ADC_DEVICE_PMIC802, O_RDWR|O_CREAT|O_TRUNC, 0644);
            }
            else
            {
                LOGE("No found ADC devices.");
                return -1;
            }
            break;
        }
        case MBTK_ADC2:
        {
            if(!access(ADC_DEVICE_AUX, R_OK))
            {
                LOGI("[adc] DEV:%s", ADC_DEVICE_AUX);
                fd = open(ADC_DEVICE_AUX, O_RDWR|O_CREAT|O_TRUNC, 0644);
            }
            else
            {
                LOGE("No found ADC devices.");
                return -1;
            }
            break;
        }
        default:
        {
            LOGE("channle is error.");
            return -1;
        }
    }
#elif defined(MBTK_PROJECT_T108)
    if(!access(ADC_DEVICE_AUX, R_OK))
    {
        LOGI("[adc] DEV:%s", ADC_DEVICE_AUX);
        fd = open(ADC_DEVICE_AUX, O_RDWR|O_CREAT|O_TRUNC, 0644);
    }
    else
    {
        LOGE("No found ADC devices.");
        return -1;
    }
#else
#if 0
    if(!access(ADC_DEVICE_802, R_OK)) {
        //LOGI("DEV:%s", ADC_DEVICE_802);
        fd = open(ADC_DEVICE_802, O_RDWR|O_CREAT|O_TRUNC, 0644);
    } else {
        if(!access(ADC_DEVICE_803, R_OK)) {
            //LOGI("DEV:%s", ADC_DEVICE_803);
            fd = open(ADC_DEVICE_803, O_RDWR|O_CREAT|O_TRUNC, 0644);
        } else {
            LOGE("No found ADC devices.");
            return -1;
        }
    }
#endif
    if(!access(ADC_DEVICE_PMIC802, R_OK))
    {
            //LOGI("DEV:%s", ADC_DEVICE_803);
            fd = open(ADC_DEVICE_PMIC802, O_RDWR|O_CREAT|O_TRUNC, 0644);
    }
    else
    {
            LOGE("No found ADC devices.");
            return -1;
    }
#endif

    if(fd < 0) {
        LOGE("[%s]  file open error\n", __FUNCTION__);
        return -2;
    }
    ret = write(fd, &adc, 1);
    if (ret < 0) {
        LOGE("%s: error writing to file!\n", __FUNCTION__);
        close(fd);
        return -2;
    }
    ret = read(fd, adc_buf, 24);
    if (ret < 0) {
        LOGE("%s: error writing to file!\n", __FUNCTION__);
        close(fd);
        return -2;
    }else{
        //LOGI("%s %d adc:%s\n", __FUNCTION__, __LINE__, adc_buf);
        adc_value = strstr(adc_buf, "channel");
    }
    close(fd);
    if(adc_value)
    {
        //LOGI("%s adc: %s\n", __FUNCTION__, adc_value);
    }
    else
        return -2;

    return atoi(&adc_value[9]);
}
