#if 1
#include <fcntl.h>
#include <stdint.h>
#include <libubox/blobmsg_json.h>
#include <libubus.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <pthread.h>
#include <sys/epoll.h>

#include "mbtk_power.h"
/****************************DEFINE***************************************/
#define MBTK_POWER_RESULT_FAIL -1
#define MBTK_POWER_RESULT_SUCCESS 0


#define MBTK_POWER_CLOSE_FAIL -1
#define MBTK_POWER_CLOSE_SUCCESS 0

#define GNSS_SOCK_PATH "/tmp/mbtk_gnss_sock"

static int sock_listen_fd = -1;

typedef enum {
    GNSS_CMD_INIT = 0,
    GNSS_CMD_DEINIT,
    GNSS_CMD_SETTING,
    GNSS_CMD_DL
} gnss_cmd_enum;


/****************************DEFINE***************************************/

/****************************VARIABLE***************************************/
const struct blobmsg_policy mbtk_power_cb_policy1[] = {
    [0] = {
        .name = "event",
        .type = BLOBMSG_TYPE_INT32,
    },
};
/****************************VARIABLE***************************************/

/****************************FUNC***************************************/
static void mbtk_power_gnss_callback(struct ubus_request *req, int type, struct blob_attr *msg)
{
    UNUSED(type);

    struct blob_attr *tb[1];
    struct blob_attr *cur;
    unsigned int event;
    int *ubus_gnss_result = (int *)req->priv;
    int rc;

    /*parsing blob to be accessed easily with tb array - parse "1" argument*/
    rc = blobmsg_parse(mbtk_power_cb_policy1, 1, tb, blob_data(msg), blob_len(msg));
    if (rc < 0)
    {
        LOGE("[MBTK_POWER] blobmsg_parse fail.");
        //printf("blobmsg_parse fail\n");
        *ubus_gnss_result = MBTK_POWER_CLOSE_FAIL;
        return;
    }

    /*parse first parameter*/
    cur = tb[0];
    if (!cur)
    {
        LOGE("[MBTK_POWER] missing parameter.");
        //printf("missing parameter\n");
        *ubus_gnss_result = MBTK_POWER_CLOSE_FAIL;
        return;
    }

    event = blobmsg_get_u32(cur);
    LOGE("[MBTK_POWER] get event = [%d].", event);
    //printf("get event = [%d].\n", event);

#if 1
    if(event != 0)
#else
    if(event != 7)
#endif
    {
        *ubus_gnss_result = MBTK_POWER_CLOSE_FAIL;
    }

    return ;
}

static int mbtk_power_ubus_uloop_init(struct ubus_context **ctx)
{
    int ret = -1;
    if(ctx == NULL)
    {
        LOGE("[MBTK_POWER] ctx is NULL");
        return MBTK_POWER_RESULT_FAIL;
    }
    
    ret = uloop_init();
    if(ret != 0)
    {
        LOGE("[MBTK_POWER] uloop_init fail.ret = [%d]", ret);
        return MBTK_POWER_RESULT_FAIL;
    }

    if(*ctx != NULL)
    {
        LOGE("[MBTK_POWER] mbtk_gnss_ctx not NULL.");
        return MBTK_POWER_RESULT_FAIL;
    }

    *ctx = ubus_connect(NULL);
    if( !(*ctx) )
    {
        LOGE("[MBTK_POWER] ubus_connect fail.");
        return MBTK_POWER_RESULT_FAIL;
    }

    ubus_add_uloop(*ctx);

    return MBTK_POWER_RESULT_SUCCESS;
}

static int mbtk_power_ubus_uloop_deinit(struct ubus_context *ctx)
{
    if(ctx != NULL)
    {
        ubus_free(ctx);
        ctx = NULL;
    }

    uloop_done();

    return MBTK_POWER_RESULT_SUCCESS;
}

static int mbtk_power_invoke_reply_data_cb(const char *service, const char *method, struct blob_attr *msg,
                         ubus_data_handler_t cb, void *cb_param, int timeout, struct ubus_context *ctx)
{
	int rc = -1;
	uint32_t id;
	struct ubus_request req;

	/* Look up the target object id by the object path */
    rc = ubus_lookup_id(ctx, service, &id);
	if(rc)
    {
        LOGE("[MBTK_POWER] ubus_lookup_id fail.rc = [%d]", rc);
		return MBTK_POWER_RESULT_FAIL;
    }

	rc = ubus_invoke(ctx, id, method, msg, cb, cb_param, timeout);
    if(rc)
    {
        LOGE("[MBTK_POWER] ubus_invoke fail.rc = [%d]", rc);
		return MBTK_POWER_RESULT_FAIL;
    }
	return MBTK_POWER_RESULT_SUCCESS;
}

                 //mbtk wyq for AT+MGPSC add start
                 
#if 0//#ifndef MBTK_GNSS_FACTORY_TEST_MODE
                 if(strncasecmp((char const *)line, "AT+MGPSC=", strlen("AT+MGPSC=")) == 0)
                 {
                     int mode,ret = 0;
                     (void)sscanf((const char *)line, "%*[^0-9]%d", &mode);
                     if(mode == 1 || mode == 5)
                     {
                         if(modem_if.echo_mode == MODEM_ECHO_MODE)
                         {
                             writen(ppp_uart2_fd, line, 10);
                         }

                         ret = mbtk_GPS_process(GNSS_CMD_INIT, &mode);
                         
                         if(-1 == ret)
                         {
                             const char RESP_BUFF[] = "\r\n+GPS: gps server timeout.\r\n\r\nERROR\r\n";
                             writen(ppp_uart2_fd, RESP_BUFF, sizeof(RESP_BUFF) - 1);
                         }
                         else
                         {
                             const char RESP_BUFF[] = "\r\n+GPS: gps init success\r\n";
                             writen(ppp_uart2_fd, RESP_BUFF, sizeof(RESP_BUFF) - 1);
                         }
                         continue;
                     }
                 }
#endif
                 //mbtk wyq for AT+MGPSC add end

 static int mbtk_GPS_process(gnss_cmd_enum cmd, void *arg)
 {
     if(sock_listen_fd < 0) {
         sock_listen_fd = socket(AF_LOCAL, SOCK_STREAM, 0);
         if(sock_listen_fd < 0)
         {
             LOGE("[MBTK_POWER]socket() fail[%d].", errno);
             return -1;
         }
 
         struct sockaddr_un cli_addr;
         memset(&cli_addr, 0, sizeof(cli_addr));
         cli_addr.sun_family = AF_LOCAL;
         strcpy(cli_addr.sun_path, GNSS_SOCK_PATH);
         if(connect(sock_listen_fd, (struct sockaddr *)&cli_addr, sizeof(cli_addr)))
         {
             LOGE("[MBTK_POWER]connect() fail[%d].", errno);
             close(sock_listen_fd);
             sock_listen_fd = -1;
             return -1;
         }
     }

     char buff[100] = {0};
     if(cmd == GNSS_CMD_INIT) {
         if(arg) {
             sprintf(buff, "gnss_init:%d", *(int*)arg);
         } else {
             return -1;
         }
     } else if(cmd == GNSS_CMD_DEINIT) {
         sprintf(buff, "gnss_deinit");
     } else if(cmd == GNSS_CMD_SETTING) {
         sprintf(buff, "gnss_setting:%s", arg);
     } else if(cmd == GNSS_CMD_DL) {
         sprintf(buff, "gnss_dl:%s", arg);
     } else {
         LOGE("[MBTK_POWER]Unknown cmd.");
         return -1;
     }
 
     write(sock_listen_fd, buff, strlen(buff));
 
     int len = 0;
     while(1) {
         memset(buff, 0, sizeof(buff));
         len = read(sock_listen_fd, buff, sizeof(buff));
         if(len > 0) {
             LOGE("[MBTK_POWER]RSP : %s", buff);
             if(cmd == GNSS_CMD_INIT) {
                 if(strstr(buff, "gnss_init") != 0) {
                     return 0;
                 } else {
                     LOGE("[MBTK_POWER]gnss_init response error.");
                     return -1;
                 }
             } else if(cmd == GNSS_CMD_DEINIT) {
                 if(strstr(buff, "gnss_deinit") != 0) {
                     return 0;
                 } else {
                     LOGE("[MBTK_POWER]gnss_deinit response error.");
                     return -1;
                 }
             } else if(cmd == GNSS_CMD_SETTING) {
                 if(strstr(buff, "gnss_setting") != 0) {
                     return 0;
                 } else {
                     LOGE("[MBTK_POWER]gnss_setting response error.");
                     return -1;
                 }
             } else if(cmd == GNSS_CMD_DL) {
                 if(strstr(buff, "gnss_dl") != 0) {
                     return 0;
                 } else {
                     LOGE("[MBTK_POWER]gnss_dl response error.");
                     return -1;
                 }
             } else {
                 LOGE("[MBTK_POWER]Unknown response.\n");
                 return -1;
             }
         } else if(len == 0) {
             LOGE("[MBTK_POWER]RSP is null.");
             return -1;
         } else {
             LOGE("[MBTK_POWER]read = %d:errno = %d", len, errno);
         }
     }
 }
 

 int mbtk_mgpsc_set(int arg)
 {
    int ret = 0;
    int *p = 3;

    if (arg == 1)
    {
        ret = mbtk_GPS_process(GNSS_CMD_INIT, &p);
        
        if (-1 == ret)
        {
            LOGE("[MBTK_POWER] mbtk_mgpsc_set fail.");
            return -1;
        }
    }
    else
    {
        ret = mbtk_GPS_process(GNSS_CMD_DEINIT, NULL);
        
        if (-1 == ret)
        {
            LOGE("[MBTK_POWER] mbtk_mgpsc_set fail.");
            return -1;
        }
    }

    return 0;
 }



static int mbtk_power_gnss_close(void)
{
    int ret = 0;

    ret = mbtk_GPS_process(GNSS_CMD_DEINIT, NULL);
   
    if (-1 == ret)
    {
        LOGE("[MBTK_POWER] mbtk_power_gnss_close fail.");
        return MBTK_POWER_CLOSE_FAIL;
    }

    return MBTK_POWER_CLOSE_SUCCESS;
}

static int gpio_direct_set(char *value,int gpio)
{
    char buffer[50]= {0};
    int file =-1;
    int result =-1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    file = open(buffer, O_WRONLY);
    if(file == -1)
    {
        LOGE("[MBTK_POWER] Open gpio[%d] direct fail.", gpio);
        return MBTK_POWER_RESULT_FAIL;
    }

    result = write(file,value,strlen(value));
    if(result != strlen(value))
    {
        LOGE("[MBTK_POWER] Set gpio[%d] direct fail.", gpio);
        close(file);
        return MBTK_POWER_RESULT_FAIL;
    }
    close(file);

    return MBTK_POWER_RESULT_SUCCESS;
}

static int gpio_value_set(int value, int gpio)
{
    char buffer[50]= {0};
    int file =-1;
    int result =-1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/value", gpio);
    file = open(buffer,O_WRONLY);
    if(file == -1)
    {
        LOGE("[MBTK_POWER] Open gpio[%d] value fail.", gpio);
        return MBTK_POWER_RESULT_FAIL;
    }
    if(value == 0) {
        result = write(file,"0",1);
    } else {
        result = write(file,"1",1);
    }
    if(result != 1)
    {
        LOGE("[MBTK_POWER] Set gpio[%d] value fail.", gpio);
        close(file);
        return MBTK_POWER_RESULT_FAIL;
    }
    close(file);

    return MBTK_POWER_RESULT_SUCCESS;
}

//type:0 value 0
//type:1 value 1
//type:2 direction "out"
//type:3 direction "in"

static int one_gpio_export(int gpio, int type)
{
    int index=0;
    int file=-1;
    int file1=-1;
    int result =-1;
    char pin_index_buffer[5]= {0};
    char buffer[50]= {0};
    int ret =0;

    file = open("/sys/class/gpio/export",O_WRONLY);
    if(file == -1)
    {
        LOGE("[MBTK_POWER] Open gpio export file fail.");
        return MBTK_POWER_RESULT_FAIL;
    }

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d", gpio);
    file1 = open(buffer,O_RDONLY);
    if(file1 != -1)
    {
        //file is created
        close(file1);
    }
    else
    { // create gpio
        memset(pin_index_buffer,0,5);
        sprintf(pin_index_buffer,"%d",gpio);
        result = write(file,pin_index_buffer,strlen(pin_index_buffer));
        if(result < 0)
        {
            LOGE("[MBTK_POWER] Gpio[%d] export fail.", gpio);
            return MBTK_POWER_RESULT_FAIL;
        }
    }

    close(file);


    switch(type)
    {
        case 0 :
        {
            ret = gpio_value_set(0, gpio);
            break;
        }
        case 1:
        {
            ret = gpio_value_set(1, gpio);
            break;
        }
        case 2:
        {
            ret = gpio_direct_set("out", gpio);
            break;
        }
        case 3:
        {
            ret = gpio_direct_set("in", gpio);
            break;
        }
        default:
        {
            break;
        }
    }


    return ret;
}

/****************************FUNC***************************************/

/****************************API***************************************/
#if defined(MBTK_PROJECT_T108)
int mbtk_system_sleep(void)
{
    int ubus_ret = 0;
    
    ubus_ret = mbtk_power_gnss_close();
    if(ubus_ret < 0)
    {
        LOGE("[MBTK_POWER] mbtk_power_gnss_close() fail.");
        return MBTK_POWER_RESULT_GNSS_CLOSE_FAIL;
    }

    // echo off > /sys/devices/mbtk-dev-op.10/gps_power && echo mem > /sys/power/autosleep
    // echo 1 > /sys/devices/asr-rfkill.0/pwr_ctrl && sleep 2 && echo 0 > /sys/devices/asr-rfkill.0/pwr_ctrl

    if(!access("/sys/power/autosleep", W_OK))
    {
        system("echo mem > /sys/power/autosleep");
    }
    else
    {
        LOGE("[MBTK_POWER] /sys/power/autosleep can not write.");
        //printf("/sys/power/autosleep can not write.");
        return MBTK_POWER_RESULT_NO_SLEEP_NODE;
    }

    return MBTK_POWER_RESULT_SUCCESS;
}

#elif defined(MBTK_PROJECT_L508_X6)
int mbtk_system_sleep(void)
{
    int ubus_ret = 0;
    
    ubus_ret = mbtk_power_gnss_close();
    if(ubus_ret < 0)
    {
        LOGE("[MBTK_POWER] mbtk_power_gnss_close() fail.");
        return MBTK_POWER_RESULT_GNSS_CLOSE_FAIL;
    }

    // echo off > /sys/devices/mbtk-dev-op.10/gps_power && echo mem > /sys/power/autosleep
    // echo 1 > /sys/devices/asr-rfkill.0/pwr_ctrl && sleep 2 && echo 0 > /sys/devices/asr-rfkill.0/pwr_ctrl
    //close Ldo6
    system("i2cset -y -f 2 0x31 0x18 0x0f");
    //GPS_WAKE_HOST to GPIO
    system("hwacc w 0xd401e198 0x1040");
    //HOST_WAKE_GPS to GPIO
    //system("hwacc w 0xd401e0c0 0x1040");
    //gpio34 to GPIO
#if 1
    system("hwacc w 0xd401e164 0x1040");
	system("hwacc w 0xd401e166 0x1040");
	system("hwacc w 0xd401e1b4 0x1040");
	
    system("hwacc w 0xd401e2ec 0xa441");
    system("hwacc w 0xd401e2f0 0xa441");
    system("hwacc w 0xd401e2f4 0xa441");
    system("hwacc w 0xd401e2f8 0xa441");
    system("hwacc w 0xd401e2fc 0xa441");
    system("hwacc w 0xd401e300 0xa441");
#endif
    one_gpio_export(117, 2);
    one_gpio_export(117, 0);

    one_gpio_export(119, 2);
    one_gpio_export(119, 0);

    one_gpio_export(127, 2);
    one_gpio_export(127, 0);

    one_gpio_export(33, 2);
    one_gpio_export(33, 0);

    one_gpio_export(34, 2);
    one_gpio_export(34, 0);

    one_gpio_export(54, 2);
    one_gpio_export(54, 0);
    
    one_gpio_export(21, 2);
    one_gpio_export(21, 0);
    
    one_gpio_export(118, 2);
    one_gpio_export(118, 0);
    
    if(!access("/sys/power/autosleep", W_OK))
    {
        system("echo mem > /sys/power/autosleep");
    }
    else
    {
        LOGE("[MBTK_POWER] /sys/power/autosleep can not write.");
        //printf("/sys/power/autosleep can not write.");
        return MBTK_POWER_RESULT_NO_SLEEP_NODE;
    }

    return MBTK_POWER_RESULT_SUCCESS;
}

#elif defined(MBTK_PROJECT_L509)
int mbtk_system_sleep(void)
{
    int ubus_ret = 0;
    
    ubus_ret = mbtk_power_gnss_close();
    if(ubus_ret < 0)
    {
        LOGE("[MBTK_POWER] mbtk_power_gnss_close() fail.");
        return MBTK_POWER_RESULT_GNSS_CLOSE_FAIL;
    }

    // echo off > /sys/devices/mbtk-dev-op.10/gps_power && echo mem > /sys/power/autosleep
    // echo 1 > /sys/devices/asr-rfkill.0/pwr_ctrl && sleep 2 && echo 0 > /sys/devices/asr-rfkill.0/pwr_ctrl

    one_gpio_export(120, 2);
    one_gpio_export(120, 0);

    one_gpio_export(21, 2);
    one_gpio_export(21, 0);
    
    one_gpio_export(118, 2);
    one_gpio_export(118, 0);
    
    if(!access("/sys/power/autosleep", W_OK))
    {
        system("echo mem > /sys/power/autosleep");
    }
    else
    {
        LOGE("[MBTK_POWER] /sys/power/autosleep can not write.");
        //printf("/sys/power/autosleep can not write.");
        return MBTK_POWER_RESULT_NO_SLEEP_NODE;
    }

    return MBTK_POWER_RESULT_SUCCESS;
}

#elif defined(MBTK_PROJECT_L508)
int mbtk_system_sleep(void)
{
    int ubus_ret = 0;
    
    ubus_ret = mbtk_power_gnss_close();
    if(ubus_ret < 0)
    {
        LOGE("[MBTK_POWER] mbtk_power_gnss_close() fail.");
        return MBTK_POWER_RESULT_GNSS_CLOSE_FAIL;
    }

    // echo off > /sys/devices/mbtk-dev-op.10/gps_power && echo mem > /sys/power/autosleep
    // echo 1 > /sys/devices/asr-rfkill.0/pwr_ctrl && sleep 2 && echo 0 > /sys/devices/asr-rfkill.0/pwr_ctrl

    one_gpio_export(119, 2);
    one_gpio_export(119, 0);

    one_gpio_export(21, 2);
    one_gpio_export(21, 0);
    
    one_gpio_export(118, 2);
    one_gpio_export(118, 0);
    
    if(!access("/sys/power/autosleep", W_OK))
    {
        system("echo mem > /sys/power/autosleep");
    }
    else
    {
        LOGE("[MBTK_POWER] /sys/power/autosleep can not write.");
        //printf("/sys/power/autosleep can not write.");
        return MBTK_POWER_RESULT_NO_SLEEP_NODE;
    }

    return MBTK_POWER_RESULT_SUCCESS;
}

#elif defined(MBTK_PROJECT_PN1803)
int mbtk_system_sleep(void)
{
    int ubus_ret = 0;
    
    ubus_ret = mbtk_power_gnss_close();
    if(ubus_ret < 0)
    {
        LOGE("[MBTK_POWER] mbtk_power_gnss_close() fail.");
        return MBTK_POWER_RESULT_GNSS_CLOSE_FAIL;
    }

    // echo off > /sys/devices/mbtk-dev-op.10/gps_power && echo mem > /sys/power/autosleep
    // echo 1 > /sys/devices/asr-rfkill.0/pwr_ctrl && sleep 2 && echo 0 > /sys/devices/asr-rfkill.0/pwr_ctrl

    one_gpio_export(119, 2);
    one_gpio_export(119, 0);

    one_gpio_export(21, 2);
    one_gpio_export(21, 0);
    
    one_gpio_export(118, 2);
    one_gpio_export(118, 0);
    
    if(!access("/sys/power/autosleep", W_OK))
    {
        system("echo mem > /sys/power/autosleep");
    }
    else
    {
        LOGE("[MBTK_POWER] /sys/power/autosleep can not write.");
        //printf("/sys/power/autosleep can not write.");
        return MBTK_POWER_RESULT_NO_SLEEP_NODE;
    }

    return MBTK_POWER_RESULT_SUCCESS;
}

#else
int mbtk_system_sleep(void)
{
    return MBTK_POWER_RESULT_SUCCESS;
}
#endif
/****************************API***************************************/
#endif
