#ifndef _MBTK_HTTP_CHUNKS_H
#define _MBTK_HTTP_CHUNKS_H
#include "mbtk_type.h"

/*
 * The longest possible hexadecimal number we support in a chunked transfer.
 * Weird enough, RFC2616 doesn't set a maximum size! Since we use strtoul()
 * to convert it, we "only" support 2^32 bytes chunk data.
 */
#define MAXNUM_SIZE 16

typedef enum {
  /* await and buffer all hexadecimal digits until we get one that isn't a
     hexadecimal digit. When done, we go CHUNK_LF */
  CHUNK_HEX,

  /* wait for LF, ignore all else */
  CHUNK_LF,

  /* We eat the amount of data specified. When done, we move on to the
     POST_CR state. */
  CHUNK_DATA,

  /* POSTLF should get a CR and then a LF and nothing else, then move back to
     HEX as the CRLF combination marks the end of a chunk. A missing CR is no
     big deal. */
  CHUNK_POSTLF,

  /* At this point optional trailer headers can be found, unless the next line
     is CRLF */
  CHUNK_TRAILER,

  /* Used to mark that we're out of the game.  NOTE: that there's a 'dataleft'
     field in the struct that will tell how many bytes that were not passed to
     the client in the end of the last buffer! */
  CHUNK_STOP
} http_chunk_state;

typedef enum {
  CHUNKE_STOP = -1,
  CHUNKE_OK = 0,
  CHUNKE_TOO_LONG_HEX = 1,
  CHUNKE_ILLEGAL_HEX,
  CHUNKE_BAD_CHUNK,
  CHUNKE_BAD_ENCODING,
  CHUNKE_OUT_OF_MEMORY,
  CHUNKE_PASSTHRU_ERROR, /* Curl_httpchunk_read() returns a CURLcode to use */
  CHUNKE_LAST
} http_chunk_code;

typedef struct {
  char hexbuffer[MAXNUM_SIZE + 1];
  int hexindex;
  http_chunk_state state;
  int datasize;
  int dataleft; /* untouched data amount at the end of the last buffer */
} http_chunker_t;

/* The following functions are defined in http_chunks.c */
void http_chunk_init(http_chunker_t *chunker);
http_chunk_code http_chunk_parse(http_chunker_t *chunker, char *src, int src_len,
            char *dest,int *dest_len);

#endif /* _MBTK_HTTP_CHUNKS_H */


