#ifndef MBTK_ADB_INFO_H
#define MBTK_ADB_INFO_H
#include "mbtk_type.h"

#define MBTK_ADB_PACK_FLAG 0xF6F7F8F9

// flag[4] + type[1] + data_len[2] [+ data[data_len]]
#define MBTK_ADB_PACK_HEAD_SIZE 7

// Message ID.
typedef enum
{
    MBTK_ADB_MSG_CONN_START = 0x01,  // cli->ser : Start handshake.
    MBTK_ADB_MSG_CONN_SUCCESS,    // ser->cli : Connect success.
    MBTK_ADB_MSG_PUSH,            // cli->ser : Start push data(ARG : data_len[4] path_len[2] path[path_len]).
    MBTK_ADB_MSG_PUSH_READY,      // ser->cli : Server ready,client can send data.
    MBTK_ADB_MSG_PUSH_COMPLETE,   // cli->ser : Push complete.
    MBTK_ADB_MSG_PUSH_SIZE,       // ser->cli : Server recv data lenght(ARG : data_len[4]).
    MBTK_ADB_MSG_CMD_REQ,         // cli->ser : Send shell/at command.(ARG : shell/at command).
    MBTK_ADB_MSG_CMD_RSP,         // ser->cli : Shell/at command response.(ARG : shell/at command response).
    MBTK_ADB_MSG_CMD_KILL,      // cli->ser : Kill shell command.
    MBTK_ADB_MSG_CMD_RSP_COMPLETE,    // ser->cli : Shell/at command response complete.
    MBTK_ADB_MSG_CLOSE_START,     // cli->ser : Start close connect.
    MBTK_ADB_MSG_CLOSE_SUCCESS,   // ser->cli : Close connect success.

    // ERR start
//    MBTK_ADB_MSG_ERR_UNKNOWN = 0x80,

    MBTK_ADB_MSG_DATA = 0xFF             // Data
} mbtk_adb_msg_enum;

// Message error ID.
typedef enum
{
    MBTK_ADB_MSG_ERR_SUCCESS = 0x0,
    MBTK_ADB_MSG_ERR_UNKNOWN = 0x80,
    MBTK_ADB_MSG_ERR_PACK,  // Packet error.
    MBTK_ADB_MSG_ERR_IO,    // Read/Write error.
    MBTK_ADB_MSG_ERR_FILE_SIZE,    // File size error.
    MBTK_ADB_MSG_ERR_FILE_PATH,    // File path error.
    MBTK_ADB_MSG_ERR_TRANS_NO_START,    // Data transfer not started.
    MBTK_ADB_MSG_ERR_UNKNOWN_MSG,  // Unknown msg.
    MBTK_ADB_MSG_ERR_COMMAND,    // Shell or AT command error.

} mbtk_adb_msg_err_enum;

typedef struct
{
    mbtk_adb_msg_enum msg_id;

    uint16 data_len;
    uint8 *data;
} mbtk_adb_pack_t;

#endif /* MBTK_ADB_INFO_H */
