#if 1
#include <ctype.h>

#include "mbtk_data_call.h"
#include "mbtk_info.h"
#include "mbtk_utils.h"

#define MBTK_RESULT_FAIL     -1
#define MBTK_RESULT_SUCCESS  0

#define MBTK_BUFF_SIZE         10
#define MBTK_BUFF_STATE_INIT   "000000000"
#define MBTK_BUFF_STATE_INIT_1 "010000000"
#define MBTK_APN_STATE         "persist.qser.apn.state"
#define MBTK_APN_AUTH_TYPE     "persist.qser.apn.auth"
#define MBTK_APN_TYPE          "persist.qser.apn.type"

#if (defined(MBTK_SG_SUPPORT) && defined(MBTK_ALL_CID_SUPPORT))
//Setting apn parameters starts from channel 1
#define MBTK_SET_APN_CID_MIN 1
#else
//Setting apn parameters starts from channel 2
#define MBTK_SET_APN_CID_MIN 2
#endif
#define MBTK_SET_APN_CID_MAX 7

/*cid 1 - 7*/
mbtk_qser_apn_info_s apninfo_s[9];
char apn_set_state[MBTK_BUFF_SIZE] = MBTK_BUFF_STATE_INIT;
char apn_auth_type[MBTK_BUFF_SIZE] = MBTK_BUFF_STATE_INIT;
mbtk_apn_auth_proto_enum apn_auth[9];
int default_apn_cid = -1;
bool default_pdp_state = false;
bool apn_init_flag = false;

int mbtk_get_default_apn_cid(void)
{
    return default_apn_cid;
}

void mbtk_set_default_apn_cid(int cid)
{
    default_apn_cid = cid;
}

bool mbtk_get_default_pdp_state(void)
{
    return default_pdp_state;
}

void mbtk_set_default_pdp_state(bool state, int cid)
{
    int default_cid = mbtk_get_default_apn_cid();
#ifndef MBTK_SG_SUPPORT
    if(default_cid == cid || cid == 1)
#else
    if(default_cid == cid)
#endif
    {
        default_pdp_state = state;
    }
}


int mbtk_check_default_pdp_state(int cid)
{
#ifdef MBTK_ALL_CID_SUPPORT
    int default_cid = mbtk_get_default_apn_cid();
#ifndef MBTK_SG_SUPPORT
    if((default_cid == cid || cid == 1) && mbtk_get_default_pdp_state())
#else
    if(default_cid == cid && mbtk_get_default_pdp_state())
#endif
    {
        LOGE("default pdp already open.default_cid [%d] cid [%d]", default_cid, cid);
        return MBTK_RESULT_FAIL;
    }
#endif
    return MBTK_RESULT_SUCCESS;
}

static int mbtk_get_cid(void)
{
    int i = 0;
    for(i = MBTK_SET_APN_CID_MIN; i <= MBTK_SET_APN_CID_MAX; i++)
    {
        if(apn_set_state[i] == '0')
        {
            return i;
        }
    }

    return MBTK_RESULT_FAIL;
}


int mbtk_check_cid(int cid)
{
    if(cid < MBTK_APN_CID_MIN || cid > MBTK_APN_CID_MAX)
    {
        LOGE("cid range error.");
        return MBTK_RESULT_FAIL;
    }

#if 0
    if(apn_set_state[cid] != '1' && apn_set_state[cid] != '2')
    {
        LOGE("cid [%d] is not exist.", cid);
        return MBTK_RESULT_FAIL;
    }
#endif
    return MBTK_RESULT_SUCCESS;
}

int mbtk_qser_route_config(int cid, mbtk_ipv4_info_t *ipv4, mbtk_ipv6_info_t *ipv6)
{
    if(ipv4 == NULL || ipv6 == NULL)
    {
        LOGE("ip param is NULL.");
        return MBTK_RESULT_FAIL;
    }

#ifdef MBTK_ALL_CID_SUPPORT
    int default_cid = mbtk_get_default_apn_cid();
#ifndef MBTK_SG_SUPPORT
    if(default_cid != cid && cid != 1)
#else
    if(default_cid != cid)
#endif
#endif
    {
        LOGE("cid [%d] no default cid.", cid);
        return MBTK_RESULT_FAIL;
    }

    char buf[1024] = {0};
    char dns[128] = {0};
    int offset = 0;
    int fd = -1;
    sprintf(buf, "route add default dev ccinet%d", cid -1);
    mbtk_system(buf);

    memset(buf, 0x0, 1024);
    memset(dns, 0x0, 128);
    offset = sprintf(buf, "search lan\n");
    if(ipv4->valid)
    {
        if(inet_ntop(AF_INET, &(ipv4->PrimaryDNS), dns, 32) == NULL) {
            LOGE("[qser_data] PrimaryDNS error.");
        } else {
            LOGE("[qser_data] PrimaryDNS : %s", dns);
        }
        offset += sprintf(buf + offset, "nameserver %s\n", dns);
        memset(dns, 0x0, 128);
        if(inet_ntop(AF_INET, &(ipv4->SecondaryDNS), dns, 32) == NULL) {
            LOGE("[qser_data] SecondaryDNS error.");
        } else {
            LOGE("[qser_data] SecondaryDNS : %s", dns);
        }
        offset += sprintf(buf + offset, "nameserver %s\n", dns);
    }
    if(ipv6->valid)
    {
        memset(dns, 0x0, 128);
		if(ipv6_2_str(&(ipv6->PrimaryDNS), dns))
        {
			LOGE("[qser_data] PrimaryDNS error.");
		} else {
			LOGE("[qser_data] PrimaryDNS : %s", dns);
		}
        offset += sprintf(buf + offset, "nameserver %s\n", dns);
        memset(dns, 0x0, 128);
		if(ipv6_2_str(&(ipv6->SecondaryDNS), dns))
        {
			LOGE("[qser_data] SecondaryDNS error.");
		} else {
			LOGE("[qser_data] SecondaryDNS : %s", dns);
		}
        offset += sprintf(buf + offset, "nameserver %s\n", dns);
    }

    if(offset > 0)
    {
        fd = open("/tmp/resolv.conf", O_WRONLY | O_TRUNC);
        if(fd < 0)
        {
            LOGE("[qser_data] mbtk_route_config : open fail.");
            return MBTK_RESULT_FAIL;
        }

        int ret = write(fd, buf, offset);
        if(ret < 0)
        {
            LOGE("[qser_data] mbtk_route_config : write fail.");
        }

        close(fd);
    }

    return MBTK_RESULT_SUCCESS;
}


static int mbtk_apn_check_num1(const uint8 *apn_type, const uint8 *apn_name, int cid)
{
    if(apn_type == NULL || apn_name == NULL)
    {
        LOGE("paran is NULL.");
        return MBTK_RESULT_FAIL;
    }

    if(cid == 1)
    {
        LOGE("no need check.");
        return MBTK_RESULT_SUCCESS;
    }

    int apn_name_length = strlen((char *)apn_name);
    //LOGD("qser_apn_info[0].apn_name: %s!", qser_apn_info[0].apn_name);
    char *p = strstr((char *)apninfo_s[1].apn_name, "mnc");
    if(p == NULL)
    {
        LOGE("mnc not find !");
        p = strstr((char *)apninfo_s[1].apn_name, "MNC");
        if(p == NULL)
        {
            LOGE("MNC not find !");
            return MBTK_RESULT_SUCCESS;
        }
    }

    {
        int default_apn_name_length = p - ((char *)apninfo_s[1].apn_name) -1;
        LOGD("[qser_data] qser_check_apn_type default_apn_name_length = [%d]!", default_apn_name_length);
        if(default_apn_name_length == apn_name_length)
        {
            int i = 0;
            while(i < default_apn_name_length)
            {
                if(isalpha(apninfo_s[1].apn_name[i]) && isalpha(apn_name[i]))
                {
                    if(tolower(apninfo_s[1].apn_name[i]) != tolower(apn_name[i]))
                    {
                        break;
                    }
                }
                else
                {
                    //LOGE("[qser_data] not char!");
                    if(apninfo_s[1].apn_name[i] != apn_name[i])
                    {
                        break;
                    }
                }

                i++;
            }

            if(i == default_apn_name_length)
            {
                LOGE("apn_name is same!cid = [1].");
                return MBTK_RESULT_FAIL;
            }
        }
    }

    return MBTK_RESULT_SUCCESS;
}

static int mbtk_apn_check_num2_7(const uint8 *apn_type, const uint8 *apn_name, mbtk_ip_type_enum ip_type,  int cid)
{
    if(apn_type == NULL || apn_name == NULL)
    {
        LOGE("paran is NULL.");
        return MBTK_RESULT_FAIL;
    }

    //check 2 - 7
    int pdp_type_tmp = 1;
    for (;pdp_type_tmp <= MBTK_APN_CID_MAX; pdp_type_tmp++)
    {
        if(pdp_type_tmp == cid)
        {
            continue;
        }
        if( (apn_set_state[pdp_type_tmp] == '1') || (apn_set_state[pdp_type_tmp] == '2') )
        {
            if(0x0 != apn_type[0])
            {
                if(strcmp((char *)apninfo_s[pdp_type_tmp].apn_type, (char *)apn_type) == 0)
                {
                    LOGE("apn_type is same!idx = [%d]", pdp_type_tmp);
                    return MBTK_RESULT_FAIL;
                }
            }

            if(0x0 != apn_name[0])
            {
                if (strcmp((char *)apninfo_s[pdp_type_tmp].apn_name, (char *)apn_name) == 0)
                {
                    if(apninfo_s[pdp_type_tmp].ip_type == MBTK_IP_TYPE_IPV4V6 || ip_type == MBTK_IP_TYPE_IPV4V6)
                    {
                        LOGE("[qser_data] apn_name is same and pdp_type is IPV4V6!idx = [%d]", pdp_type_tmp);
                        return MBTK_RESULT_FAIL;
                    }

                    if(apninfo_s[pdp_type_tmp].ip_type == ip_type)
                    {
                        LOGE("pdp_type is same and pdp_type is same!idx = [%d]", pdp_type_tmp);
                        return MBTK_RESULT_FAIL;
                    }
                }
            }
        }
    }

    return MBTK_RESULT_SUCCESS;
}

static int get_apn_user_pass_by_cid(mbtk_apn_info_t *apn)
{
    char prop_name[20] = {0};
    char prop_data[300] = {0};
    char local_ip[2] = {0};
    char local_apn_name[128] = {0};
    char local_apn_user[128] = {0};
    char local_apn_pass[128] = {0};
    char local_apn_auth[128] = {0};
    sprintf(prop_name, "%s_%d",MBTK_APN_PROP,apn->cid);
    if(property_get(prop_name, prop_data, "") > 0 && !str_empty(prop_data))
    {
        int i = 0;
        int data_len = strlen(prop_data);
        for(; i < data_len; i++)
        {
            if(prop_data[i] == ',')
            {
                prop_data[i] = ' ';
            }
        }
        //LOGD("prop_data [%s].", prop_data);
        int ret = sscanf(prop_data, " %s %s %s %s %s ", local_ip, local_apn_name, local_apn_user, local_apn_pass, local_apn_auth);
        if(ret != 5)
        {
            LOGE("get user pass fail!ret [%d].", ret);
            return MBTK_RESULT_FAIL;
        }

        mbtk_ip_type_enum local_ip_type = (mbtk_ip_type_enum)atoi(&local_ip[0]);

        if(apn->ip_type != local_ip_type || strcmp((char *)apn->apn, local_apn_name))
        {
            LOGE("APN Changed, not get user/pass/auth.");
            return MBTK_RESULT_FAIL;
        }

        if(memcmp(local_apn_user, "NULL", 4))
        { // Not "NULL"
            memcpy(apn->user, local_apn_user, strlen(local_apn_user)); // user
        }

        if(memcmp(local_apn_pass, "NULL", 4))
        { // Not "NULL"
            memcpy(apn->pass, local_apn_pass, strlen(local_apn_pass)); // pass
        }

        return MBTK_RESULT_SUCCESS;
    }
    return MBTK_RESULT_FAIL;
}


int mbtk_qser_apn_del(int cid)
{
    char buff[32] = {0};
    int ret = mbtk_check_cid(cid);
    if(ret < 0)
    {
        LOGE("cid is exist");
        return MBTK_RESULT_FAIL;
    }

#ifndef MBTK_SG_SUPPORT
    if(cid == 1)
    {
        LOGE("cid 1 is exist");
        return MBTK_RESULT_FAIL;
    }
#endif

    apn_auth_type[cid] = '0';
    property_set(MBTK_APN_AUTH_TYPE, (char *)apn_auth_type);

    if(apn_set_state[cid] == '2')
    {
        mbtk_set_default_apn_cid(-1);
    }
    apn_set_state[cid] = '0';
    property_set(MBTK_APN_STATE, (char *)apn_set_state);

    sprintf(buff, "%s%d", MBTK_APN_TYPE, cid);
    property_set(buff, "");

    memset(&apninfo_s[cid], 0x0, sizeof(mbtk_qser_apn_info_s));
    return MBTK_RESULT_SUCCESS;
}
/*
AT+CGDCONT?
+CGDCONT: 1,"IPV4V6","cmnet.MNC000.MCC460.GPRS","10.131.67.146 254.128.0.0.0.0.0.0.0.1.0.2.200.2.158.0",0,0,,,,

+CGDCONT: 8,"IPV4V6","IMS","254.128.0.0.0.0.0.0.0.1.0.2.200.2.160.160",0,0,0,2,1,1

OK
*/

int mbtk_qser_req_apn_get(void *data, int *data_len, int *cme_err)
{
    ATResponse *response = NULL;
    int err = at_send_command_multiline("AT+CGDCONT?", "+CGDCONT:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    int tmp_int;
    char *tmp_str = NULL;
    char buff[32] = {0};
    uint8 apn_type[128] = {0};
    /*
        <apn_num[1]><cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth[1]><apn_type_len[2]><apn_type_len>...
                    <cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth[1]><apn_type_len[2]><apn_type_len>
    */
    uint8* apn_num = (uint8*)data;
    uint8* data_ptr = (uint8*)((uint8*)data + sizeof(uint8)); // Jump apn_num[1]
    mbtk_apn_info_t apn;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }

        err = at_tok_nextint(&line, &tmp_int); // cid
        if (err < 0)
        {
            goto exit;
        }
        // Only get CID 1-7
        if(apn_set_state[tmp_int] != '0')
        {
            memset(&apn, 0x0, sizeof(mbtk_apn_info_t));
            apn.cid = tmp_int;
            *data_ptr++ = (uint8)tmp_int; // cid

            err = at_tok_nextstr(&line, &tmp_str);// ip type
            if (err < 0)
            {
                goto exit;
            }
            if(!strcasecmp(tmp_str, "IP")) {
                *data_ptr++ = (uint8)MBTK_IP_TYPE_IP;
                apn.ip_type = MBTK_IP_TYPE_IP;
            } else if(!strcasecmp(tmp_str, "IPV6")) {
                *data_ptr++ = (uint8)MBTK_IP_TYPE_IPV6;
                apn.ip_type = MBTK_IP_TYPE_IPV6;
            } else if(!strcasecmp(tmp_str, "IPV4V6")) {
                *data_ptr++ = (uint8)MBTK_IP_TYPE_IPV4V6;
                apn.ip_type = MBTK_IP_TYPE_IPV4V6;
            } else {
                *data_ptr++ = (uint8)MBTK_IP_TYPE_PPP;
                apn.ip_type = MBTK_IP_TYPE_PPP;
            }

            err = at_tok_nextstr(&line, &tmp_str); // apn
            if (err < 0)
            {
                goto exit;
            }
            if(str_empty(tmp_str)) {
                uint16_2_byte((uint16)0, data_ptr, false);
                data_ptr += sizeof(uint16);
            } else {
                uint16_2_byte((uint16)strlen(tmp_str), data_ptr, false);
                data_ptr += sizeof(uint16);
                memcpy(data_ptr, tmp_str, strlen(tmp_str));
                data_ptr += strlen(tmp_str);
                memcpy(apn.apn, tmp_str, strlen(tmp_str));
            }

            if(get_apn_user_pass_by_cid(&apn)) {
                // user
                uint16_2_byte((uint16)0, data_ptr, false);
                data_ptr += sizeof(uint16);

                // pass
                uint16_2_byte((uint16)0, data_ptr, false);
                data_ptr += sizeof(uint16);

                // auth
                *data_ptr++ = (uint8)MBTK_APN_AUTH_PROTO_DEFAULT;
            } else {
                // user
                if(str_empty(apn.user)) {
                    uint16_2_byte((uint16)0, data_ptr, false);
                    data_ptr += sizeof(uint16);
                } else {
                    uint16_2_byte((uint16)strlen((char *)apn.user), data_ptr, false);
                    data_ptr += sizeof(uint16);
                    memcpy(data_ptr, apn.user, strlen((char *)apn.user));
                    data_ptr += strlen((char *)apn.user);
                }

                // pass
                if(str_empty(apn.pass)) {
                    uint16_2_byte((uint16)0, data_ptr, false);
                    data_ptr += sizeof(uint16);
                } else {
                    uint16_2_byte((uint16)strlen((char *)apn.pass), data_ptr, false);
                    data_ptr += sizeof(uint16);
                    memcpy(data_ptr, apn.pass, strlen((char *)apn.pass));
                    data_ptr += strlen((char *)apn.pass);
                }

                // auth
                switch(apn_auth_type[apn.cid])
                {
                    case '0':
                    {
                        *data_ptr++ = (uint8)MBTK_APN_AUTH_PROTO_DEFAULT;
                        break;
                    }
                    case '1':
                    {
                        *data_ptr++ = (uint8)MBTK_APN_AUTH_PROTO_NONE;
                        break;
                    }
                    case '2':
                    {
                        *data_ptr++ = (uint8)MBTK_APN_AUTH_PROTO_PAP;
                        break;
                    }
                    case '3':
                    {
                        *data_ptr++ = (uint8)MBTK_APN_AUTH_PROTO_CHAP;
                        break;
                    }
                    default:
                    {
                        *data_ptr++ = (uint8)MBTK_APN_AUTH_PROTO_DEFAULT;
                        break;
                    }
                }
            }

            //apn_type
            memset(buff, 0x0, 32);
            sprintf(buff, "%s%d", MBTK_APN_TYPE, apn.cid);
            property_get(buff, (char *)apn_type, "");
            if(str_empty(apn_type))
            {
                uint16_2_byte((uint16)0, data_ptr, false);
                data_ptr += sizeof(uint16);
            } else
            {
                uint16_2_byte((uint16)strlen((char *)apn_type), data_ptr, false);
                data_ptr += sizeof(uint16);
                memcpy(data_ptr, apn_type, strlen((char *)apn_type));
                data_ptr += strlen((char *)apn_type);
            }

            if(apn_init_flag)
            {
                mbtk_qser_apn_save(apn, apn_type, false);
            }
            (*apn_num)++;
        }

        lines_ptr = lines_ptr->p_next;
    }

    *data_len = data_ptr - (uint8*)data;
    if(apn_init_flag)
    {
        apn_init_flag = false;
    }
    goto exit;
exit:
    at_response_free(response);
    return err;
}


int mbtk_qser_apn_save(mbtk_apn_info_t apn, const uint8 *apn_type, bool state_save)
{
    if(apn_type == NULL)
    {
        LOGE("param is error.");
        return MBTK_RESULT_FAIL;
    }

//    int ret = -1;
    char buff[32] = {0};
    int cid = apn.cid;

    memset(&apninfo_s[cid], 0x0, sizeof(mbtk_qser_apn_info_s));
    apninfo_s[cid].cid = apn.cid;
    apninfo_s[cid].ip_type = apn.ip_type;
    apninfo_s[cid].auth_proto = apn_auth[cid];
    if(strlen((char *)apn.apn))
    {
        memcpy(apninfo_s[cid].apn_name, apn.apn, strlen((char *)apn.apn));
    }
    if(strlen((char *)apn.user))
    {
        memcpy(apninfo_s[cid].user_name, apn.user, strlen((char *)apn.user));
    }
    if(strlen((char *)apn.pass))
    {
        memcpy(apninfo_s[cid].user_pass, apn.pass, strlen((char *)apn.pass));
    }

    memcpy(apninfo_s[cid].apn_type, apn_type, strlen((char *)apn_type));
    if(state_save)
    {
        sprintf(buff, "%s%d", MBTK_APN_TYPE, apn.cid);
        property_set(buff, (char *)apn_type);
    }


    if(state_save)
    {
        if(strcmp((char *)apn_type, "iot_default") == 0)
        {
            apn_set_state[cid] = '2';
            mbtk_set_default_apn_cid(cid);
        }
        else
        {
            apn_set_state[cid] = '1';
        }
        property_set(MBTK_APN_STATE, (char *)apn_set_state);

        apn_auth_type[cid] = (char)apn_auth[cid] + '0';
        property_set(MBTK_APN_AUTH_TYPE, (char *)apn_auth_type);
    }
    return MBTK_RESULT_SUCCESS;
}

int mbtk_strdata_to_apn(const uint8 *str, mbtk_apn_info_t *apn, uint8 *apn_type, mbtk_apn_req_type_enum *req_type)
{
    if(str == NULL || apn == NULL || apn_type == NULL)
    {
        LOGE("param is error.");
        return MBTK_RESULT_FAIL;
    }

    // <cid[1]><ip_type[1]><req_type[1]><auth[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth_len[2]><apn_type[2]>
    int len = 0;
    int ret = -1;
    memset(apn, 0x0, sizeof(mbtk_apn_info_t));

    // cid
    apn->cid = (int)*str++;

    // ip_type
    apn->ip_type = (mbtk_ip_type_enum)(*str++);

    //req_type
    *req_type = (mbtk_apn_req_type_enum)(*str++);
    if((*req_type) == MBTK_APN_REQ_TYPE_ADD)
    {
        apn->cid = mbtk_get_cid();
        if(apn->cid < 0)
        {
            LOGE("no enough cid.");
            return MBTK_RESULT_FAIL;
        }
    }
    else
    {
#ifndef MBTK_SG_SUPPORT
        ret = mbtk_check_cid(apn->cid);
        if(ret < 0)
        {
            LOGE("cid is error.");
            return MBTK_RESULT_FAIL;
        }

        if(apn->cid == 1)
        {
            LOGE("cid 1 no support set.");
            return MBTK_RESULT_FAIL;
        }
#endif
    }

    // auth
    apn_auth[apn->cid] = (mbtk_apn_auth_proto_enum)(*str++);
    if(apn_auth[apn->cid] == MBTK_APN_AUTH_PROTO_NONE || apn_auth[apn->cid] == MBTK_APN_AUTH_PROTO_DEFAULT)
    {
        memcpy(apn->auth,"NONE",strlen("NONE")+1);
    }
    else if(apn_auth[apn->cid] == MBTK_APN_AUTH_PROTO_PAP)
    {
        memcpy(apn->auth,"PAP",strlen("PAP")+1);
    }
    else if(apn_auth[apn->cid] == MBTK_APN_AUTH_PROTO_CHAP)
    {
        memcpy(apn->auth,"CHAP",strlen("CHAP")+1);
    }
    #if 0
    else if(apn->auth_proto == QSER_APN_AUTH_PROTO_PAP_CHAP)
    {
        //NOT SUPPORT
    }
    #endif
    else
    {
        LOGE("auth input error!");
        return MBTK_RESULT_FAIL;
    }

    // apn
    len = byte_2_uint16(str, false);
    str += sizeof(uint16);
    if(len > 0)
    {
        memcpy(apn->apn, str, len);
        str += len;
    }

    // user
    len = byte_2_uint16(str, false);
    str += sizeof(uint16);
    if(len > 0)
    {
        memcpy(apn->user, str, len);
        str += len;
    }

    // pass
    len = byte_2_uint16(str, false);
    str += sizeof(uint16);
    if(len > 0)
    {
        memcpy(apn->pass, str, len);
        str += len;
    }

    // auth_type
    len = byte_2_uint16(str, false);
    str += sizeof(uint16);
    if(len > 0)
    {
        memcpy(apn_type, str, len);
        str += len;
    }

    LOGD("APN : %d, %d, %s, %s, %s, %s, %s.", apn->cid,
                                        apn->ip_type,
                                        (str_empty(apn->apn) ? "NULL" : (char*)apn->apn),
                                        (str_empty(apn->user) ? "NULL" : (char*)apn->user),
                                        (str_empty(apn->pass) ? "NULL" : (char*)apn->pass),
                                        (str_empty(apn->auth) ? "NULL" : (char*)apn->auth),
                                        (str_empty(apn_type) ? "NULL" : (char*)apn_type));

    ret = mbtk_apn_check_num1(apn_type, apn->apn, apn->cid);
    if(ret < 0)
    {
        LOGE("num1 check error!");
        return MBTK_RESULT_FAIL;
    }

    ret = mbtk_apn_check_num2_7(apn_type, apn->apn, apn->ip_type, apn->cid);
    if(ret < 0)
    {
        LOGE("num2_7 check error!");
        return MBTK_RESULT_FAIL;
    }
    return MBTK_RESULT_SUCCESS;
}

void mbtk_qser_apn_init(void)
{
    LOGD("enter mbtk_qser_apn_init.");
    apn_init_flag = true;
#ifdef MBTK_SG_SUPPORT
    property_get(MBTK_APN_STATE, (char *)apn_set_state, MBTK_BUFF_STATE_INIT);
#else
    property_get(MBTK_APN_STATE, (char *)apn_set_state, MBTK_BUFF_STATE_INIT_1);
#endif
    LOGD("get apn_set_state[%s].", apn_set_state);

    int i = 0;
    for(; i < MBTK_BUFF_SIZE; i++)
    {
        if(apn_set_state[i] == '2')
        {
            mbtk_set_default_apn_cid(i);
            break;
        }
    }

    property_get(MBTK_APN_AUTH_TYPE, (char *)apn_auth_type, MBTK_BUFF_STATE_INIT);
    LOGD("get apn_auth_type[%s].", apn_auth_type);

    mbtk_get_apn_send_pack();
}
#endif
