#include <string.h>
#include "mbtk_type.h"
#include "mbtk_utils.h"

#ifdef MBTK_DEV_INFO_VERSION_2
#include "mbtk_device_v2.h"
#else
#include "mbtk_device.h"
#endif


static char* band_2_str(mbtk_modem_band_area_enum band_area)
{
    switch(band_area)
    {
        case MBTK_MODEM_BAND_AREA_CN:
            return "CN";
        case MBTK_MODEM_BAND_AREA_EU:
            return "EU";
        case MBTK_MODEM_BAND_AREA_SA:
            return "SA";
        default:
            return "ALL";
    }
}

#ifdef MBTK_DEV_INFO_VERSION_2
static char* net_support_str_get(uint32 net_support)
{
    static char net_str[100] = {0};

    if(net_support & MBTK_NET_SUPPORT_2G) { // GSM
        if(strlen(net_str) > 0) {
            strcat(net_str, "/2G");
        } else {
            strcat(net_str, "2G");
        }
    }

    if(net_support & MBTK_NET_SUPPORT_3G) { // WCDMA
        if(strlen(net_str) > 0) {
            strcat(net_str, "/3G");
        } else {
            strcat(net_str, "3G");
        }
    }

    if(net_support & MBTK_NET_SUPPORT_4G) { // LTE
        if(strlen(net_str) > 0) {
            strcat(net_str, "/4G");
        } else {
            strcat(net_str, "4G");
        }
    }

    if(net_support & MBTK_NET_SUPPORT_5G) { // NR
        if(strlen(net_str) > 0) {
            strcat(net_str, "/5G");
        } else {
            strcat(net_str, "5G");
        }
    }
    return net_str;
}
#endif

static char* band_str_get(uint32 band, int index)
{
    int band_list[33] = {0};
    int ret = mbtk_band_2_list(band, index, band_list);
    if(ret > 0) {
        static char buff[150] = {0};
        memset(buff, 0, sizeof(buff));
        int i = 0;
        while(i < ret) {
            if(strlen(buff) > 0) {
                sprintf(buff + strlen(buff), "/b%d", band_list[i]);
            } else {
                sprintf(buff + strlen(buff), "b%d", band_list[i]);
            }
            i++;
        }
        return buff;
    } else {
        return "NON";
    }
}

int main(int argc, char *argv[])
{
    mbtk_device_info_basic_t info_basic;
    memset(&info_basic, 0, sizeof(mbtk_device_info_basic_t));
    int result = mbtk_dev_info_read(MBTK_DEVICE_INFO_ITEM_BASIC, &info_basic, sizeof(mbtk_device_info_basic_t));
    if(result) {
        printf("mbtk_dev_info_read(BASIC) fail.\n");
        return -1;
    }

    /*
    uint8 project[16];          // T108 / L508_X6
        uint8 project_cust[16];     // T108_C1 / L508_X6_C1  (Refer to: Custom_Model in blf file.)
        uint32 ab_support;          // 1 for ab
        uint8 revision_out[48];     // L508_X6v01.01b04.00
        uint8 revision_in[64];
    */
    printf("Project:%s\n", info_basic.project);
    printf("Custom_Model:%s\n", info_basic.project_cust);
    printf("Revision_Out:%s\n", info_basic.revision_out);
    printf("Revision_In:%s\n", info_basic.revision_in);
    printf("Build_Time:%s\n", info_basic.build_time);
    printf("AB System:%s\n", info_basic.ab_support ? "Yes" : "No");
    printf("Reboot flag:%d\n", info_basic.reboot_flag);

    mbtk_device_info_modem_t info_modem;
    memset(&info_modem, 0, sizeof(mbtk_device_info_modem_t));
    result = mbtk_dev_info_read(MBTK_DEVICE_INFO_ITEM_MODEM, &info_modem, sizeof(mbtk_device_info_modem_t));
    if(result) {
        printf("mbtk_dev_info_read(MODEM) fail.\n");
        return -1;
    }

#ifdef MBTK_DEV_INFO_VERSION_2
    printf("net_pref:%d\n", info_modem.net_pref);
    printf("net_support:%s\n", net_support_str_get(info_modem.net_support));
    printf("Band:%s\n", band_2_str(info_modem.band_area));
    printf("Band GSM:0x%08x(%s)\n", info_modem.band_gsm, band_str_get(info_modem.band_gsm, 0));
    printf("Band WCDMA:0x%08x(%s)\n", info_modem.band_wcdma, band_str_get(info_modem.band_wcdma, 0));
    printf("Band TDLTE:0x%08x(%s)\n", info_modem.band_tdlte, band_str_get(info_modem.band_tdlte, 1));
    printf("Band FDDLTE:0x%08x(%s)\n", info_modem.band_fddlte, band_str_get(info_modem.band_fddlte, 0));
    printf("Band EXT_LTE:0x%08x(%s)\n", info_modem.band_lte_ext, band_str_get(info_modem.band_lte_ext, 0));
    printf("Band NR_3:0x%08x(%s)\n", info_modem.band_nr_3, band_str_get(info_modem.band_nr_3, 3));
    printf("Band NR_2:0x%08x(%s)\n", info_modem.band_nr_2, band_str_get(info_modem.band_nr_2, 2));
    printf("Band NR_1:0x%08x(%s)\n", info_modem.band_nr_1, band_str_get(info_modem.band_nr_1, 1));
    printf("Band NR_0:0x%08x(%s)\n", info_modem.band_nr_0, band_str_get(info_modem.band_nr_0, 0));
#else
    printf("Band:%s\n", band_2_str(info_modem.band_area));
    printf("Band GSM:0x%08x(%s)\n", info_modem.band_gsm, band_str_get(info_modem.band_gsm, 0));
    printf("Band WCDMA:0x%08x(%s)\n", info_modem.band_wcdma, band_str_get(info_modem.band_wcdma, 0));
    printf("Band TDLTE:0x%08x(%s)\n", info_modem.band_tdlte, band_str_get(info_modem.band_tdlte, 1));
    printf("Band FDDLTE:0x%08x(%s)\n", info_modem.band_fddlte, band_str_get(info_modem.band_fddlte, 0));
    printf("Band EXT_LTE:0x%08x(%s)\n", info_modem.band_lte_ext, band_str_get(info_modem.band_lte_ext, 0));
#endif

    return 0;
}


