#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "mbtk_type.h"

#ifdef MBTK_DEV_INFO_VERSION_2
#include "mbtk_device_v2.h"
#else
#include "mbtk_device.h"
#endif

/*
* revision_out start from 0x1000.
*/
#define REVISION_OUT_ADDR 0x1000
#define DEV_INFO_FILE_NAME "dev_info.bin"

static void help()
{
    printf("ota_update -f [ota_bin] -v [new_revision_dir]\n");
}

/*
*
* ota_update -f [ota_bin] -v [new_revision_dir]
*
*/
int main(int argc, char *argv[])
{
    int ch;
    char ota_bin[128] = {0};
    char dev_info_file[128] = {0};
    while((ch = getopt(argc, argv, "f:v:"))!= -1)
    {
        switch(ch)
        {
            case 'f':
                if(strlen(optarg) > 0)
                    memcpy(ota_bin, optarg, strlen(optarg));
                break;
            case 'v':
                if(strlen(optarg) > 0)
                    memcpy(dev_info_file, optarg, strlen(optarg));
                break;
            default:
                help();
                return -1;
        }
    }
    if(strlen(ota_bin) == 0 || strlen(dev_info_file) == 0)
    {
        help();
        return -1;
    }

    printf("Ota Bin:%s, Revision Dir:%s\n", ota_bin, dev_info_file);

    sprintf(dev_info_file + strlen(dev_info_file), "/%s", DEV_INFO_FILE_NAME);

    if(access(ota_bin, F_OK))
    {
        printf("%s not exist.", ota_bin);
        return -1;
    }

    if(access(dev_info_file, F_OK))
    {
        printf("%s not exist.", dev_info_file);
        return -1;
    }

    int fd = open(dev_info_file, O_RDONLY);
    if(fd < 0)
    {
        printf("Open(%s) fail:%d\n", dev_info_file, errno);
        return -1;
    }
    mbtk_device_info_header_t info_header;
    memset(&info_header, 0, sizeof(mbtk_device_info_header_t));
    if(read(fd, &info_header, sizeof(mbtk_device_info_header_t)) != sizeof(mbtk_device_info_header_t)) {
        printf("Read mbtk_device_info_header_t fail:%d\n", errno);
        goto fail;
    }

    if(lseek(fd, info_header.item_header[MBTK_DEVICE_INFO_ITEM_BASIC].addr, SEEK_SET) < 0)
    {
        printf("seek failed\n");
        goto fail;
    }

    mbtk_device_info_basic_t info_basic;
    memset(&info_basic, 0, sizeof(mbtk_device_info_basic_t));
    if(read(fd, &info_basic, sizeof(mbtk_device_info_basic_t)) != sizeof(mbtk_device_info_basic_t)) {
        printf("Read mbtk_device_info_basic_t fail:%d\n", errno);
        goto fail;
    }

    printf("New Revision:%s\n", info_basic.revision_out);

    close(fd);
    fd = open(ota_bin, O_WRONLY, 0644);
    if(fd < 0)
    {
        printf("Open(%s) fail:%d\n", ota_bin, errno);
        return -1;
    }

    if(lseek(fd, REVISION_OUT_ADDR, SEEK_SET) < 0)
    {
        printf("seek failed\n");
        goto fail;
    }

    if(write(fd, info_basic.revision_out, strlen(info_basic.revision_out)) != strlen(info_basic.revision_out)) {
        printf("Write revision failed\n");
        goto fail;
    }

    printf("%s revision update to:%s\n", ota_bin, info_basic.revision_out);
    close(fd);
    return 0;
fail:
    close(fd);
    return -1;
}

