#ifndef _8122_AGNSS_H_
#define _8122_AGNSS_H_
//#define PYTHON_SUPPORT 1

typedef enum {
    HD_EPH_INJECT_STATUS_SUCCESS,
    HD_EPH_INJECT_STATUS_FAIL,
    HD_EPH_INJECT_STATUS_WAIT_RETURN
} hd_eph_inject_status_type;

typedef struct {
    uint16_t year; //2000 ~ 0xffff
    uint8_t month; // 1 ~ 12
    uint8_t day; //1 ~ 31
    uint8_t hour; // 0 ~ 24
    uint8_t min; // 0 ~ 60
    uint8_t second; // 0 ~ 60
}HD_AGNSS_UTC_TIME_TYPE;

/**
  * @brief  AGNSS星历注入、位置注入、时间注入。星历、位置、时间可选择性注入。
  * @param  eph_file_path：从服务器下载的星历数据文件路径；若无则填NULL

            latitude：纬度，乘以10^7；若无则填0
            longitude：经度，乘以10^7；若无则填0
            altitude：高程，浮点，单位为m；若无则填0
            accuracy：精度；若无则填0

            UTC_time：UTC时间；若无则填NULL
  * @retval void
**/
int hd_agnss_inject(const char *eph_file_path, int32_t latitude, int32_t longitude, float altitude, float accuracy, /****latitude和longitude由double型乘以10^7得到*****/
                                HD_AGNSS_UTC_TIME_TYPE *UTC_time);


void hd_set_gnss_dev_fd(int fd);

int hd_eph_inject_result_check(const uint8_t *pack, int pack_len);

void hd_set_eph_inject_status(hd_eph_inject_status_type status);

hd_eph_inject_status_type hd_get_eph_inject_status(void);

#endif

