#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <arpa/inet.h>

#include "agnss_http_download.h"
#include "mbtk_log.h"
#include "mbtk_http.h"

#define HTTP_RESULT_SUCCESS 0
#define HTTP_RESULT_FAIL    -1

static char eph_file_path[128] = {0};
static int eph_file_fd = -1;

static void http_data_cb_func(int session_id, mbtk_http_data_type_enum type, void *data,int data_len)
{
    int ret = 0;

    if(type == MBTK_HTTP_DATA_HEADER) 
    {
        LOGD("Header(%d):%s", data_len, (char*)data);
        if(eph_file_fd > 0)
        {
            return;
        }
        unlink(eph_file_path);
        eph_file_fd = open(eph_file_path, O_RDWR|O_CREAT|O_TRUNC, 0644);
        if (eph_file_fd < 0)
        {
            LOGD("file open error");
        }
        else
        {
            LOGD("agnss file open: %d", eph_file_fd);
        }
    } 
    else if(type == MBTK_HTTP_DATA_CONTENT) 
    {
        LOGD("http Data(%d)", data_len);

        ret = write(eph_file_fd, (char*)data, data_len);
        if (ret < 0) 
        {
            LOGE("%s: error writing to file!", __FUNCTION__);
        } 
        else if (ret < data_len) 
        {
            LOGD("%s: wrote less the buffer size!", __FUNCTION__);
        }
        else
        {
            //
        }
    } 
    else 
    {
        LOGD(">>>>>Complete<<<<<");
        if(eph_file_fd <= 0)
        {
            return;
        }
        close(eph_file_fd);
        eph_file_fd = -1;
    }
}

int eph_data_from_http_get(char *host, const char *path)
{
    if(host == NULL || path == NULL || strlen(path) == 0)
    {
        LOGE("eph_data_from_http_get param is error.");
    }
    
    int http_handle = mbtk_http_handle_get(TRUE, http_data_cb_func);
    if(http_handle < 0)
    {
        LOGE("mbtk_http_handle_get() fail.");
        return HTTP_RESULT_FAIL;
    }
    int http_session = mbtk_http_session_create(http_handle, HTTP_OPTION_GET, HTTP_VERSION_1_1);
    if(http_handle < 0)
    {
        LOGE("mbtk_http_session_create() fail.");
        goto error;
    }

    memcpy(eph_file_path, path, strlen(path));
    if(mbtk_http_session_url_set(http_handle, http_session, host))
    {
        LOGE("mbtk_http_session_url_set() fail.\n");
        goto error;
    }
    if(mbtk_http_session_start(http_handle, http_session))
    {
        LOGE("mbtk_http_session_start() fail.\n");
        goto error;
    }
    if(mbtk_http_handle_free(http_handle))
    {
        LOGE("mbtk_http_handle_free() fail.");
        return HTTP_RESULT_FAIL;
    }

    return HTTP_RESULT_SUCCESS;
error:
    mbtk_http_handle_free(http_handle);
    return HTTP_RESULT_FAIL;
}

