#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <fcntl.h>
#include <signal.h>
#include <cutils/properties.h>
#include <arpa/inet.h>

#include "mbtk_type.h"
#include "mbtk_ril.h"
#include "atchannel.h"
#include "at_tok.h"
#include "mbtk_utils.h"
#include "ril_info.h"
#include "mbtk_str.h"

mbtk_cell_pack_info_t cell_info;

extern ril_band_info_t band_info;
void ril_rsp_pack_send(mbtk_sim_type_enum sim_id, ATPortType_enum port, int fd, int ril_id, int msg_index, const void* data, int data_len);
ATPortId_enum portType_2_portId(mbtk_sim_type_enum sim_id, ATPortType_enum port);


static bool net_support_check(uint32 net_type, uint32 net_flag)
{
    return (net_type & net_flag);
}

/*
AT+COPS=?

+COPS: (2, "CHN-CT", "CT", "46011", 7),(3, "CHN-UNICOM", "UNICOM", "46001", 7),(3, "CHINA MOBILE", "CMCC", "46000", 0),(3, "CHINA MOBILE", "CMCC", "46000", 7),(3, "China Broadnet", "CBN", "46015", 7),,(0,1,2,3,4),(0,1,2)

OK
*/
static int req_available_net_get(mbtk_sim_type_enum sim_id, ATPortType_enum port, mbtk_net_info_array_t* nets, int *cme_err)
{
    ATResponse *response = NULL;
    int err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT+COPS=?", "+COPS:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }
    char *line_ptr = response->p_intermediates->line;
    if(line_ptr == NULL) {
        LOG("line is NULL");
        err = -1;
        goto exit;
    }
    //LOG("Line:%s",line_ptr);
    line_ptr = strstr(line_ptr, "(");
    while(line_ptr) {
        line_ptr++;
        // Only for available/current net.
        if(*line_ptr == '1' || *line_ptr == '2' || *line_ptr == '3') {
            nets->net_info[nets->num].net_state = (uint8)atoi(line_ptr); // net_state

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL) {
                err = -1;
                goto exit;
            }
            line_ptr++;

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL) {
                err = -1;
                goto exit;
            }
            line_ptr++;

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL) {
                err = -1;
                goto exit;
            }

            while(*line_ptr != '\0' && (*line_ptr == ',' || *line_ptr == ' ' || *line_ptr == '"'))
                line_ptr++;

            // set sel_mode to 0
            nets->net_info[nets->num].net_sel_mode = (uint8)0;
            // Point to "46000"
            //LOG("PLMN:%s",line_ptr);
            //sleep(1);
            //uint32_2_byte((uint32)atoi(line_ptr), buff_ptr + 3, false); // plmn
            nets->net_info[nets->num].plmn = (uint32)atoi(line_ptr);

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL) {
                err = -1;
                goto exit;
            }

            while(*line_ptr != '\0' && (*line_ptr == ',' || *line_ptr == ' '))
                line_ptr++;

            // Point to "7"
            if(*line_ptr == '\0') {
                err = -1;
                goto exit;
            }
            //LOG("Type:%s",line_ptr);
            //sleep(1);
            nets->net_info[nets->num].net_type = (uint8)atoi(line_ptr); // net_type

            nets->num++;
        }

        line_ptr = strstr(line_ptr, "(");
    }
exit:
    at_response_free(response);
    return err;
}

/*
AT+COPS?
+COPS: 1

OK

or

AT+COPS?
+COPS: 0,2,"46001",7

OK

*/
static int req_net_sel_mode_get(mbtk_sim_type_enum sim_id, ATPortType_enum port, mbtk_net_info_t *net, int *cme_err)
{
    //LOG("req_net_sel_mode_get() 0");
    //sleep(1);
    ATResponse *response = NULL;
    int tmp_int;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT+COPS?", "+COPS:", &response);
    //LOG("req_net_sel_mode_get() 00");
    //sleep(1);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 1");
    //sleep(1);
    char *line = response->p_intermediates->line;
    if(line == NULL) {
        LOG("line is NULL");
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 2");
    //sleep(1);
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 3");
    //sleep(1);
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    net->net_sel_mode = (uint8)tmp_int;
    //LOG("req_net_sel_mode_get() 4");
    //sleep(1);
    // +COPS: 1
    if(!at_tok_hasmore(&line)) {
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 5");
    //sleep(1);
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 6");
    //sleep(1);
    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }
    // memcpy(net->plmn, tmp_ptr, strlen(tmp_ptr));
    net->plmn = (uint32)atoi(tmp_ptr);
    //LOG("req_net_sel_mode_get() 7");
    //sleep(1);
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    net->net_type = (uint8)tmp_int;

    net->net_state = (uint8)MBTK_NET_AVIL_STATE_CURRENT;

exit:
    //LOG("req_net_sel_mode_get() 8");
    //sleep(1);
    at_response_free(response);
    return err;
}

/*
AT+COPS=0
or
AT+COPS=1,2,"46000",7

OK

*/
static int req_net_sel_mode_set(mbtk_sim_type_enum sim_id, ATPortType_enum port, mbtk_net_info_t* net, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[50] = {0};
    char* cmp_ptr = cmd;
    if(net == NULL) {
        cmp_ptr += sprintf(cmp_ptr, "AT+COPS=0");
     } else {
        if(net->net_sel_mode == 0) {
            cmp_ptr += sprintf(cmp_ptr, "AT+COPS=0");
        } else if(net->net_type == 0xFF) {
            cmp_ptr += sprintf(cmp_ptr, "AT+COPS=1,2,\"%d\"",net->plmn);
        } else {
            cmp_ptr += sprintf(cmp_ptr, "AT+COPS=1,2,\"%d\",%d",net->plmn, net->net_type);
        }
     }

    int err = at_send_command(portType_2_portId(sim_id, port), cmd, &response);

    if (err < 0 || response->success == 0) {
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT*BAND=15
OK

*/
int req_band_set(mbtk_sim_type_enum sim_id, ATPortType_enum port, mbtk_band_info_t* band, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[100] = {0};
    int err = -1;

    if(band->gsm_band == 0 && band->umts_band == 0
        && band->tdlte_band == 0 && band->fddlte_band == 0 && band->lte_ext_band == 0
        && band->nr_3_band == 0 && band->nr_2_band == 0
        && band->nr_1_band == 0 && band->nr_0_band == 0
        ) {
        sprintf(cmd, "AT*BAND=%d", band->net_pref);
    } else {
        log_hex("BAND_SUPPORT", &band_info.band_support, sizeof(mbtk_band_info_t));
        log_hex("BAND", band, sizeof(mbtk_band_info_t));

        if(band->gsm_band == 0 && net_support_check(band_info.net_support, MBTK_NET_SUPPORT_2G)) {
            band->gsm_band = band_info.band_support.gsm_band;
        }
        if(band->umts_band == 0 && net_support_check(band_info.net_support, MBTK_NET_SUPPORT_3G)) {
            band->umts_band = band_info.band_support.umts_band;
        }

        if(net_support_check(band_info.net_support, MBTK_NET_SUPPORT_4G)) {
            if(band->tdlte_band == 0) {
                band->tdlte_band = band_info.band_support.tdlte_band;
            }
            if(band->fddlte_band == 0) {
                band->fddlte_band = band_info.band_support.fddlte_band;
            }
            if(band->lte_ext_band == 0) {
                band->lte_ext_band = band_info.band_support.lte_ext_band;
            }
        }

        if(net_support_check(band_info.net_support, MBTK_NET_SUPPORT_5G)) {
            if(band->nr_3_band == 0) {
                band->nr_3_band = band_info.band_support.nr_3_band;
            }
            if(band->nr_2_band == 0) {
                band->nr_2_band = band_info.band_support.nr_2_band;
            }
            if(band->nr_1_band == 0) {
                band->nr_1_band = band_info.band_support.nr_1_band;
            }
            if(band->nr_0_band == 0) {
                band->nr_0_band = band_info.band_support.nr_0_band;
            }
        }

        if((band->gsm_band & band_info.band_support.gsm_band) != band->gsm_band) {
            LOG("GSM band error.");
            goto exit;
        }

        if((band->umts_band & band_info.band_support.umts_band) != band->umts_band) {
            LOG("UMTS band error.");
            goto exit;
        }

        if((band->tdlte_band & band_info.band_support.tdlte_band) != band->tdlte_band) {
            LOG("TDLTE band error.");
            goto exit;
        }

        if((band->fddlte_band & band_info.band_support.fddlte_band) != band->fddlte_band) {
            LOG("FDDLTE band error.");
            goto exit;
        }

        if((band->lte_ext_band & band_info.band_support.lte_ext_band) != band->lte_ext_band) {
            LOG("EXT_LTE band error.");
            goto exit;
        }
        if((band->nr_3_band & band_info.band_support.nr_3_band) != band->nr_3_band) {
            LOG("nr_3_band band error.");
            goto exit;
        }

        if((band->nr_2_band & band_info.band_support.nr_2_band) != band->nr_2_band) {
            LOG("nr_2_band band error.");
            goto exit;
        }

        if((band->nr_1_band & band_info.band_support.nr_1_band) != band->nr_1_band) {
            LOG("nr_1_band band error.");
            goto exit;
        }

        if((band->nr_0_band & band_info.band_support.nr_0_band) != band->nr_0_band) {
            LOG("nr_0_band band error.");
            goto exit;
        }
        if(band->net_pref == 0xFF) { // No change net_pref.
            int tmp_int;
            err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT*BAND?", "*BAND:", &response);
            if (err < 0 || response->success == 0 || !response->p_intermediates){
                if(cme_err) {
                    *cme_err = at_get_cme_error(response);
                }
                goto exit;
            }

            char *line = response->p_intermediates->line;
            err = at_tok_start(&line);
            if (err < 0)
            {
                goto exit;
            }

            err = at_tok_nextint(&line, &tmp_int);
            if (err < 0)
            {
                goto exit;
            }
            band->net_pref = (uint8)tmp_int; // Set to current net_pref.

            at_response_free(response);
        }
        // Only support 4G/5G
        if(band_info.net_support & MBTK_NET_SUPPORT_5G) {
            // AT*band=19,0,0,482,134742231,0,24576,256,134217877,0
            if(band->lte_ext_band > 0) {
                sprintf(cmd, "AT*BAND=%d,%d,%d,%d,%d,%d,%d,%d,%d,0,,,,%d", band->net_pref, band->gsm_band, band->umts_band, band->tdlte_band, band->fddlte_band,
                    band->nr_3_band, band->nr_2_band, band->nr_1_band, band->nr_0_band, band->lte_ext_band);
            } else {
                sprintf(cmd, "AT*BAND=%d,%d,%d,%d,%d,%d,%d,%d,%d,0", band->net_pref, band->gsm_band, band->umts_band, band->tdlte_band, band->fddlte_band,
                    band->nr_3_band, band->nr_2_band, band->nr_1_band, band->nr_0_band);
            }
        } else {
            if(band->lte_ext_band > 0) {
                sprintf(cmd, "AT*BAND=%d,%d,%d,%d,%d,,,,%d", band->net_pref, band->gsm_band, band->umts_band, band->tdlte_band, band->fddlte_band, band->lte_ext_band);
            } else {
                sprintf(cmd, "AT*BAND=%d,%d,%d,%d,%d", band->net_pref, band->gsm_band, band->umts_band, band->tdlte_band, band->fddlte_band);
            }
        }
    }
    err = at_send_command(portType_2_portId(sim_id, port), cmd, &response);

    if (err < 0 || response->success == 0){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

    err = 0;
exit:
    at_response_free(response);
    return err;
}

/*
// ???????
AT*BAND=?
*BAND:(0-18),79,147,482,524503

OK

// ???????????
AT*BAND?
*BAND: 15, 78, 147, 482, 524503, 0, 2, 2, 0, 0

OK

5G :
*BAND: 19, 0, 0, 482, 149,0, 24576, 256, 134217877, 0, 0, 2, 2, 0


// ?????????
AT*BAND=5,79,147,128,1
OK

net_prefferred??
    0 : GSM only
    1 : UMTS only
    2 : GSM/UMTS(auto)
    3 : GSM/UMTS(GSM preferred)
    4 : GSM/UMTS(UMTS preferred)
    5 : LTE only
    6 : GSM/LTE(auto)
    7 : GSM/LTE(GSM preferred)
    8 : GSM/LTE(LTE preferred)
    9 : UMTS/LTE(auto)
    10 : UMTS/LTE(UMTS preferred)
    11 : UMTS/LTE(LTE preferred)
    12 : GSM/UMTS/LTE(auto)
    13 : GSM/UMTS/LTE(GSM preferred)
    14 : GSM/UMTS/LTE(UMTS preferred)
    15 : GSM/UMTS/LTE(LTE preferred)
GSM band??
    1 ?C PGSM 900 (standard or primary)
    2 ?C DCS GSM 1800
    4 ?C PCS GSM 1900
    8 ?C EGSM 900 (extended)
    16 ?C GSM 450
    32 ?C GSM 480
    64 ?C GSM 850
    512 - BAND_LOCK_BIT // used for GSM band setting
UMTS band??
    1 ?C UMTS_BAND_1
    2 ?C UMTS_BAND_2
    4 ?C UMTS_BAND_3
    8 ?C UMTS_BAND_4
    16 ?C UMTS_BAND_5
    32 ?C UMTS_BAND_6
    64 ?C UMTS_BAND_7
    128 ?C UMTS_BAND_8
    256 ?C UMTS_BAND_9
LTEbandH(TDD-LTE band)
    32 ?C TDLTE_BAND_38
    64 ?C TDLTE_BAND_39
    128 ?C TDLTE_BAND_40
    256 ?C TDLTE_BAND_41
LTEbandL(FDD-LTE band)
    1 ?C FDDLTE_BAND_1
    4 ?C FDDLTE _BAND_3
    8 ?C FDDLTE _BAND_4
    64 ?C FDDLTE _BAND_7
    65536 ?C FDDLTE _BAND_17
    524288 ?C FDDLTE _BAND_20
*/
static int req_band_get(mbtk_sim_type_enum sim_id, ATPortType_enum port, mbtk_band_info_t *band, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;

    log_hex("BAND_SUPPORT", &band_info.band_support, sizeof(mbtk_band_info_t));
    int err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT*BAND?", "*BAND:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->net_pref = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->gsm_band = (uint16)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->umts_band = (uint16)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->tdlte_band = (uint32)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->fddlte_band = (uint32)tmp_int;

    if(band_info.net_support & MBTK_NET_SUPPORT_5G)
    {
        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto exit;
        }
        band->nr_3_band = (uint32)tmp_int;

        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto exit;
        }
        band->nr_2_band = (uint32)tmp_int;

        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto exit;
        }
        band->nr_1_band = (uint32)tmp_int;

        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto exit;
        }
        band->nr_0_band = (uint32)tmp_int;
    }

    // roamingConfig
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    // srvDomain
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    // bandPriorityFlag
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    //
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    // ltebandExt
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->lte_ext_band = (uint32)tmp_int;

    log_hex("BAND", band, sizeof(mbtk_band_info_t));

exit:
    at_response_free(response);
    return err;
}

/*
AT+CSQ
+CSQ: 31,99

OK

AT+CESQ
+CESQ: 60,99,255,255,20,61

OK

AT+COPS?
+COPS: 0,2,"46001",7

OK

*/
static int req_net_signal_get(mbtk_sim_type_enum sim_id, ATPortType_enum port, mbtk_signal_info_t *signal, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;
    char *tmp_ptr = NULL;
    // AT+EEMOPT=1 in the first.
    int err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT+CSQ", "+CSQ:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rssi = (uint8)tmp_int;
    at_response_free(response);

    err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT+CESQ", "+CESQ:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }

    line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rxlev = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->ber = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rscp = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->ecno = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rsrq = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rsrp = (uint8)tmp_int;

    if(at_tok_hasmore(&line)) {
        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto exit;
        }
        signal->ss_rsrq = (uint8)tmp_int;
    }
    if(at_tok_hasmore(&line)) {
        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto exit;
        }
        signal->ss_rsrp = (uint8)tmp_int;
    }
    if(at_tok_hasmore(&line)) {
        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto exit;
        }
        signal->ss_sinr = (uint8)tmp_int;
    }

    at_response_free(response);
    err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT+COPS?", "+COPS:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }
    line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    if(!at_tok_hasmore(&line)) {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->type = (uint8)tmp_int;

exit:
    at_response_free(response);
    return err;
}

/*
AT+CREG=3
OK

AT+CREG?
+CREG: 3,1,"8330","06447340",7

OK

AT+CREG?
+CREG: 3,0

OK

AT+CEREG?
+CEREG: 3,1,"8330","06447340",7

OK


AT+CIREG?
+CIREG: 2,1,15

OK

AT+CIREG?
+CIREG: 0

OK


*/
static int req_net_reg_get(mbtk_sim_type_enum sim_id, ATPortType_enum port, mbtk_net_reg_info_t *reg, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;
    char *tmp_str = NULL;
    int err = at_send_command(portType_2_portId(sim_id, port), "AT+CREG=3", &response);
    if (err < 0 || response->success == 0){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }
    at_response_free(response);

    err = at_send_command_multiline(portType_2_portId(sim_id, port), "AT+CREG?", "+CREG:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int); // n
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);// stat
    if (err < 0)
    {
        goto exit;
    }
    reg->call_state = (uint8)tmp_int;

    if(at_tok_hasmore(&line)) {
        err = at_tok_nextstr(&line, &tmp_str); // lac
        if (err < 0)
        {
            goto exit;
        }
        reg->lac = strtol(tmp_str, NULL, 16);

        err = at_tok_nextstr(&line, &tmp_str); // ci
        if (err < 0)
        {
            goto exit;
        }
        reg->ci = strtol(tmp_str, NULL, 16);

        err = at_tok_nextint(&line, &tmp_int);// AcT
        if (err < 0)
        {
            goto exit;
        }
        reg->type = (uint8)tmp_int;
    }
    at_response_free(response);

    err = at_send_command_multiline(portType_2_portId(sim_id, port), "AT+CEREG?", "+CEREG:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

    line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int); // n
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);// stat
    if (err < 0)
    {
        goto exit;
    }
    reg->data_state = (uint8)tmp_int;

    if(reg->lac == 0 && at_tok_hasmore(&line)) {
        err = at_tok_nextstr(&line, &tmp_str); // lac
        if (err < 0)
        {
            goto exit;
        }
        reg->lac = strtol(tmp_str, NULL, 16);

        err = at_tok_nextstr(&line, &tmp_str); // ci
        if (err < 0)
        {
            goto exit;
        }
        reg->ci = strtol(tmp_str, NULL, 16);

        err = at_tok_nextint(&line, &tmp_int);// AcT
        if (err < 0)
        {
            goto exit;
        }
        reg->type = (uint8)tmp_int;
    } else if(reg->data_state == 0 && (band_info.net_support & MBTK_NET_SUPPORT_5G)) {
        at_response_free(response);
        err = at_send_command_multiline(portType_2_portId(sim_id, port), "AT+C5GREG?", "+C5GREG:", &response);
        if (err < 0 || response->success == 0 || !response->p_intermediates){
            if(cme_err) {
                *cme_err = at_get_cme_error(response);
            }
            goto exit;
        }

        line = response->p_intermediates->line;
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }
        err = at_tok_nextint(&line, &tmp_int); // n
        if (err < 0)
        {
            goto exit;
        }
        err = at_tok_nextint(&line, &tmp_int);// stat
        if (err < 0)
        {
            goto exit;
        }
        reg->data_state = (uint8)tmp_int;

        if(/*reg->lac == 0 && */at_tok_hasmore(&line)) {
            err = at_tok_nextstr(&line, &tmp_str); // lac
            if (err < 0)
            {
                goto exit;
            }
            reg->lac = strtol(tmp_str, NULL, 16);

            err = at_tok_nextstr(&line, &tmp_str); // ci
            if (err < 0)
            {
                goto exit;
            }
            reg->ci = strtol(tmp_str, NULL, 16);

            err = at_tok_nextint(&line, &tmp_int);// AcT
            if (err < 0)
            {
                goto exit;
            }
            reg->type = (uint8)tmp_int;
        }
    }
    at_response_free(response);

    err = at_send_command_multiline(portType_2_portId(sim_id, port), "AT+CIREG?", "+CIREG:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        reg->ims_state = (uint8)0;
        err = 0;
        goto exit;
    }
    line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int); // n/stat
    if (err < 0)
    {
        goto exit;
    }
    if(at_tok_hasmore(&line)) {
        err = at_tok_nextint(&line, &tmp_int);// stat
        if (err < 0)
        {
            goto exit;
        }
        reg->ims_state = (uint8)tmp_int;
    } else {
        reg->ims_state = (uint8)tmp_int;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+EEMOPT=1
OK

// LTE
AT+EEMGINFO?
// <mcc>, <length of mnc>, <mnc>, <tac>, <PCI>, <dlEuarfcn>, < ulEuarfcn >, <band>, <dlBandwidth>,
// <rsrp>,<rsrq>, <sinr>,
// errcModeState,emmState,serviceState,IsSingleEmmRejectCause,EMMRejectCause,mmeGroupId,mmeCode,mTmsi,
// cellId,subFrameAssignType,specialSubframePatterns,transMode
// mainRsrp,diversityRsrp,mainRsrq,diversityRsrq,rssi,cqi,pathLoss,tb0DlTpt,tb1DlTpt,tb0DlPeakTpt,tb1DlPeakTpt,tb0UlPeakTpt,
// tb1UlPeakTpt,dlThroughPut,dlPeakThroughPut,averDlPRB,averCQITb0,averCQITb1,rankIndex,grantTotal,ulThroughPut,ulPeakThroughPut,currPuschTxPower,averUlPRB,
// dlBer, ulBer,
// diversitySinr, diversityRssi
+EEMLTESVC: 1120, 2, 0, 33584, 430, 40936, 40936, 41, 20,
0, 0, 0,
1, 10, 0, 1, 0, 1059, 78, 3959566565,
105149248, 2, 7, 7,
0, 0, 0, 0, 0, 0, 0, 1190919, 0, 0, 0, 16779777,
0, 5112867, 3959566565, 2, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0,
7, 44

// index,phyCellId,euArfcn,rsrp,rsrq
+EEMLTEINTER: 0, 65535, 38950, 0, 0

+EEMLTEINTER: 1, 0, 0, 0, 0

+EEMLTEINTER: 2, 0, 4294967295, 255, 255

+EEMLTEINTER: 3, 65535, 1300, 0, 0

+EEMLTEINTER: 4, 0, 0, 0, 0

+EEMLTEINTER: 5, 0, 4294967295, 247, 0

+EEMLTEINTER: 6, 197, 41332, 24, 9

+EEMLTEINTER: 7, 0, 0, 0, 0

+EEMLTEINTER: 8, 0, 0, 0, 0

+EEMLTEINTRA: 0, 429, 40936, 56, 12

+EEMLTEINTERRAT: 0,0

+EEMLTEINTERRAT: 1,0

+EEMGINFO: 3, 2         // <state>:
                        // 0: ME in Idle mode
                        // 1: ME in Dedicated mode
                        // 2: ME in PS PTM mode
                        // 3: invalid state
                        // <nw_type>:
                        // 0: GSM 1: UMTS 2: LTE

OK

// WCDMA
AT+EEMGINFO?
// Mode, sCMeasPresent, sCParamPresent, ueOpStatusPresent,

// if sCMeasPresent == 1
// cpichRSCP, utraRssi, cpichEcN0, sQual, sRxLev, txPower,
// endif

// if sCParamPresent == 1
// rac, nom, mcc, mnc_len, mnc, lac, ci,
// uraId, psc, arfcn, t3212, t3312, hcsUsed, attDetAllowed,
// csDrxCycleLen, psDrxCycleLen, utranDrxCycleLen, HSDPASupport, HSUPASupport,
// endif

// if ueOpStatusPresent == 1
// rrcState, numLinks, srncId, sRnti,
// algPresent, cipherAlg, cipherOn, algPresent, cipherAlg, cipherOn,
// HSDPAActive, HSUPAActive, MccLastRegisteredNetwork, MncLastRegisteredNetwork, TMSI, PTMSI, IsSingleMmRejectCause, IsSingleGmmRejectCause,
// MMRejectCause, GMMRejectCause, mmState, gmmState, gprsReadyState, readyTimerValueInSecs, NumActivePDPContext, ULThroughput, DLThroughput,
// serviceStatus, pmmState, LAU_status, LAU_count, RAU_status, RAU_count
// endif
//
+EEMUMTSSVC: 3, 1, 1, 1,
-80, 27, -6, -18, -115, -32768,
1, 1, 1120, 2, 1, 61697, 168432821,
15, 24, 10763, 0, 0, 0, 0,
128, 128, 65535, 0, 0,
2, 255, 65535, 4294967295,
0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 1, 1,
28672, 28672, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0

// index, cpichRSCP, utraRssi, cpichEcN0, sQual, sRxLev ,mcc, mnc, lac, ci, arfcn, psc
+EEMUMTSINTRA: 0, -32768, -1, -32768, -18, -115, 0, 0, 65534, 1, 10763, 32

+EEMUMTSINTRA: 1, -1, -32768, -18, -115, 0, 0, 65534, 2, 10763, 40, 32768

+EEMUMTSINTRA: 2, -32768, -18, -115, 0, 0, 65534, 3, 10763, 278, 32768, 65535

+EEMUMTSINTRA: 3, -18, -115, 0, 0, -2, 4, 10763, 28, 32768, 65535, 32768

+EEMUMTSINTRA: 4, -115, 0, 0, -2, 5, 10763, 270, 32768, 65535, 32768, 65518

+EEMUMTSINTRA: 5, 0, 0, -2, 6, 10763, 286, 32768, 65535, 32768, 65518, 65421

+EEMUMTSINTRA: 6, 0, -2, 7, 10763, 80, 32768, 65535, 32768, 65518, 65421, 0

+EEMUMTSINTRA: 7, -2, 8, 10763, 206, -32768, 65535, 32768, 65518, 65421, 0, 0

+EEMUMTSINTRA: 8, 9, 10763, 11, -32768, -1, 32768, 65518, 65421, 0, 0, 65534

+EEMUMTSINTRA: 9, 10763, 19, -32768, -1, -32768, 65518, 65421, 0, 0, 65534, 11

+EEMUMTSINTRA: 10, 232, -32768, -1, -32768, -18, 65421, 0, 0, 65534, 12, 10763

+EEMUMTSINTRA: 11, -32768, -1, -32768, -18, -115, 0, 0, 65534, 13, 10763, 66

+EEMUMTSINTRA: 12, -1, -32768, -18, -115, 0, 0, 65534, 14, 10763, 216, 32768

+EEMUMTSINTRA: 13, -32768, -18, -115, 0, 0, 65534, 15, 10763, 183, 32768, 65535

+EEMUMTSINTRA: 14, -18, -115, 0, 0, -2, 16, 10763, 165, 32768, 65535, 32768

+EEMUMTSINTRA: 15, -115, 0, 0, -2, 17, 10763, 151, 32768, 65535, 32768, 65518

+EEMUMTSINTRA: 16, 0, 0, -2, 18, 10763, 43, 32768, 65535, 32768, 65518, 65421

+EEMUMTSINTRA: 17, 0, -2, 19, 10763, 72, 32768, 65535, 32768, 65518, 65421, 0

+EEMUMTSINTRA: 18, -2, 20, 10763, 157, -32768, 65535, 32768, 65518, 65421, 0, 0

+EEMUMTSINTRA: 19, 21, 10763, 165, -32768, -1, 32768, 65518, 65421, 0, 0, 65534

+EEMUMTSINTRA: 20, 10763, 301, -32768, -1, -32768, 65518, 65421, 0, 0, 65534, 23

+EEMUMTSINTRA: 21, 23, -32768, -1, -32768, -18, 65421, 0, 0, 65534, 24, 10763

+EEMUMTSINTRA: 22, -32768, -1, -32768, -18, -115, 0, 0, 65534, 25, 10763, 0

+EEMUMTSINTRA: 23, -1, -32768, -18, -115, 0, 0, 65534, 26, 10763, 167, 32768

+EEMUMTSINTRA: 24, -32768, -18, -115, 0, 0, 65534, 27, 10763, 34, 32768, 65535

+EEMUMTSINTRA: 25, -18, -115, 0, 0, -2, 28, 10763, 313, 32768, 65535, 32768

+EEMUMTSINTRA: 26, -115, 0, 0, -2, 29, 10763, 152, 32768, 65535, 32768, 65518

+EEMUMTSINTRA: 27, 0, 0, -2, 30, 10763, 239, 0, 0, 0, 0, 0

+EEMUMTSINTRA: 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

+EEMUMTSINTRA: 29, 0, 0, 0, 0, -115, 0, 0, 65534, 30, 10763, 239

// index,gsmRssi,rxLev,C1,C2,mcc,mnc,lac,ci,arfcn,bsic
+EEMUMTSINTERRAT: 0, -32768, -107, -1, -1, 0, 0, 65534, 0, 117, 36

+EEMUMTSINTERRAT: 1, -107, -1, -1, 0, 0, 65534, 1, 72, 49, 0

+EEMUMTSINTERRAT: 2, -1, -1, 0, 0, 65534, 2, 119, 15, 32768, 149

+EEMUMTSINTERRAT: 3, -1, 0, 0, -2, 3, 121, 23, 0, 0, 0

+EEMGINFO: 3, 1

OK


// GSM
AT+EEMGINFO?
+EEMGINFOBASIC: 2

// mcc, mnc_len, mnc, lac, ci, nom, nco,
// bsic, C1, C2, TA, TxPwr,
// RxSig, RxSigFull, RxSigSub, RxQualFull, RxQualSub,
// ARFCB_tch, hopping_chnl, chnl_type, TS, PacketIdle, rac, arfcn,
// bs_pa_mfrms, C31, C32, t3212, t3312, pbcch_support, EDGE_support,
// ncc_permitted, rl_timeout, ho_count, ho_succ, chnl_access_count, chnl_access_succ_count,
// gsmBand,channelMode
+EEMGINFOSVC: 1120, 2, 0, 32784, 24741, 2, 0,
63, 36, 146, 1, 7,
46, 42, 42, 7, 0,
53, 0, 8, 0, 1, 6, 53,
2, 0, 146, 42, 54, 0, 1,
1, 32, 0, 0, 0, 0,
0, 0

// PS_attached, attach_type, service_type, tx_power, c_value,
// ul_ts, dl_ts, ul_cs, dl_cs, ul_modulation, dl_modulation,
// gmsk_cv_bep, 8psk_cv_bep, gmsk_mean_bep, 8psk_mean_bep, EDGE_bep_period, single_gmm_rej_cause
// pdp_active_num, mac_mode, network_control, network_mode, EDGE_slq_measurement_mode, edge_status
+EEMGINFOPS: 1, 255, 0, 0, 0,
0, 0, 268435501, 1, 0, 0,
4, 0, 96, 0, 0, 0,
0, 0, 0, 65535, 0, 13350

+EEMGINFO: 0, 0

OK

*/
static int req_cell_info_get(mbtk_sim_type_enum sim_id, ATPortType_enum port, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;
    int buff_size = 0;
    // AT+EEMOPT=1 in the first.
    int err = at_send_command(portType_2_portId(sim_id, port), "AT+EEMOPT=1", &response);
    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    // Reset buffer in the first.
    memset(&cell_info, 0xFF, sizeof(mbtK_cell_pack_info_t));
    cell_info.running = true;
    cell_info.cell_list.num = 0;

    err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT+EEMGINFO?", "+EEMGINFO:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    // Now, cell infomation has get from URC message.

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    cell_info.cell_list.type = (uint8)tmp_int;
    cell_info.running = false;

#if 0
    while(lines_ptr)
    {
        // LTE
        if(strStartsWith(line, "+EEMLTESVC:")) // LTE Server Cell
        {

        }
        else if(strStartsWith(line, "+EEMLTEINTER:")) // LTE
        {

        }
        else if(strStartsWith(line, "+EEMLTEINTRA:")) // LTE
        {

        }
        else if(strStartsWith(line, "+EEMLTEINTERRAT:")) // LTE
        {

        }
        else if(strStartsWith(line, "+EEMGINFO:")) // <state>: 0: ME in Idle mode 1: ME in Dedicated mode 2: ME in PS PTM mode 3: invalid state
                                                   // <nw_type>: 0: GSM 1: UMTS 2: LTE
        {

        }
        // WCDMA
        else if(strStartsWith(line, "+EEMUMTSSVC:")) // WCDMA Server Cell
        {

        }
        else if(strStartsWith(line, "+EEMUMTSINTRA:")) // WCDMA
        {

        }
        else if(strStartsWith(line, "+EEMUMTSINTERRAT:")) // WCDMA
        {

        }
        // GSM
        else if(strStartsWith(line, "+EEMGINFOBASIC:")) // Basic information in GSM
        // 0: ME in Idle mode   1: ME in Dedicated mode   2: ME in PS PTM mode
        {

        }
        else if(strStartsWith(line, "+EEMGINFOSVC:")) // GSM Server Cell
        {

        }
        else if(strStartsWith(line, "+EEMGINFOPS:")) // PS
        {

        }


        lines_ptr = lines_ptr->p_next;
    }
#endif

exit:
    at_response_free(response);
    return buff_size;
}

static int req_cell_info_set(mbtk_sim_type_enum sim_id, ATPortType_enum port, const char *cmgl, char *reg, int len, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[500] = {0};
	char data[218] = {0};
    int err = 0;

	memcpy(data, cmgl, len);

	sprintf(cmd, "AT*CELL=%s", data);

	if(strlen(cmd) > 0)
	{
        err = at_send_command_multiline(portType_2_portId(sim_id, port), cmd, "", &response);
		if (err < 0 || response->success == 0 || !response->p_intermediates){
			*cme_err = at_get_cme_error(response);
			goto exit;
		}

        ATLine* lines_ptr = response->p_intermediates;
        char *line = NULL;
//        int reg_len = 0;
//		bool flag = false;
        while(lines_ptr)
        {
            line = lines_ptr->line;
            if(line ==NULL)
            {
                LOGD("line is null----------------------");
            }
            lines_ptr = lines_ptr->p_next;
        }
	}
    err = 0;
	memcpy(reg, "req_cell_info_set succss", strlen("req_cell_info_set succss"));
exit:
    at_response_free(response);
    return err;
}

/*
AT+OOSPP=1
or
AT+OOSPP=0
or
AT+OOSPP=1,20,30,40 //AtOospp()
 param1mode
 param2oosPhasePeriod[0] //5 times, 5s by default;
 param3oosPhasePeriod[1] //5 times, 10s by default;
 param4oosPhasePeriod[2] //unlimited, 20s by default;


BTW
1, ֻmode=1ã൱ܴ򿪣ʱܵĬֵ
2, mode=1ò󣬹ܴ򿪣ʱǱõֵ
3mode=0൱ܹرգƽ̨Լһ׵á
ƽ̨һ׼ҲʷƵȴ߼Ҫǽд
ṩǵAT+OOSPPָǿԶ
*/
static int req_oos_set(mbtk_sim_type_enum sim_id, ATPortType_enum port, const mbtk_ril_oos_info_t* oos_info, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[100] = {0};
    int err = 0;

    if ((oos_info->state == 1 && oos_info->oosPhase[0] == 0 && oos_info->oosPhase[1] == 0 && oos_info->oosPhase[2] == 0) \
        || oos_info->state == 0)
    {
        sprintf(cmd, "AT+OOSPP=%d", oos_info->state);//ֻһֵ0/1
    }
    else
    {
        if ((oos_info->oosPhase[0] != 0) && (oos_info->oosPhase[1] != 0) && (oos_info->oosPhase[2] != 0))
        {
            sprintf(cmd, "AT+OOSPP=%d,%d,%d,%d", oos_info->state, oos_info->oosPhase[0], oos_info->oosPhase[1], oos_info->oosPhase[2]);
        }
        else if ((oos_info->oosPhase[0] != 0) && (oos_info->oosPhase[1] != 0) && (oos_info->oosPhase[2] == 0))
        {
            sprintf(cmd, "AT+OOSPP=%d,%d,%d", oos_info->state, oos_info->oosPhase[0], oos_info->oosPhase[1]);
        }
        else if ((oos_info->oosPhase[0] != 0) && (oos_info->oosPhase[1] == 0) && (oos_info->oosPhase[2] == 0))
        {
            sprintf(cmd, "AT+OOSPP=%d,%d", oos_info->state, oos_info->oosPhase[0]);
        }
        else
        {
            LOGE("AT+OOSPP SET ERR");
            goto exit;
        }
    }

    LOGI("Set the oos command is = [%s]\n", cmd);
    err = at_send_command(portType_2_portId(sim_id, port), cmd, &response);
    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+OOSPP?
(Ĭֵ)
+OOSPP:5,10,20
أ
+OOSPP:0
*/
static int req_oos_get(mbtk_sim_type_enum sim_id, ATPortType_enum port, mbtk_ril_oos_info_t *oos_info, int *cme_err)
{
    ATResponse *response = NULL;

    int err = at_send_command_singleline(portType_2_portId(sim_id, port), "AT+OOSPP?", "+OOSPP:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;

    char *tmp_str = NULL;
    err = at_tok_start(&line);//+OOSPP:10,15,20,+OOSPP:
    if (err < 0)
    {
        goto exit;
    }

    //LOG("req_oos_get =[%s]",line);

    err = at_tok_nextstr(&line, &tmp_str);
    if (err < 0)
    {
        goto exit;
    }

    int mode = atoi(tmp_str);
    if (mode == 0)//ر״̬
    {
        oos_info->state = mode;
    }
    else//״̬
    {
        oos_info->state = 1;
        //LOG("tmp_str =[%s]",tmp_str);
        oos_info->oosPhase[0] = mode;  //modify by hq at 2025/08/28

        err = at_tok_nextstr(&line, &tmp_str);
        if (err < 0)
        {
            goto exit;
        }
        //LOG("tmp_str =[%s]",tmp_str);
        oos_info->oosPhase[1] = atoi(tmp_str);

        err = at_tok_nextstr(&line, &tmp_str);
        if (err < 0)
        {
            goto exit;
        }
        //LOG("tmp_str =[%s]",tmp_str);
        oos_info->oosPhase[2] = atoi(tmp_str);
    }

exit:
    at_response_free(response);
    return err;
}

//void net_list_free(void *data);
// Return MBTK_INFO_ERR_SUCCESS,will call pack_error_send() to send RSP.
// Otherwise, do not call pack_error_send().
mbtk_ril_err_enum net_pack_req_process(sock_cli_info_t* cli_info, ril_msg_pack_info_t* pack)
{
    mbtk_ril_err_enum err = MBTK_RIL_ERR_SUCCESS;
    int cme_err = MBTK_RIL_ERR_CME_NON;
    LOGD("lynq rild 51, simid %d port %d %d",cli_info->sim_id,cli_info->port,pack->msg_id);
    switch(pack->msg_id)
    {
        case RIL_MSG_ID_NET_AVAILABLE:
        {
            if(pack->data_len == 0 || pack->data == NULL)
            {
                mbtk_net_info_array_t net_array;
                memset(&net_array, 0, sizeof(mbtk_net_info_array_t));
                if(req_available_net_get(cli_info->sim_id, cli_info->port, &net_array, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                    LOGD("Get Available Net fail.");
                }
                else
                {
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, &net_array, sizeof(mbtk_net_info_array_t));
                }
            }
            else     // Set
            {
                err = MBTK_RIL_ERR_UNSUPPORTED;
                LOGW("Unsupport set available net.");
            }
            break;
        }
        case RIL_MSG_ID_NET_SEL_MODE:
        {
            if(pack->data_len == 0 || pack->data == NULL)
            {
                mbtk_net_info_t info;
                memset(&info, 0, sizeof(mbtk_net_info_t));
                if(req_net_sel_mode_get(cli_info->sim_id, cli_info->port, &info, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                    LOGD("Get Net sel mode fail.");
                }
                else
                {
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, &info, sizeof(mbtk_net_info_t));
                }
            }
            else     // Set
            {
                mbtk_net_info_t *info = (mbtk_net_info_t*)pack->data;
                if(req_net_sel_mode_set(cli_info->sim_id, cli_info->port, info, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                    LOGD("Set Net sel mode fail.");
                }
                else
                {
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, NULL, 0);
                }
            }
            break;
        }
        case RIL_MSG_ID_NET_BAND:
        {
            if(pack->data_len == 0 || pack->data == NULL)
            {
                err = MBTK_RIL_ERR_REQ_PARAMETER;
                LOG("No data found.");
            }
            else     // Set
            {
                if(pack->data_len == sizeof(uint8)) {
                    if(*(pack->data)) { // Get current bands.
                        mbtk_band_info_t band;
                        memset(&band, 0x0, sizeof(mbtk_band_info_t));
                        if(req_band_get(cli_info->sim_id, cli_info->port, &band, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                        {
                            if(cme_err != MBTK_RIL_ERR_CME_NON) {
                                err = MBTK_RIL_ERR_CME + cme_err;
                            } else {
                                err = MBTK_RIL_ERR_UNKNOWN;
                            }
                            LOG("Get net band fail.");
                        }
                        else
                        {
                            ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, &band, sizeof(mbtk_band_info_t));
                        }
                    } else { // Get support bands.
                        ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, &band_info.band_support, sizeof(mbtk_band_info_t));
                    }
                } else { // Set current bands.
                    mbtk_band_info_t* band = (mbtk_band_info_t*)pack->data;
                    if(pack->data_len != sizeof(mbtk_band_info_t))
                    {
                        err = MBTK_RIL_ERR_REQ_PARAMETER;
                        LOG("Set net band error.");
                        break;
                    }

                    if(req_band_set(cli_info->sim_id, cli_info->port, band, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_RIL_ERR_CME_NON) {
                            err = MBTK_RIL_ERR_CME + cme_err;
                        } else {
                            err = MBTK_RIL_ERR_UNKNOWN;
                        }
                        LOG("Set net band fail.");
                    }
                    else
                    {
                        ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, NULL, 0);
                    }
                }
            }
            break;
        }
        case RIL_MSG_ID_NET_SIGNAL:
        {
            if(pack->data_len == 0 || pack->data == NULL)
            {
                mbtk_signal_info_t signal;
                memset(&signal, 0, sizeof(mbtk_signal_info_t));
                if(req_net_signal_get(cli_info->sim_id, cli_info->port, &signal, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                    LOGD("Get net signal fail.");
                }
                else
                {
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, &signal, sizeof(mbtk_signal_info_t));
                }
            }
            else     // Set
            {
                err = MBTK_RIL_ERR_UNSUPPORTED;
                LOGW("Unsupport set net signal.");
            }
            break;
        }
        case RIL_MSG_ID_NET_REG:
        {
            if(pack->data_len == 0 || pack->data == NULL)
            {
                mbtk_net_reg_info_t net_reg;
                memset(&net_reg, 0, sizeof(mbtk_net_reg_info_t));
                if(req_net_reg_get(cli_info->sim_id, cli_info->port, &net_reg, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                    LOGD("Get Net reg info fail.");
                }
                else
                {
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, &net_reg, sizeof(mbtk_net_reg_info_t));
                }
            }
            else     // Set
            {
                err = MBTK_RIL_ERR_UNSUPPORTED;
                LOGW("Unsupport set net reg info.");
            }
            break;
        }
        case RIL_MSG_ID_NET_CELL:
        {
            if(pack->data_len == 1 || pack->data == NULL)   // Get net cell.   //  data_len == 1 is wrote by hq at 2025/08/26 for bug 2187
            {
                if(req_cell_info_get(cli_info->sim_id, cli_info->port, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                    LOG("Get net cell fail.");
                }
                else
                {
                    LOG("req_cell_info_get() success,cell number: %d", cell_info.cell_list.num);
                    LOGD("data_len = %d", sizeof(mbtk_cell_info_array_t));
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, &cell_info.cell_list, sizeof(mbtk_cell_info_array_t));
                }
            }
            else     // Lock cell
            {
                char *mem = (char*)(pack->data);
                int len = pack->data_len;
                char reg[100] = {0};
                if(req_cell_info_set(cli_info->sim_id, cli_info->port, mem, reg, len, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                }
                else
                {
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, reg, strlen(reg));
                }
            }
            break;
        }
        case RIL_MSG_ID_NET_OOS:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get net oos.
            {
                mbtk_ril_oos_info_t oos_info;
                memset(&oos_info, 0, sizeof(mbtk_ril_oos_info_t));
                if(req_oos_get(cli_info->sim_id, cli_info->port, &oos_info, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                    LOG("Get net oos fail.");
                }
                else
                {
                    LOG("req_oos_get() success,cell number: %d", oos_info.state);
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, &oos_info, sizeof(mbtk_ril_oos_info_t));
                }
            }
            else     // Set net oos.
            {
                mbtk_ril_oos_info_t *oos_info = (mbtk_ril_oos_info_t*)(pack->data);
                if(req_oos_set(cli_info->sim_id, cli_info->port, oos_info, &cme_err) || cme_err != MBTK_RIL_ERR_CME_NON)
                {
                    if(cme_err != MBTK_RIL_ERR_CME_NON) {
                        err = MBTK_RIL_ERR_CME + cme_err;
                    } else {
                        err = MBTK_RIL_ERR_UNKNOWN;
                    }
                }
                else
                {
                    ril_rsp_pack_send(cli_info->sim_id, cli_info->port, cli_info->fd, pack->msg_id, pack->msg_index, NULL, 0);
                }
            }
            break;
        }
        default:
        {
            err = MBTK_RIL_ERR_REQ_UNKNOWN;
            LOG("Unknown request : %s", id2str(pack->msg_id));
            break;
        }
    }

    return err;
}

