#include <string.h>
#include "aboot-tiny.h"
#include "jacana_callback.h"

/*---------------------------------------------------------------------------*/
static aboot_tiny_error_t rc;
/*---------------------------------------------------------------------------*/
aboot_tiny_error_t
jacana_aboot_tiny_get_result(void)
{
  return rc;
}
/*---------------------------------------------------------------------------*/
void
jacana_aboot_tiny_set_result(aboot_tiny_error_t r)
{
  rc = r;
}
/*---------------------------------------------------------------------------*/
void
jacana_aboot_tiny_callback(const aboot_tiny_message_t *msg)
{
  switch(msg->event) {
  case ABOOT_TINY_EVENT_START:
    if(msg->u.message) {
      aboot_tiny_log_printf("%s\n", msg->u.message);
    }
    if(!msg->error) {
      if(!aboot_tiny_download()) {
        break;
      }
    } else {
      rc = msg->error;
      aboot_tiny_stop();
    }
    break;

  case ABOOT_TINY_EVENT_DOWNLOAD:
    if(msg->u.message) {
      aboot_tiny_log_printf("%s\n", msg->u.message);
    }
    if(msg->error) {
      rc = msg->error;
      aboot_tiny_stop();
    }
    break;

  case ABOOT_TINY_EVENT_STOP:
    if(msg->u.message) {
      aboot_tiny_log_printf("%s\n", msg->u.message);
    }
    aboot_tiny_exit();
    break;

  case ABOOT_TINY_EVENT_PROGRESS:
    aboot_tiny_log_printf("PROGRESS: %d\n", msg->u.progress);
    break;

  case ABOOT_TINY_EVENT_STATUS:
    aboot_tiny_log_printf("STATUS: %s\n", msg->u.status);
    if(msg->error ||
       !strcmp(msg->u.status, ABOOT_TINY_STATUS_FAILED) ||
       !strcmp(msg->u.status, ABOOT_TINY_STATUS_SUCCEEDED)) {
      rc = msg->error;
      aboot_tiny_stop();
    }
    break;

  default:
    aboot_tiny_log_printf("Unknown event: %d\n", msg->event);
    break;
  }
}
/*---------------------------------------------------------------------------*/
