/*
 * mbtk_list.c
 *
 *  Created on: Aug 18, 2020
 *      Author: lb
 */
#include <string.h>
#include <stdlib.h>
#include "mbtk_list.h"

list_node_t* list_create(list_free_func free_func)
{
    list_node_t *list = (list_node_t*) malloc(sizeof(list_node_t));
    if (list) {
        memset(list, 0x0, sizeof(list_node_t));
        list->size = 0;
        list->cur_index = 0;
        list->cur_array_data = NULL;
        list->sort_func = NULL;
        list->free_func = free_func;
        return list;
    }

    return NULL;
}

uint32 list_size(list_node_t *list)
{
    if (list) {
        return list->size;
    } else {
        return 0;
    }
}

static list_treenode_t* list_treeadd(list_node_t *list, list_treenode_t *node,
        list_arraynode_t *data)
{
    if (node && node->data) {
        int result = list->sort_func(data->data, node->data->data);
        if (result == 0) { // Same node
            node->count++;
            // printf("Same[%d]:%s\n", node->count, data->data);

            // Add the same node to last.
            list_arraynode_t *array_node = node->data;
            while (array_node->next) {
                array_node = array_node->next;
            }
            array_node->next = data;
            array_node->next->next = NULL;

        } else if (result < 0) {
            node->left = list_treeadd(list, node->left, data);
        } else {
            node->right = list_treeadd(list, node->right, data);
        }
    } else {
        if (!node) {
            node = (list_treenode_t*) malloc(sizeof(list_treenode_t));
        }
        node->left = NULL;
        node->right = NULL;
        node->data = data;
        node->count = 1;
    }

    return node;
}

void list_add(list_node_t *list, void *data)
{
    if (list && data) {
        list_arraynode_t *node = &(list->array_data);
        while (node->next) {
            node = node->next;
        }

        node->next = (list_arraynode_t*) malloc(sizeof(list_arraynode_t));
        if(node->next) {
            node->next->data = data;
            node->next->next = NULL;
            list->size++;
        }
    }
}

void list_add_unique(list_node_t *list, void *data, uint32 len)
{
    if (list && data && len > 0) {
        list_arraynode_t *node = &(list->array_data);
        while (node->next) {
            if (!memcmp(node->next->data, data, len)) {
                return;
            }
            node = node->next;
        }

        node->next = (list_arraynode_t*) malloc(sizeof(list_arraynode_t));
        node->next->data = data;
        node->next->next = NULL;

        list->size++;
    }
}

void* list_remove(list_node_t *list, void *data)
{
    if (list) {
        list_arraynode_t *node = list->array_data.next;
        if (node) {
            if (data == node->data) { // Find node
                list_arraynode_t *result = node;
                void *reault_data = result->data;
                list->array_data.next = node->next;
                free(result);
                list->size--;
                return reault_data;
            }
        } else {
            return NULL;
        }

        while (node->next) {
            if (data == node->next->data) { // Find node
                list_arraynode_t *result = node->next;
                void *reault_data = result->data;
                node->next = node->next->next;
                free(result);
                list->size--;
                return reault_data;
            }
            node = node->next;
        }
    }

    return NULL;
}

void* list_remove_by_content(list_node_t *list, void *data, uint32 data_len)
{
    if (list) {
        list_arraynode_t *node = list->array_data.next;
        if (node) {
            if (!memcmp(data, node->data, data_len)) { // Find node
                list_arraynode_t *result = node;
                void *reault_data = result->data;
                list->array_data.next = node->next;
                free(result);
                list->size--;
                return reault_data;
            }
        } else {
            return NULL;
        }

        while (node->next) {
            if (!memcmp(data, node->next->data, data_len)) { // Find node
                list_arraynode_t *result = node->next;
                void *reault_data = result->data;
                node->next = node->next->next;
                free(result);
                list->size--;
                return reault_data;
            }
            node = node->next;
        }
    }

    return NULL;
}

void list_first(list_node_t *list)
{
    if (list) {
        list->cur_index = 0;
        list->cur_array_data = list->array_data.next;
    }
}

void* list_next(list_node_t *list)
{
    if (list) {
        list_arraynode_t *node = list->cur_array_data;
        if (node) {
            list->cur_array_data = list->cur_array_data->next;
            list->cur_index++;

            return node->data;
        } else {
            return NULL;
        }
    } else {
        return NULL;
    }
}

void* list_get(list_node_t *list, uint32 index)
{
    if (list) {
        if (index >= list->size) {
            return NULL;
        }

        list_arraynode_t *node = list->array_data.next;
        if (node) {
            uint32 i = 0;
            while (node) {
                if (i == index) {
                    return node->data;
                }
                node = node->next;
                i++;
            }
        }

        return NULL;
    } else {
        return NULL;
    }
}

static void list_treenext(list_node_t *list, list_treenode_t *tree_node)
{
    if (list && tree_node) {
        list_treenode_t *left = tree_node->left;
        list_treenode_t *right = tree_node->right;
        list_treenext(list, left);

        list_arraynode_t *array_node = tree_node->data;
        while (array_node) {
            list->cur_array_data->next = array_node;
            list->cur_array_data = array_node;
            array_node = array_node->next;
        }
        list_treenext(list, right);
    }
}

static void list_treefree(list_node_t *list, list_treenode_t *tree_node)
{
    if (list && tree_node) {
        list_treefree(list, tree_node->left);
        list_treefree(list, tree_node->right);

        if (&(list->tree_data) != tree_node) {
            free(tree_node);
            tree_node = NULL;
        }
    }
}

void list_sort(list_node_t *list, list_sort_func sort_func)
{
    if (list && sort_func) {
        list->sort_func = sort_func;
        list_arraynode_t *node = list->array_data.next; // First node
        if (node) {
            uint32 i = 0;
            list_arraynode_t **temp = (list_arraynode_t **) malloc(
                    sizeof(list_arraynode_t*) * list->size);
            list_arraynode_t *temp_node = node;
            while (node) {
                temp[i] = node;
                temp_node = node;
                node = node->next;
                temp_node->next = NULL;
                i++;
            }

            for (i = 0; i < list->size; i++) {
                list_treeadd(list, &(list->tree_data), temp[i]);
            }

            /*while (node) {
             list_treeadd(list, &(list->tree_data), node);
             node = node->next;
             }*/

            // Sort complete.
            list->cur_array_data = &(list->array_data);
            list_treenext(list, &(list->tree_data));

            list_treefree(list, &(list->tree_data));
            free(temp);
        }
    }
}

void list_free(list_node_t *list)
{
    if (list) {
        list_arraynode_t *node = &(list->array_data); // Head node
        list_arraynode_t *node_temp = NULL;
        while (node->next) {
            node_temp = node->next;
            node->next = node->next->next;

            if (list->free_func) {
                list->free_func(node_temp->data);
            } else {
                free(node_temp->data);
            }
            free(node_temp);
        }
        free(list);
    }
}

void list_clear(list_node_t *list)
{
    if (list) {
        list_arraynode_t *node = &(list->array_data); // Head node
        list_arraynode_t *node_temp = NULL;
        while (node->next) {
            node_temp = node->next;
            node->next = node->next->next;

            if (list->free_func) {
                list->free_func(node_temp->data);
            }
            free(node_temp);
        }
        list_free_func free_func = list->free_func;
        memset(list, 0x0, sizeof(list_node_t));
        list->size = 0;
        list->cur_index = 0;
        list->cur_array_data = NULL;
        list->sort_func = NULL;
        list->free_func = free_func;
    }
}
