/*
*    mbtk_version.c
*
*    mbtk_source compilation informations.
*
*/
/******************************************************************************

                          EDIT HISTORY FOR FILE

  WHEN        WHO       WHAT,WHERE,WHY
--------    --------    -------------------------------------------------------
2024/6/7     LiuBin      Initial version

******************************************************************************/
#include "mbtk_version.h"
#include "mbtk_log.h"

#define STR_GET(str) (#str)

static mbtk_build_def_info_t def_infos[MBTK_BUILD_DEF_NUM];
static bool inited = FALSE;

static void def_item_set(mbtk_build_define_enum def_id, char *name, char *value)
{
    switch(def_id)
    {
        case MBTK_BUILD_DEF_AF_SUPPORT:
        {
            strcpy(name, STR_GET(MBTK_BUILD_DEF_AF_SUPPORT));
#ifdef MBTK_AF_SUPPORT
            strcpy(value, "Y");
#else
            strcpy(value, "N");
#endif
            break;
        }
        case MBTK_BUILD_DEF_YX_SUPPORT:
        {
            strcpy(name, STR_GET(MBTK_BUILD_DEF_YX_SUPPORT));
#ifdef MBTK_YX_SUPPORT
            strcpy(value, "Y");
#else
            strcpy(value, "N");
#endif
            break;
        }
        case MBTK_BUILD_DEF_SG_SUPPORT:
        {
            strcpy(name, STR_GET(MBTK_BUILD_DEF_SG_SUPPORT));
#ifdef MBTK_SG_SUPPORT
            strcpy(value, "Y");
#else
            strcpy(value, "N");
#endif
            break;
        }
        case MBTK_BUILD_DEF_MBTK_ALL_CID_SUPPORT:
        {
            strcpy(name, STR_GET(MBTK_BUILD_DEF_MBTK_ALL_CID_SUPPORT));
#ifdef MBTK_ALL_CID_SUPPORT
            strcpy(value, "Y");
#else
            strcpy(value, "N");
#endif
            break;
        }
        case MBTK_BUILD_DEF_MBTK_GNSS_MODE:
        {
            strcpy(name, STR_GET(MBTK_BUILD_DEF_MBTK_GNSS_MODE));
#if defined(MBTK_GNSS_6228)
            strcpy(value, "6228");
#elif defined(MBTK_GNSS_5311)
            strcpy(value, "5311");
#else
            strcpy(value, "Unknown");
#endif
            break;
        }
        case MBTK_BUILD_DEF_MBTK_DUMP_SUPPORT:
        {
            strcpy(name, STR_GET(MBTK_BUILD_DEF_MBTK_DUMP_SUPPORT));
#ifdef MBTK_DUMP_SUPPORT
            strcpy(value, "Y");
#else
            strcpy(value, "N");
#endif
            break;
        }
        default:
        {
            strcpy(name, "Unknown");
            strcpy(value, "Unknown");
            break;
        }
    }
}

static void def_info_reset()
{
    if(!inited) {
        int index = 0;
        while(index < MBTK_BUILD_DEF_NUM) {
            memset(&(def_infos[index]), 0, sizeof(mbtk_build_def_info_t));
            def_item_set(index, def_infos[index].name, def_infos[index].value);
            index++;
        }
        inited = TRUE;
    }
}

void mbtk_build_def_get(char *buff, int buff_len)
{
    if(buff && buff_len > 0) {
        def_info_reset();

        int len = 0;
        int index = 0;
        while(index < MBTK_BUILD_DEF_NUM) {
            len += snprintf(buff + len, buff_len - len, "%s:%s\n", def_infos[index].name, def_infos[index].value);
            index++;
        }
    }
}

void mbtk_lib_info_print()
{
    MBTK_SOURCE_INFO_PRINT("mbtk_lib");
}

