/*******************************************************************************
 * Copyright (c) 2014 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Allan Stockdill-Mander - initial API and implementation and/or initial documentation
 *******************************************************************************/
// #include <openssl/ssl.h>
// #include <openssl/err.h>
#include "MQTTLinux.h"
//#include "global.h"
//#include "DC_iot_port.h"
#include "mbtk_sock2.h"
#define TIMEOUT 60*1000

char expired(Timer* timer)
{
	struct timeval now, res;
	gettimeofday(&now, NULL);
	timersub(&timer->end_time, &now, &res);
	return res.tv_sec < 0 || (res.tv_sec == 0 && res.tv_usec <= 0);
}


void countdown_ms(Timer* timer, unsigned int timeout)
{
	struct timeval now;
	gettimeofday(&now, NULL);
	struct timeval interval = {timeout / 1000, (timeout % 1000) * 1000};
	timeradd(&now, &interval, &timer->end_time);
}


void countdown(Timer* timer, unsigned int timeout)
{
	struct timeval now;
	gettimeofday(&now, NULL);
	struct timeval interval = {timeout, 0};
	timeradd(&now, &interval, &timer->end_time);
}


int left_ms(Timer* timer)
{
	struct timeval now, res;
	gettimeofday(&now, NULL);
	timersub(&timer->end_time, &now, &res);
	//printf("left %d ms\n", (res.tv_sec < 0) ? 0 : res.tv_sec * 1000 + res.tv_usec / 1000);
	return (res.tv_sec < 0) ? 0 : res.tv_sec * 1000 + res.tv_usec / 1000;
}


void InitTimer(Timer* timer)
{
	timer->end_time = (struct timeval){0, 0};
}


int linux_read(Network* n, unsigned char* buffer, int len, int timeout_ms)
{

    int err;
    int read_len = mbtk_sock_read(n->handle,n->my_socket, buffer, len, TIMEOUT, &err);
    if(read_len < 0) {
        if(err == MBTK_SOCK_ETIMEOUT) {
            return -2;
        } else {
            return -1;
        }
    } else {
        return read_len;
    }



#if 0

	struct timeval interval = {timeout_ms / 1000, (timeout_ms % 1000) * 1000};
	//mDEBUG("[%s]timeout_ms = %d \n", __FUNCTION__, timeout_ms);
	if (interval.tv_sec < 0 || (interval.tv_sec == 0 && interval.tv_usec <= 0))
	{
		interval.tv_sec = 0;
		interval.tv_usec = 100;
	}

	setsockopt(n->my_socket, SOL_SOCKET, SO_RCVTIMEO, (char *)&interval, sizeof(struct timeval));

	int bytes = 0;
	while (bytes < len)
	{

		int rc = recv(n->my_socket, &buffer[bytes], (size_t)(len - bytes), 0);
		//mDEBUG("[%s]socket recv rc = %d \n", __FUNCTION__, rc);

		if(rc == 0)
		{
			 //mDEBUG("[%s]socket close \n", __FUNCTION__);
			 bytes = 0;
			 break;
		}
		
		if (rc == -1)
		{
			if (errno != ENOTCONN && errno != ECONNRESET)
			{
				bytes = -1;
				break;
			}
		}
		else
			bytes += rc;
	}
	return bytes;
#endif
}


int linux_write(Network* n, unsigned char* buffer, int len, int timeout_ms)
{

    int err;
    printf("Write[%d]:%s",len,(char*)buffer);
    return mbtk_sock_write(n->handle, n->my_socket, buffer, len, TIMEOUT, &err);

#if 0
	struct timeval tv;

	tv.tv_sec = 0;  /* 30 Secs Timeout */
	tv.tv_usec = timeout_ms * 1000;  // Not init'ing this can cause strange errors

	setsockopt(n->my_socket, SOL_SOCKET, SO_RCVTIMEO, (char *)&tv,sizeof(struct timeval));

	int	rc = write(n->my_socket, buffer, len);

	return rc;
#endif
}


void linux_disconnect(Network* n)
{
    int errno;
    mbtk_sock_close(n->handle,n->my_socket,TIMEOUT,&errno);
}


void NewNetwork(Network* n)
{

	n->my_socket = 0;
	n->mqttread = linux_read;
	n->mqttwrite = linux_write;
	n->disconnect = linux_disconnect;
    n->ingnore_cert = true;
    n->is_support_ssl = false;
}


int ConnectNetwork(Network* n, char* addr, int port, bool is_support_ssl, bool ingnore_cert)
{
    mbtk_init_info *info ;
    mbtk_sock_info *sock_info;
    int rc = 0;
    int errno;
    info = NULL;
    sock_info = (mbtk_sock_info *)malloc(sizeof(mbtk_sock_info));
    if(sock_info ==NULL)
    {
        rc = -1;
        return rc;
    }
    memcpy(sock_info->address, addr, strlen(addr));
    sock_info->port = port;
    sock_info->is_support_ssl = is_support_ssl;
    sock_info->ingnore_cert = ingnore_cert;

    printf("host %s\nport %d\nis_support_ssl %d\ningnore_cert %d\n",sock_info->address,sock_info->port,sock_info->is_support_ssl,sock_info->ingnore_cert);

	mbtk_sock_handle handle = mbtk_sock_init(info);
    if (handle < 0 )
    {
        rc = -1;
        return rc;
    }

    int fd  = mbtk_sock_open(handle, sock_info, TIMEOUT, &errno);
    if(fd < 0)
    {
        rc = -1;
        return rc;
    }

    n->my_socket = fd;
    n->handle = handle;
	return rc;
}
