#include <stdio.h>
#include <string.h>

#define FOTA_FBFVERSION_IMAGEID	0x464F5456 //"FOTV"

#if 0
static int get_fota_version(const char *fname, char *mversion, size_t msize)
{
	FILE *fp;
	int ret;
	fp = fopen(fname, "rb");
	if (fp == NULL)
	{
		perror("fopen");
		return 1;
	}
	ret = 0;
	do
	{
		int num_img;
		size_t sz;
		char buf[64];
		sz = fread(buf, 1, 32, fp);
		if (sz < 32 || strncmp(buf, "Marvell_FBF", 11)) /* check FBF magic */
		{
			ret = 2;
			break;
		}
		sz = fread(buf, 1, 2, fp);
		if (sz < 2 || buf[0] != 11 || buf[1] != 0) /* check format version */
		{
			ret = 3;
			break;
		}
		ret = fseek(fp, 0x13C, SEEK_SET);
		if (ret)
		{
			perror("fseek");
			ret = 1;
			break;
		}
		sz = fread(&num_img, 1, 4, fp);
		if (sz < 4 || num_img <= 0) /* check number of images */
		{
			ret = 4;
			break;
		}
		ret = 5; /* not found */
		while (num_img--)
		{
			sz = fread(buf, 1, 52, fp);
			if (sz < 52) /* check ImageStruct_11 size */
			{
				ret = 6;
				break;
			}
			if (*(int *)buf == FOTA_FBFVERSION_IMAGEID) /* check image ID */
			{
				unsigned offset = ((int *)buf)[5];
				offset <<= 13; /* 8KB sectors */
				ret = fseek(fp, offset, SEEK_SET);
				if (ret)
				{
					perror("fseek");
					ret = 1;
					break;
				}
				sz = fread(mversion, 1, msize, fp);
				if (sz < msize || strnlen(mversion, sz) == sz) /* check ASCIIZ */
				{
					ret = 7;
					break;
				}
				if (strncmp(mversion, "OTA", 3)) /* check prefix */
				{
					/* treat as successful */
				}
				else
				{
					char *p;
					switch (mversion[3])
					{
						case '0': /* FOTA */
							p = strchr(mversion, ';');
							if (p)
							{
								sz = p - mversion - 4;
								memmove(mversion, mversion + 4, sz);
								mversion[sz] = '\0';
							}
							else
							{
								ret = 8;
							}
							break;
						case '4': /* DFOTA */
							p = strchr(mversion, ';');
							if (p)
							{
								char *q = p + 1;
								p = strchr(q, ';');
								if (p)
								{
									sz = p - q;
									memmove(mversion, q, sz);
									mversion[sz] = '\0';
								}
								else
								{
									ret = 9;
								}
							}
							else
							{
								ret = 8;
							}
							break;
						default:
							ret = 7;
							break;
					}
				}
				break;
			}
		}
	} while (0);
	fclose(fp);
	return ret;
}
#endif
