/*-----------------------------------------------------------------------------------------------*/
/**
  @file reboot_reason.c
  @brief set reboot reason
*/
/*-----------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  Copyright (c) 2024 mobiletek Wireless Solution, Co., Ltd. All Rights Reserved.
  mobiletek Wireless Solution Proprietary and Confidential.
-------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when       who          what, where, why
  --------   ---------    -----------------------------------------------------------------
  20250515    yq.wang      Created .
-------------------------------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <cutils/properties.h>

#include "mbtk_type.h"
#include "reboot_reason.h"
#include "mbtk_log.h"
#include "mbtk_device.h"

int reboot_reason_init(void)
{
    int ret = 0;
    char buff[32] = {0};
    mbtk_device_info_reboot_flag_enum reboot_reason = MBTK_REBOOT_FLAG_NORMAL;
    mbtk_device_info_basic_t info_basic = {0};
    memset(&info_basic, 0, sizeof(mbtk_device_info_basic_t));


    ret = mbtk_dev_info_read(MBTK_DEVICE_INFO_ITEM_BASIC, &(info_basic), sizeof(mbtk_device_info_basic_t));
    if(ret != 0)
    {
        LOGE("[%s] mbtk_dev_info_read(BASIC) fail.", __func__);
        reboot_reason = MBTK_REBOOT_FLAG_UNKNOWN;
    }
    else
    {
        if(info_basic.version == DEV_INFO_VERSION_V1) {
            reboot_reason = info_basic.basic.v1.reboot_flag;
            if(reboot_reason != MBTK_REBOOT_FLAG_NORMAL)
            {
                info_basic.basic.v1.reboot_flag = MBTK_REBOOT_FLAG_NORMAL;
                ret = mbtk_dev_info_write(MBTK_DEVICE_INFO_ITEM_BASIC, &info_basic, sizeof(mbtk_device_info_basic_t));
                if(ret != 0) {
                    LOGE("[%s] mbtk_dev_info_write(BASIC) fail.", __func__);
                }
            }
        } else {
            reboot_reason = info_basic.basic.v2.reboot_flag;
            if(reboot_reason != MBTK_REBOOT_FLAG_NORMAL)
            {
                info_basic.basic.v2.reboot_flag = MBTK_REBOOT_FLAG_NORMAL;
                ret = mbtk_dev_info_write(MBTK_DEVICE_INFO_ITEM_BASIC, &info_basic, sizeof(mbtk_device_info_basic_t));
                if(ret != 0) {
                    LOGE("[%s] mbtk_dev_info_write(BASIC) fail.", __func__);
                }
            }

        }
    }

    LOGD("[%s] reboot reason [%d].", __func__, reboot_reason);
    memset(buff, 0x0, 32);
    sprintf(buff, "%d", reboot_reason);
    property_set("persist.mbtk.reboot_reason", buff);

    LOGD("[%s] reboot reason exit.", __func__);

    return 0;
}

