#include "mbtk_audio.h"
#include "audio_if_types.h"
#include "audio_if_ubus.h"
#include "audio_if_parameter.h"
#include "audio_if.h"
#include "audio_if_api.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <libubox/blobmsg_json.h>
#include "libubus.h"
#include <string.h>
//#include "audio_if_audio_hw_mrvl.h"
//#include "utlEventHandler.h"
//#include "udev_monitor.h"
#include "audio_hw_mrvl.h"
#include <stdlib.h>
#include <stdio.h>
#include <cutils/str_parms.h>
#include "vcm.h"
#include <libavutil/avutil.h>
#include <libavutil/attributes.h>
#include <libavutil/opt.h>
#include <libavutil/mathematics.h>
#include <libavutil/imgutils.h>
#include <libavutil/samplefmt.h>
#include <libavutil/timestamp.h>
#include <libavformat/avformat.h>
#include <libavcodec/avcodec.h>
#include <libswscale/swscale.h>
#include <libavutil/mathematics.h>
#include <libswresample/swresample.h>
//#include <libavutil/channel_layout.h>
#include <libavutil/common.h>
#include <libavformat/avio.h>
#include <libavutil/file.h>
#include <libswresample/swresample.h>
#include <libavfilter/avfilter.h>


extern int mbtk_audio_play_stream_old(void *dev_hdl, const void *pData, int len);
extern int mbtk_audio_get_status(void* hdl);

#define AVCODEC_MAX_AUDIO_FRAME_SIZE 192000

/* the size may be modified because of different decoded sample number. */
#define MGR_BUFFER_SIZE 1024

//#define DEBUG_FFMPEG_PCM_STREAM

/* needed by PCM stream */
extern void* audio_hal_install(void);
extern void audio_hal_uninstall(void);
extern void configure_vcm(unsigned int data[]);
extern void set_pcm_config(int role, int rate);
extern int mrvl_hw_dev_config_pcm(struct audio_hw_device *dev, unsigned int pcm);


typedef struct {
    int videoindex;
    int sndindex;
    AVFormatContext* pFormatCtx;
    AVCodecContext* sndCodecCtx;
    AVCodec* sndCodec;
    SwrContext *swr_ctx;
    DECLARE_ALIGNED(16,uint8_t,audio_buf) [AVCODEC_MAX_AUDIO_FRAME_SIZE * 2];
    //DECLARE_ALIGNED(16,uint8_t,audio_buf) [AVCODEC_MAX_AUDIO_FRAME_SIZE];
}AudioState;

/******************************************************************************
 *  Globals
 ******************************************************************************/
/* needed by FFMPEG */
extern int64_t av_get_default_channel_layout(int nb_channels);
extern AVFrame *avcodec_alloc_frame(void);


static int my_init_ffmpeg1(AudioState* is, char* filepath)
{
    is->sndindex = -1;

    if(NULL == filepath)
    {
        printf("input file is NULL");
        return -1;
    }

    avcodec_register_all();
    avfilter_register_all();
    av_register_all();

    is->pFormatCtx = avformat_alloc_context();

    if(avformat_open_input(&is->pFormatCtx, filepath, NULL, NULL)!=0)
        return -1;

    if(avformat_find_stream_info(is->pFormatCtx, NULL)<0)
        return -1;

    av_dump_format(is->pFormatCtx,0, 0, 0);

    is->videoindex = av_find_best_stream(is->pFormatCtx, AVMEDIA_TYPE_VIDEO, is->videoindex, -1, NULL, 0); 
    is->sndindex = av_find_best_stream(is->pFormatCtx, AVMEDIA_TYPE_AUDIO,is->sndindex, is->videoindex, NULL, 0);

    printf("videoindex=%d, sndindex=%d", is->videoindex, is->sndindex);

    if(is->sndindex != -1)
    {
        is->sndCodecCtx = is->pFormatCtx->streams[is->sndindex]->codec;
        is->sndCodec = avcodec_find_decoder(is->sndCodecCtx->codec_id);

        if(is->sndCodec == NULL)
        {
            printf("Codec not found");
            return -1;
        }

        if(avcodec_open2(is->sndCodecCtx, is->sndCodec, NULL) < 0)
            return -1;
    }

    return 0;
} 


int mbtk_audio_mp3_to_wav(const char *wavpath, char *mp3path)
{
    int in_channel_nb = 0;
    int ret, rc;
    int fd;
    int size;
    int len;
    int file_data_size = 0;
    int converted_nb_samples = 0;
    int got_frame;
    int index =0;
    int i =0;
    AVPacket *packet = av_mallocz(sizeof(AVPacket));
    //AVFrame *frame = av_frame_alloc();
    AVFrame *frame = avcodec_alloc_frame();
    AudioState* is = (AudioState*) av_mallocz(sizeof(AudioState));
    uint8_t *out[] = { is->audio_buf };
    //char buf[MGR_BUFFER_SIZE];

    enum AVSampleFormat out_sample_fmt = AV_SAMPLE_FMT_S16; //输出采样格式16bit PCM

    int out_channel_nb = 0;
    struct wav_header header;


#if 1
    int sample_rate = 8000;
    //int sample_rate = 16000;
    //int sample_rate = 44100;

    int out_sample_rate = sample_rate; //输出采样率
    uint64_t out_ch_layout = AV_CH_LAYOUT_MONO; //输出的声道布局
    //uint64_t out_ch_layout = AV_CH_LAYOUT_STEREO; //输出的声道布局

#endif

    fd = open(wavpath, O_WRONLY | O_CREAT);  //wavpath

    //leave enough room for header
    lseek(fd, sizeof(struct wav_header), SEEK_SET);


    //第1步初始化ffmpeg,并用ffmpeg解码,最后转为pcm格式
    if( (ret = my_init_ffmpeg1(is, mp3path)) != 0)            //1.1 初始化ffmpeg
    {
        printf("my_init_ffmpeg error");
        return -1;
    }

    while(av_read_frame(is->pFormatCtx, packet) >= 0)    //1.2 循环读取mp3文件中的数据帧
    {
        if(packet->stream_index != is->sndindex)
            continue;

        if((ret = avcodec_decode_audio4(is->sndCodecCtx, frame, &got_frame, packet)) < 0) //1.3 解码数据帧
        {
            printf("file eof");
            break;
        }

        if(got_frame <= 0) /* No data yet, get more frames */
            continue;

        //1.4下面将ffmpeg解码后的数据帧转为我们需要的数据(关于"需要的数据"下面有解释)
        if(NULL==is->swr_ctx)
        {
            if(is->swr_ctx != NULL)
                swr_free(&is->swr_ctx);

            //输入的声道个数
            in_channel_nb = av_get_channel_layout_nb_channels(frame->channel_layout);

            //输出的声道个数
            out_channel_nb = av_get_channel_layout_nb_channels(out_ch_layout);

            printf("frame: input channel: channnels=%d, format=%d, sample_rate=%d, nb_samples=%d.\n",
                    in_channel_nb, frame->format, frame->sample_rate, frame->nb_samples);
            printf("frame: out channel: channels=%d, format=%d, sample_rate=%d.\n", out_channel_nb, out_sample_fmt, out_sample_rate);

            is->swr_ctx = swr_alloc_set_opts(NULL, out_ch_layout, out_sample_fmt, out_sample_rate, av_get_default_channel_layout(in_channel_nb), frame->format, frame->sample_rate, 0, NULL);


            if(is->swr_ctx == NULL)
            {
                printf("swr_ctx == NULL");
            }

            swr_init(is->swr_ctx);
        }

        converted_nb_samples = swr_convert(is->swr_ctx, out, AVCODEC_MAX_AUDIO_FRAME_SIZE * 2, (const uint8_t **)frame->data, frame->nb_samples);

        file_data_size += converted_nb_samples;

        //1.5 数据格式转换完成后就写到文件中
        //sample bit is 16bits = 2Bytes
        size = converted_nb_samples*out_channel_nb*2;
        write(fd, (char *)(is->audio_buf), size);

    }

    //sample bit is 16bits = 2Bytes
    file_data_size *= (out_channel_nb*2);//(numSamples * wavFMT->numChannels * wavFMT->uiBitsPerSample) / 8

    printf("file_data_size=%d, nb_samples=%d, converted_nb_samples=%d.\n", file_data_size, frame->nb_samples, converted_nb_samples);

    //第2步添加上wav的头
    //write header now all information is known
    header.riff_id = ID_RIFF;
    header.riff_sz = 0;
    header.riff_fmt = ID_WAVE;
    header.fmt_id = ID_FMT;
    header.fmt_sz = 16;
    header.audio_format = 1;        //FORMAT_PCM;
    header.num_channels = out_channel_nb;        //Modem ONLY support mono recording
    header.sample_rate = sample_rate;     //44100, 8000, 16000
    header.bits_per_sample = 16;    //PCM_SAMPLEBITS_S16_LE;
    header.byte_rate = (header.bits_per_sample / 8) * header.num_channels * header.sample_rate;
    header.block_align = header.num_channels * (header.bits_per_sample / 8);
    header.data_id = ID_DATA;

    header.data_sz = file_data_size;
    header.riff_sz = header.data_sz + sizeof(header) - 8;

    lseek(fd, 0, SEEK_SET);
    write(fd, &header, sizeof(struct wav_header));
    printf("%s: sample_rate = %d, num_channels = %d!\n", __FUNCTION__,  header.sample_rate, header.num_channels);

    av_free_packet(packet);
    av_free(frame);
    avcodec_close(is->sndCodecCtx);
    avformat_close_input(&is->pFormatCtx);

    close(fd);

    return 0;
}


int mbtk_audio_mp3_to_play(char *mp3path, int hdl, int sample_rate)
{
    int in_channel_nb = 0;
    int ret, rc;
    int size;
    int len;
    int file_data_size = 0;
    int converted_nb_samples = 0;
    int got_frame;
    int index =0;
    int i =0;
    int audio_status =0;
    AVPacket *packet = av_mallocz(sizeof(AVPacket));
    //AVFrame *frame = av_frame_alloc();
    AVFrame *frame = avcodec_alloc_frame();
    AudioState* is = (AudioState*) av_mallocz(sizeof(AudioState));
    uint8_t *out[] = { is->audio_buf };
    //char buf[MGR_BUFFER_SIZE];

    enum AVSampleFormat out_sample_fmt = AV_SAMPLE_FMT_S16; //输出采样格式16bit PCM

    int out_channel_nb = 0;


    if(sample_rate)
    {
        sample_rate = 16000;
    }
    else
    {
        sample_rate = 8000;
    }
//    int sample_rate = 8000;
    //int sample_rate = 16000;
    //int sample_rate = 44100;

    int out_sample_rate = sample_rate; //输出采样率
    uint64_t out_ch_layout = AV_CH_LAYOUT_MONO; //输出的声道布局
    //uint64_t out_ch_layout = AV_CH_LAYOUT_STEREO; //输出的声道布局

    //第1步初始化ffmpeg,并用ffmpeg解码,最后转为pcm格式
    if( (ret = my_init_ffmpeg1(is, mp3path)) != 0)            //1.1 初始化ffmpeg
    {
        printf("my_init_ffmpeg error");
        return -1;
    }

    audio_status = mbtk_audio_get_status((void *)hdl);

    while(av_read_frame(is->pFormatCtx, packet) >= 0 && ((audio_status==AUDIO_OPEN)|| (audio_status==AUDIO_RUNNING)))    //1.2 循环读取mp3文件中的数据帧
    {
        if(packet->stream_index != is->sndindex)
            continue;

        if((ret = avcodec_decode_audio4(is->sndCodecCtx, frame, &got_frame, packet)) < 0) //1.3 解码数据帧
        {
            printf("file eof");
            break;
        }

        if(got_frame <= 0) /* No data yet, get more frames */
            continue;

        //1.4下面将ffmpeg解码后的数据帧转为我们需要的数据(关于"需要的数据"下面有解释)
        if(NULL==is->swr_ctx)
        {
            if(is->swr_ctx != NULL)
                swr_free(&is->swr_ctx);

            //输入的声道个数
            in_channel_nb = av_get_channel_layout_nb_channels(frame->channel_layout);

            //输出的声道个数
            out_channel_nb = av_get_channel_layout_nb_channels(out_ch_layout);

            printf("frame: input channel: channnels=%d, format=%d, sample_rate=%d, nb_samples=%d.\n",
                    in_channel_nb, frame->format, frame->sample_rate, frame->nb_samples);
            printf("frame: out channel: channels=%d, format=%d, sample_rate=%d.\n", out_channel_nb, out_sample_fmt, out_sample_rate);

            is->swr_ctx = swr_alloc_set_opts(NULL, out_ch_layout, out_sample_fmt, out_sample_rate, av_get_default_channel_layout(in_channel_nb), frame->format, frame->sample_rate, 0, NULL);


            if(is->swr_ctx == NULL)
            {
                printf("swr_ctx == NULL");
            }

            swr_init(is->swr_ctx);
        }

        converted_nb_samples = swr_convert(is->swr_ctx, out, AVCODEC_MAX_AUDIO_FRAME_SIZE * 2, (const uint8_t **)frame->data, frame->nb_samples);

        file_data_size += converted_nb_samples;

        //1.5 数据格式转换完成后就写到文件中
        //sample bit is 16bits = 2Bytes
        size = converted_nb_samples*out_channel_nb*2;
        mbtk_audio_play_stream((void *)hdl, (char *)(is->audio_buf), size);
//        mbtk_audio_play_stream_old((void *)hdl, (char *)(is->audio_buf), size);
        audio_status = mbtk_audio_get_status((void *)hdl);

    }


    av_free_packet(packet);
    av_free(frame);
    avcodec_close(is->sndCodecCtx);
    avformat_close_input(&is->pFormatCtx);

    return 0;
}


