#if 1
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <pthread.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <sys/epoll.h>
#include <time.h>
#include <arpa/inet.h>

#include "mbtk_led.h"
#include "mbtk_log.h"
#include "mbtk_ril_api.h"

/****************************DEFINE***************************************/
#define MBTK_RESULT_FAIL   -1
#define MBTK_RESULT_SUCCESS 0

#define MBTK_NET_LED 99
#define MBTK_STATUS_LED 8

#define LED_SOCK_PATH  "/tmp/mbtk_led_sock"

/****************************DEFINE***************************************/

/****************************VARIABLE***************************************/
static mbtk_net_led_type mbtk_net_led_state = MBTK_NET_LED_SEARCH_NETWORK;
static mbtk_net_led_type mbtk_net_led_prev_state = MBTK_NET_LED_SEARCH_NETWORK;
static mbtk_status_led_type mbtk_status_led_state = MBTK_STATUS_LED_CLOSE;

static int MBTK_NET_LED_LOCK_SET = 0;
static int led_server_fd = -1;
static int sock_cli_fds[2];

/****************************VARIABLE***************************************/

/******************************FUNC*****************************************/
static int led_cli_fd_find(int fd)
{
    int i = 0;
    while(i < 2) {
        if(fd == sock_cli_fds[i])
            return i;
        i++;
    }

    return -1;
}

int mbtk_led_grcv(char *data)
{
    int led_type,led_statue;

    //LOGI("[led]type and statue data >>%s",data);
    led_type = (int)((data[0]) - '0');
    led_statue = (int)((data[2]) - '0');
    //LOGI("[led]>>[type=%d] [statue=%d]",led_type, led_statue);
    if (led_type == 0)//MBTK_STATUS_LED
    {
        if (led_statue == 0)
        {
            status_led_set(MBTK_STATUS_LED_CLOSE);
        }
        else if (led_statue == 1)
        {
            status_led_set(MBTK_STATUS_LED_OPEN);
        }
        else
        {
            LOGE("[led]led_statue error(%d)",led_statue);
            return MBTK_RESULT_FAIL;
        }
    }
    else if (led_type == 1)//MBTK_NET_LED
    {
        if (led_statue == 0)
        {
            mbtk_net_led_set(MBTK_NET_LED_CLOSE);
        }
        else if (led_statue == 1)
        {
            mbtk_net_led_set(MBTK_NET_LED_OPEN);
        }
        else
        {
            LOGE("[led]led_statue error(%d)",led_statue);
            return MBTK_RESULT_FAIL;
        }
    }
    else
    {
        LOGE("[led]led_type error(%d)",led_type);
        return MBTK_RESULT_FAIL;
    }

    return MBTK_RESULT_SUCCESS;
}

static void* led_control_thread_run()
{
    int i,numEvents;

    int epoll_fd = epoll_create(2);
    if(epoll_fd < 0)
    {
        LOGE("epoll_create() fail[%d].", errno);
        return NULL;
    }

    uint32 event = EPOLLIN | EPOLLET;
    struct epoll_event ev_cli;
    ev_cli.data.fd = led_server_fd;
    ev_cli.events = event; //EPOLLIN | EPOLLERR | EPOLLET;
    epoll_ctl(epoll_fd,EPOLL_CTL_ADD,led_server_fd,&ev_cli);

    struct epoll_event events[2];

    while (1)
    {
        numEvents = epoll_wait(epoll_fd, events, 2, -1);

        for (i = 0; i < numEvents; ++i)
        {
            if (events[i].events & EPOLLHUP)
            {
                int index = led_cli_fd_find(events[i].data.fd);
                if(index != -1)
                {
                    memset(&ev_cli,0,sizeof(struct epoll_event));
                    ev_cli.data.fd = events[i].data.fd;
                    ev_cli.events = EPOLLIN | EPOLLERR | EPOLLET;
                    epoll_ctl(epoll_fd, EPOLL_CTL_DEL, events[i].data.fd, &ev_cli);

                    close(events[i].data.fd);
                    sock_cli_fds[index] = -1;
                }
                else
                {
                    LOGE("Unknown client[fd = %d].", events[i].data.fd);
                }
            }
            else if (events[i].events & EPOLLIN)
            {
                if (events[i].data.fd == led_server_fd)
                {
                    int client_fd = -1;
                     while(1)
                     {
                         struct sockaddr_un cliaddr;
                         socklen_t clilen = sizeof(cliaddr);
                         client_fd = accept(events[i].data.fd, (struct sockaddr *) &cliaddr, &clilen);
                         if(client_fd <= 0)
                         {
                             if(errno == EAGAIN)
                             {
                                 LOGE("All client connect get.");
                             }
                             else
                             {
                                 LOGE("accept() error[%d].", errno);
                             }
                             break;
                         } else {
                            i = 0;
                             while(i < 2) {
                                 if(sock_cli_fds[i] <= 0) {
                                     sock_cli_fds[i] = client_fd;
                                     break;
                                 }
                                 i++;
                             }

                             if(i >= 2) {
                                 LOGE("Client is full.");
                                 break;
                             }
                         }
                         // Set O_NONBLOCK
                         int flags = fcntl(client_fd, F_GETFL, 0);
                         if (flags > 0)
                         {
                             flags |= O_NONBLOCK;
                             if (fcntl(client_fd, F_SETFL, flags) < 0)
                             {
                                 LOGE("Set flags error:%d", errno);
                             }
                         }

                         memset(&ev_cli,0,sizeof(struct epoll_event));
                         ev_cli.data.fd = client_fd;
                         ev_cli.events = event;//EPOLLIN | EPOLLERR | EPOLLET;
                         epoll_ctl(epoll_fd, EPOLL_CTL_ADD, client_fd, &ev_cli);
                     }

                }
                else if (events[i].data.fd > 0) // data grcv
                {
                    char buff[8];
                    memset(buff, 0, strlen(buff));
                    int len = read(events[i].data.fd, buff, 8);
                    if(len > 0) {
                        mbtk_led_grcv(buff);
                    }
                }
                else
                {
                    LOGE("Unknown events[i].data.fd = %d", events[i].data.fd);
                }
            }
            else
            {
                LOGW("Unknown event : %x", events[i].events);
            }
       }
    }
    return NULL;

}

int mbtk_led_contril_server_init()
{
    if(led_server_fd > 0) {
        LOGW("LED Server has inited.");
        return MBTK_RESULT_SUCCESS;
    }

    led_server_fd = socket(AF_LOCAL, SOCK_STREAM, 0);
    if(led_server_fd < 0)
    {
        LOGE("socket() fail[%d].", errno);
        goto error;
    }

    // Set O_NONBLOCK
    int flags = fcntl(led_server_fd, F_GETFL, 0);
    if (flags < 0)
    {
        LOGE("Get flags error:%d", errno);
        goto error;
    }
    flags |= O_NONBLOCK;
    if (fcntl(led_server_fd, F_SETFL, flags) < 0)
    {
        LOGE("Set flags error:%d", errno);
        goto error;
    }

    struct sockaddr_un sever_addr;

    unlink(LED_SOCK_PATH);

    memset(&sever_addr, 0, sizeof(sever_addr));
    sever_addr.sun_family = AF_LOCAL;
    strcpy(sever_addr.sun_path, LED_SOCK_PATH);

    if(bind(led_server_fd, (struct sockaddr *)&sever_addr, sizeof(sever_addr)))
    {
        LOGE("bind() fail[%d].", errno);
        goto error;
    }

    if(listen(led_server_fd, 2))
    {
        LOGE("listen() fail[%d].", errno);
        goto error;
    }

    pthread_attr_t thread_attr;
    pthread_t led_control_thread_id;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOGE("[led] pthread_attr_setdetachstate() fail.");
        return MBTK_RESULT_FAIL;
    }

    if(pthread_create(&led_control_thread_id, &thread_attr, led_control_thread_run, NULL))
    {
        LOGE("[led] pthread_create() fail.");
        return MBTK_RESULT_FAIL;
    }

    pthread_attr_destroy(&thread_attr);

    return MBTK_RESULT_SUCCESS;

error:
    if(led_server_fd > 0) {
        close(led_server_fd);
        led_server_fd = -1;
    }

    return MBTK_RESULT_FAIL;
}

static void led_net_reg_state_change_cb(const void* data, int data_len)
{
    static bool net_led_gms_wcdma = FALSE;
    static bool net_led_lte = FALSE;

    if(data) {
        mbtk_ril_net_reg_state_info_t *state = (mbtk_ril_net_reg_state_info_t*)data;
        LOGD("[led]net reg state change : type - %d, tech - %d, reg_state - %d\n", state->type,
            state->tech, state->reg_state);
        if (state->type == MBTK_NET_REG_TYPE_DATA_GSM_WCDMA)
        {
            if (state->reg_state == MBTK_NET_REG_STATE_HOME)
            {
                net_led_gms_wcdma = TRUE;
            }
            else
            {
                net_led_gms_wcdma = FALSE;
            }
        }
        else
        {
           if (state->reg_state == MBTK_NET_REG_STATE_HOME)
           {
               net_led_lte = TRUE;
           }
           else
           {
               net_led_lte = FALSE;
           }
        }

        if(FALSE == net_led_gms_wcdma && FALSE == net_led_lte)
        {
           mbtk_net_led_set(MBTK_NET_LED_SEARCH_NETWORK);
        }
        else
        {
           mbtk_net_led_set(MBTK_NET_LED_NET_CONNECT);
        }
    }
}

static void led_call_state_change_cb(const void* data, int data_len)
{
    if(data) {
        mbtk_ril_call_state_info_t *state = (mbtk_ril_call_state_info_t*)data;
        LOGD("[led]call state change : call_id-%d, dir-%d, state-%d, num_type-%d,number-%s\n", state->call_id,
            state->dir, state->state, state->num_type, state->call_number);

        if(state->state == 2 || state->state == 3 || state->state == 0)
        {
            mbtk_net_led_set(MBTK_NET_LED_CALL_CONNECT);
        }

        if(state->state == 4 && state->dir == 1)
        {
            mbtk_net_led_set(MBTK_NET_LED_CALL_CONNECT);
        }

        if(state->state == MBTK_RIL_CALL_STATE_DISCONNECT)
        {
            mbtk_net_led_set(MBTK_NET_LED_CALL_DISCONNECT);
        }

    }
}

int mbtk_status_led_control_get()
{
    int ret;
    mbtk_ril_handle* handle_def = mbtk_ril_open(MBTK_AT_PORT_DEF);
    if(handle_def == NULL) {
        LOGE("[led]mbtk_ril_open(MBTK_AT_PORT_DEF/ATPORTTYPE_0) fail.");
        goto error;
    }

    mbtk_ril_handle* handle_1 = mbtk_ril_open(MBTK_AT_PORT_VOICE);
    if(handle_1 == NULL) {
        LOGE("mbtk_ril_open(ATPORTTYPE_1) fail.");
        goto error;
    }

    mbtk_net_info_array_t net_list;
    ret = mbtk_available_net_get(handle_1, &net_list);
    if(ret != MBTK_RIL_ERR_SUCCESS) {
        LOGE("[led]Error : %d\n", ret);
        goto error;
    } else {
        LOGD("[led]Available net number:%d\n", net_list.num);
        int i = 0;
        while(i < net_list.num) {
            LOGD("[led]NET : %d,%d,%d,%d\n", net_list.net_info[i].net_sel_mode,
                net_list.net_info[i].net_type, net_list.net_info[i].net_state,
                net_list.net_info[i].plmn);
            if (net_list.net_info[i].net_state == 2)
            {
                mbtk_net_led_set(MBTK_NET_LED_NET_CONNECT);
                break;
            }
            i++;
        }
    }
    mbtk_ril_close(MBTK_AT_PORT_VOICE);

    ret = mbtk_net_reg_state_change_cb_reg(led_net_reg_state_change_cb);
    if(ret != MBTK_RIL_ERR_SUCCESS)
    {
        LOGE("[led]mbtk_net_reg_state_change_cb_reg fail.");
        goto error;
    }

    ret = mbtk_call_state_change_cb_reg(led_call_state_change_cb);
    if(ret != MBTK_RIL_ERR_SUCCESS)
    {
        LOGE("[led]mbtk_call_state_change_cb_reg fail.");
        goto error;
    }

    return MBTK_RESULT_SUCCESS;

error:
    mbtk_ril_close(MBTK_AT_PORT_DEF);
    mbtk_ril_close(MBTK_AT_PORT_VOICE);
    return MBTK_RESULT_FAIL;
}



int mbtk_read_ccinet(void)
{
    FILE *fp;
//    int ret = 0;
    char buffer[1024];
//    char type[10]={0};

    fp = popen("ifconfig", "r");
    if (fp == NULL) {
        printf("popen fail\n");
        return -1;
    }

    if(fread(buffer,1, sizeof(buffer) -1, fp) <= 0) {

    }
    //LOGE("[led]buffer:%s\n", buffer);
    pclose(fp); //

    char *p1 = strstr(buffer, "ccinet");
    if(p1 == NULL)
    {
    	//LOGE("[led]read ccinet is null\n");
    	return -1;
    }

    return 0;
}

int mbtk_net_led_get(void)
{

    if (MBTK_NET_LED_LOCK_SET == 1)
    {
        mbtk_net_led_state = MBTK_NET_LED_CALL_CONNECT;//call 优先级最高
        return mbtk_net_led_state;
    }

    if(mbtk_net_led_state == MBTK_NET_LED_OPEN)
    {
        mbtk_net_led_state = mbtk_net_led_prev_state;
    }

    int ret = -1;
    if(mbtk_net_led_state == MBTK_NET_LED_NET_CONNECT)
    {
        ret = mbtk_read_ccinet();
        if(ret == 0)
        {
            mbtk_net_led_state = MBTK_NET_LED_DATA_CONNECT;
        }
    }
    else if(mbtk_net_led_state == MBTK_NET_LED_DATA_CONNECT)
    {
        ret = mbtk_read_ccinet();
        if(0 != ret)
        {
            mbtk_net_led_state = MBTK_NET_LED_NET_CONNECT;
        }
    }
    return mbtk_net_led_state;
}

void mbtk_net_led_set(mbtk_net_led_type status)
{
    if(mbtk_net_led_state == MBTK_NET_LED_CLOSE)
    {
        if(status == MBTK_NET_LED_CLOSE || status == MBTK_NET_LED_OPEN)
        {
            //
        }
        else
        {
            mbtk_net_led_prev_state = status;
			return;
        }
    }
    else
    {
        if(status == MBTK_NET_LED_CLOSE)
        {
            mbtk_net_led_prev_state = mbtk_net_led_state;
        }
    }

    if (status == MBTK_NET_LED_CALL_CONNECT)
    {
        MBTK_NET_LED_LOCK_SET = 1;
    }

    if (status == MBTK_NET_LED_CALL_DISCONNECT)
    {
        MBTK_NET_LED_LOCK_SET = 0;
        status = MBTK_NET_LED_NET_CONNECT;
    }

    mbtk_net_led_state = status;
}

static int mbtk_led_gpio_init(int gpio)
{
    char buffer[50]= {0};
    char pin_index_buffer[5]= {0};
    int fd =-1;
    int result = -1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    if(access(buffer , F_OK) != 0)
    {
        fd = open("/sys/class/gpio/export",O_WRONLY);
        if(fd < -1)
        {
            LOGE("[led]Open export fail.", gpio);
            return MBTK_RESULT_FAIL;
        }

        memset(pin_index_buffer,0,5);
        sprintf(pin_index_buffer,"%d", gpio);
        result = write(fd,pin_index_buffer,strlen(pin_index_buffer));
        close(fd);
        if(result < 0)
        {
            LOGE("[led]Gpio[%d] export fail.", gpio);
            return MBTK_RESULT_FAIL;
        }
        fd = -1;
    }

    fd = open(buffer, O_WRONLY);
    if(fd < -1)
    {
        LOGE("[led]Open gpio[%d] direct fail.", gpio);
        return MBTK_RESULT_FAIL;
    }

    result = write(fd, "out",strlen("out"));
    close(fd);
    if(result < 0)
    {
        LOGE("[led]Set gpio[%d] direct fail.", gpio);
        return MBTK_RESULT_FAIL;
    }
    return MBTK_RESULT_SUCCESS;
}

static int mbtk_led_gpio_level_set(int gpio, int value)
{
    char buffer[50]= {0};
    int fd =-1;
    int result =-1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/value", gpio);
    fd = open(buffer,O_WRONLY);
    if(fd < -1)
    {
        LOGE("[led]Open gpio[%d] value fail.", gpio);
        return MBTK_RESULT_FAIL;
    }
    if(value == 0)
    {
        result = write(fd,"0",1);
    }
    else
    {
        result = write(fd,"1",1);
    }
    close(fd);

    if(result != 1)
    {
        LOGE("[led]Set gpio[%d] value fail.", gpio);
        return MBTK_RESULT_FAIL;
    }

    return MBTK_RESULT_SUCCESS;
}

static void net_led_close(void)
{
    mbtk_led_gpio_level_set(MBTK_NET_LED, 0);
}

static void net_led_open(void)
{
    mbtk_led_gpio_level_set(MBTK_NET_LED, 1);
}

static void net_led_flicker_200ms(void)
{
    mbtk_led_gpio_level_set(MBTK_NET_LED, 1);
    usleep(100000);
    mbtk_led_gpio_level_set(MBTK_NET_LED, 0);
    usleep(100000);
}

static void net_led_flicker_800ms(void)
{
    mbtk_led_gpio_level_set(MBTK_NET_LED, 1);
    usleep(800000);
    mbtk_led_gpio_level_set(MBTK_NET_LED, 0);
    usleep(800000);
}

static void* net_led_thread_run(void* arg)
{
    mbtk_net_led_type status = MBTK_NET_LED_CLOSE;

    while(1)
    {
        status = mbtk_net_led_get();
        //LOGE("[led] get net led status = [%d].", status);

        if (status == MBTK_NET_LED_CALL_CONNECT) //call 优先
        {
            net_led_open();
        }
        else
        {
            switch(status)
            {
                case MBTK_NET_LED_CLOSE:
                case MBTK_NET_LED_POWER:
                {
                    net_led_close();
                    sleep(3);
                    break;
                }
                case MBTK_NET_LED_SEARCH_NETWORK:
                {
                    net_led_open();
                    sleep(3);
                    break;
                }
                case MBTK_NET_LED_DATA_CONNECT:
                {
                    net_led_flicker_200ms();
                    break;
                }
                case MBTK_NET_LED_NET_CONNECT:
                {
                    net_led_flicker_800ms();
                    break;
                }
                default:
                {
                    LOGE("[led]Uknown status.");
                    sleep(1);
                    break;
                }
            }
        }
        usleep(100000);
    }
    return NULL;
}

int status_led_set(mbtk_status_led_type status)
{
    int ret = MBTK_RESULT_FAIL;
    ret = mbtk_led_gpio_level_set(MBTK_STATUS_LED, status);
    if(ret != MBTK_RESULT_SUCCESS)
    {
        LOGE("[led]set status led fail.");
        return MBTK_RESULT_FAIL;
    }

    mbtk_status_led_state = status;
    return MBTK_RESULT_SUCCESS;
}


int mbtk_led_init(void)
{
//    int ret = MBTK_RESULT_FAIL;

    mbtk_led_gpio_init(MBTK_STATUS_LED);
    mbtk_led_gpio_init(MBTK_NET_LED);
    status_led_set(MBTK_STATUS_LED_OPEN);
    mbtk_net_led_set(MBTK_NET_LED_SEARCH_NETWORK);

    pthread_attr_t thread_attr;
    pthread_t net_led_thread_id;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOGE("[led] pthread_attr_setdetachstate() fail.");
        return MBTK_RESULT_FAIL;
    }

    if(pthread_create(&net_led_thread_id, &thread_attr, net_led_thread_run, NULL))
    {
        LOGE("[led] pthread_create() fail.");
        return MBTK_RESULT_FAIL;
    }

    pthread_attr_destroy(&thread_attr);

    if(mbtk_status_led_control_get())
    {
        LOGW("mbtk_status_led_control_get() fail.");
    }

    return MBTK_RESULT_SUCCESS;
}
/******************************FUNC*****************************************/

#endif

