#include "lynq-adc.h"
#include "mbtk_type.h"
#include "mbtk_adc.h"
#include "mbtk_log.h"

int qser_adc_show(ADC_CHANNEL_E qadc)
{
    UNUSED(qadc);

    mbtk_adc_enum adc = MBTK_ADC0;
    switch(qadc) {
        case QADC_NONE:
        {
            return 0;
        }
        case ADC0:
            adc = MBTK_ADC0;
            break;
        case ADC1:
            adc = MBTK_ADC1;
            break;
#if defined(MBTK_PROJECT_T108) || defined(MBTK_PROJECT_L508_X6)
        case ADC2:
            adc = MBTK_ADC2;
            break;
#endif
        default:
            LOGE("Unsupport adc : %d", qadc);
            return -1;
    }

    return mbtk_adc_get(adc);
}

