#include "mbtk_type.h"
#include "lynq-gpio.h"
#include "unistd.h"
#include "fcntl.h"
#include "mbtk_log.h"

#include <errno.h>
static int gpio_export(int gpio)
{
    int index=0;
    int file=-1;
    int result =-1;
    char pin_index_buffer[5]= {0};

    char buffer[50];
    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    if(access(buffer , F_OK) == 0)
    {
        LOGD("%d has export.", gpio);
        return 0;
    }

    file = open("/sys/class/gpio/export",O_WRONLY);
    if(file == -1)
    {
        LOGE("Open gpio export file fail.");
        return -1;
    }

    memset(pin_index_buffer,0,5);
    sprintf(pin_index_buffer,"%d", gpio);
    result = write(file,pin_index_buffer,strlen(pin_index_buffer));
    if(result < 0)
    {
        LOGE("Gpio[%d] export fail. err = %d", gpio, errno);
        close(file);
        return -1;
    }
    close(file);

    return 0;
}

static int gpio_unexport(int gpio)
{
    int index=0;
    int file=-1;
    int result =-1;
    char pin_index_buffer[5]= {0};
    char buffer[50];
    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    if(access(buffer , F_OK) == -1)
    {
        LOGD("%d not export.", gpio);
        return 0;
    }

    file = open("/sys/class/gpio/unexport",O_WRONLY);
    if(file == -1)
    {
        LOGE("Open gpio unexport file fail.");
        return -1;
    }

    memset(pin_index_buffer,0,5);
    sprintf(pin_index_buffer,"%d", gpio);
    result=write(file,pin_index_buffer,strlen(pin_index_buffer));
    if(result < 0)
    {
        close(file);
        LOGE("Gpio[%d] unexport fail.", gpio);
        return -1;
    }
    close(file);

    return 0;
}

static int gpio_direct_get(int gpio, char *value, int value_size)
{
    char buffer[50]= {0};
    int file =-1;
    int result =-1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    file = open(buffer, O_RDONLY);
    if(file == -1)
    {
        LOGE("Open gpio[%d] direct fail.", gpio);
        return -1;
    }

    memset(value, 0x0, value_size);
    result = read(file,value,value_size);
    if(result <= 0)
    {
        LOGE("Get gpio[%d] direct fail.", gpio);
        close(file);
        return -1;
    }
    close(file);

    return 0;
}


static int gpio_direct_set(int gpio, char *value)
{
    char buffer[50]= {0};
    int file =-1;
    int result =-1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    file = open(buffer, O_WRONLY);
    if(file == -1)
    {
        LOGE("Open gpio[%d] direct fail.", gpio);
        return -1;
    }

    result = write(file,value,strlen(value));
    if(result != strlen(value))
    {
        LOGE("Set gpio[%d] direct fail.", gpio);
        close(file);
        return -1;
    }
    close(file);

    return 0;
}

static int gpio_value_get(int gpio)
{
    char buffer[50];
    char path[10];
    int file =-1;
    int result =-1;
    int value;

    memset(path,0,50);
    memset(buffer,0,10);
    sprintf(path,"/sys/class/gpio/gpio%d/value", gpio);
    file = open(path,O_RDONLY);
    if(file == -1)
    {
        LOGE("Open gpio[%d] fail.", gpio);
        return -1;
    }
    result = read(file,buffer,5);
    if(result <= 0)
    {
        LOGE("Get gpio[%d] value fail", gpio);
        close(file);
        return -1;
    }
    close(file);
    value = atoi(buffer);
    return value;
}

static int gpio_value_set(int gpio, int value)
{
    char buffer[50]= {0};
    int file =-1;
    int result =-1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/value", gpio);
    file = open(buffer,O_WRONLY);
    if(file == -1)
    {
        LOGE("Open gpio[%d] value fail.", gpio);
        return -1;
    }
    if(value == 0) {
        result = write(file,"0",1);
    } else {
        result = write(file,"1",1);
    }
    if(result != 1)
    {
        LOGE("Set gpio[%d] value fail err =%d.", gpio, errno);
        close(file);
        return -1;
    }
    close(file);

    return 0;
}


int lynq_gpio_init(int gpio, int direction, int value, int pullsel)
{
    //UNUSED(gpio);
    //UNUSED(direction);
    //UNUSED(value);
    UNUSED(pullsel);

    if (direction != 1 && direction != 0)
    {
        LOGE("[lynq_gpio_init] direction fail.");
        return -1;
    }

    if (value != 1 && value != 0)
    {
        LOGE("[lynq_gpio_init] value fail.");
        return -1;
    }

    if(gpio_export(gpio))
    {
        LOGE("[lynq_gpio_init]gpio_export fail.");
        return -1;
    }

    if(gpio_direct_set(gpio, direction == 0 ? "in" : "out"))
    {
        LOGE("[lynq_gpio_init]gpio_direct_set fail.");
        return -1;
    }

    if(direction == 1 && (gpio_value_set(gpio, value) != 0))
    {
        LOGE("[lynq_gpio_init]gpio_value_set fail.");
        return -1;
    }


    return 0;
}

int lynq_gpio_deinit(int gpio)
{
    UNUSED(gpio);

    if(gpio_unexport(gpio))
    {
        LOGE("[lynq_gpio_deinit]gpio_unexport fail.");
        return -1;
    }

    return 0;
}

int lynq_gpio_direction_set(int gpio, int direction)
{
    //UNUSED(gpio);
    //UNUSED(direction);

    if(gpio_direct_set(gpio, direction == 0 ? "in" : "out"))
    {
        LOGE("[lynq_gpio_direction_set]gpio_direct_set fail.");
        return -1;
    }

    return 0;
}


int lynq_gpio_value_set(int gpio, int value)
{
    //UNUSED(gpio);
    //UNUSED(value);

    if(gpio_value_set(gpio, value))
    {
        LOGE("[lynq_gpio_value_set]gpio_value_set fail.");
        return -1;
    }

    return 0;
}

int lynq_gpio_value_get(int gpio)
{
    //UNUSED(gpio);
    int ret = -1;

    ret = gpio_value_get(gpio);
    if (ret == -1)
    {
        LOGE("[lynq_gpio_value_get]gpio_value_get fail.");
        return -1;
    }

    return ret;
}

int lynq_gpio_pullsel_set(int gpio, int pullsel)
{
    //UNUSED(gpio);
    //UNUSED(pullsel);
    int ret = -1;
    int value_t;

    if (pullsel == 1)
        value_t = 0;
    else if (pullsel == 2)
        value_t = 1;
    else
    {
        LOGE("[lynq_gpio_pullsel_set] value_t fail.");
        return -1;
    }

    ret = gpio_value_set(gpio, value_t);
    if(ret == -1)
    {
        LOGE("[lynq_gpio_pullsel_set]gpio_value_set() fail.");
        return -1;
    }

    return ret;
}


int lynq_gpio_pullsel_get(int gpio)
{
    //UNUSED(gpio);
    int ret = -1;

    ret = gpio_value_get(gpio);
    if (ret == -1)
    {
        LOGE("[lynq_gpio_pullsel_get]gpio_value_get() fail.");
        return -1;
    }

    return ret + 1;
}



