#include "lynq_qser_sim.h"
#include "mbtk_type.h"
#include "mbtk_info_api.h"

/****************************DEFINE***************************************/
#define QSER_RESULT_SUCCESS 0
#define QSER_RESULT_FAIL -1

#define QSER_IMEI_SV_VERSION "01"

/****************************DEFINE***************************************/

/****************************VARIABLE***************************************/
extern mbtk_info_handle_t* qser_info_handle;
extern int qser_info_handle_num;
static bool inited = FALSE;
static uint qser_h_sim = 0x5F6F7F8F;
static QSER_SIM_RxMsgHandlerFunc_t qser_sim_state_cb = NULL;
static bool qser_sim_cb_state = false;
/****************************VARIABLE***************************************/

/******************************FUNC*****************************************/
void qser_sim_state_change_cb(const void* data, int data_len)
{
    uint8 *ptr = (uint8*)data;
    LOGE("[qser_sim] SIM state : %d\n", *ptr);
    QSER_SIM_CARD_STATUS_INFO_T qser_sim_statue = {0};
    if(*ptr == 0)
    {
        qser_sim_statue.e_card_state = QSER_SIM_CARD_STATE_ABSENT;
    }
    else if(*ptr == 1)
    {
        qser_sim_statue.e_card_state = QSER_SIM_CARD_STATE_PRESENT;
    }
    else if(*ptr == 18)
    {
        qser_sim_statue.e_card_state = QSER_SIM_CARD_STATE_ABSENT;
    }
    else
    {
        qser_sim_statue.e_card_state = QSER_SIM_CARD_STATE_UNKNOWN;
    }
    if(qser_sim_state_cb != NULL)
    {
        qser_sim_state_cb(&qser_sim_statue);
    }
}

/******************************FUNC*****************************************/

/****************************API***************************************/
int qser_sim_client_init(sim_client_handle_type *ph_sim)
{
    //UNUSED(ph_sim);
    if(ph_sim == NULL)
    {
        LOGE("[qser_sim] ph_sim is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(!inited && qser_info_handle == NULL)
    {
        qser_info_handle = mbtk_info_handle_get();
        if(qser_info_handle)
        {
            qser_info_handle_num++;
            inited = TRUE;
            //mbtk_pdp_state_change_cb_reg(qser_info_handle, qser_wan_net_state_change_cb);
        } 
        else
        {
            LOGE("[qser_sim] mbtk_info_handle_get() fail.");
            return QSER_RESULT_FAIL;
        }
    }
    else
    {
        if(!inited)
        {
            qser_info_handle_num++;
            inited = TRUE;
            //mbtk_pdp_state_change_cb_reg(qser_info_handle, qser_wan_net_state_change_cb);
        }
    }
    *ph_sim = qser_h_sim;

    LOGE("[qser_sim] mbtk_info_handle_get() success.");
    return QSER_RESULT_SUCCESS;
}

int qser_sim_getimsi(sim_client_handle_type h_sim, QSER_SIM_APP_ID_INFO_T *pt_info,char *imsi,size_t imsiLen)
{
    //UNUSED(h_sim);
    UNUSED(pt_info);
    //UNUSED(imsi);
    //UNUSED(imsiLen);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(imsi == NULL || imsiLen < 15)
    {
        LOGE("[qser_sim] imsi is NULL.");
        return QSER_RESULT_FAIL;
    }

    memset(imsi,0,imsiLen);
    int err = mbtk_imsi_get(qser_info_handle, imsi);
    if(err)
    {
        LOGE("[qser_sim] mbtk_imsi_get is fail.");
        return QSER_RESULT_FAIL;
    }

    if(strlen(imsi) > imsiLen)
    {
        LOGE("[qser_sim] get datalength out of range.");
        return QSER_RESULT_FAIL;
    }

    return QSER_RESULT_SUCCESS;
}

int qser_sim_geticcid(sim_client_handle_type h_sim,QSER_SIM_SLOT_ID_TYPE_T simId,char *iccid, size_t iccidLen)
{
    //UNUSED(h_sim);
    UNUSED(simId);
    //UNUSED(iccid);
    //UNUSED(iccidLen);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(iccid == NULL || iccidLen < QSER_SIM_ICCID_LEN_MAX)
    {
        LOGE("[qser_sim] iccid is NULL.");
        return QSER_RESULT_FAIL;
    }

    memset(iccid, 0, iccidLen);
    int err = mbtk_iccid_get(qser_info_handle, iccid);
    if(err)
    {
        LOGE("[qser_sim] mbtk_iccid_get is fail.");
        return QSER_RESULT_FAIL;
    }

    if(strlen(iccid) > iccidLen)
    {
        LOGE("[qser_sim] get datalength out of range.");
        return QSER_RESULT_FAIL;
    }
    
    return QSER_RESULT_SUCCESS;
}

int qser_sim_getphonenumber(sim_client_handle_type h_sim,QSER_SIM_APP_ID_INFO_T *pt_info, char*phone_num, size_t phoneLen)
{
    //UNUSED(h_sim);
    UNUSED(pt_info);
    //UNUSED(phone_num);
    //UNUSED(phoneLen);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(phone_num == NULL || phoneLen < 11)
    {
        LOGE("[qser_sim] phone_num is NULL.");
        return QSER_RESULT_FAIL;
    }

    memset(phone_num, 0, phoneLen);
    int err = mbtk_phone_number_get(qser_info_handle, phone_num);
    if(err)
    {
        LOGE("[qser_sim] mbtk_phone_number_get is fail.");
        return QSER_RESULT_FAIL;
    }

    if(strlen(phone_num) > phoneLen)
    {
        LOGE("[qser_sim] get datalength out of range.");
        return QSER_RESULT_FAIL;
    }

    return QSER_RESULT_SUCCESS;
}

int qser_sim_verifypin(sim_client_handle_type h_sim,QSER_SIM_VERIFY_PIN_INFO_T *pt_info)
{
    //UNUSED(h_sim);
    //UNUSED(pt_info);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(pt_info == NULL)
    {
        LOGE("[qser_sim] pt_info is NULL.");
        return QSER_RESULT_FAIL;
    }

    int err = mbtk_verify_pin(qser_info_handle, pt_info->pin_value);
    if(err)
    {
        LOGE("[qser_sim] mbtk_verify_pin is fail.");
        return QSER_RESULT_FAIL;
    }
    
    return QSER_RESULT_SUCCESS;
}

int qser_sim_changepin(sim_client_handle_type h_sim,QSER_SIM_CHANGE_PIN_INFO_T *pt_info)
{
    //UNUSED(h_sim);
    //UNUSED(pt_info);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(pt_info == NULL)
    {
        LOGE("[qser_sim] pt_info is NULL.");
        return QSER_RESULT_FAIL;
    }

    mbtk_change_pin_info pin_info = {0};
    memcpy(pin_info.old_pin_value, pt_info->old_pin_value, pt_info->old_pin_value_len);
    memcpy(pin_info.new_pin_value, pt_info->new_pin_value, pt_info->new_pin_value_len);
    int err = mbtk_change_pin(qser_info_handle, &pin_info);
    if(err)
    {
        LOGE("[qser_sim] mbtk_change_pin is fail.");
        return QSER_RESULT_FAIL;
    }
    
    return QSER_RESULT_SUCCESS;
}

int qser_sim_unblockpin(sim_client_handle_type h_sim, QSER_SIM_UNBLOCK_PIN_INFO_T *pt_info)
{
    //UNUSED(h_sim);
    //UNUSED(pt_info);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(pt_info == NULL)
    {
        LOGE("[qser_sim] pt_info is NULL.");
        return QSER_RESULT_FAIL;
    }

    mbtk_unlock_pin_info puk_pin_info = {0};
    memcpy(puk_pin_info.pin_value, pt_info->new_pin_value, pt_info->new_pin_value_len);
    memcpy(puk_pin_info.puk_value, pt_info->puk_value, pt_info->puk_value_len);
    int err = mbtk_unlock_pin(qser_info_handle, &puk_pin_info);
    if(err)
    {
        LOGE("[qser_sim] mbtk_unlock_pin is fail.");
        return QSER_RESULT_FAIL;
    }

    return QSER_RESULT_SUCCESS;
}

int qser_sim_enablepin(sim_client_handle_type h_sim, QSER_SIM_ENABLE_PIN_INFO_T *pt_info)
{
    //UNUSED(h_sim);
    //UNUSED(pt_info);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(pt_info == NULL)
    {
        LOGE("[qser_sim] pt_info is NULL.");
        return QSER_RESULT_FAIL;
    }

    mbtk_enable_pin_info pin_info = {0};
    memcpy(pin_info.pin_value, pt_info->pin_value, pt_info->pin_value_len);
    pin_info.enable = 1;
    int err = mbtk_enable_pin(qser_info_handle, &pin_info);
    if(err)
    {
        LOGE("[qser_sim] mbtk_enable_pin is fail.");
        return QSER_RESULT_FAIL;
    }
    
    return QSER_RESULT_SUCCESS;
}

int qser_sim_disablepin(sim_client_handle_type h_sim, QSER_SIM_DISABLE_PIN_INFO_T *pt_info)
{
    //UNUSED(h_sim);
    //UNUSED(pt_info);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(pt_info == NULL)
    {
        LOGE("[qser_sim] pt_info is NULL.");
        return QSER_RESULT_FAIL;
    }

    mbtk_enable_pin_info pin_info = {0};
    memcpy(pin_info.pin_value, pt_info->pin_value, pt_info->pin_value_len);
    pin_info.enable = 0;
    int err = mbtk_enable_pin(qser_info_handle, &pin_info);
    if(err)
    {
        LOGE("[qser_sim] mbtk_enable_pin is fail.");
        return QSER_RESULT_FAIL;
    }
    
    return QSER_RESULT_SUCCESS;
}

int qser_sim_getcardstatus(sim_client_handle_type h_sim,QSER_SIM_SLOT_ID_TYPE_T simId,QSER_SIM_CARD_STATUS_INFO_T *pt_info)
{
    //UNUSED(h_sim);
    //UNUSED(simId);
    //UNUSED(pt_info);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(pt_info == NULL)
    {
        LOGE("[qser_sim] pt_info is NULL.");
        return QSER_RESULT_FAIL;
    }

    mbtk_sim_state_enum sim;
    mbtk_sim_card_type_enum sim_card_type;
    mbtk_pin_puk_last_times qser_last_times = {0};
    int err = mbtk_sim_state_get(qser_info_handle, &sim);
    if(err)
    {
        LOGE("[qser_sim] mbtk_sim_state_get fail [err = %d].", err);
        return QSER_RESULT_FAIL;
    }
    else
    {
        LOGE("[qser_sim] sim = %d.", sim);
        memset(pt_info, 0x0, sizeof(QSER_SIM_CARD_STATUS_INFO_T));
        switch (sim)
        {
            case 0:                     //ABSENT
                pt_info->e_card_state = QSER_SIM_CARD_STATE_ABSENT;
                break;
            case 1:                     //NOT READY
                pt_info->e_card_state = QSER_SIM_CARD_STATE_ABSENT;
                break;
            case 2:                     //READY
                pt_info->e_card_state = QSER_SIM_CARD_STATE_PRESENT;
                break;
            case 3:                     //SIM PIN
                pt_info->e_card_state = QSER_SIM_CARD_STATE_PRESENT;
                break;
            case 4:                     //SIM PUK
                pt_info->e_card_state = QSER_SIM_CARD_STATE_PRESENT;
                break;
            case 5:                     //NETWORK
                pt_info->e_card_state = QSER_SIM_CARD_STATE_ERROR_SIM_TECHNICAL_PROBLEMS;
                break;
            default:
                pt_info->e_card_state = QSER_SIM_CARD_STATE_UNKNOWN;
                break;
        }
    }
    
    err = mbtk_sim_card_type_get(qser_info_handle, &sim_card_type);
    if(err)
    {
        LOGE("[qser_sim] mbtk_sim_state_get fail [err = %d].", err);
        return QSER_RESULT_FAIL;
    }
    else
    {
        if(sim_card_type == 0 || sim_card_type == 2)
            pt_info->e_card_type = QSER_SIM_CARD_TYPE_ICC;
        else if(sim_card_type == 1 || sim_card_type == 3)
            pt_info->e_card_type = QSER_SIM_CARD_TYPE_UICC;
        else
            pt_info->e_card_type = QSER_SIM_CARD_TYPE_UNKNOWN;
    }
    
    err = mbtk_pin_last_num_get(qser_info_handle, &qser_last_times);
    if(err)
    {
        LOGE("[qser_sim] mbtk_sim_state_get fail [err = %d].", err);
        return QSER_RESULT_FAIL;
    }
    else
    {
        pt_info->card_app_info.app_3gpp.pin1_num_retries = qser_last_times.p1_retry;
        pt_info->card_app_info.app_3gpp.pin2_num_retries = qser_last_times.p2_retry;
        pt_info->card_app_info.app_3gpp.puk1_num_retries = qser_last_times.puk1_retry;
        pt_info->card_app_info.app_3gpp.puk2_num_retries = qser_last_times.puk2_retry;
    }

    return QSER_RESULT_SUCCESS;
}

int qser_sim_getimei(sim_client_handle_type h_sim, char *imei)
{
    //UNUSED(h_sim);
    //UNUSED(imei);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(imei == NULL)
    {
        LOGE("[qser_sim] imei is NULL.");
        return QSER_RESULT_FAIL;
    }

    int err = mbtk_imei_get(qser_info_handle, imei);
    if(err)
    {
        LOGE("[qser_sim] mbtk_imei_get Error : %d\n", err);
        return QSER_RESULT_FAIL;
    }
    return QSER_RESULT_SUCCESS;
}

int qser_get_imei_and_sv(sim_client_handle_type h_sim,char *imei, char*sv)
{
    //UNUSED(h_sim);
    //UNUSED(imei);
    //UNUSED(sv);
    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(imei == NULL || sv == NULL)
    {
        LOGE("[qser_sim] param is NULL.");
        return QSER_RESULT_FAIL;
    }

    int err = mbtk_imei_get(qser_info_handle, imei);
    if(err)
    {
        LOGE("[qser_sim] mbtk_imei_get Error: %d\n", err);
        return QSER_RESULT_FAIL;
    }

    memcpy(sv, QSER_IMEI_SV_VERSION, strlen(QSER_IMEI_SV_VERSION));

    return QSER_RESULT_SUCCESS;
}

int qser_reset_modem(sim_client_handle_type h_sim)
{
    //UNUSED(h_sim);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    for(int cid =0; cid < MBTK_APN_CID_MAX; cid++)
    {
        mbtk_data_call_stop(qser_info_handle, cid, 1);
    }


    //mbtk_system_reboot(0);
    mbtk_modem_info_t info;
    info.fun = MBTK_DEV_MODEM_MIN_FUN;
    info.rst = 0;
    int err = mbtk_set_modem_fun(qser_info_handle, &info);
    if(err)
    {
        LOGE("[qser_sim] mbtk_set_modem_fun Error : %d\n", err);
        return QSER_RESULT_FAIL;
    }

    info.fun = MBTK_DEV_MODEM_FULL_FUN;
    err = mbtk_set_modem_fun(qser_info_handle, &info);
    if(err)
    {
        LOGE("[qser_sim] mbtk_set_modem_fun Error : %d\n", err);
        return QSER_RESULT_FAIL;
    }
    return QSER_RESULT_SUCCESS;
}

int qser_get_version(sim_client_handle_type h_sim, char *buf)
{
    //UNUSED(h_sim);
    //UNUSED(buf);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(buf == NULL)
    {
        LOGE("[qser_sim] buf is NULL.");
        return QSER_RESULT_FAIL;
    }

    int err = mbtk_version_get(qser_info_handle, buf);
    if(err)
    {
        LOGE("[qser_sim] mbtk_version_get Error : %d\n", err);
        return QSER_RESULT_FAIL;
    }
    return QSER_RESULT_SUCCESS;
}

int qser_reset_sim(sim_client_handle_type h_sim)
{
    //UNUSED(h_sim);

    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }

    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    //mbtk_sim_power_set(0);
    //sleep(1);
    //mbtk_sim_power_set(1);
    mbtk_modem_info_t info;
    info.fun = MBTK_DEV_MODEM_DISABLE_SIM;
    info.rst = 0;
    int err = mbtk_set_modem_fun(qser_info_handle, &info);
    if(err)
    {
        LOGE("[qser_sim] mbtk_set_modem_fun Error : %d\n", err);
        return QSER_RESULT_FAIL;
    }

    info.fun = MBTK_DEV_MODEM_FULL_FUN;
    err = mbtk_set_modem_fun(qser_info_handle, &info);
    if(err)
    {
        LOGE("[qser_sim] mbtk_set_modem_fun Error : %d\n", err);
        return QSER_RESULT_FAIL;
    }
    return QSER_RESULT_SUCCESS;
}

int qser_sim_addrxmsghandler(QSER_SIM_RxMsgHandlerFunc_t handlerPtr)
{
    if(qser_info_handle == NULL)
    {
        LOGE("[qser_sim] handle is NULL.");
        return QSER_RESULT_FAIL;
    }

    if(handlerPtr == NULL)
    {
        LOGE("[qser_sim] param is NULL.");
        qser_sim_state_cb = NULL;
        return QSER_RESULT_SUCCESS;
    }

    qser_sim_state_cb = handlerPtr;
    if(!qser_sim_cb_state)
    {
        int ret = mbtk_sim_state_change_cb_reg(qser_info_handle, qser_sim_state_change_cb);
        if(ret != 0)
        {
            LOGE("[qser_sim] set cb fail.");
            qser_sim_state_cb = NULL;
            return QSER_RESULT_FAIL;
        }
    }

    return QSER_RESULT_SUCCESS;
}


int qser_sim_client_deinit(sim_client_handle_type h_sim)
{
    //UNUSED(h_sim);
    if(h_sim != qser_h_sim)
    {
        LOGE("[qser_sim] h_sim is error.");
        return QSER_RESULT_FAIL;
    }
    
    if(qser_info_handle)
    {
        LOGE("[qser_sim] qser_info_handle_num = %d", qser_info_handle_num);
        if(qser_info_handle_num == 1)
        { // 最后一个引用，可释放。
            int ret = mbtk_info_handle_free(&qser_info_handle);
            if(ret)
            {
                LOGE("[qser_sim] mbtk_info_handle_free() fail.");
                return QSER_RESULT_FAIL;
            }
            else
            {
                qser_info_handle_num = 0;
                qser_info_handle = NULL;
                qser_sim_state_cb = NULL;
                inited = FALSE;
            }
        } 
        else
        {
            qser_info_handle_num--;
            qser_sim_state_cb = NULL;
        }
    }
    else
    {
        LOGE("[qser_sim] handle not inited.");
        return QSER_RESULT_FAIL;
    }

    return QSER_RESULT_SUCCESS;
}
/****************************API***************************************/

