#include "lynq_led.h"
#include "mbtk_type.h"
#include "mbtk_log.h"
#include "mbtk_info_api.h"

/****************************DEFINE***************************************/
#define QSER_RESULT_FAIL    -1
#define QSER_RESULT_SUCCESS 0
/****************************DEFINE***************************************/

/****************************VARIABLE***************************************/
extern mbtk_info_handle_t* qser_info_handle;
extern int qser_info_handle_num;
/****************************VARIABLE***************************************/


/******************************FUNC*****************************************/
static int qser_led_client_init(void)
{
    if(qser_info_handle == NULL)
    {
        qser_info_handle = mbtk_info_handle_get();
        if(qser_info_handle)
        {
            qser_info_handle_num++;
        } 
        else
        {
            LOGE("[qser_led] mbtk_info_handle_get() fail.");
            return QSER_RESULT_FAIL;
        }
    }
    else
    {
        qser_info_handle_num++;
    }

    LOGE("[qser_led] mbtk_info_handle_get() success.");
    return QSER_RESULT_SUCCESS;
}

static int qser_led_client_deinit(void)
{
    if(qser_info_handle)
    {
        LOGE("[qser_led] qser_info_handle_num = %d", qser_info_handle_num);
        if(qser_info_handle_num == 1)
        { // 最后一个引用，可释放。
            int ret = mbtk_info_handle_free(&qser_info_handle);
            if(ret)
            {
                LOGE("[qser_led] mbtk_info_handle_free() fail.");
                return QSER_RESULT_FAIL;
            }
            else
            {
                qser_info_handle_num = 0;
                qser_info_handle = NULL;
            }
        } 
        else
        {
            qser_info_handle_num--;
        }
    }
    else
    {
        LOGE("[qser_led] handle not inited.");
        return QSER_RESULT_FAIL;
    }

    return QSER_RESULT_SUCCESS;
}

/******************************FUNC*****************************************/

/****************************API***************************************/
int lynq_set_netled_on(int led_mode)
{
    //UNUSED(led_mode);

    if(led_mode != 0 && led_mode != 1)
    {
        LOGE("[qser_led]param is fail.");
        return QSER_RESULT_FAIL;
    }

    
    int ret = qser_led_client_init();
    if(ret != QSER_RESULT_SUCCESS)
    {
        LOGE("[qser_led]qser_led_client_init fail.");
        return QSER_RESULT_FAIL;
    }

    ret = mbtk_led_set(qser_info_handle, MBTK_LED_TYPE_NET, led_mode);
    if(ret != 0)
    {
        LOGE("[qser_led]mbtk_led_gpio_init fail.");
        qser_led_client_init();
        return QSER_RESULT_FAIL;
    }

    ret = qser_led_client_init();
    
    return QSER_RESULT_SUCCESS;
}

int lynq_set_statusled_on(int led_mode)
{
    //UNUSED(led_mode);

    if(led_mode != 0 && led_mode != 1)
    {
        LOGE("[qser_led]param is fail.");
        return QSER_RESULT_FAIL;
    }
    
    int ret = qser_led_client_init();
    if(ret != QSER_RESULT_SUCCESS)
    {
        LOGE("[qser_led]qser_led_client_init fail.");
        return QSER_RESULT_FAIL;
    }

    ret = mbtk_led_set(qser_info_handle, MBTK_LED_TYPE_STATUS, led_mode);
    if(ret != 0)
    {
        LOGE("[qser_led]mbtk_led_gpio_init fail.");
        qser_led_client_init();
        return QSER_RESULT_FAIL;
    }

    ret = qser_led_client_init();
    
    return QSER_RESULT_SUCCESS;
}
/****************************API***************************************/


