/*
*    gnss_n50db.c
*
*    MBTK N50-DB GNSS support source file.
*
*/
/******************************************************************************

                          EDIT HISTORY FOR FILE

  WHEN        WHO       WHAT,WHERE,WHY
--------    --------    -------------------------------------------------------
2024/7/18     LiuBin      Initial version

******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <pthread.h>

#include "gnss_n50db.h"
#include "gnss_utils.h"
#include "mbtk_log.h"

#define UART_BITRATE_NMEA_DEF_FW    115200   // Default bitrate.

int gnss_n50db_dev_open()
{
    return 0;
}

int gnss_n50db_dev_close(int fd)
{
    return 0;
}

int gnss_n50db_open(const char *dev)
{
    return gnss_port_open(dev, O_RDWR | O_NONBLOCK | O_NOCTTY, UART_BITRATE_NMEA_DEF_FW, TRUE);
}

int gnss_n50db_close(int fd)
{
    return gnss_port_close(fd);
}

int gnss_n50db_fw_dl(int fd, const char *fw_name, const char *dev)
{
    return GNSS_ERR_UNSUPPORT;
}

void gnss_n50db_set_cb(const void *data, int data_len)
{
    UNUSED(data);
    UNUSED(data_len);
}

gnss_err_enum gnss_n50db_set(int fd, const char *cmd, void *cmd_rsp, int cmd_rsp_len)
{
    return GNSS_ERR_UNSUPPORT;
}

