#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <fcntl.h>
#include <signal.h>

#include "mbtk_type.h"
#include "mbtk_ril.h"
#include "atchannel.h"
#include "at_tok.h"
#include "mbtk_utils.h"
#include "ril_info.h"

/*
IPv4 : 10.255.74.26
IPv6 : 254.128.0.0.0.0.0.0.0.1.0.2.144.5.212.239
*/
bool is_ipv4(const char *ip)
{
    const char *ptr = ip;
    int count = 0;
    while(*ptr) {
        if(*ptr == '.')
            count++;
        ptr++;
    }

    if(count == 3) {
        return true;
    } else {
        return false;
    }
}

static void net_if_as_def_route(mbtk_ril_cid_enum cid)
{
    if(cid != MBTK_RIL_CID_NUL) {
        char buf[100] = {0};

        // Delete all default route in the first.
        // route del default

        // Add default route.
        memset(buf, 0, sizeof(buf));
        sprintf(buf, "route add default dev ccinet%d", cid - 1);
        system(buf);
    }
}

static int net_if_as_dns(mbtk_ril_cid_enum cid, mbtk_ipv4_info_t *ipv4, mbtk_ipv6_info_t *ipv6)
{
    char buf[1024] = {0};
    char dns[128] = {0};
    int offset = 0;
    int fd = -1;

    memset(buf, 0x0, 1024);
    memset(dns, 0x0, 128);
    offset = sprintf(buf, "search lan\n");
    if(ipv4->valid)
    {
        if(inet_ntop(AF_INET, &(ipv4->PrimaryDNS), dns, 32) == NULL) {
            LOGE("PrimaryDNS error.");
        } else {
            LOGD("PrimaryDNS : %s", dns);
        }
        offset += sprintf(buf + offset, "nameserver %s\n", dns);
        memset(dns, 0x0, 128);
        if(inet_ntop(AF_INET, &(ipv4->SecondaryDNS), dns, 32) == NULL) {
            LOGE("SecondaryDNS error.");
        } else {
            LOGD("SecondaryDNS : %s", dns);
        }
        offset += sprintf(buf + offset, "nameserver %s\n", dns);
    }
    if(ipv6->valid)
    {
        memset(dns, 0x0, 128);
		if(ipv6_2_str(&(ipv6->PrimaryDNS), dns))
        {
			LOGE("PrimaryDNS error.");
		} else {
			LOGD("PrimaryDNS : %s", dns);
		}
        offset += sprintf(buf + offset, "nameserver %s\n", dns);
        memset(dns, 0x0, 128);
		if(ipv6_2_str(&(ipv6->SecondaryDNS), dns))
        {
			LOGE("SecondaryDNS error.");
		} else {
			LOGD("SecondaryDNS : %s", dns);
		}
        offset += sprintf(buf + offset, "nameserver %s\n", dns);
    }

    if(offset > 0)
    {
        fd = open("/tmp/resolv.conf", O_WRONLY | O_TRUNC);
        if(fd < 0)
        {
            LOGE("/tmp/resolv.conf : open fail.");
            return -1;
        }

        int ret = write(fd, buf, offset);
        if(ret < 0)
        {
            LOGE("/tmp/resolv.conf : write fail.");
            close(fd);
            return -1;
        }

        close(fd);
    }
    return 0;
}

int net_ifc_config(mbtk_ril_cid_enum cid, bool def_route, bool as_dns, mbtk_ip_info_t *ip_info)
{
    int ret = -1;
    char dev[20] = {0};
    sprintf(dev, "ccinet%d", cid - 1);
    if(ip_info) { // Config IP.
        // Config IPv4 address.
        if(ip_info->ipv4.valid) {
            char ip[20] = {0};
            if(inet_ntop(AF_INET, &(ip_info->ipv4.IPAddr), ip, 20) == NULL) {
                LOGE("inet_ntop ipv4 ip fail.");
                goto exit;
            }

            if(mbtk_ifc_configure2(dev, ip, 0, NULL, "255.255.255.0")) {
                LOGD("Config %s IPv4 %s fail.", dev, ip);
                goto exit;
            } else {
                LOGD("Config %s IPv4 %s success.", dev, ip);
            }
        }

        // Config IPv6 address.
        if(ip_info->ipv6.valid) {
            char ip[50] = {0};

            if(inet_ntop(AF_INET6, &(ip_info->ipv6.IPV6Addr), ip, 50) == NULL) {
                LOGE("inet_ntop ipv6 ip fail.");
                goto exit;
            }

            if(mbtk_ipv6_config(dev, ip, 64)) {
                LOGD("Config %s IPv6 %s fail.", dev, ip);
                goto exit;
            } else {
                LOGD("Config %s IPv6 %s success.", dev, ip);
            }
        }

        // mbtk_qser_route_config(cid, &ip_info->ipv4, &ip_info->ipv6);
        if(def_route && (ip_info->ipv4.valid || ip_info->ipv6.valid)) {
            net_if_as_def_route(cid);
        }

        if(as_dns) {
            ret = net_if_as_dns(cid, &(ip_info->ipv4), &(ip_info->ipv6));
        }
    } else { // Del IP
        if(mbtk_ifc_configure2(dev, NULL, 0, NULL, NULL)) {
            LOGD("Config %s IPv4 0 fail.", dev);
            goto exit;
        } else {
            LOGD("Config %s IPv4 0 success.", dev);
        }
#if 0
        if(mbtk_ipv6_config(dev, NULL, 64)) {
            LOGD("Config %s IPv6 0 fail.", dev);
            goto exit;
        } else {
            LOGD("Config %s IPv6 0 success.", dev);
        }
#endif
    }

    ret = 0;
exit:
    return ret;
}

int net_ifc_reconfig(mbtk_ril_cid_enum cid, bool def_route, bool as_dns, mbtk_ip_info_t *ip_info)
{
    int ret = net_ifc_config(cid, FALSE, FALSE, NULL);
    if(ret) {
        return ret;
    }

    return net_ifc_config(cid, def_route, as_dns, ip_info);
}

