#!/bin/bash

# Config item.
# static / shared
#LIB_TYPE=static
# gcc-4.9 / gcc-8.4
#export PLATFORM=gcc-4.9

# static / shared
export BUILD_LIB_TYPE=shared
# gcc-4.9 / gcc-8.4

ROOT_DIR=`pwd`

cd ..
grep "url" .git/config | cut -d " " -f 3 | grep "kernel_5.4.195"
if [ $? -eq "0" ]; then
	export BUILD_PLATFORM=v2102
else
	export BUILD_PLATFORM=master
fi

export BUILD_BRANCH=`git branch | grep "*" | cut -d " " -f 2`
cd $ROOT_DIR

BUILD_PROJECT_TEMP=`cat config | grep CONFIG_PROJECT | cut -d '=' -f 2`
if [ "$BUILD_PROJECT_TEMP" == "DEFAULT" ];then
	BUILD_PROJECT_TEMP=`cat ../build_version | grep PROJECT | cut -d '=' -f 2`
fi

BUILD_LIBC_TEMP=`cat config | grep CONFIG_MBTK_LIBC | cut -d '=' -f 2`
if [ "$BUILD_LIBC_TEMP" == "musl" ];then
	export BUILD_STD_LIBC=musl
else
	export BUILD_STD_LIBC=glibc
fi

MBTK_SOURCE_VERSION_TEMP=`cat config | grep CONFIG_MBTK_SOURCE_VERSION | cut -d '=' -f 2`
if [ "$MBTK_SOURCE_VERSION_TEMP" == "2" ];then
	export MBTK_SOURCE_VERSION=2
else
	export MBTK_SOURCE_VERSION=1
fi

if [ "$BUILD_PLATFORM" == "master" ];then
	if [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-4`" == "L509" ];then
		export BUILD_PROJECT=L509
	elif [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-4`" == "L508" ];then
		export BUILD_PROJECT=L508
	elif [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-6`" == "PN1803" ];then
		export BUILD_PROJECT=PN1803
	else
		echo "Unknown BUILD_PROJECT:$BUILD_PROJECT_TEMP"
		exit 1
	fi
else
	if [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-4`" == "L509" ];then
		export BUILD_PROJECT=L509
	elif [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-7`" == "L508_X6" ];then
		export BUILD_PROJECT=L508_X6
	elif [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-4`" == "L508" ];then
		export BUILD_PROJECT=L508
	elif [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-6`" == "PN1803" ];then
		export BUILD_PROJECT=PN1803
	elif [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-6`" == "T108-2" ];then
		export BUILD_PROJECT=T108_2
	elif [ "`echo $BUILD_PROJECT_TEMP | cut -c 1-4`" == "T108" ];then
		export BUILD_PROJECT=T108
	else
		echo "Unknown BUILD_PROJECT:$BUILD_PROJECT_TEMP"
		exit 1
	fi
fi

export MBTK_AF_SUPPORT=`cat config | grep CONFIG_AF_SUPPORT | cut -d '=' -f 2`
export MBTK_YX_SUPPORT=`cat config | grep CONFIG_YX_SUPPORT | cut -d '=' -f 2`
export MBTK_SG_SUPPORT=`cat config | grep CONFIG_SG_SUPPORT | cut -d '=' -f 2`
export MBTK_ALL_CID_SUPPORT=`cat config | grep CONFIG_MBTK_ALL_CID_SUPPORT | cut -d '=' -f 2`
export MBTK_GNSS_MODE=`cat config | grep CONFIG_MBTK_GNSS_MODE | cut -d '=' -f 2`
export MBTK_DUMP_SUPPORT=`cat config | grep CONFIG_MBTK_DUMP_SUPPORT | cut -d '=' -f 2`

# 赛格默认打开 ALL_CID_SUPPORT 
if [ "$MBTK_SG_SUPPORT" == "y" ];then
	export MBTK_ALL_CID_SUPPORT=y
	export BUILD_STD_LIBC=musl
fi

# 安付默认打开 ALL_CID_SUPPORT 
if [ "$MBTK_AF_SUPPORT" == "y" ];then
	export BUILD_STD_LIBC=musl
fi


# musl 不支持mbtk dump
if [ "$BUILD_STD_LIBC" == "musl" ];then
	export MBTK_DUMP_SUPPORT=n
fi

export STAGING_DIR=

#TOOLCHAIN_DIR=$ROOT_DIR/toolchain/$BUILD_PLATFORM
#echo "toolchain : $ROOT_DIR"



function build()
{
	cd mbtk

	if [ -n "$1" ] ;then
		case "$1" in
			clean)
				make clean
				;;
			*)
#				exit 1;;
				make -C $1
		esac
	else	# 无参数
		make || exit 1
	fi

	cd $ROOT_DIR

	echo "Build MBTK success."
}

ln_lib()
{
	PWD_TEMP=`pwd`
	
	cd $ROOTFS_DIR/lib
	[ ! -f libpoweralarm.so ] && ln -s liblynq_lib.so libpoweralarm.so
	[ ! -f liblynq-qser-audio.so ] && ln -s liblynq_lib.so liblynq-qser-audio.so
	[ ! -f liblynq-adc.so ] && ln -s liblynq_lib.so liblynq-adc.so
	[ ! -f liblynq-fota.so ] && ln -s liblynq_lib.so liblynq-fota.so
	[ ! -f liblynq-qser-gnss.so ] && ln -s liblynq_lib.so liblynq-qser-gnss.so
	[ ! -f liblynq-log.so ] && ln -s liblynq_lib.so liblynq-log.so
	[ ! -f liblynq-led.so ] && ln -s liblynq_lib.so liblynq-led.so
	[ ! -f liblynq-qser-autosuspend.so ] && ln -s liblynq_lib.so liblynq-qser-autosuspend.so
	[ ! -f liblynq-systime.so ] && ln -s liblynq_lib.so liblynq-systime.so
	[ ! -f liblynq-qser-thermal.so ] && ln -s liblynq_lib.so liblynq-qser-thermal.so
	[ ! -f liblynq-qser-sim.so ] && ln -s liblynq_lib.so liblynq-qser-sim.so
	[ ! -f liblynq-qser-sms.so ] && ln -s liblynq_lib.so liblynq-qser-sms.so
	[ ! -f liblynq-qser-voice.so ] && ln -s liblynq_lib.so liblynq-qser-voice.so
	[ ! -f liblynq-qser-network.so ] && ln -s liblynq_lib.so liblynq-qser-network.so
	[ ! -f liblynq-qser-data.so ] && ln -s liblynq_lib.so liblynq-qser-data.so
	[ ! -f liblynq-irq.so ] && ln -s liblynq_lib.so liblynq-irq.so
	
	cd $PWD_TEMP
}

function copy_bin_and_lib()
{
	# Copy All SO Files.
	cp -f out/lib/* $1/lib
	
	# Copy All Bin Files.
	#cp -f out/bin/* $1/bin
	[ -f out/bin/at ] && cp -f out/bin/at $1/bin
	[ -f out/bin/mbtk_rild ] && cp -f out/bin/mbtk_rild $1/bin
	[ -f out/bin/mbtk_logd ] && cp -f out/bin/mbtk_logd $1/bin
	[ -f out/bin/mbtk_adbd ] && cp -f out/bin/mbtk_adbd $1/bin
	[ -f out/bin/mbtk_mdio ] && cp -f out/bin/mbtk_mdio $1/bin
	[ -f out/bin/device_info_generate ] && cp -f out/bin/device_info_generate $1/..
	[ -f out/bin/ota_update ] && cp -f out/bin/ota_update $1/..
	[ -f out/bin/device_info ] && cp -f out/bin/device_info $1/bin
	[ -f out/bin/mtd_info ] && cp -f out/bin/mtd_info $1/bin
	[ -f out/bin/mbtk_sdk_ready ] && cp -f out/bin/mbtk_sdk_ready $1/bin
	[ -f out/bin/mbtk_reboot ] && cp -f out/bin/mbtk_reboot $1/bin
	[ -f out/bin/mbtk_gnssd ] && cp -f out/bin/mbtk_gnssd $1/bin
	[ -f out/bin/mbtk_version ] && cp -f out/bin/mbtk_version $1/bin
	[ -f out/bin/mbtk_servicesd ] && cp -f out/bin/mbtk_servicesd $1/bin
	[ -f out/bin/aboot-tiny ] && cp -f out/bin/aboot-tiny $1/bin
	
	
	# Copy GNSS(5311) bin files.
	[ -f mbtk/aboot-tiny/files/release/jacana_fw.bin ] && cp -f mbtk/aboot-tiny/files/release/jacana_fw.bin $1/etc
	[ -f mbtk/aboot-tiny/files/config/jacana_pvt.bin ] && cp -f mbtk/aboot-tiny/files/config/jacana_pvt.bin $1/etc
}

function file_copy()
{
	ROOTFS_DIR=$ROOT_DIR/../asr_code/mbtk/rootfs

	if [ -d $ROOTFS_DIR ];then
		echo "Copy MBTK out files..."
		if [ ! -d $ROOTFS_DIR/bin ];then
			mkdir $ROOTFS_DIR/bin
		fi
		if [ ! -d $ROOTFS_DIR/lib ];then
			mkdir $ROOTFS_DIR/lib
		fi
		
		copy_bin_and_lib $ROOTFS_DIR
		
		ln_lib
	else
		echo "No found rootfs : $ROOTFS_DIR"
	fi
}

function temp_mbtk_copy()
{
	TEMP_MBTK_DIR=$ROOT_DIR/../temp_open
	if [ -d $TEMP_MBTK_DIR ];then
		rm -rf $TEMP_MBTK_DIR
	fi
	
	mkdir -p $TEMP_MBTK_DIR/mbtk/include
	mkdir -p $TEMP_MBTK_DIR/mbtk/rootfs/bin
	mkdir -p $TEMP_MBTK_DIR/mbtk/rootfs/lib
	mkdir -p $TEMP_MBTK_DIR/mbtk/rootfs/etc
	mkdir -p $TEMP_MBTK_DIR/mbtk/test
	
	copy_bin_and_lib $TEMP_MBTK_DIR/mbtk/rootfs
	
	# Copy include file.
	if [ -d mbtk/include ];then
		cp -rf mbtk/include/* $TEMP_MBTK_DIR/mbtk/include
	fi
	
	# Copy test source.
	if [ -d mbtk/test ];then
		cope_file="mbtk/test/*"
		files=$(ls $cope_file 2> /dev/null | wc -l)
		if [ "$files" != "0" ] ;then  #如果存在文件
			cp -rf $cope_file $TEMP_MBTK_DIR/mbtk/test
		fi
	fi
}

function print_arg()
{
	echo BUILD_PROJECT=$BUILD_PROJECT
	echo BUILD_STD_LIBC=$BUILD_STD_LIBC
	echo MBTK_SOURCE_VERSION=$MBTK_SOURCE_VERSION
	echo MBTK_GNSS_MODE=$MBTK_GNSS_MODE
	echo MBTK_AF_SUPPORT=$MBTK_AF_SUPPORT
	echo MBTK_YX_SUPPORT=$MBTK_YX_SUPPORT
	echo MBTK_SG_SUPPORT=$MBTK_SG_SUPPORT
	echo MBTK_ALL_CID_SUPPORT=$MBTK_ALL_CID_SUPPORT
	echo MBTK_DUMP_SUPPORT=$MBTK_DUMP_SUPPORT
}

function main()
{
	if [ -n "$1" ] ;then
		build $1
		exit 0
	fi

	if [ -d out/bin -a -d out/lib ];then
		build
		
		print_arg

		file_copy
	else
		if [ ! -d out/lib ];then
			mkdir -p out/lib
		fi
		
		if [ ! -d out/bin ];then
			mkdir -p out/bin
		fi

		build
		
		print_arg

		file_copy
	fi
	
	temp_mbtk_copy
}

# exit 1
print_arg

main $1
