#ifndef JACANA_PVT_H
#define JACANA_PVT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "jacana_firmware.h"
#include "sparse_file.h"

/*---------------------------------------------------------------------------*/
typedef struct {
  sparse_file_t sparse_file;
  size_t max_download_size;
  size_t offset;
  int state;
} pvt_info_t;
/*---------------------------------------------------------------------------*/
/* portable layer api */
void *jacana_pvt_raw_open(void);
size_t jacana_pvt_raw_get_total_size(void *priv);
int jacana_pvt_raw_read(void *priv, size_t start,
                        uint8_t *data, size_t size);
void jacana_pvt_raw_close(void *priv);
/*---------------------------------------------------------------------------*/
int jacana_pvt_open(firmware_handle_t *firmware, void *priv);
int jacana_pvt_read_line(firmware_handle_t *firmware, char *line);
int jacana_pvt_read_data(firmware_handle_t *firmware,
                         uint8_t *data, size_t size);
void jacana_pvt_close(firmware_handle_t *firmware);
/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* JACANA_PVT_H */
