#include <math.h>
#include <stdlib.h>

#include "mbtk_alarm.h"
#include "lynq_alarm.h"
#include "mbtk_str.h"


bool rtc_flag = FALSE;
int lynq_rtc_service_init(void)
{
    int ret = 0;
    if(!rtc_flag)
    {
        rtc_flag = TRUE;
        ret = 1;
    }
    else
    {
        ret = -1;
    }
    return ret;
}

int lynq_rtc_service_deinit(void)
{
    int ret = 0;
    if(rtc_flag)
    {
        rtc_flag = FALSE;
        ret = 0;
    }
    else{
        ret = -1;
    }

    return ret;
}

int lynq_set_wakealarm(unsigned long time_sec,int src_id,int rtc_id,lynq_wakealarm_add_cb wakealarm_notify )
{
    UNUSED(time_sec);
    if(time_sec < 1 || time_sec > pow(2, 28)) {
        return -1;
    }

    return -1;
}

//int lynq_set_poweralarm(unsigned long time_sec)
int lynq_set_poweralarm(unsigned long time_sec,int src_id)
{
    UNUSED(time_sec);
    if(time_sec < 1 || time_sec > pow(2, 28)) {
        return -1;
    }
    char buf[50] ={0};
    sprintf(buf, "rtcwake -d rtc0 -s %d -m on &", time_sec);
    system(buf);

    return 0;
}

// min:1 max:2^28
ssize_t wakealarm(char *buffer,int src_id,int rtc_id,lynq_wakealarm_add_cb wakealarm_notify )
{
    UNUSED(buffer);
    if(str_empty(buffer)) {
        return -1;
    }
    return lynq_set_wakealarm(atol(buffer), src_id, rtc_id, wakealarm_notify);
}

// min:1 max:2^28
ssize_t poweralarm(char *buffer,int src_id)
{
    UNUSED(buffer);
    if(str_empty(buffer)) {
        return -1;
    }
    return lynq_set_poweralarm(atol(buffer), 0);
}

ssize_t cancel_wakealarm(int src_id, int rtc_id)
{
    return -1;
}

